/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.forester.archaeopteryx.ColorSchemeChooser;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.FontChooser;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TextFrame;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.Util;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;

public class ArchaeopteryxE
extends JApplet
implements ActionListener {
    private static final String NAME = "ArchaeopteryxE";
    private static final long serialVersionUID = -1220055577935759443L;
    private Configuration _configuration;
    private MainPanelApplets _main_panel;
    private JMenuBar _jmenubar;
    private JMenu _options_jmenu;
    private JMenu _font_size_menu;
    private JMenuItem _super_tiny_fonts_mi;
    private JMenuItem _tiny_fonts_mi;
    private JMenuItem _small_fonts_mi;
    private JMenuItem _medium_fonts_mi;
    private JMenuItem _large_fonts_mi;
    private TextFrame _textframe;
    private JMenu _tools_menu;
    private JMenuItem _taxcolor_item;
    private JMenuItem _confcolor_item;
    private JMenuItem _midpoint_root_item;
    private JMenu _view_jmenu;
    private JMenuItem _view_as_XML_item;
    private JMenuItem _view_as_NH_item;
    private JMenuItem _view_as_NHX_item;
    private JMenuItem _view_as_nexus_item;
    private JMenu _type_menu;
    private JCheckBoxMenuItem _rectangular_type_cbmi;
    private JCheckBoxMenuItem _triangular_type_cbmi;
    private JCheckBoxMenuItem _curved_type_cbmi;
    private JCheckBoxMenuItem _convex_type_cbmi;
    private JCheckBoxMenuItem _euro_type_cbmi;
    private JCheckBoxMenuItem _rounded_type_cbmi;
    private JCheckBoxMenuItem _unrooted_type_cbmi;
    private JCheckBoxMenuItem _circular_type_cbmi;
    private JMenuItem _help_item;
    private JMenuItem _about_item;
    private JMenu _help_jmenu;
    private JMenuItem _website_item;
    private JMenuItem _phyloxml_website_item;
    private JMenuItem _phyloxml_ref_item;
    private JMenuItem _aptx_ref_item;
    private JMenuItem _remove_branch_color_item;
    private JMenuItem _infer_common_sn_names_item;
    private JCheckBoxMenuItem _screen_antialias_cbmi;
    private JCheckBoxMenuItem _background_gradient_cbmi;
    private JRadioButtonMenuItem _non_lined_up_cladograms_rbmi;
    private JRadioButtonMenuItem _uniform_cladograms_rbmi;
    private JRadioButtonMenuItem _ext_node_dependent_cladogram_rbmi;
    private Options _options;
    private JMenuItem _choose_font_mi;
    private JMenuItem _switch_colors_mi;
    JCheckBoxMenuItem _label_direction_cbmi;
    private JCheckBoxMenuItem _show_node_boxes_cbmi;
    private JCheckBoxMenuItem _show_scale_cbmi;
    private JCheckBoxMenuItem _search_case_senstive_cbmi;
    private JCheckBoxMenuItem _search_whole_words_only_cbmi;
    private JCheckBoxMenuItem _inverse_search_result_cbmi;
    private JCheckBoxMenuItem _show_overview_cbmi;
    private JMenuItem _choose_minimal_confidence_mi;
    private JCheckBoxMenuItem _show_branch_length_values_cbmi;
    private JMenuItem _collapse_species_specific_subtrees;
    private JMenuItem _overview_placment_mi;
    private JMenuItem _collapse_below_threshold;
    private ButtonGroup _radio_group_1;

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this._midpoint_root_item) {
            this.getMainPanel().getCurrentTreePanel().midpointRoot();
        } else if (o == this._taxcolor_item) {
            this.getMainPanel().getCurrentTreePanel().taxColor();
        } else if (o == this._confcolor_item) {
            this.getMainPanel().getCurrentTreePanel().confColor();
        } else if (o == this._infer_common_sn_names_item) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().inferCommonPartOfScientificNames();
            }
        } else if (o == this._collapse_species_specific_subtrees) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().collapseSpeciesSpecificSubtrees();
            }
        } else if (o == this._remove_branch_color_item) {
            this.removeBranchColors();
        } else if (o == this._switch_colors_mi) {
            this.switchColors();
        } else if (o == this._view_as_NH_item) {
            this.viewAsNH();
        } else if (o == this._view_as_NHX_item) {
            this.viewAsNHX();
        } else if (o == this._view_as_XML_item) {
            this.viewAsXML();
        } else if (o == this._view_as_nexus_item) {
            this.viewAsNexus();
        } else if (o == this._super_tiny_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSuperTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._tiny_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setTinyFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._small_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setSmallFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._medium_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setMediumFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._large_fonts_mi) {
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().setLargeFonts();
                this.getCurrentTreePanel().repaint();
            }
        } else if (o == this._choose_font_mi) {
            this.chooseFont();
        } else if (o == this._choose_minimal_confidence_mi) {
            this.chooseMinimalConfidence();
        } else if (o == this._overview_placment_mi) {
            MainFrame.cycleOverview(this.getOptions(), this.getCurrentTreePanel());
        } else if (o == this._show_node_boxes_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._non_lined_up_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this._main_panel.getControlPanel().showWhole();
        } else if (o == this._uniform_cladograms_rbmi) {
            this.updateOptions(this.getOptions());
            this._main_panel.getControlPanel().showWhole();
        } else if (o == this._ext_node_dependent_cladogram_rbmi) {
            this.updateOptions(this.getOptions());
            this._main_panel.getControlPanel().showWhole();
        } else if (o == this._search_case_senstive_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search();
        } else if (o == this._search_whole_words_only_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search();
        } else if (o == this._inverse_search_result_cbmi) {
            this.updateOptions(this.getOptions());
            this.getMainPanel().getControlPanel().search();
        } else if (o == this._show_scale_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_branch_length_values_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._label_direction_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._show_overview_cbmi) {
            this.updateOptions(this.getOptions());
            if (this.getCurrentTreePanel() != null) {
                this.getCurrentTreePanel().updateOvSizes();
            }
        } else if (o == this._rectangular_type_cbmi || o == this._triangular_type_cbmi || o == this._curved_type_cbmi || o == this._convex_type_cbmi || o == this._rounded_type_cbmi || o == this._euro_type_cbmi || o == this._unrooted_type_cbmi || o == this._circular_type_cbmi) {
            this.typeChanged(o);
        } else if (o == this._screen_antialias_cbmi) {
            this.updateOptions(this.getOptions());
            ArchaeopteryxE.setupScreenTextAntialias(this.getMainPanel().getTreePanels(), this.isScreenAntialias());
        } else if (o == this._background_gradient_cbmi) {
            this.updateOptions(this.getOptions());
        } else if (o == this._about_item) {
            MainFrame.about();
        } else if (o == this._help_item) {
            MainFrame.help(this.getConfiguration().getWebLinks());
        } else if (o == this._website_item) {
            try {
                Util.openWebsite("http://www.phylosoft.org/archaeopteryx/", true, this);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._phyloxml_website_item) {
            try {
                Util.openWebsite("http://www.phyloxml.org", true, this);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._aptx_ref_item) {
            try {
                Util.openWebsite("http://www.biomedcentral.com/bmcbioinformatics/", true, this);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        } else if (o == this._phyloxml_ref_item) {
            try {
                Util.openWebsite("http://www.biomedcentral.com/1471-2105/10/356/", true, this);
            }
            catch (IOException e1) {
                ForesterUtil.printErrorMessage("Archaeopteryx", e1.toString());
            }
        }
        this.repaint();
    }

    void buildFontSizeMenu() {
        this._font_size_menu = MainFrame.createMenu("Font Size", this.getConfiguration());
        this._super_tiny_fonts_mi = new JMenuItem("Super tiny fonts");
        this._font_size_menu.add(this._super_tiny_fonts_mi);
        this._tiny_fonts_mi = new JMenuItem("Tiny fonts");
        this._font_size_menu.add(this._tiny_fonts_mi);
        this._small_fonts_mi = new JMenuItem("Small fonts");
        this._font_size_menu.add(this._small_fonts_mi);
        this._medium_fonts_mi = new JMenuItem("Medium fonts");
        this._font_size_menu.add(this._medium_fonts_mi);
        this._large_fonts_mi = new JMenuItem("Large fonts");
        this._font_size_menu.add(this._large_fonts_mi);
        this.customizeJMenuItem(this._super_tiny_fonts_mi);
        this.customizeJMenuItem(this._tiny_fonts_mi);
        this.customizeJMenuItem(this._small_fonts_mi);
        this.customizeJMenuItem(this._medium_fonts_mi);
        this.customizeJMenuItem(this._large_fonts_mi);
        this._jmenubar.add(this._font_size_menu);
    }

    void buildHelpMenu() {
        this._help_jmenu = MainFrame.createMenu("Help", this.getConfiguration());
        this._help_item = new JMenuItem("Help");
        this._help_jmenu.add(this._help_item);
        this._website_item = new JMenuItem("Archaeopteryx Home");
        this._help_jmenu.add(this._website_item);
        this._aptx_ref_item = new JMenuItem("Archaeopteryx Reference");
        this._phyloxml_website_item = new JMenuItem("phyloXML Home");
        this._help_jmenu.add(this._phyloxml_website_item);
        this._phyloxml_ref_item = new JMenuItem("phyloXML Reference");
        this._help_jmenu.add(this._phyloxml_ref_item);
        this._help_jmenu.addSeparator();
        this._about_item = new JMenuItem("About");
        this._help_jmenu.add(this._about_item);
        this.customizeJMenuItem(this._help_item);
        this.customizeJMenuItem(this._website_item);
        this.customizeJMenuItem(this._phyloxml_website_item);
        this.customizeJMenuItem(this._aptx_ref_item);
        this.customizeJMenuItem(this._phyloxml_ref_item);
        this.customizeJMenuItem(this._about_item);
        this._phyloxml_ref_item.setToolTipText("Han MV and Zmasek CM (2009): \"phyloXML: XML for evolutionary biology and comparative genomics\", BMC Bioinformatics 10:356");
        this._aptx_ref_item.setToolTipText("Zmasek...");
        this._jmenubar.add(this._help_jmenu);
    }

    void buildOptionsMenu() {
        this._options_jmenu = MainFrame.createMenu("Options", this.getConfiguration());
        this._options_jmenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.setOvPlacementColorChooseMenuItem(ArchaeopteryxE.this._overview_placment_mi, ArchaeopteryxE.this.getCurrentTreePanel());
                MainFrame.setTextColorChooseMenuItem(ArchaeopteryxE.this._switch_colors_mi, ArchaeopteryxE.this.getCurrentTreePanel());
                MainFrame.setTextMinSupportMenuItem(ArchaeopteryxE.this._choose_minimal_confidence_mi, ArchaeopteryxE.this.getOptions(), ArchaeopteryxE.this.getCurrentTreePanel());
                MainFrame.setTextForFontChooserMenuItem(ArchaeopteryxE.this._choose_font_mi, MainFrame.createCurrentFontDesc(ArchaeopteryxE.this.getMainPanel().getTreeFontSet()));
                MainFrame.updateOptionsMenuDependingOnPhylogenyType(ArchaeopteryxE.this.getMainPanel(), ArchaeopteryxE.this._show_scale_cbmi, ArchaeopteryxE.this._show_branch_length_values_cbmi, ArchaeopteryxE.this._non_lined_up_cladograms_rbmi, ArchaeopteryxE.this._uniform_cladograms_rbmi, ArchaeopteryxE.this._ext_node_dependent_cladogram_rbmi, ArchaeopteryxE.this._label_direction_cbmi);
            }
        });
        this._options_jmenu.add(MainFrame.customizeMenuItemAsLabel(new JMenuItem("Display:"), this.getConfiguration()));
        this._ext_node_dependent_cladogram_rbmi = new JRadioButtonMenuItem("External Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._ext_node_dependent_cladogram_rbmi);
        this._uniform_cladograms_rbmi = new JRadioButtonMenuItem("Total Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._uniform_cladograms_rbmi);
        this._non_lined_up_cladograms_rbmi = new JRadioButtonMenuItem("Non-Lined Up Cladograms");
        this._options_jmenu.add(this._non_lined_up_cladograms_rbmi);
        this._radio_group_1 = new ButtonGroup();
        this._radio_group_1.add(this._ext_node_dependent_cladogram_rbmi);
        this._radio_group_1.add(this._uniform_cladograms_rbmi);
        this._radio_group_1.add(this._non_lined_up_cladograms_rbmi);
        this._show_node_boxes_cbmi = new JCheckBoxMenuItem("Display Node Boxes");
        this._options_jmenu.add(this._show_node_boxes_cbmi);
        this._show_scale_cbmi = new JCheckBoxMenuItem("Display Scale");
        this._options_jmenu.add(this._show_scale_cbmi);
        this._show_branch_length_values_cbmi = new JCheckBoxMenuItem("Display Branch Length Values");
        this._options_jmenu.add(this._show_branch_length_values_cbmi);
        this._show_overview_cbmi = new JCheckBoxMenuItem("Show Overview");
        this._options_jmenu.add(this._show_overview_cbmi);
        this._label_direction_cbmi = new JCheckBoxMenuItem("Radial Labels");
        this._options_jmenu.add(this._label_direction_cbmi);
        this._label_direction_cbmi.setToolTipText("To use radial node labels in radial and unrooted display types");
        this._screen_antialias_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._screen_antialias_cbmi);
        this._background_gradient_cbmi = new JCheckBoxMenuItem("Background Color Gradient");
        this._options_jmenu.add(this._background_gradient_cbmi);
        this._choose_minimal_confidence_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_minimal_confidence_mi);
        this._overview_placment_mi = new JMenuItem("");
        this._options_jmenu.add(this._overview_placment_mi);
        this._switch_colors_mi = new JMenuItem("");
        this._options_jmenu.add(this._switch_colors_mi);
        this._choose_font_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_font_mi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrame.customizeMenuItemAsLabel(new JMenuItem("Search:"), this.getConfiguration()));
        this._search_case_senstive_cbmi = new JCheckBoxMenuItem("Case Sensitive");
        this._options_jmenu.add(this._search_case_senstive_cbmi);
        this._search_whole_words_only_cbmi = new JCheckBoxMenuItem("Match Complete Terms Only");
        this._options_jmenu.add(this._search_whole_words_only_cbmi);
        this._inverse_search_result_cbmi = new JCheckBoxMenuItem("Negate Result");
        this._options_jmenu.add(this._inverse_search_result_cbmi);
        this.customizeJMenuItem(this._choose_font_mi);
        this.customizeJMenuItem(this._choose_minimal_confidence_mi);
        this.customizeJMenuItem(this._switch_colors_mi);
        this.customizeJMenuItem(this._overview_placment_mi);
        this.customizeCheckBoxMenuItem(this._show_node_boxes_cbmi, this.getOptions().isShowNodeBoxes());
        this.customizeCheckBoxMenuItem(this._label_direction_cbmi, this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL);
        this.customizeCheckBoxMenuItem(this._screen_antialias_cbmi, this.getOptions().isAntialiasScreen());
        this.customizeCheckBoxMenuItem(this._background_gradient_cbmi, this.getOptions().isBackgroundColorGradient());
        this.customizeCheckBoxMenuItem(this._search_case_senstive_cbmi, this.getOptions().isSearchCaseSensitive());
        this.customizeCheckBoxMenuItem(this._show_scale_cbmi, this.getOptions().isShowScale());
        this.customizeRadioButtonMenuItem(this._non_lined_up_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP);
        this.customizeRadioButtonMenuItem(this._uniform_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        this.customizeRadioButtonMenuItem(this._ext_node_dependent_cladogram_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        this.customizeCheckBoxMenuItem(this._show_branch_length_values_cbmi, this.getOptions().isShowBranchLengthValues());
        this.customizeCheckBoxMenuItem(this._show_overview_cbmi, this.getOptions().isShowOverview());
        this.customizeCheckBoxMenuItem(this._search_whole_words_only_cbmi, this.getOptions().isMatchWholeTermsOnly());
        this.customizeCheckBoxMenuItem(this._inverse_search_result_cbmi, this.getOptions().isInverseSearchResult());
        this._jmenubar.add(this._options_jmenu);
    }

    void buildToolsMenu() {
        this._tools_menu = MainFrame.createMenu("Tools", this.getConfiguration());
        this._confcolor_item = new JMenuItem("Colorize Branches Depending on Confidence");
        this._tools_menu.add(this._confcolor_item);
        this.customizeJMenuItem(this._confcolor_item);
        this._taxcolor_item = new JMenuItem("Taxonomy Colorize Branches");
        this._tools_menu.add(this._taxcolor_item);
        this.customizeJMenuItem(this._taxcolor_item);
        this._remove_branch_color_item = new JMenuItem("Delete Branch Colors");
        this._tools_menu.add(this._remove_branch_color_item);
        this._remove_branch_color_item.setToolTipText("To delete branch color values from the current phylogeny.");
        this.customizeJMenuItem(this._remove_branch_color_item);
        this._tools_menu.addSeparator();
        this._midpoint_root_item = new JMenuItem("Midpoint-Root");
        this._tools_menu.add(this._midpoint_root_item);
        this.customizeJMenuItem(this._midpoint_root_item);
        this._tools_menu.addSeparator();
        this._infer_common_sn_names_item = new JMenuItem("Infer Common Parts of Internal Scientific Names");
        this._tools_menu.add(this._infer_common_sn_names_item);
        this.customizeJMenuItem(this._infer_common_sn_names_item);
        this._collapse_species_specific_subtrees = new JMenuItem("Collapse Species-Specific Subtrees");
        this._tools_menu.add(this._collapse_species_specific_subtrees);
        this.customizeJMenuItem(this._collapse_species_specific_subtrees);
        this._collapse_below_threshold = new JMenuItem("Collapse Branches with Confidence Below Threshold");
        this._tools_menu.add(this._collapse_below_threshold);
        this.customizeJMenuItem(this._collapse_below_threshold);
        this._jmenubar.add(this._tools_menu);
    }

    void buildTypeMenu() {
        this._type_menu = MainFrame.createMenu("Type", this.getConfiguration());
        this._rectangular_type_cbmi = new JCheckBoxMenuItem("Rectangular");
        this._type_menu.add(this._rectangular_type_cbmi);
        this._euro_type_cbmi = new JCheckBoxMenuItem("Euro Type");
        this._type_menu.add(this._euro_type_cbmi);
        this._rounded_type_cbmi = new JCheckBoxMenuItem("Rounded");
        this._type_menu.add(this._rounded_type_cbmi);
        this._curved_type_cbmi = new JCheckBoxMenuItem("Curved");
        this._type_menu.add(this._curved_type_cbmi);
        this._triangular_type_cbmi = new JCheckBoxMenuItem("Triangular");
        this._type_menu.add(this._triangular_type_cbmi);
        this._convex_type_cbmi = new JCheckBoxMenuItem("Convex");
        this._type_menu.add(this._convex_type_cbmi);
        this._unrooted_type_cbmi = new JCheckBoxMenuItem("Unrooted (alpha)");
        this._type_menu.add(this._unrooted_type_cbmi);
        this._circular_type_cbmi = new JCheckBoxMenuItem("Circular (alpha)");
        this._type_menu.add(this._circular_type_cbmi);
        this.customizeCheckBoxMenuItem(this._rectangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._triangular_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._euro_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._rounded_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._curved_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._convex_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._unrooted_type_cbmi, false);
        this.customizeCheckBoxMenuItem(this._circular_type_cbmi, false);
        this._unrooted_type_cbmi.setToolTipText("In this display type, use mousewheel + Shift to rotate [or A and S]");
        this._circular_type_cbmi.setToolTipText("In this display type, use mousewheel + Shift to rotate [or A and S]");
        this.initializeTypeMenu(this.getOptions());
        this._jmenubar.add(this._type_menu);
    }

    void buildViewMenu() {
        this._view_jmenu = MainFrame.createMenu("View as Text", this.getConfiguration());
        this._view_as_XML_item = new JMenuItem("View as phyloXML");
        this._view_jmenu.add(this._view_as_XML_item);
        this._view_as_NH_item = new JMenuItem("View as Newick");
        this._view_jmenu.add(this._view_as_NH_item);
        this._view_as_NHX_item = new JMenuItem("View as NHX");
        this._view_jmenu.add(this._view_as_NHX_item);
        this._view_as_nexus_item = new JMenuItem("View as Nexus");
        this._view_jmenu.add(this._view_as_nexus_item);
        this.customizeJMenuItem(this._view_as_NH_item);
        this.customizeJMenuItem(this._view_as_NHX_item);
        this.customizeJMenuItem(this._view_as_XML_item);
        this.customizeJMenuItem(this._view_as_nexus_item);
        this._jmenubar.add(this._view_jmenu);
    }

    private void chooseFont() {
        FontChooser fc = new FontChooser();
        fc.setFont(this.getMainPanel().getTreeFontSet().getLargeFont());
        fc.showDialog(this, "Select the Base Font");
        this.getMainPanel().getTreeFontSet().setBaseFont(fc.getFont());
    }

    private void chooseMinimalConfidence() {
        String s = (String)JOptionPane.showInputDialog(this, "Please the minimum for confidence values to be displayed.\n[current value: " + this.getOptions().getMinConfidenceValue() + "]\n", "Minimal Confidence Value", 3, null, null, this.getOptions().getMinConfidenceValue());
        if (!ForesterUtil.isEmpty(s)) {
            boolean success = true;
            double m = 0.0;
            String m_str = s.trim();
            if (!ForesterUtil.isEmpty(m_str)) {
                try {
                    m = Double.parseDouble(m_str);
                }
                catch (Exception ex) {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && m >= 0.0) {
                this.getOptions().setMinConfidenceValue(m);
            }
        }
    }

    void customizeCheckBoxMenuItem(JCheckBoxMenuItem item, boolean is_selected) {
        if (item != null) {
            item.setFont(MainFrame.menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                item.setBackground(Constants.MENU_BACKGROUND_COLOR_DEFAULT);
                item.setForeground(Constants.MENU_TEXT_COLOR_DEFAULT);
            }
            item.setSelected(is_selected);
            item.addActionListener(this);
        }
    }

    void customizeJMenuItem(JMenuItem jmi) {
        jmi.setFont(MainFrame.menu_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            jmi.setBackground(Constants.MENU_BACKGROUND_COLOR_DEFAULT);
            jmi.setForeground(Constants.MENU_TEXT_COLOR_DEFAULT);
        }
        jmi.addActionListener(this);
    }

    private void customizeRadioButtonMenuItem(JRadioButtonMenuItem item, boolean is_selected) {
        if (item != null) {
            item.setFont(MainFrame.menu_font);
            if (!this.getConfiguration().isUseNativeUI()) {
                item.setBackground(Constants.MENU_BACKGROUND_COLOR_DEFAULT);
                item.setForeground(Constants.MENU_TEXT_COLOR_DEFAULT);
            }
            item.setSelected(is_selected);
            item.addActionListener(this);
        }
    }

    @Override
    public void destroy() {
        Util.printAppletMessage(NAME, "going to be destroyed ");
        this.removeTextFrame();
        if (this.getMainPanel() != null) {
            this.getMainPanel().terminate();
        }
    }

    Configuration getConfiguration() {
        return this._configuration;
    }

    TreePanel getCurrentTreePanel() {
        return this.getMainPanel().getCurrentTreePanel();
    }

    JCheckBoxMenuItem getlabelDirectionCbmi() {
        return this._label_direction_cbmi;
    }

    private MainPanel getMainPanel() {
        return this._main_panel;
    }

    public Options getOptions() {
        return this._options;
    }

    Options getOtions() {
        return this._options;
    }

    @Override
    public void init() {
        String config_filename = this.getParameter("config_file");
        Util.printAppletMessage(NAME, "URL for configuration file is: " + config_filename);
        Configuration configuration = new Configuration(config_filename, true, true);
        this.setConfiguration(configuration);
        this.setOptions(Options.createInstance(configuration));
        this.setupUI();
        URL phys_url = null;
        Phylogeny[] phys = null;
        String phys_url_string = this.getParameter("url_of_tree_to_load");
        Util.printAppletMessage(NAME, "URL for phylogenies is " + phys_url_string);
        if (phys_url_string != null) {
            try {
                phys_url = new URL(phys_url_string);
            }
            catch (Exception e) {
                ForesterUtil.printErrorMessage(NAME, "error: " + e);
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "ArchaeopteryxE: Could not create URL from: \"" + phys_url_string + "\"\nException: " + e, "Failed to create URL", 0);
            }
        }
        if (phys_url != null) {
            try {
                phys = Util.readPhylogeniesFromUrl(phys_url, this.getConfiguration().isValidatePhyloXmlAgainstSchema());
            }
            catch (Exception e) {
                ForesterUtil.printErrorMessage(NAME, e.toString());
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "ArchaeopteryxE: Failed to read phylogenies: \nException: " + e, "Failed to read phylogenies", 0);
            }
        }
        if (phys == null || phys.length < 1) {
            ForesterUtil.printErrorMessage(NAME, "phylogenies from [" + phys_url + "] are null or empty");
            JOptionPane.showMessageDialog(this, "ArchaeopteryxE: phylogenies from [" + phys_url + "] are null or empty", "Failed to read phylogenies", 0);
            return;
        }
        Util.printAppletMessage(NAME, "loaded " + phys.length + " phylogenies from: " + phys_url);
        this.setVisible(false);
        this.setMainPanel(new MainPanelApplets(this.getConfiguration(), this));
        this._jmenubar = new JMenuBar();
        if (!this.getConfiguration().isHideControlPanelAndMenubar()) {
            if (!this.getConfiguration().isUseNativeUI()) {
                this._jmenubar.setBackground(Constants.MENU_BACKGROUND_COLOR_DEFAULT);
            }
            this.buildToolsMenu();
            this.buildViewMenu();
            this.buildFontSizeMenu();
            this.buildOptionsMenu();
            this.buildTypeMenu();
            this.buildHelpMenu();
            this.setJMenuBar(this._jmenubar);
        }
        Container contentpane = this.getContentPane();
        contentpane.setLayout(new BorderLayout());
        contentpane.add((Component)this.getMainPanel(), "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (ArchaeopteryxE.this.getMainPanel().getCurrentTreePanel() != null) {
                    ArchaeopteryxE.this.getMainPanel().getCurrentTreePanel().setParametersForPainting(ArchaeopteryxE.this.getMainPanel().getCurrentTreePanel().getWidth(), ArchaeopteryxE.this.getMainPanel().getCurrentTreePanel().getHeight(), false);
                }
            }
        });
        if (this.getConfiguration().isUseTabbedDisplay()) {
            Util.printAppletMessage(NAME, "using tabbed display");
            Util.addPhylogeniesToTabs(phys, new File(phys_url.getFile()).getName(), phys_url.toString(), this.getConfiguration(), this.getMainPanel());
        } else {
            Util.printAppletMessage(NAME, "not using tabbed display");
            Util.addPhylogenyToPanel(phys, this.getConfiguration(), this.getMainPanel());
        }
        this.validate();
        this.setName(NAME);
        this.getMainPanel().getControlPanel().showWholeAll();
        this.getMainPanel().getControlPanel().showWhole();
        System.gc();
        Util.printAppletMessage(NAME, "successfully initialized");
        this.setVisible(true);
    }

    void initializeTypeMenu(Options options) {
        this.setTypeMenuToAllUnselected();
        try {
            switch (options.getPhylogenyGraphicsType()) {
                case CONVEX: {
                    this._convex_type_cbmi.setSelected(true);
                    break;
                }
                case CURVED: {
                    this._curved_type_cbmi.setSelected(true);
                    break;
                }
                case EURO_STYLE: {
                    this._euro_type_cbmi.setSelected(true);
                    break;
                }
                case ROUNDED: {
                    this._rounded_type_cbmi.setSelected(true);
                    break;
                }
                case TRIANGULAR: {
                    this._triangular_type_cbmi.setSelected(true);
                    break;
                }
                case UNROOTED: {
                    this._unrooted_type_cbmi.setSelected(true);
                    break;
                }
                case CIRCULAR: {
                    this._circular_type_cbmi.setSelected(true);
                    break;
                }
                default: {
                    this._rectangular_type_cbmi.setSelected(true);
                    break;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private boolean isScreenAntialias() {
        return true;
    }

    private void removeBranchColors() {
        if (this.getMainPanel().getCurrentPhylogeny() != null) {
            Util.removeBranchColors(this.getMainPanel().getCurrentPhylogeny());
        }
    }

    void removeTextFrame() {
        if (this._textframe != null) {
            this._textframe.close();
            this._textframe = null;
        }
    }

    void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    private void setMainPanel(MainPanelApplets main_panel) {
        this._main_panel = main_panel;
    }

    void setOptions(Options options) {
        this._options = options;
    }

    void setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE type) {
        this.setTypeMenuToAllUnselected();
        try {
            switch (type) {
                case CIRCULAR: {
                    this._circular_type_cbmi.setSelected(true);
                    break;
                }
                case CONVEX: {
                    this._convex_type_cbmi.setSelected(true);
                    break;
                }
                case CURVED: {
                    this._curved_type_cbmi.setSelected(true);
                    break;
                }
                case EURO_STYLE: {
                    this._euro_type_cbmi.setSelected(true);
                    break;
                }
                case ROUNDED: {
                    this._rounded_type_cbmi.setSelected(true);
                    break;
                }
                case RECTANGULAR: {
                    this._rectangular_type_cbmi.setSelected(true);
                    break;
                }
                case TRIANGULAR: {
                    this._triangular_type_cbmi.setSelected(true);
                    break;
                }
                case UNROOTED: {
                    this._unrooted_type_cbmi.setSelected(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown type: " + (Object)((Object)type));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void setTypeMenuToAllUnselected() {
        if (this._convex_type_cbmi != null) {
            this._convex_type_cbmi.setSelected(false);
        }
        if (this._curved_type_cbmi != null) {
            this._curved_type_cbmi.setSelected(false);
        }
        if (this._euro_type_cbmi != null) {
            this._euro_type_cbmi.setSelected(false);
        }
        if (this._rounded_type_cbmi != null) {
            this._rounded_type_cbmi.setSelected(false);
        }
        if (this._triangular_type_cbmi != null) {
            this._triangular_type_cbmi.setSelected(false);
        }
        if (this._rectangular_type_cbmi != null) {
            this._rectangular_type_cbmi.setSelected(false);
        }
        if (this._unrooted_type_cbmi != null) {
            this._unrooted_type_cbmi.setSelected(false);
        }
        if (this._circular_type_cbmi != null) {
            this._circular_type_cbmi.setSelected(false);
        }
    }

    private void setupUI() {
        try {
            if (this.getConfiguration().isUseNativeUI()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            Util.dieWithSystemError("UnsupportedLookAndFeelException: " + e.toString());
        }
        catch (ClassNotFoundException e) {
            Util.dieWithSystemError("ClassNotFoundException: " + e.toString());
        }
        catch (InstantiationException e) {
            Util.dieWithSystemError("InstantiationException: " + e.toString());
        }
        catch (IllegalAccessException e) {
            Util.dieWithSystemError("IllegalAccessException: " + e.toString());
        }
        catch (Exception e) {
            Util.dieWithSystemError(e.toString());
        }
    }

    @Override
    public void start() {
        if (this.getMainPanel() != null) {
            this.getMainPanel().validate();
        }
        this.requestFocus();
        this.requestFocusInWindow();
        this.requestFocus();
        Util.printAppletMessage(NAME, "started");
    }

    void switchColors() {
        TreeColorSet colorset = this.getMainPanel().getCurrentTreePanel().getTreeColorSet();
        ColorSchemeChooser csc = new ColorSchemeChooser(this.getMainPanel(), colorset);
        csc.setVisible(true);
        this.getMainPanel().setTreeColorSet(colorset);
    }

    void typeChanged(Object o) {
        this.updateTypeCheckboxes(this.getOptions(), o);
        this.updateOptions(this.getOptions());
        if (this.getCurrentTreePanel() != null) {
            Options.PHYLOGENY_GRAPHICS_TYPE previous_type = this.getCurrentTreePanel().getPhylogenyGraphicsType();
            Options.PHYLOGENY_GRAPHICS_TYPE new_type = this.getOptions().getPhylogenyGraphicsType();
            if (previous_type == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && new_type != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || previous_type == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && new_type != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || previous_type != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && new_type == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || previous_type != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR && new_type == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().showWhole();
            }
            if (this.getCurrentTreePanel().isPhyHasBranchLengths() && new_type != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(true);
            } else {
                this.getCurrentTreePanel().getControlPanel().setDrawPhylogramEnabled(false);
            }
            this.getCurrentTreePanel().setPhylogenyGraphicsType(this.getOptions().getPhylogenyGraphicsType());
            MainFrame.updateScreenTextAntialias(this.getMainPanel().getTreePanels());
        }
    }

    void updateOptions(Options options) {
        options.setAntialiasScreen(this._screen_antialias_cbmi != null && this._screen_antialias_cbmi.isSelected());
        options.setBackgroundColorGradient(this._background_gradient_cbmi != null && this._background_gradient_cbmi.isSelected());
        options.setShowNodeBoxes(this._show_node_boxes_cbmi != null && this._show_node_boxes_cbmi.isSelected());
        if (this._non_lined_up_cladograms_rbmi != null && this._non_lined_up_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.NON_LINED_UP);
        } else if (this._uniform_cladograms_rbmi != null && this._uniform_cladograms_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        } else if (this._ext_node_dependent_cladogram_rbmi != null && this._ext_node_dependent_cladogram_rbmi.isSelected()) {
            options.setCladogramType(Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        }
        options.setSearchCaseSensitive(this._search_case_senstive_cbmi != null && this._search_case_senstive_cbmi.isSelected());
        if (this._show_scale_cbmi != null && this._show_scale_cbmi.isEnabled()) {
            options.setShowScale(this._show_scale_cbmi.isSelected());
        }
        if (this._label_direction_cbmi != null) {
            if (this._label_direction_cbmi.isSelected()) {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
            } else {
                options.setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
            }
        }
        options.setShowOverview(this._show_overview_cbmi != null && this._show_overview_cbmi.isSelected());
        if (this._show_branch_length_values_cbmi != null && this._show_branch_length_values_cbmi.isEnabled()) {
            options.setShowBranchLengthValues(this._show_branch_length_values_cbmi.isSelected());
        }
        options.setMatchWholeTermsOnly(this._search_whole_words_only_cbmi != null && this._search_whole_words_only_cbmi.isSelected());
        options.setInverseSearchResult(this._inverse_search_result_cbmi != null && this._inverse_search_result_cbmi.isSelected());
        if (this._rectangular_type_cbmi != null && this._rectangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        } else if (this._triangular_type_cbmi != null && this._triangular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
        } else if (this._curved_type_cbmi != null && this._curved_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
        } else if (this._convex_type_cbmi != null && this._convex_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
        } else if (this._euro_type_cbmi != null && this._euro_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
        } else if (this._rounded_type_cbmi != null && this._rounded_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
        } else if (this._unrooted_type_cbmi != null && this._unrooted_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
        } else if (this._circular_type_cbmi != null && this._circular_type_cbmi.isSelected()) {
            options.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
        }
    }

    void updateTypeCheckboxes(Options options, Object o) {
        this.setTypeMenuToAllUnselected();
        ((JCheckBoxMenuItem)o).setSelected(true);
    }

    void viewAsNexus() {
        this.removeTextFrame();
        if (this.getMainPanel().getCurrentPhylogeny() == null || this.getMainPanel().getCurrentPhylogeny().isEmpty() || this.getMainPanel().getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this.getMainPanel().getCurrentPhylogeny().toNexus());
    }

    void viewAsNH() {
        this.removeTextFrame();
        if (this.getMainPanel().getCurrentPhylogeny() == null || this.getMainPanel().getCurrentPhylogeny().isEmpty() || this.getMainPanel().getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this.getMainPanel().getCurrentPhylogeny().toNewHampshire(false));
    }

    void viewAsNHX() {
        this.removeTextFrame();
        if (this.getMainPanel().getCurrentPhylogeny() == null || this.getMainPanel().getCurrentPhylogeny().isEmpty() || this.getMainPanel().getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this.getMainPanel().getCurrentPhylogeny().toNewHampshireX());
    }

    void viewAsXML() {
        this.removeTextFrame();
        if (this.getMainPanel().getCurrentPhylogeny() == null || this.getMainPanel().getCurrentPhylogeny().isEmpty() || this.getMainPanel().getCurrentPhylogeny().getNumberOfExternalNodes() > 10000) {
            return;
        }
        this._textframe = TextFrame.instantiate(this.getMainPanel().getCurrentPhylogeny().toPhyloXML(0));
    }

    static void setupScreenTextAntialias(List<TreePanel> treepanels, boolean antialias) {
        for (TreePanel tree_panel : treepanels) {
            tree_panel.setTextAntialias();
        }
    }
}

