/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Blast {
    private String getResult(String query) throws IOException {
        String baseURL = "http://xml.nig.ac.jp/rest/Invoke";
        URL url = new URL("http://xml.nig.ac.jp/rest/Invoke");
        URLConnection urlc = url.openConnection();
        urlc.setDoOutput(true);
        urlc.setAllowUserInteraction(false);
        PrintStream ps = new PrintStream(urlc.getOutputStream());
        ps.print(query);
        ps.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
        StringBuffer sb = new StringBuffer();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(String.valueOf(line) + "\n");
        }
        br.close();
        return sb.toString();
    }

    void go(String geneName) {
        String queryPath = "/ENTRY/DDBJ/division=='HUM' AND (/ENTRY/DDBJ/length>=300 AND /ENTRY/DDBJ/length<=1000) ";
        queryPath = String.valueOf(queryPath) + "AND (/ENTRY/DDBJ/feature-table/feature{/f_key = 'CDS' AND ";
        queryPath = String.valueOf(queryPath) + "/f_quals/qualifier{/q_name = 'gene' AND /q_value=='" + geneName + "'}})";
        String query = "service=ARSA&method=searchByXMLPath&queryPath=" + queryPath + "&returnPath=/ENTRY/DDBJ/primary-accession&offset=1&count=100";
        String arsaResult = null;
        try {
            arsaResult = this.getResult(query);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] arsaResultLines = arsaResult.split("\n");
        int arsaResultNum = Integer.parseInt(arsaResultLines[0].replaceAll("hitscount       =", "").trim());
        if (arsaResultNum == 0) {
            System.out.println("There is no entry for gene:" + geneName);
            return;
        }
        String repAccession = arsaResultLines[2];
        query = "service=GetEntry&method=getFASTA_DDBJEntry&accession=" + repAccession;
        String dnaSeq = null;
        try {
            dnaSeq = this.getResult(query);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Retrieved DNA sequence is: " + dnaSeq);
        query = "service=Blast&method=searchParam&program=blastn&database=ddbjpri ddbjrod ddbjmam ddbjvrt ddbjinv&query=" + dnaSeq + "&param=-m 8 -b 50 -v 50 -e 0.0001";
        String blastResult = null;
        try {
            blastResult = this.getResult(query);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] blastResultLines = blastResult.split("\n");
        Vector<String[]> parsedBlastResult = new Vector<String[]>();
        String[] stringArray = blastResultLines;
        int n = blastResultLines.length;
        int n2 = 0;
        while (n2 < n) {
            String blastResultLine = stringArray[n2];
            String[] cols = blastResultLine.split("\t");
            String accession = cols[1].substring(0, cols[1].indexOf("|"));
            String[] result = new String[]{accession, cols[2]};
            parsedBlastResult.add(result);
            ++n2;
        }
        Hashtable<String, String> organismAccession = new Hashtable<String, String>();
        int i = 0;
        while (i < parsedBlastResult.size()) {
            String[] parsed = (String[])parsedBlastResult.elementAt(i);
            query = "service=ARSA&method=searchByXMLPath&queryPath=/ENTRY/DDBJ/primary-accession=='" + parsed[0] + "'&returnPath=/ENTRY/DDBJ/organism&offset=1&count=100";
            String organism = null;
            try {
                organism = this.getResult(query);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String[] organismLines = organism.split("\n");
            organism = organismLines[2];
            if (!organismAccession.containsKey(organism)) {
                organismAccession.put(organism, String.valueOf(parsed[0]) + "\t" + parsed[1]);
            }
            ++i;
        }
        System.out.println("DDBJ entries: " + arsaResultNum);
        System.out.println("Representative accession: " + repAccession);
        System.out.println("Organism name\tDDBJ accession number\tSequence similarity");
        Object[] keys = new String[organismAccession.size()];
        Enumeration enu = organismAccession.keys();
        int count = 0;
        while (enu.hasMoreElements()) {
            keys[count] = (String)enu.nextElement();
            ++count;
        }
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n3 = keys.length;
        int n4 = 0;
        while (n4 < n3) {
            Object key = objectArray[n4];
            System.out.println(String.valueOf(key) + "\t" + (String)organismAccession.get(key));
            ++n4;
        }
    }
}

