/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreePanel;

final class ColorSchemeChooser
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 6150960100859081126L;
    private final TreeColorSet _colorset;
    private final JComboBox _selector;
    private final JPanel _color_panel;
    private final JPanel[] _color_labels;
    private final JButton _ok_btn;
    private final JButton _cancel_btn;
    private final MainPanel _main_panel;
    private final int _prev_selected_scheme;
    private int _selected_scheme;

    ColorSchemeChooser(MainPanel parent, TreeColorSet colorset) {
        this.setName("Color Scheme Chooser");
        this.setModal(true);
        this._colorset = colorset;
        this._prev_selected_scheme = this._colorset.getCurrentColorScheme();
        this._main_panel = parent;
        this.setSize(400, 350);
        Container contentpane = this.getContentPane();
        contentpane.setLayout(new BorderLayout(5, 15));
        JPanel select_panel = new JPanel();
        JLabel l = new JLabel("Choose a color scheme:");
        select_panel.add(l);
        Vector<String> list = new Vector<String>();
        String[] stringArray = TreeColorSet.SCHEME_NAMES;
        int n = TreeColorSet.SCHEME_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            list.add(element);
            ++n2;
        }
        this._selector = new JComboBox(list);
        this._selector.setMaximumRowCount(list.size());
        this._selector.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                int selection = ColorSchemeChooser.this._selector.getSelectedIndex();
                ColorSchemeChooser.this.changeDialogColors(selection);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        select_panel.add(this._selector);
        contentpane.add((Component)select_panel, "North");
        int num_colors = TreeColorSet.COLOR_FIELDS.length;
        this._color_panel = new JPanel(new GridLayout(num_colors, 2, 8, 0));
        JLabel[] headings = new JLabel[num_colors];
        this._color_labels = new JPanel[num_colors];
        int i = 0;
        while (i < num_colors) {
            headings[i] = new JLabel(TreeColorSet.COLOR_FIELDS[i]);
            headings[i].setFont(new Font(Configuration.getDefaultFontFamilyName(), 0, 9));
            headings[i].setHorizontalAlignment(4);
            this._color_panel.add(headings[i]);
            this._color_labels[i] = new JPanel();
            this._color_labels[i].setPreferredSize(new Dimension(15, 40));
            this._color_panel.add(this._color_labels[i]);
            ++i;
        }
        contentpane.add((Component)this._color_panel, "Center");
        this.setColors(this._colorset.getColorSchemes()[0]);
        JPanel btn_panel = new JPanel();
        this._ok_btn = new JButton("OK");
        this._ok_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorSchemeChooser.this.ok();
            }
        });
        btn_panel.add(this._ok_btn);
        this._cancel_btn = new JButton("Cancel");
        this._cancel_btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorSchemeChooser.this.cancel();
            }
        });
        btn_panel.add(this._cancel_btn);
        btn_panel.setPreferredSize(new Dimension(400, 30));
        this.getContentPane().add((Component)btn_panel, "South");
        this.setCurrentColor(colorset.getCurrentColorScheme());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void cancel() {
        this._colorset.setColorSchema(this._prev_selected_scheme);
        for (TreePanel tree_panel : this.getMainPanel().getTreePanels()) {
            tree_panel.setBackground(this._colorset.getBackgroundColor());
        }
        this.redrawTreePanel();
        this.setVisible(false);
        this.dispose();
    }

    private void changeDialogColors(int scheme_index) {
        this._selected_scheme = scheme_index;
        this.setColors(this._colorset.getColorSchemes()[scheme_index]);
        this._colorset.setColorSchema(this.getSelectedScheme());
        for (TreePanel tree_panel : this.getMainPanel().getTreePanels()) {
            tree_panel.setBackground(this._colorset.getBackgroundColor());
        }
        this.redrawTreePanel();
    }

    private MainPanel getMainPanel() {
        return this._main_panel;
    }

    private int getSelectedScheme() {
        return this._selected_scheme;
    }

    private void ok() {
        this._colorset.setColorSchema(this.getSelectedScheme());
        this.setVisible(false);
        this.dispose();
    }

    private void redrawTreePanel() {
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            this.getMainPanel().getCurrentTreePanel().repaint();
        }
    }

    private void setColors(Color[] colors) {
        int i = 0;
        while (i < colors.length) {
            this._color_labels[i].setBackground(colors[i]);
            ++i;
        }
    }

    private void setCurrentColor(int color_index) {
        this.setColors(this._colorset.getColorSchemes()[color_index]);
        this._selector.setSelectedIndex(color_index);
    }
}

