/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import org.forester.archaeopteryx.ArchaeopteryxE;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.Util;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.ForesterUtil;

final class ControlPanel
extends JPanel
implements ActionListener {
    private static final String RETURN_TO_SUPER_TREE_TEXT = "Back to Super Tree";
    static final Font jcb_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 9);
    static final Font js_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 9);
    static final Font jcb_bold_font = new Font(Configuration.getDefaultFontFamilyName(), 1, 9);
    private static Color background_color;
    private static Color jcb_text_color;
    private static Color jcb_background_color;
    private static Color button_text_color;
    private static Color button_background_color;
    private static Color button_border_color;
    private static final long serialVersionUID = -8463483932821545633L;
    private final MainPanel _mainpanel;
    private final Configuration _configuration;
    private JCheckBox _display_internal_data;
    private JCheckBox _show_node_names;
    private JCheckBox _show_taxo_code;
    private JCheckBox _write_confidence;
    private JCheckBox _show_events;
    private JCheckBox _color_acc_species;
    private JCheckBox _color_branches_cb;
    private JCheckBox _width_branches;
    private JCheckBox _show_domain_architectures;
    private JCheckBox _show_annotation;
    private JCheckBox _show_binary_characters;
    private JCheckBox _show_binary_character_counts;
    private JCheckBox _show_gene_names;
    private JCheckBox _show_gene_symbols;
    private JCheckBox _show_sequence_acc;
    private JCheckBox _node_desc_popup_cb;
    private JCheckBox _dynamically_hide_data;
    private JCheckBox _show_taxo_names;
    private JCheckBox _color_according_to_annotation;
    private JCheckBox _display_as_phylogram_cb;
    private JLabel _click_to_label;
    private JLabel _zoom_label;
    private JLabel _domain_display_label;
    private JComboBox _click_to_combobox;
    private Map<Integer, String> _all_click_to_names;
    private List<String> _click_to_names;
    private int _show_data_item;
    private int _collapse_cb_item;
    private int _reroot_cb_item;
    private int _swap_cb_item;
    private int _subtree_cb_item;
    private int _color_subtree_cb_item;
    private int _open_seq_web_item;
    private int _open_tax_web_item;
    private int _cut_subtree_item;
    private int _copy_subtree_item;
    private int _delete_node_or_subtree_item;
    private int _paste_subtree_item;
    private int _add_new_node_item;
    private int _edit_node_data_item;
    private int _blast_item;
    private JButton _zoom_in_x;
    private JButton _zoom_in_y;
    private JButton _zoom_out_x;
    private JButton _zoom_out_y;
    private JButton _show_whole;
    private JButton _order;
    private JButton _uncollapse_all;
    private JButton _zoom_in_domain_structure;
    private JButton _zoom_out_domain_structure;
    private JButton _decr_domain_structure_evalue_thr;
    private JButton _incr_domain_structure_evalue_thr;
    private JButton _return_to_super_tree;
    private JTextField _domain_structure_evalue_thr_tf;
    private JTextField _search_tf;
    private boolean _order_of_appearance;
    private boolean _color_branches;
    private NodeClickAction _action_when_node_clicked;
    private List<Boolean> _draw_phylogram;
    private Map<String, Color> _annotation_colors;
    private Map<String, Color> _species_colors;
    private JButton _search_reset_button;
    private JLabel _search_found_label;

    ControlPanel(MainPanel ap, Configuration config_settings) {
        this.init();
        this._mainpanel = ap;
        this._configuration = config_settings;
        this.setDefaultColors();
        if (!this._configuration.isUseNativeUI()) {
            this.setBackground(background_color);
            this.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        this.setLayout(new GridLayout(0, 1, 2, 2));
        this._order_of_appearance = true;
        this.setupControls();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            TreePanel tp = this._mainpanel.getCurrentTreePanel();
            if (tp == null) {
                return;
            }
            if (e.getSource() == this._click_to_combobox) {
                this.setClickToAction(this._click_to_combobox.getSelectedIndex());
                this.getCurrentTreePanel().repaint();
            } else if (e.getSource() == this._show_binary_characters) {
                if (this._show_binary_character_counts != null && this._show_binary_characters.isSelected()) {
                    this._show_binary_character_counts.setSelected(false);
                }
                this.displayedPhylogenyMightHaveChanged(true);
            } else if (e.getSource() == this._show_binary_character_counts) {
                if (this._show_binary_characters != null && this._show_binary_character_counts.isSelected()) {
                    this._show_binary_characters.setSelected(false);
                }
                this.displayedPhylogenyMightHaveChanged(true);
            } else if (e.getSource() == this._color_according_to_annotation) {
                if (this._show_annotation != null && this._color_according_to_annotation.isSelected()) {
                    this._show_annotation.setSelected(true);
                }
                this.displayedPhylogenyMightHaveChanged(false);
            } else if (e.getSource() == this._show_annotation) {
                if (this._color_according_to_annotation != null && !this._show_annotation.isSelected()) {
                    this._color_according_to_annotation.setSelected(false);
                }
                this.displayedPhylogenyMightHaveChanged(false);
            } else if (tp != null && tp.getPhylogeny() != null) {
                if (e.getSource() == this.getDisplayAsPhylogramCb()) {
                    this.setDrawPhylogram(this.getDisplayAsPhylogramCb().isSelected());
                    this.showWhole();
                } else if (e.getSource() == this._zoom_in_x) {
                    this.zoomInX(1.25f, 1.2f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (e.getSource() == this._zoom_in_y) {
                    this.zoomInY(1.25f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (e.getSource() == this._zoom_out_x) {
                    this.zoomOutX(0.8f, 0.8333333f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (e.getSource() == this._zoom_out_y) {
                    this.zoomOutY(0.8f);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (e.getSource() == this._show_whole) {
                    this.showWhole();
                } else if (e.getSource() == this._return_to_super_tree) {
                    this._mainpanel.getCurrentTreePanel().superTree();
                    this.showWhole();
                } else if (e.getSource() == this._order) {
                    tp.getPhylogeny().orderAppearance(this._order_of_appearance);
                    this._order_of_appearance = !this._order_of_appearance;
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (e.getSource() == this._uncollapse_all) {
                    this.uncollapseAll(tp);
                    this.displayedPhylogenyMightHaveChanged(false);
                } else if (e.getSource() == this._zoom_in_domain_structure) {
                    this._mainpanel.getCurrentTreePanel().zoomInDomainStructure();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (e.getSource() == this._zoom_out_domain_structure) {
                    this._mainpanel.getCurrentTreePanel().zoomOutDomainStructure();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (e.getSource() == this._decr_domain_structure_evalue_thr) {
                    this._mainpanel.getCurrentTreePanel().decreaseDomainStructureEvalueThreshold();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (e.getSource() == this._incr_domain_structure_evalue_thr) {
                    this._mainpanel.getCurrentTreePanel().increaseDomainStructureEvalueThreshold();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else if (e.getSource() == this._search_tf) {
                    this.search();
                    this.displayedPhylogenyMightHaveChanged(true);
                } else {
                    this.displayedPhylogenyMightHaveChanged(true);
                }
            }
            tp.requestFocus();
            tp.requestFocusInWindow();
            tp.requestFocus();
        }
        catch (Exception ex) {
            Util.unexpectedException(ex);
        }
        catch (Error err) {
            Util.unexpectedError(err);
        }
    }

    void activateButtonToReturnToSuperTree(int index) {
        if (--index > 0) {
            this._return_to_super_tree.setText("Back to Super Tree " + index);
        } else {
            this._return_to_super_tree.setText(RETURN_TO_SUPER_TREE_TEXT);
        }
        this._return_to_super_tree.setForeground(Constants.BUTTON_TEXT_COLOR_ON_DEFAULT);
        this._return_to_super_tree.setEnabled(true);
    }

    void addButtons() {
        JLabel spacer = new JLabel("");
        spacer.setOpaque(false);
        this.add(spacer);
        JPanel x_panel = new JPanel(new GridLayout(1, 1, 0, 0));
        JPanel y_panel = new JPanel(new GridLayout(1, 3, 0, 0));
        JPanel z_panel = new JPanel(new GridLayout(1, 1, 0, 0));
        if (!this.getConfiguration().isUseNativeUI()) {
            x_panel.setBackground(this.getBackground());
            y_panel.setBackground(this.getBackground());
            z_panel.setBackground(this.getBackground());
        }
        this._zoom_label = new JLabel("Zoom:");
        this.add(this._zoom_label);
        ControlPanel.customizeLabel(this._zoom_label, this.getConfiguration());
        this.add(x_panel);
        this.add(y_panel);
        this.add(z_panel);
        if (this.getConfiguration().isUseNativeUI()) {
            this._zoom_in_x = new JButton("+");
            this._zoom_out_x = new JButton("-");
        } else {
            this._zoom_in_x = new JButton("X+");
            this._zoom_out_x = new JButton("X-");
        }
        this._zoom_in_y = new JButton("Y+");
        this._zoom_out_y = new JButton("Y-");
        this._show_whole = new JButton("F");
        this._show_whole.setToolTipText("To fit the complete phylogeny to the current display size [Backspace]");
        this._zoom_in_x.setToolTipText("To zoom in horizontally [Shift+Right]");
        this._zoom_in_y.setToolTipText("To zoom in vertically [Shift+Up]");
        this._zoom_out_x.setToolTipText("To zoom out horizontally [Shift+Left]");
        this._zoom_out_y.setToolTipText("To zoom out vertically [Shift+Down]");
        if (this.getConfiguration().isUseNativeUI() && Util.isMac()) {
            this._zoom_out_x.setPreferredSize(new Dimension(55, 10));
            this._zoom_in_x.setPreferredSize(new Dimension(55, 10));
        } else {
            this._zoom_out_x.setPreferredSize(new Dimension(10, 10));
            this._zoom_in_x.setPreferredSize(new Dimension(10, 10));
        }
        this._zoom_out_y.setPreferredSize(new Dimension(10, 10));
        this._zoom_in_y.setPreferredSize(new Dimension(10, 10));
        this._show_whole.setPreferredSize(new Dimension(10, 10));
        this._return_to_super_tree = new JButton(RETURN_TO_SUPER_TREE_TEXT);
        this._return_to_super_tree.setEnabled(false);
        this._order = new JButton("Order Subtrees");
        this._uncollapse_all = new JButton("Uncollapse All");
        this.addJButton(this._zoom_in_y, x_panel);
        this.addJButton(this._zoom_out_x, y_panel);
        this.addJButton(this._show_whole, y_panel);
        this.addJButton(this._zoom_in_x, y_panel);
        this.addJButton(this._zoom_out_y, z_panel);
        if (this.getConfiguration().doDisplayOption(9)) {
            this.setUpControlsForDomainStrucures();
        }
        JLabel spacer2 = new JLabel("");
        this.add(spacer2);
        this.addJButton(this._return_to_super_tree, this);
        this.addJButton(this._order, this);
        this.addJButton(this._uncollapse_all, this);
        JLabel spacer3 = new JLabel("");
        this.add(spacer3);
        this.setVisibilityOfDomainStrucureControls();
    }

    void addCheckbox(int which, String title) {
        JPanel ch_panel = new JPanel(new BorderLayout(0, 0));
        switch (which) {
            case 0: {
                this._display_as_phylogram_cb = new JCheckBox(title);
                this.getDisplayAsPhylogramCb().setToolTipText("To switch between phylogram and cladogram display");
                this.addJCheckBox(this.getDisplayAsPhylogramCb(), ch_panel);
                this.add(ch_panel);
                break;
            }
            case 14: {
                this._display_internal_data = new JCheckBox(title);
                this._display_internal_data.setToolTipText("To allow or disallow display of internal labels");
                this.addJCheckBox(this._display_internal_data, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 6: {
                this._color_acc_species = new JCheckBox(title);
                this._color_acc_species.setToolTipText("To colorize taxonomy and sequence labels as a function of taxonomy");
                this.addJCheckBox(this._color_acc_species, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 17: {
                this._color_according_to_annotation = new JCheckBox(title);
                this._color_according_to_annotation.setToolTipText("To colorize sequence annotation labels as a function of sequence annotation");
                this.addJCheckBox(this._color_according_to_annotation, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 1: {
                this._show_node_names = new JCheckBox(title);
                this.addJCheckBox(this._show_node_names, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 2: {
                this._show_taxo_code = new JCheckBox(title);
                this.addJCheckBox(this._show_taxo_code, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 16: {
                this._show_taxo_names = new JCheckBox(title);
                this.addJCheckBox(this._show_taxo_names, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 10: {
                this._show_binary_characters = new JCheckBox(title);
                this.addJCheckBox(this._show_binary_characters, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 3: {
                this._show_annotation = new JCheckBox(title);
                this.addJCheckBox(this._show_annotation, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 11: {
                this._show_binary_character_counts = new JCheckBox(title);
                this.addJCheckBox(this._show_binary_character_counts, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 4: {
                this._write_confidence = new JCheckBox(title);
                this.addJCheckBox(this.getWriteConfidenceCb(), ch_panel);
                this.add(ch_panel);
                break;
            }
            case 5: {
                this._show_events = new JCheckBox(title);
                this.addJCheckBox(this.getShowEventsCb(), ch_panel);
                this.add(ch_panel);
                break;
            }
            case 7: {
                this._color_branches_cb = new JCheckBox(title);
                this.getColorBranchesCb().setToolTipText("To use branch color values, if present");
                this.addJCheckBox(this.getColorBranchesCb(), ch_panel);
                this.add(ch_panel);
                break;
            }
            case 8: {
                this._width_branches = new JCheckBox(title);
                this._width_branches.setToolTipText("To use branch width values, if present");
                this.addJCheckBox(this._width_branches, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 9: {
                this._show_domain_architectures = new JCheckBox(title);
                this.addJCheckBox(this._show_domain_architectures, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 12: {
                this._show_gene_names = new JCheckBox(title);
                this.addJCheckBox(this._show_gene_names, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 19: {
                this._show_gene_symbols = new JCheckBox(title);
                this.addJCheckBox(this._show_gene_symbols, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 13: {
                this._show_sequence_acc = new JCheckBox(title);
                this.addJCheckBox(this._show_sequence_acc, ch_panel);
                this.add(ch_panel);
                break;
            }
            case 15: {
                this._dynamically_hide_data = new JCheckBox(title);
                this.getDynamicallyHideData().setToolTipText("To hide labels depending on likely visibility");
                this.addJCheckBox(this.getDynamicallyHideData(), ch_panel);
                this.add(ch_panel);
                break;
            }
            case 20: {
                this._node_desc_popup_cb = new JCheckBox(title);
                this.getNodeDescPopupCb().setToolTipText("To enable mouse rollover display of basic node data");
                this.addJCheckBox(this.getNodeDescPopupCb(), ch_panel);
                this.add(ch_panel);
                break;
            }
            default: {
                throw new IllegalStateException("unknown checkbox: " + which);
            }
        }
    }

    private void addClickToOption(int which, String title) {
        this._click_to_combobox.addItem(title);
        this._click_to_names.add(title);
        this._all_click_to_names.put(new Integer(which), title);
        if (!this._configuration.isUseNativeUI()) {
            this._click_to_combobox.setBackground(Constants.BUTTON_BACKGROUND_COLOR_DEFAULT);
            this._click_to_combobox.setForeground(Constants.BUTTON_TEXT_COLOR_DEFAULT);
        }
    }

    void addJButton(JButton jb, JPanel p) {
        jb.setFocusPainted(false);
        jb.setFont(jcb_font);
        if (!this._configuration.isUseNativeUI()) {
            jb.setBorder(BorderFactory.createLineBorder(button_border_color));
            jb.setBackground(button_background_color);
            jb.setForeground(button_text_color);
        }
        p.add(jb);
        jb.addActionListener(this);
    }

    void addJCheckBox(JCheckBox jcb, JPanel p) {
        jcb.setFocusPainted(false);
        jcb.setFont(jcb_font);
        if (!this._configuration.isUseNativeUI()) {
            jcb.setBackground(jcb_background_color);
            jcb.setForeground(jcb_text_color);
        }
        p.add((Component)jcb, "Center");
        jcb.addActionListener(this);
    }

    void addJTextField(JTextField tf, JPanel p) {
        if (!this._configuration.isUseNativeUI()) {
            tf.setForeground(background_color);
            tf.setFont(jcb_font);
        }
        p.add(tf);
        tf.addActionListener(this);
    }

    void deactivateButtonToReturnToSuperTree() {
        this._return_to_super_tree.setText(RETURN_TO_SUPER_TREE_TEXT);
        this._return_to_super_tree.setForeground(Constants.BUTTON_TEXT_COLOR_DEFAULT);
        this._return_to_super_tree.setEnabled(false);
    }

    void displayedPhylogenyMightHaveChanged(boolean recalc_longest_ext_node_info) {
        if (this._mainpanel != null && this._mainpanel.getCurrentPhylogeny() != null) {
            if (this.getOptions().isShowOverview()) {
                this._mainpanel.getCurrentTreePanel().updateOvSizes();
            }
            this._mainpanel.getCurrentTreePanel().recalculateMaxDistanceToRoot();
            this.setVisibilityOfDomainStrucureControls();
            this.updateDomainStructureEvaluethresholdDisplay();
            this._mainpanel.getCurrentTreePanel().calculateScaleDistance();
            this._mainpanel.getCurrentTreePanel().calcMaxDepth();
            this._mainpanel.adjustJScrollPane();
            if (recalc_longest_ext_node_info) {
                this._mainpanel.getCurrentTreePanel().initNodeData();
                this._mainpanel.getCurrentTreePanel().calculateLongestExtNodeInfo();
            }
            this._mainpanel.getCurrentTreePanel().repaint();
        }
    }

    void endClickToOptions() {
        this._click_to_combobox.addActionListener(this);
    }

    NodeClickAction getActionWhenNodeClicked() {
        return this._action_when_node_clicked;
    }

    Map<Integer, String> getAllClickToItems() {
        return this._all_click_to_names;
    }

    Map<String, Color> getAnnotationColors() {
        return this._annotation_colors;
    }

    public JCheckBox getColorBranchesCb() {
        return this._color_branches_cb;
    }

    Configuration getConfiguration() {
        return this._configuration;
    }

    TreePanel getCurrentTreePanel() {
        return this.getMainPanel().getCurrentTreePanel();
    }

    public JCheckBox getDisplayAsPhylogramCb() {
        return this._display_as_phylogram_cb;
    }

    public JCheckBox getDynamicallyHideData() {
        return this._dynamically_hide_data;
    }

    private List<Boolean> getIsDrawPhylogramList() {
        return this._draw_phylogram;
    }

    MainPanel getMainPanel() {
        return this._mainpanel;
    }

    public JCheckBox getNodeDescPopupCb() {
        return this._node_desc_popup_cb;
    }

    Options getOptions() {
        return this.getMainPanel().getOptions();
    }

    private JLabel getSearchFoundCountsLabel() {
        return this._search_found_label;
    }

    private JButton getSearchResetButton() {
        return this._search_reset_button;
    }

    JTextField getSearchTextField() {
        return this._search_tf;
    }

    public JCheckBox getShowEventsCb() {
        return this._show_events;
    }

    List<String> getSingleClickToNames() {
        return this._click_to_names;
    }

    Map<String, Color> getSpeciesColors() {
        return this._species_colors;
    }

    public JCheckBox getWriteConfidenceCb() {
        return this._write_confidence;
    }

    private void init() {
        this._draw_phylogram = new ArrayList<Boolean>();
        this.setSpeciesColors(new HashMap<String, Color>());
        this.setAnnotationColors(new HashMap<String, Color>());
    }

    boolean isAntialiasScreenText() {
        return true;
    }

    boolean isColorAccordingToAnnotation() {
        return this._color_according_to_annotation != null && this._color_according_to_annotation.isSelected();
    }

    boolean isColorAccordingToTaxonomy() {
        return this._color_acc_species != null && this._color_acc_species.isSelected();
    }

    boolean isColorBranches() {
        return this.getColorBranchesCb() != null && this.getColorBranchesCb().isSelected() || this.getColorBranchesCb() == null && this._color_branches;
    }

    boolean isDrawPhylogram() {
        return this.isDrawPhylogram(this.getMainPanel().getCurrentTabIndex());
    }

    private boolean isDrawPhylogram(int index) {
        return this.getIsDrawPhylogramList().get(index);
    }

    boolean isDynamicallyHideData() {
        return this.getDynamicallyHideData() != null && this.getDynamicallyHideData().isSelected();
    }

    boolean isEvents() {
        return this.getShowEventsCb() != null && this.getShowEventsCb().isSelected();
    }

    boolean isNodeDescPopup() {
        return this.getNodeDescPopupCb() != null && this.getNodeDescPopupCb().isSelected();
    }

    boolean isShowAnnotation() {
        return this._show_annotation != null && this._show_annotation.isSelected();
    }

    boolean isShowBinaryCharacterCounts() {
        return this._show_binary_character_counts != null && this._show_binary_character_counts.isSelected();
    }

    boolean isShowBinaryCharacters() {
        return this._show_binary_characters != null && this._show_binary_characters.isSelected();
    }

    boolean isShowBootstrapValues() {
        return this.getWriteConfidenceCb() != null && this.getWriteConfidenceCb().isSelected();
    }

    boolean isShowDate() {
        return true;
    }

    boolean isShowDistribution() {
        return true;
    }

    boolean isShowDomainArchitectures() {
        return this._show_domain_architectures != null && this._show_domain_architectures.isSelected();
    }

    boolean isShowGeneNames() {
        return this._show_gene_names != null && this._show_gene_names.isSelected();
    }

    boolean isShowGeneSymbols() {
        return this._show_gene_symbols != null && this._show_gene_symbols.isSelected();
    }

    boolean isShowInternalData() {
        return this._display_internal_data == null || this._display_internal_data.isSelected();
    }

    boolean isShowNodeNames() {
        return this._show_node_names != null && this._show_node_names.isSelected();
    }

    public boolean isShowProperties() {
        return false;
    }

    boolean isShowProperty() {
        return this._show_annotation != null && this._show_annotation.isSelected();
    }

    boolean isShowSequenceAcc() {
        return this._show_sequence_acc != null && this._show_sequence_acc.isSelected();
    }

    boolean isShowTaxonomyCode() {
        return this._show_taxo_code != null && this._show_taxo_code.isSelected();
    }

    boolean isShowTaxonomyNames() {
        return this._show_taxo_names != null && this._show_taxo_names.isSelected();
    }

    boolean isWidthBranches() {
        return this._width_branches != null && this._width_branches.isSelected();
    }

    void phylogenyAdded(Configuration configuration) {
        this.getIsDrawPhylogramList().add(configuration.isDrawAsPhylogram());
    }

    void phylogenyRemoved(int index) {
        this.getIsDrawPhylogramList().remove(index);
    }

    void search() {
        MainPanel main_panel = this.getMainPanel();
        Phylogeny tree = main_panel.getCurrentPhylogeny();
        if (tree == null || tree.isEmpty()) {
            return;
        }
        String query = this.getSearchTextField().getText();
        if (query != null) {
            query = query.trim();
        } else {
            this.getSearchFoundCountsLabel().setVisible(false);
            this.getSearchResetButton().setEnabled(false);
            this.getSearchResetButton().setVisible(false);
            this.searchReset();
        }
        if (!ForesterUtil.isEmpty(query)) {
            this.search(main_panel, tree, query);
        } else {
            this.getSearchFoundCountsLabel().setVisible(false);
            this.getSearchResetButton().setEnabled(false);
            this.getSearchResetButton().setVisible(false);
            this.searchReset();
        }
    }

    private void search(MainPanel atv_panel, Phylogeny tree, String query_str) {
        this.getSearchFoundCountsLabel().setVisible(true);
        this.getSearchResetButton().setEnabled(true);
        this.getSearchResetButton().setVisible(true);
        String[] queries = null;
        Set<PhylogenyNode> nodes = null;
        queries = query_str.indexOf(44) >= 0 ? query_str.split(",+") : new String[]{query_str.trim()};
        if (queries != null && queries.length > 0) {
            nodes = new HashSet<PhylogenyNode>();
            String[] stringArray = queries;
            int n = queries.length;
            int n2 = 0;
            while (n2 < n) {
                String query = stringArray[n2];
                if (!ForesterUtil.isEmpty(query)) {
                    if ((query = query.trim()).indexOf(43) >= 0) {
                        nodes.addAll(PhylogenyMethods.searchDataLogicalAnd(query.split("\\++"), tree, this.getOptions().isSearchCaseSensitive(), !this.getOptions().isMatchWholeTermsOnly()));
                    } else {
                        nodes.addAll(PhylogenyMethods.searchData(query, tree, this.getOptions().isSearchCaseSensitive(), !this.getOptions().isMatchWholeTermsOnly()));
                    }
                }
                ++n2;
            }
            if (this.getOptions().isInverseSearchResult()) {
                Set<PhylogenyNode> all = PhylogenyMethods.obtainAllNodesAsSet(tree);
                all.removeAll(nodes);
                nodes = all;
            }
        }
        if (nodes != null && nodes.size() > 0) {
            atv_panel.getCurrentTreePanel().setFoundNodes(nodes);
            this.setSearchFoundCountsOnLabel(nodes.size());
        } else {
            this.setSearchFoundCountsOnLabel(0);
            this.searchReset();
        }
    }

    private void searchReset() {
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            this.getMainPanel().getCurrentTreePanel().setFoundNodes(null);
        }
    }

    void setActionWhenNodeClicked(NodeClickAction action) {
        this._action_when_node_clicked = action;
    }

    void setAnnotationColors(Map<String, Color> annotation_colors) {
        this._annotation_colors = annotation_colors;
    }

    void setCheckbox(int which, boolean state) {
        switch (which) {
            case 0: {
                if (this.getDisplayAsPhylogramCb() == null) break;
                this.getDisplayAsPhylogramCb().setSelected(state);
                break;
            }
            case 14: {
                if (this._display_internal_data == null) break;
                this._display_internal_data.setSelected(state);
                break;
            }
            case 6: {
                if (this._color_acc_species == null) break;
                this._color_acc_species.setSelected(state);
                break;
            }
            case 17: {
                if (this._color_according_to_annotation == null) break;
                this._color_according_to_annotation.setSelected(state);
                break;
            }
            case 1: {
                if (this._show_node_names == null) break;
                this._show_node_names.setSelected(state);
                break;
            }
            case 2: {
                if (this._show_taxo_code == null) break;
                this._show_taxo_code.setSelected(state);
                break;
            }
            case 16: {
                if (this._show_taxo_names == null) break;
                this._show_taxo_names.setSelected(state);
                break;
            }
            case 3: {
                if (this._show_annotation == null) break;
                this._show_annotation.setSelected(state);
                break;
            }
            case 10: {
                if (this._show_binary_characters == null) break;
                this._show_binary_characters.setSelected(state);
                break;
            }
            case 11: {
                if (this._show_binary_character_counts == null) break;
                this._show_binary_character_counts.setSelected(state);
                break;
            }
            case 4: {
                if (this.getWriteConfidenceCb() == null) break;
                this.getWriteConfidenceCb().setSelected(state);
                break;
            }
            case 5: {
                if (this.getShowEventsCb() == null) break;
                this.getShowEventsCb().setSelected(state);
                break;
            }
            case 7: {
                if (this.getColorBranchesCb() == null) break;
                this.getColorBranchesCb().setSelected(state);
                break;
            }
            case 8: {
                if (this._width_branches == null) break;
                this._width_branches.setSelected(state);
                break;
            }
            case 9: {
                if (this._show_domain_architectures == null) break;
                this._show_domain_architectures.setSelected(state);
                break;
            }
            case 12: {
                if (this._show_gene_names == null) break;
                this._show_gene_names.setSelected(state);
                break;
            }
            case 19: {
                if (this._show_gene_symbols == null) break;
                this._show_gene_symbols.setSelected(state);
                break;
            }
            case 13: {
                if (this._show_sequence_acc == null) break;
                this._show_sequence_acc.setSelected(state);
                break;
            }
            case 15: {
                if (this.getDynamicallyHideData() == null) break;
                this.getDynamicallyHideData().setSelected(state);
                break;
            }
            case 20: {
                if (this.getNodeDescPopupCb() == null) break;
                this.getNodeDescPopupCb().setSelected(state);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown checkbox: " + which));
            }
        }
    }

    void setCheckbox(JCheckBox cb, boolean state) {
        if (cb != null) {
            cb.setSelected(state);
        }
    }

    void setClickToAction(int action) {
        if (action == this._show_data_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SHOW_DATA);
        } else if (action == this._collapse_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COLLAPSE);
        } else if (action == this._reroot_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.REROOT);
        } else if (action == this._subtree_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SUBTREE);
        } else if (action == this._swap_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.SWAP);
        } else if (action == this._color_subtree_cb_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COLOR_SUBTREE);
        } else if (action == this._open_seq_web_item) {
            this.setActionWhenNodeClicked(NodeClickAction.OPEN_SEQ_WEB);
        } else if (action == this._blast_item) {
            this.setActionWhenNodeClicked(NodeClickAction.BLAST);
        } else if (action == this._open_tax_web_item) {
            this.setActionWhenNodeClicked(NodeClickAction.OPEN_TAX_WEB);
        } else if (action == this._cut_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.CUT_SUBTREE);
        } else if (action == this._copy_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.COPY_SUBTREE);
        } else if (action == this._delete_node_or_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.DELETE_NODE_OR_SUBTREE);
        } else if (action == this._paste_subtree_item) {
            this.setActionWhenNodeClicked(NodeClickAction.PASTE_SUBTREE);
        } else if (action == this._add_new_node_item) {
            this.setActionWhenNodeClicked(NodeClickAction.ADD_NEW_NODE);
        } else if (action == this._edit_node_data_item) {
            this.setActionWhenNodeClicked(NodeClickAction.EDIT_NODE_DATA);
        } else {
            throw new IllegalStateException("unknown action: " + action);
        }
        this._click_to_combobox.setSelectedIndex(action);
    }

    void setColorBranches(boolean color_branches) {
        this._color_branches = color_branches;
    }

    void setDefaultColors() {
        background_color = Constants.GUI_BACKGROUND_DEFAULT;
        jcb_text_color = Constants.CHECKBOX_TEXT_COLOR_DEFAULT;
        jcb_background_color = Constants.CHECKBOX_BACKGROUND_COLOR_DEFAULT;
        button_text_color = Constants.BUTTON_TEXT_COLOR_DEFAULT;
        button_background_color = Constants.BUTTON_BACKGROUND_COLOR_DEFAULT;
        button_border_color = Constants.BUTTON_BORDER_COLOR;
    }

    void setDrawPhylogram(boolean b) {
        this.getDisplayAsPhylogramCb().setSelected(b);
        this.setDrawPhylogram(this.getMainPanel().getCurrentTabIndex(), b);
    }

    private void setDrawPhylogram(int index, boolean b) {
        this.getIsDrawPhylogramList().set(index, b);
    }

    void setDrawPhylogramEnabled(boolean b) {
        this.getDisplayAsPhylogramCb().setEnabled(b);
    }

    void setDynamicHidingIsOn(boolean is_on) {
        if (is_on) {
            this.getDynamicallyHideData().setForeground(Constants.CHECKBOX_TEXT_COLOR_ON_DEFAULT);
        } else if (!this._configuration.isUseNativeUI()) {
            this.getDynamicallyHideData().setForeground(Constants.CHECKBOX_TEXT_COLOR_DEFAULT);
        } else {
            this.getDynamicallyHideData().setForeground(Color.BLACK);
        }
    }

    private void setSearchFoundCountsOnLabel(int counts) {
        this.getSearchFoundCountsLabel().setText("Found: " + counts);
    }

    void setShowEvents(boolean show_events) {
        if (this.getShowEventsCb() == null) {
            this._show_events = new JCheckBox("");
        }
        this.getShowEventsCb().setSelected(show_events);
    }

    void setSpeciesColors(Map<String, Color> species_colors) {
        this._species_colors = species_colors;
    }

    private void setupClickToOptions() {
        int default_option = this._configuration.getDefaultDisplayClicktoOption();
        int selected_index = 0;
        int cb_index = 0;
        if (this._configuration.doDisplayClickToOption(0)) {
            this._show_data_item = cb_index;
            this.addClickToOption(0, this._configuration.getClickToTitle(0));
            if (default_option == 0) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(1)) {
            this._collapse_cb_item = cb_index;
            this.addClickToOption(1, this._configuration.getClickToTitle(1));
            if (default_option == 1) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(2)) {
            this._reroot_cb_item = cb_index;
            this.addClickToOption(2, this._configuration.getClickToTitle(2));
            if (default_option == 2) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(3)) {
            this._subtree_cb_item = cb_index;
            this.addClickToOption(3, this._configuration.getClickToTitle(3));
            if (default_option == 3) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(4)) {
            this._swap_cb_item = cb_index;
            this.addClickToOption(4, this._configuration.getClickToTitle(4));
            if (default_option == 4) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(5)) {
            this._color_subtree_cb_item = cb_index;
            this.addClickToOption(5, this._configuration.getClickToTitle(5));
            if (default_option == 5) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(6)) {
            this._open_seq_web_item = cb_index;
            this.addClickToOption(6, this._configuration.getClickToTitle(6));
            if (default_option == 6) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this._configuration.doDisplayClickToOption(7)) {
            this._open_tax_web_item = cb_index;
            this.addClickToOption(7, this._configuration.getClickToTitle(7));
            if (default_option == 7) {
                selected_index = cb_index;
            }
            ++cb_index;
        }
        if (this.getOptions().isEditable()) {
            if (this._configuration.doDisplayClickToOption(8)) {
                this._cut_subtree_item = cb_index;
                this.addClickToOption(8, this._configuration.getClickToTitle(8));
                if (default_option == 8) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
            if (this._configuration.doDisplayClickToOption(9)) {
                this._copy_subtree_item = cb_index;
                this.addClickToOption(9, this._configuration.getClickToTitle(9));
                if (default_option == 9) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
            if (this._configuration.doDisplayClickToOption(10)) {
                this._paste_subtree_item = cb_index;
                this.addClickToOption(10, this._configuration.getClickToTitle(10));
                if (default_option == 10) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
            if (this._configuration.doDisplayClickToOption(11)) {
                this._delete_node_or_subtree_item = cb_index;
                this.addClickToOption(11, this._configuration.getClickToTitle(11));
                if (default_option == 11) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
            if (this._configuration.doDisplayClickToOption(12)) {
                this._add_new_node_item = cb_index;
                this.addClickToOption(12, this._configuration.getClickToTitle(12));
                if (default_option == 12) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
            if (this._configuration.doDisplayClickToOption(13)) {
                this._edit_node_data_item = cb_index;
                this.addClickToOption(13, this._configuration.getClickToTitle(13));
                if (default_option == 13) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
            if (this._configuration.doDisplayClickToOption(14)) {
                this._blast_item = cb_index;
                this.addClickToOption(14, this._configuration.getClickToTitle(14));
                if (default_option == 14) {
                    selected_index = cb_index;
                }
                ++cb_index;
            }
        }
        this._click_to_combobox.setSelectedIndex(selected_index);
        this.setClickToAction(selected_index);
    }

    void setupControls() {
        this.setupDisplayCheckboxes();
        this.startClickToOptions();
        this.setupClickToOptions();
        this.endClickToOptions();
        this.addButtons();
        this.setupSearchTools();
    }

    void setUpControlsForDomainStrucures() {
        this._domain_display_label = new JLabel("Domain Display:");
        this.add(ControlPanel.customizeLabel(this._domain_display_label, this.getConfiguration()));
        this.add(this._domain_display_label);
        this._zoom_in_domain_structure = new JButton("d+");
        this._zoom_out_domain_structure = new JButton("d-");
        this._decr_domain_structure_evalue_thr = new JButton("-");
        this._incr_domain_structure_evalue_thr = new JButton("+");
        this._zoom_in_domain_structure.setPreferredSize(new Dimension(10, 10));
        this._zoom_out_domain_structure.setPreferredSize(new Dimension(10, 10));
        this._decr_domain_structure_evalue_thr.setPreferredSize(new Dimension(10, 10));
        this._incr_domain_structure_evalue_thr.setPreferredSize(new Dimension(10, 10));
        this._incr_domain_structure_evalue_thr.setToolTipText("Increase the E-value threshold by a factor of 10");
        this._decr_domain_structure_evalue_thr.setToolTipText("Decrease the E-value threshold by a factor of 10");
        this._domain_structure_evalue_thr_tf = new JTextField(3);
        this._domain_structure_evalue_thr_tf.setEditable(false);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._domain_structure_evalue_thr_tf.setForeground(Constants.MENU_BACKGROUND_COLOR_DEFAULT);
            this._domain_structure_evalue_thr_tf.setBackground(jcb_text_color);
            this._domain_structure_evalue_thr_tf.setBorder(null);
        }
        JPanel d1_panel = new JPanel(new GridLayout(1, 2, 0, 0));
        JPanel d2_panel = new JPanel(new GridLayout(1, 3, 0, 0));
        if (!this._configuration.isUseNativeUI()) {
            d1_panel.setBackground(this.getBackground());
            d2_panel.setBackground(this.getBackground());
        }
        this.add(d1_panel);
        this.add(d2_panel);
        this.addJButton(this._zoom_out_domain_structure, d1_panel);
        this.addJButton(this._zoom_in_domain_structure, d1_panel);
        this.addJButton(this._decr_domain_structure_evalue_thr, d2_panel);
        this.addJTextField(this._domain_structure_evalue_thr_tf, d2_panel);
        this.addJButton(this._incr_domain_structure_evalue_thr, d2_panel);
    }

    private void setupDisplayCheckboxes() {
        if (this._configuration.doDisplayOption(0)) {
            this.addCheckbox(0, this._configuration.getDisplayTitle(0));
            this.setCheckbox(0, this._configuration.doCheckOption(0));
        }
        if (this._configuration.doDisplayOption(15)) {
            this.addCheckbox(15, this._configuration.getDisplayTitle(15));
            this.setCheckbox(15, this._configuration.doCheckOption(15));
        }
        if (this._configuration.doDisplayOption(20)) {
            this.addCheckbox(20, this._configuration.getDisplayTitle(20));
            this.setCheckbox(20, this._configuration.doCheckOption(20));
        }
        if (this._configuration.doDisplayOption(14)) {
            this.addCheckbox(14, this._configuration.getDisplayTitle(14));
            this.setCheckbox(14, this._configuration.doCheckOption(14));
        }
        if (this._configuration.doDisplayOption(6)) {
            this.addCheckbox(6, this._configuration.getDisplayTitle(6));
            this.setCheckbox(6, this._configuration.doCheckOption(6));
        }
        if (this._configuration.doDisplayOption(17)) {
            this.addCheckbox(17, this._configuration.getDisplayTitle(17));
            this.setCheckbox(17, this._configuration.doCheckOption(17));
        }
        if (this._configuration.doDisplayOption(7)) {
            this.addCheckbox(7, this._configuration.getDisplayTitle(7));
            this.setCheckbox(7, this._configuration.doCheckOption(7));
        }
        if (this._configuration.doDisplayOption(8)) {
            this.addCheckbox(8, this._configuration.getDisplayTitle(8));
            this.setCheckbox(8, this._configuration.doCheckOption(8));
        }
        JLabel label = new JLabel("Display Data:");
        label.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            label.setForeground(jcb_text_color);
        }
        this.add(label);
        if (this._configuration.doDisplayOption(1)) {
            this.addCheckbox(1, this._configuration.getDisplayTitle(1));
            this.setCheckbox(1, this._configuration.doCheckOption(1));
        }
        if (this._configuration.doDisplayOption(2)) {
            this.addCheckbox(2, this._configuration.getDisplayTitle(2));
            this.setCheckbox(2, this._configuration.doCheckOption(2));
        }
        if (this._configuration.doDisplayOption(16)) {
            this.addCheckbox(16, this._configuration.getDisplayTitle(16));
            this.setCheckbox(16, this._configuration.doCheckOption(16));
        }
        if (this._configuration.doDisplayOption(19)) {
            this.addCheckbox(19, this._configuration.getDisplayTitle(19));
            this.setCheckbox(19, this._configuration.doCheckOption(19));
        }
        if (this._configuration.doDisplayOption(12)) {
            this.addCheckbox(12, this._configuration.getDisplayTitle(12));
            this.setCheckbox(12, this._configuration.doCheckOption(12));
        }
        if (this._configuration.doDisplayOption(13)) {
            this.addCheckbox(13, this._configuration.getDisplayTitle(13));
            this.setCheckbox(13, this._configuration.doCheckOption(13));
        }
        if (this._configuration.doDisplayOption(3)) {
            this.addCheckbox(3, this._configuration.getDisplayTitle(3));
            this.setCheckbox(3, this._configuration.doCheckOption(3));
        }
        if (this._configuration.doDisplayOption(10)) {
            this.addCheckbox(10, this._configuration.getDisplayTitle(10));
            this.setCheckbox(10, this._configuration.doCheckOption(10));
        }
        if (this._configuration.doDisplayOption(11)) {
            this.addCheckbox(11, this._configuration.getDisplayTitle(11));
            this.setCheckbox(11, this._configuration.doCheckOption(11));
        }
        if (this._configuration.doDisplayOption(9)) {
            this.addCheckbox(9, this._configuration.getDisplayTitle(9));
            this.setCheckbox(9, this._configuration.doCheckOption(9));
        }
        if (this._configuration.doDisplayOption(4)) {
            this.addCheckbox(4, this._configuration.getDisplayTitle(4));
            this.setCheckbox(4, this._configuration.doCheckOption(4));
        }
        if (this._configuration.doDisplayOption(5)) {
            this.addCheckbox(5, this._configuration.getDisplayTitle(5));
            this.setCheckbox(5, this._configuration.doCheckOption(5));
        }
    }

    void setupSearchTools() {
        String tip = "Enter text to search for. Use ',' for multiple searches (logical OR) and '+' for logical AND.";
        JLabel search_label = new JLabel("Search:");
        search_label.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            search_label.setForeground(jcb_text_color);
        }
        this.add(search_label);
        search_label.setToolTipText("Enter text to search for. Use ',' for multiple searches (logical OR) and '+' for logical AND.");
        this._search_found_label = new JLabel();
        this.getSearchFoundCountsLabel().setVisible(false);
        this._search_found_label.setFont(jcb_bold_font);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._search_found_label.setForeground(jcb_text_color);
        }
        this._search_tf = new JTextField(3);
        this._search_tf.setToolTipText("Enter text to search for. Use ',' for multiple searches (logical OR) and '+' for logical AND.");
        this._search_tf.setEditable(true);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._search_tf.setForeground(Constants.MENU_BACKGROUND_COLOR_DEFAULT);
            this._search_tf.setBackground(jcb_text_color);
            this._search_tf.setBorder(null);
        }
        this._search_reset_button = new JButton();
        this.getSearchResetButton().setText("Reset");
        this.getSearchResetButton().setEnabled(false);
        this.getSearchResetButton().setVisible(false);
        JPanel s_panel_1 = new JPanel(new BorderLayout());
        JPanel s_panel_2 = new JPanel(new GridLayout(1, 2, 0, 0));
        s_panel_1.setBackground(this.getBackground());
        this.add(s_panel_1);
        s_panel_2.setBackground(this.getBackground());
        this.add(s_panel_2);
        KeyAdapter key_adapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent key_event) {
                ControlPanel.this.search();
                ControlPanel.this.displayedPhylogenyMightHaveChanged(true);
            }
        };
        ActionListener action_listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.searchReset();
                ControlPanel.this.setSearchFoundCountsOnLabel(0);
                ControlPanel.this.getSearchFoundCountsLabel().setVisible(false);
                ControlPanel.this.getSearchTextField().setText("");
                ControlPanel.this.getSearchResetButton().setEnabled(false);
                ControlPanel.this.getSearchResetButton().setVisible(false);
                ControlPanel.this.displayedPhylogenyMightHaveChanged(true);
            }
        };
        this._search_reset_button.addActionListener(action_listener);
        this._search_tf.addKeyListener(key_adapter);
        this.addJTextField(this._search_tf, s_panel_1);
        s_panel_2.add(this._search_found_label);
        this.addJButton(this._search_reset_button, s_panel_2);
    }

    private void setVisibilityOfDomainStrucureControls() {
        if (this._zoom_in_domain_structure != null) {
            if (this.isShowDomainArchitectures()) {
                this._domain_display_label.setVisible(true);
                this._zoom_in_domain_structure.setVisible(true);
                this._zoom_out_domain_structure.setVisible(true);
                this._decr_domain_structure_evalue_thr.setVisible(true);
                this._incr_domain_structure_evalue_thr.setVisible(true);
                this._domain_structure_evalue_thr_tf.setVisible(true);
            } else {
                this._domain_display_label.setVisible(false);
                this._zoom_in_domain_structure.setVisible(false);
                this._zoom_out_domain_structure.setVisible(false);
                this._decr_domain_structure_evalue_thr.setVisible(false);
                this._incr_domain_structure_evalue_thr.setVisible(false);
                this._domain_structure_evalue_thr_tf.setVisible(false);
            }
        }
    }

    void showWhole() {
        if (this._mainpanel.getCurrentScrollPane() == null) {
            return;
        }
        this.displayedPhylogenyMightHaveChanged(false);
        this._mainpanel.getCurrentTreePanel().updateOvSettings();
        this._mainpanel.getCurrentTreePanel().validate();
        this._mainpanel.validate();
        this._mainpanel.getCurrentTreePanel().setParametersForPainting(this._mainpanel.getSizeOfViewport().width, this._mainpanel.getSizeOfViewport().height, true);
        this._mainpanel.getCurrentTreePanel().resetPreferredSize();
        this._mainpanel.adjustJScrollPane();
        this._mainpanel.getCurrentTreePanel().repaint();
        this._mainpanel.getCurrentTreePanel().validate();
        this._mainpanel.validate();
        this._mainpanel.getCurrentTreePanel().setParametersForPainting(this._mainpanel.getSizeOfViewport().width, this._mainpanel.getSizeOfViewport().height, true);
        this._mainpanel.getCurrentTreePanel().resetPreferredSize();
        this._mainpanel.adjustJScrollPane();
        this._mainpanel.getCurrentTreePanel().repaint();
        this._mainpanel.getCurrentTreePanel().updateOvSizes();
    }

    void showWholeAll() {
        for (TreePanel tree_panel : this._mainpanel.getTreePanels()) {
            if (tree_panel == null) continue;
            tree_panel.validate();
            tree_panel.setParametersForPainting(this._mainpanel.getSizeOfViewport().width, this._mainpanel.getSizeOfViewport().height, true);
            tree_panel.resetPreferredSize();
            tree_panel.repaint();
        }
    }

    void startClickToOptions() {
        JLabel spacer = new JLabel("");
        spacer.setFont(jcb_font);
        this.add(spacer);
        this._click_to_label = new JLabel("Click on Node to:");
        this.add(ControlPanel.customizeLabel(this._click_to_label, this.getConfiguration()));
        this._click_to_combobox = new JComboBox();
        this._click_to_combobox.setFocusable(false);
        this._click_to_combobox.setMaximumRowCount(14);
        this._click_to_combobox.setFont(js_font);
        if (!this._configuration.isUseNativeUI()) {
            this._click_to_combobox.setBackground(background_color);
        }
        this.add(this._click_to_combobox);
        this._all_click_to_names = new HashMap<Integer, String>();
        this._click_to_names = new ArrayList<String>();
    }

    void tabChanged() {
        if (this.getMainPanel().getTabbedPane().getTabCount() > 0) {
            if (this.getCurrentTreePanel().isPhyHasBranchLengths() && this.getCurrentTreePanel().getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.setDrawPhylogramEnabled(true);
                this.setDrawPhylogram(this.isDrawPhylogram());
            } else {
                this.setDrawPhylogramEnabled(false);
                this.setDrawPhylogram(false);
            }
            if (this.getMainPanel().getMainFrame() == null) {
                ArchaeopteryxE e = (ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet();
                e.setSelectedTypeInTypeMenu(e.getCurrentTreePanel().getPhylogenyGraphicsType());
            } else {
                this.getMainPanel().getMainFrame().setSelectedTypeInTypeMenu(this.getMainPanel().getCurrentTreePanel().getPhylogenyGraphicsType());
            }
            this.getMainPanel().getCurrentTreePanel().updateSubSuperTreeButton();
            this.getMainPanel().getControlPanel().search();
        }
    }

    void uncollapseAll(TreePanel tp) {
        Phylogeny t = tp.getPhylogeny();
        if (t != null && !t.isEmpty()) {
            t.setAllNodesToNotCollapse();
            t.recalculateNumberOfExternalDescendants(false);
            this.showWhole();
        }
    }

    void updateDomainStructureEvaluethresholdDisplay() {
        if (this._domain_structure_evalue_thr_tf != null) {
            this._domain_structure_evalue_thr_tf.setText("10^" + this._mainpanel.getCurrentTreePanel().getDomainStructureEvalueThreshold());
        }
    }

    void zoomInX(float factor, float x_correction_factor) {
        JScrollBar sb = this._mainpanel.getCurrentScrollPane().getHorizontalScrollBar();
        TreePanel treepanel = this._mainpanel.getCurrentTreePanel();
        treepanel.multiplyUrtFactor(1.0f);
        if (treepanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || treepanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.isDrawPhylogram(this._mainpanel.getCurrentTabIndex()) || this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP) {
            double x = (double)(sb.getMaximum() - sb.getMinimum()) / ((double)sb.getValue() + (double)sb.getVisibleAmount() / 2.0);
            treepanel.setXdistance(treepanel.getXdistance() * factor);
            treepanel.setXcorrectionFactor(treepanel.getXcorrectionFactor() * x_correction_factor);
            this._mainpanel.adjustJScrollPane();
            treepanel.resetPreferredSize();
            this._mainpanel.getCurrentScrollPane().getViewport().validate();
            sb.setValue(ForesterUtil.roundToInt((double)(sb.getMaximum() - sb.getMinimum()) / x - (double)sb.getVisibleAmount() / 2.0));
        } else {
            int x = sb.getMaximum() - sb.getMinimum() - sb.getVisibleAmount() - sb.getValue();
            treepanel.setXdistance(treepanel.getXdistance() * factor);
            treepanel.setXcorrectionFactor(treepanel.getXcorrectionFactor() * x_correction_factor);
            this._mainpanel.adjustJScrollPane();
            treepanel.resetPreferredSize();
            this._mainpanel.getCurrentScrollPane().getViewport().validate();
            sb.setValue(sb.getMaximum() - sb.getMinimum() - x - sb.getVisibleAmount());
        }
        treepanel.resetPreferredSize();
        treepanel.updateOvSizes();
    }

    void zoomInY(float factor) {
        JScrollBar sb = this._mainpanel.getCurrentScrollPane().getVerticalScrollBar();
        TreePanel treepanel = this._mainpanel.getCurrentTreePanel();
        treepanel.multiplyUrtFactor(1.1f);
        double x = (double)(sb.getMaximum() - sb.getMinimum()) / ((double)sb.getValue() + (double)sb.getVisibleAmount() / 2.0);
        treepanel.setYdistance(treepanel.getYdistance() * factor);
        this._mainpanel.adjustJScrollPane();
        treepanel.resetPreferredSize();
        this._mainpanel.getCurrentScrollPane().getViewport().validate();
        sb.setValue(ForesterUtil.roundToInt((double)(sb.getMaximum() - sb.getMinimum()) / x - (double)sb.getVisibleAmount() / 2.0));
        treepanel.resetPreferredSize();
        treepanel.updateOvSizes();
    }

    void zoomOutX(float factor, float x_correction_factor) {
        TreePanel treepanel = this._mainpanel.getCurrentTreePanel();
        treepanel.multiplyUrtFactor(1.0f);
        if ((double)(treepanel.getXdistance() * factor) > 0.0) {
            JScrollBar sb = this._mainpanel.getCurrentScrollPane().getHorizontalScrollBar();
            if (treepanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR || treepanel.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.isDrawPhylogram(this._mainpanel.getCurrentTabIndex()) || this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP) {
                this._mainpanel.adjustJScrollPane();
                treepanel.resetPreferredSize();
                this._mainpanel.getCurrentScrollPane().getViewport().validate();
                double x = (double)(sb.getMaximum() - sb.getMinimum()) / ((double)sb.getValue() + (double)sb.getVisibleAmount() / 2.0);
                treepanel.setXdistance(treepanel.getXdistance() * factor);
                treepanel.setXcorrectionFactor(treepanel.getXcorrectionFactor() * x_correction_factor);
                this._mainpanel.adjustJScrollPane();
                treepanel.resetPreferredSize();
                this._mainpanel.getCurrentScrollPane().getViewport().validate();
                sb.setValue(ForesterUtil.roundToInt((double)(sb.getMaximum() - sb.getMinimum()) / x - (double)sb.getVisibleAmount() / 2.0));
            } else {
                int x = sb.getMaximum() - sb.getMinimum() - sb.getVisibleAmount() - sb.getValue();
                treepanel.setXdistance(treepanel.getXdistance() * factor);
                treepanel.setXcorrectionFactor(treepanel.getXcorrectionFactor() * x_correction_factor);
                if (x > 0) {
                    this._mainpanel.adjustJScrollPane();
                    treepanel.resetPreferredSize();
                    this._mainpanel.getCurrentScrollPane().getViewport().validate();
                    sb.setValue(sb.getMaximum() - sb.getMinimum() - x - sb.getVisibleAmount());
                }
            }
            treepanel.resetPreferredSize();
            treepanel.updateOvSizes();
        }
    }

    void zoomOutY(float factor) {
        TreePanel treepanel = this._mainpanel.getCurrentTreePanel();
        treepanel.multiplyUrtFactor(0.9f);
        if ((double)(treepanel.getYdistance() * factor) > 0.0) {
            JScrollBar sb = this._mainpanel.getCurrentScrollPane().getVerticalScrollBar();
            double x = (double)(sb.getMaximum() - sb.getMinimum()) / ((double)sb.getValue() + (double)sb.getVisibleAmount() / 2.0);
            treepanel.setYdistance(treepanel.getYdistance() * factor);
            this._mainpanel.adjustJScrollPane();
            treepanel.resetPreferredSize();
            this._mainpanel.getCurrentScrollPane().getViewport().validate();
            sb.setValue(ForesterUtil.roundToInt((double)(sb.getMaximum() - sb.getMinimum()) / x - (double)sb.getVisibleAmount() / 2.0));
            treepanel.resetPreferredSize();
            treepanel.updateOvSizes();
        }
    }

    static JLabel customizeLabel(JLabel label, Configuration configuration) {
        label.setFont(jcb_bold_font);
        if (!configuration.isUseNativeUI()) {
            label.setForeground(jcb_text_color);
            label.setBackground(background_color);
        }
        return label;
    }

    static enum NodeClickAction {
        SHOW_DATA,
        COLLAPSE,
        REROOT,
        SUBTREE,
        SWAP,
        COLOR_SUBTREE,
        OPEN_TAX_WEB,
        OPEN_SEQ_WEB,
        CUT_SUBTREE,
        COPY_SUBTREE,
        DELETE_NODE_OR_SUBTREE,
        PASTE_SUBTREE,
        ADD_NEW_NODE,
        EDIT_NODE_DATA,
        BLAST;

    }
}

