/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.forester.archaeopteryx.ArchaeopteryxA;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.Util;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;

public final class MainFrameApplet
extends MainFrame {
    private static final long serialVersionUID = 1941019292746717053L;
    private static final int FRAME_X_SIZE = 640;
    private static final int FRAME_Y_SIZE = 580;
    private final ArchaeopteryxA _applet;
    private ButtonGroup _radio_group_1;

    MainFrameApplet(ArchaeopteryxA parent_applet, Configuration configuration) {
        this.setTitle("ArchaeopteryxA");
        this._applet = parent_applet;
        this.setConfiguration(configuration);
        this.setOptions(Options.createInstance(configuration));
        this._textframe = null;
        URL url = null;
        Phylogeny[] phys = null;
        if (this._applet.getUrlString() != null) {
            try {
                url = new URL(this._applet.getUrlString());
            }
            catch (Exception e) {
                ForesterUtil.printErrorMessage("ArchaeopteryxA", e.toString());
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "ArchaeopteryxA: Could not create URL from: \"" + this._applet.getUrlString() + "\"\nError: " + e, "Failed to create URL", 0);
                this.close();
            }
        }
        if (url != null) {
            try {
                phys = Util.readPhylogeniesFromUrl(url, this.getConfiguration().isValidatePhyloXmlAgainstSchema());
            }
            catch (Exception e) {
                ForesterUtil.printErrorMessage("ArchaeopteryxA", e.toString());
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "ArchaeopteryxA: Failed to read phylogenies: \nError: " + e, "Failed to read phylogenies", 0);
                this.close();
            }
        }
        if (phys == null || phys.length < 1) {
            ForesterUtil.printErrorMessage("ArchaeopteryxA", "phylogenies from [" + url + "] are null or empty");
            JOptionPane.showMessageDialog(this, "ArchaeopteryxA: phylogenies from [" + url + "] are null or empty", "Failed to read phylogenies", 0);
        } else {
            Util.printAppletMessage("ArchaeopteryxA", "loaded " + phys.length + " phylogenies from: " + url);
        }
        this._mainpanel = new MainPanelApplets(this._configuration, this);
        this._jmenubar = new JMenuBar();
        if (!this._configuration.isUseNativeUI()) {
            this._jmenubar.setBackground(Constants.MENU_BACKGROUND_COLOR_DEFAULT);
        }
        this.buildToolsMenu();
        this.buildViewMenu();
        this.buildFontSizeMenu();
        this.buildOptionsMenu();
        this.buildTypeMenu();
        this.buildHelpMenu();
        this.setJMenuBar(this._jmenubar);
        this._contentpane = this.getContentPane();
        this._contentpane.setLayout(new BorderLayout());
        this._contentpane.add((Component)this._mainpanel, "Center");
        this.setSize(640, 580);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrameApplet.this.close();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (MainFrameApplet.this._mainpanel.getCurrentTreePanel() != null) {
                    MainFrameApplet.this._mainpanel.getCurrentTreePanel().setParametersForPainting(MainFrameApplet.this._mainpanel.getCurrentTreePanel().getWidth(), MainFrameApplet.this._mainpanel.getCurrentTreePanel().getHeight(), false);
                }
            }
        });
        this.setFocusable(true);
        this.requestFocus();
        this.requestFocusInWindow();
        this.setVisible(true);
        System.gc();
    }

    void buildOptionsMenu() {
        this._options_jmenu = MainFrame.createMenu("Options", this.getConfiguration());
        this._options_jmenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.setOvPlacementColorChooseMenuItem(MainFrameApplet.this._overview_placment_mi, MainFrameApplet.this.getCurrentTreePanel());
                MainFrame.setTextColorChooseMenuItem(MainFrameApplet.this._switch_colors_mi, MainFrameApplet.this.getCurrentTreePanel());
                MainFrame.setTextMinSupportMenuItem(MainFrameApplet.this._choose_minimal_confidence_mi, MainFrameApplet.this.getOptions(), MainFrameApplet.this.getCurrentTreePanel());
                MainFrame.setTextForFontChooserMenuItem(MainFrameApplet.this._choose_font_mi, MainFrameApplet.createCurrentFontDesc(MainFrameApplet.this.getMainPanel().getTreeFontSet()));
                MainFrame.updateOptionsMenuDependingOnPhylogenyType(MainFrameApplet.this.getMainPanel(), MainFrameApplet.this._show_scale_cbmi, MainFrameApplet.this._show_branch_length_values_cbmi, MainFrameApplet.this._non_lined_up_cladograms_rbmi, MainFrameApplet.this._uniform_cladograms_rbmi, MainFrameApplet.this._ext_node_dependent_cladogram_rbmi, MainFrameApplet.this._label_direction_cbmi);
            }
        });
        this._options_jmenu.add(MainFrame.customizeMenuItemAsLabel(new JMenuItem("Display:"), this.getConfiguration()));
        this._ext_node_dependent_cladogram_rbmi = new JRadioButtonMenuItem("External Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._ext_node_dependent_cladogram_rbmi);
        this._uniform_cladograms_rbmi = new JRadioButtonMenuItem("Total Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._uniform_cladograms_rbmi);
        this._non_lined_up_cladograms_rbmi = new JRadioButtonMenuItem("Non-Lined Up Cladograms");
        this._options_jmenu.add(this._non_lined_up_cladograms_rbmi);
        this._radio_group_1 = new ButtonGroup();
        this._radio_group_1.add(this._ext_node_dependent_cladogram_rbmi);
        this._radio_group_1.add(this._uniform_cladograms_rbmi);
        this._radio_group_1.add(this._non_lined_up_cladograms_rbmi);
        this._show_node_boxes_cbmi = new JCheckBoxMenuItem("Display Node Boxes");
        this._options_jmenu.add(this._show_node_boxes_cbmi);
        this._show_scale_cbmi = new JCheckBoxMenuItem("Display Scale");
        this._options_jmenu.add(this._show_scale_cbmi);
        this._show_branch_length_values_cbmi = new JCheckBoxMenuItem("Display Branch Length Values");
        this._options_jmenu.add(this._show_branch_length_values_cbmi);
        this._show_overview_cbmi = new JCheckBoxMenuItem("Show Overview");
        this._options_jmenu.add(this._show_overview_cbmi);
        this._label_direction_cbmi = new JCheckBoxMenuItem("Radial Labels");
        this._options_jmenu.add(this._label_direction_cbmi);
        this._label_direction_cbmi.setToolTipText("To use radial node labels in radial and unrooted display types");
        this._screen_antialias_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._screen_antialias_cbmi);
        this._background_gradient_cbmi = new JCheckBoxMenuItem("Background Color Gradient");
        this._options_jmenu.add(this._background_gradient_cbmi);
        this._choose_minimal_confidence_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_minimal_confidence_mi);
        this._overview_placment_mi = new JMenuItem("");
        this._options_jmenu.add(this._overview_placment_mi);
        this._switch_colors_mi = new JMenuItem("");
        this._options_jmenu.add(this._switch_colors_mi);
        this._choose_font_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_font_mi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrame.customizeMenuItemAsLabel(new JMenuItem("Search:"), this.getConfiguration()));
        this._search_case_senstive_cbmi = new JCheckBoxMenuItem("Case Sensitive");
        this._options_jmenu.add(this._search_case_senstive_cbmi);
        this._search_whole_words_only_cbmi = new JCheckBoxMenuItem("Match Complete Terms Only");
        this._options_jmenu.add(this._search_whole_words_only_cbmi);
        this._inverse_search_result_cbmi = new JCheckBoxMenuItem("Negate Result");
        this._options_jmenu.add(this._inverse_search_result_cbmi);
        this.customizeJMenuItem(this._choose_font_mi);
        this.customizeJMenuItem(this._switch_colors_mi);
        this.customizeJMenuItem(this._choose_minimal_confidence_mi);
        this.customizeJMenuItem(this._overview_placment_mi);
        this.customizeCheckBoxMenuItem(this._show_node_boxes_cbmi, this.getOptions().isShowNodeBoxes());
        this.customizeCheckBoxMenuItem(this._screen_antialias_cbmi, this.getOptions().isAntialiasScreen());
        this.customizeCheckBoxMenuItem(this._background_gradient_cbmi, this.getOptions().isBackgroundColorGradient());
        this.customizeCheckBoxMenuItem(this._search_case_senstive_cbmi, this.getOptions().isSearchCaseSensitive());
        this.customizeCheckBoxMenuItem(this._show_scale_cbmi, this.getOptions().isShowScale());
        this.customizeRadioButtonMenuItem(this._non_lined_up_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP);
        this.customizeRadioButtonMenuItem(this._uniform_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        this.customizeRadioButtonMenuItem(this._ext_node_dependent_cladogram_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        this.customizeCheckBoxMenuItem(this._show_branch_length_values_cbmi, this.getOptions().isShowBranchLengthValues());
        this.customizeCheckBoxMenuItem(this._show_overview_cbmi, this.getOptions().isShowOverview());
        this.customizeCheckBoxMenuItem(this._label_direction_cbmi, this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL);
        this.customizeCheckBoxMenuItem(this._search_whole_words_only_cbmi, this.getOptions().isMatchWholeTermsOnly());
        this.customizeCheckBoxMenuItem(this._inverse_search_result_cbmi, this.getOptions().isInverseSearchResult());
        this._jmenubar.add(this._options_jmenu);
    }

    JApplet getApplet() {
        return this._applet;
    }

    @Override
    MainPanel getMainPanel() {
        return this._mainpanel;
    }

    @Override
    void readPhylogeniesFromURL() {
        throw new NoSuchMethodError("not implemented");
    }
}

