/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.forester.archaeopteryx.ArchaeopteryxE;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.DefaultFilter;
import org.forester.archaeopteryx.GraphicsFileFilter;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.NHFilter;
import org.forester.archaeopteryx.NHXFilter;
import org.forester.archaeopteryx.NexusFilter;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.PdfExporter;
import org.forester.archaeopteryx.PdfFilter;
import org.forester.archaeopteryx.Printer;
import org.forester.archaeopteryx.TolFilter;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.Util;
import org.forester.archaeopteryx.XMLFilter;
import org.forester.archaeopteryx.webservices.PhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.WebservicesManager;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.GSDI;
import org.forester.sdi.SDIR;
import org.forester.sdi.SDIse;
import org.forester.util.ForesterUtil;
import org.forester.util.WindowsUtils;

public final class MainFrameApplication
extends MainFrame {
    private static final int FRAME_X_SIZE = 800;
    private static final int FRAME_Y_SIZE = 800;
    private static final NHFilter nhfilter = new NHFilter();
    private static final NHXFilter nhxfilter = new NHXFilter();
    private static final XMLFilter xmlfilter = new XMLFilter();
    private static final TolFilter tolfilter = new TolFilter();
    private static final NexusFilter nexusfilter = new NexusFilter();
    private static final PdfFilter pdffilter = new PdfFilter();
    private static final GraphicsFileFilter graphicsfilefilter = new GraphicsFileFilter();
    private static final DefaultFilter defaultfilter = new DefaultFilter();
    private static final long serialVersionUID = -799735726778865234L;
    private final JFileChooser _open_filechooser;
    private final JFileChooser _open_filechooser_for_species_tree;
    private final JFileChooser _save_filechooser;
    private final JFileChooser _writetopdf_filechooser;
    private final JFileChooser _writetographics_filechooser;
    private JMenu _analysis_menu;
    private JMenuItem _load_species_tree_item;
    private JMenuItem _sdi_item;
    private JMenuItem _gsdi_item;
    private JMenuItem _root_min_dups_item;
    private JMenuItem _root_min_cost_l_item;
    private JMenuItem _print_item;
    private JMenuItem _write_to_pdf_item;
    private JMenuItem _write_to_jpg_item;
    private JMenuItem _write_to_gif_item;
    private JMenuItem _write_to_tif_item;
    private JMenuItem _write_to_png_item;
    private JMenuItem _write_to_bmp_item;
    private Phylogeny _species_tree;
    private File _current_dir;
    private ButtonGroup _radio_group_1;

    private MainFrameApplication(Phylogeny[] phys, Configuration config, String title) {
        this._configuration = config;
        if (this._configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        try {
            if (this._configuration.isUseNativeUI()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            Util.dieWithSystemError("UnsupportedLookAndFeelException: " + e.toString());
        }
        catch (ClassNotFoundException e) {
            Util.dieWithSystemError("ClassNotFoundException: " + e.toString());
        }
        catch (InstantiationException e) {
            Util.dieWithSystemError("InstantiationException: " + e.toString());
        }
        catch (IllegalAccessException e) {
            Util.dieWithSystemError("IllegalAccessException: " + e.toString());
        }
        catch (Exception e) {
            Util.dieWithSystemError(e.toString());
        }
        this.setVisible(false);
        this.setOptions(Options.createInstance(this._configuration));
        this._textframe = null;
        this._species_tree = null;
        this.setTitle("Archaeopteryx 0.955 beta x (2010.01.15)");
        this._mainpanel = new MainPanel(this._configuration, this);
        this._open_filechooser = new JFileChooser();
        this._open_filechooser.setCurrentDirectory(new File("."));
        this._open_filechooser.setMultiSelectionEnabled(false);
        this._open_filechooser.addChoosableFileFilter(xmlfilter);
        this._open_filechooser.addChoosableFileFilter(nhxfilter);
        this._open_filechooser.addChoosableFileFilter(nhfilter);
        this._open_filechooser.addChoosableFileFilter(nexusfilter);
        this._open_filechooser.addChoosableFileFilter(tolfilter);
        this._open_filechooser.addChoosableFileFilter(this._open_filechooser.getAcceptAllFileFilter());
        this._open_filechooser.setFileFilter(defaultfilter);
        this._open_filechooser_for_species_tree = new JFileChooser();
        this._open_filechooser_for_species_tree.setCurrentDirectory(new File("."));
        this._open_filechooser_for_species_tree.setMultiSelectionEnabled(false);
        this._open_filechooser_for_species_tree.addChoosableFileFilter(xmlfilter);
        this._open_filechooser_for_species_tree.addChoosableFileFilter(tolfilter);
        this._open_filechooser_for_species_tree.setFileFilter(xmlfilter);
        this._save_filechooser = new JFileChooser();
        this._save_filechooser.setCurrentDirectory(new File("."));
        this._save_filechooser.setMultiSelectionEnabled(false);
        this._save_filechooser.setFileFilter(xmlfilter);
        this._save_filechooser.addChoosableFileFilter(nhxfilter);
        this._save_filechooser.addChoosableFileFilter(nhfilter);
        this._save_filechooser.addChoosableFileFilter(nexusfilter);
        this._save_filechooser.addChoosableFileFilter(this._save_filechooser.getAcceptAllFileFilter());
        this._writetopdf_filechooser = new JFileChooser();
        this._writetopdf_filechooser.addChoosableFileFilter(pdffilter);
        this._writetographics_filechooser = new JFileChooser();
        this._writetographics_filechooser.addChoosableFileFilter(graphicsfilefilter);
        this._jmenubar = new JMenuBar();
        if (!this._configuration.isUseNativeUI()) {
            this._jmenubar.setBackground(Constants.MENU_BACKGROUND_COLOR_DEFAULT);
        }
        this.buildFileMenu();
        this.buildToolsMenu();
        this.buildViewMenu();
        this.buildFontSizeMenu();
        this.buildOptionsMenu();
        this.buildTypeMenu();
        this.buildAnalysisMenu();
        this.buildHelpMenu();
        this.setJMenuBar(this._jmenubar);
        this._jmenubar.add(this._help_jmenu);
        this._contentpane = this.getContentPane();
        this._contentpane.setLayout(new BorderLayout());
        this._contentpane.add((Component)this._mainpanel, "Center");
        this.setSize(800, 800);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int r;
                if (MainFrameApplication.this.isUnsavedDataPresent() ? (r = JOptionPane.showConfirmDialog(null, "Exit despite potentially unsaved changes?", "Exit?", 0)) != 0 : (r = JOptionPane.showConfirmDialog(null, "Exit Archaeopteryx?", "Exit?", 0)) != 0) {
                    return;
                }
                MainFrameApplication.this.exit();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (MainFrameApplication.this._mainpanel.getCurrentTreePanel() != null) {
                    MainFrameApplication.this._mainpanel.getCurrentTreePanel().setParametersForPainting(MainFrameApplication.this._mainpanel.getCurrentTreePanel().getWidth(), MainFrameApplication.this._mainpanel.getCurrentTreePanel().getHeight(), false);
                }
            }
        });
        this.requestFocusInWindow();
        this.setVisible(true);
        if (phys != null && phys.length > 0) {
            Util.addPhylogeniesToTabs(phys, title, null, this._configuration, this._mainpanel);
            this.validate();
            this.getMainPanel().getControlPanel().showWholeAll();
            this.getMainPanel().getControlPanel().showWhole();
        }
        this.activateSaveAllIfNeeded();
        this._contentpane.repaint();
        System.gc();
    }

    private MainFrameApplication(Phylogeny[] phys, String config_file, String title) {
        this(phys, new Configuration(config_file, false, false), title);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            super.actionPerformed(e);
            Object o = e.getSource();
            if (o == this._open_item) {
                this.readPhylogeniesFromFile();
            } else if (o == this._save_item) {
                this.writeToFile(this._mainpanel.getCurrentPhylogeny());
            } else if (o == this._new_item) {
                this.newTree();
            } else if (o == this._save_all_item) {
                this.writeAllToFile();
            } else if (o == this._close_item) {
                this.closeCurrentPane();
            } else if (o == this._write_to_pdf_item) {
                this.writeToPdf(this._mainpanel.getCurrentPhylogeny());
            } else if (o == this._write_to_jpg_item) {
                this.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), Util.GraphicsExportType.JPG);
            } else if (o == this._write_to_png_item) {
                this.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), Util.GraphicsExportType.PNG);
            } else if (o == this._write_to_gif_item) {
                this.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), Util.GraphicsExportType.GIF);
            } else if (o == this._write_to_tif_item) {
                this.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), Util.GraphicsExportType.TIFF);
            } else if (o == this._write_to_bmp_item) {
                this.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), Util.GraphicsExportType.BMP);
            } else if (o == this._print_item) {
                this.print();
            } else if (o == this._load_species_tree_item) {
                this.readSpeciesTreeFromFile();
            } else if (o == this._sdi_item) {
                this.executeSDI();
            } else if (o == this._gsdi_item) {
                this.executeGSDI();
            } else if (o == this._root_min_dups_item) {
                this.executeSDIR(false);
            } else if (o == this._root_min_cost_l_item) {
                this.executeSDIR(true);
            } else if (o == this._graphics_export_visible_only_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (o == this._antialias_print_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (o == this._print_black_and_white_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (o == this._print_using_actual_size_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (o == this._graphics_export_using_actual_size_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (o == this._print_size_mi) {
                this.choosePrintSize();
            } else if (o == this._choose_pdf_width_mi) {
                this.choosePdfWidth();
            } else if (o == this._internal_number_are_confidence_for_nh_parsing_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (o == this._ignore_quotes_in_nh_parsing_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (o == this._replace_underscores_cbmi) {
                if (this._extract_pfam_style_tax_codes_cbmi != null && this._replace_underscores_cbmi.isSelected()) {
                    this._extract_pfam_style_tax_codes_cbmi.setSelected(false);
                }
                this.updateOptions(this.getOptions());
            } else if (o == this._extract_pfam_style_tax_codes_cbmi) {
                if (this._replace_underscores_cbmi != null && this._extract_pfam_style_tax_codes_cbmi.isSelected()) {
                    this._replace_underscores_cbmi.setSelected(false);
                }
                this.updateOptions(this.getOptions());
            }
            this._contentpane.repaint();
        }
        catch (Exception ex) {
            Util.unexpectedException(ex);
        }
        catch (Error err) {
            Util.unexpectedError(err);
        }
    }

    void buildAnalysisMenu() {
        this._analysis_menu = MainFrame.createMenu("Analysis", this.getConfiguration());
        this._sdi_item = new JMenuItem("SDI (Speciation Duplication Inference)");
        this._analysis_menu.add(this._sdi_item);
        this._gsdi_item = new JMenuItem("GSDI (Generalized Speciation Duplication Inference)");
        this._analysis_menu.add(this._gsdi_item);
        this._analysis_menu.addSeparator();
        this._root_min_dups_item = new JMenuItem("Root by Minimizing Duplications | Height (SDI)");
        this._analysis_menu.add(this._root_min_dups_item);
        this._root_min_cost_l_item = new JMenuItem("Root by Minimizing Cost L | Height (SDI)");
        this._analysis_menu.add(this._root_min_cost_l_item);
        this._analysis_menu.addSeparator();
        this._load_species_tree_item = new JMenuItem("Load Species Tree...");
        this._analysis_menu.add(this._load_species_tree_item);
        this.customizeJMenuItem(this._sdi_item);
        this.customizeJMenuItem(this._gsdi_item);
        this.customizeJMenuItem(this._root_min_dups_item);
        this.customizeJMenuItem(this._root_min_cost_l_item);
        this.customizeJMenuItem(this._load_species_tree_item);
        this._jmenubar.add(this._analysis_menu);
    }

    @Override
    void buildFileMenu() {
        this._file_jmenu = MainFrame.createMenu("File", this.getConfiguration());
        this._open_item = new JMenuItem("Read Tree from File...");
        this._file_jmenu.add(this._open_item);
        this._file_jmenu.addSeparator();
        this._open_url_item = new JMenuItem("Read Tree from URL/Webservice...");
        this._file_jmenu.add(this._open_url_item);
        this._file_jmenu.addSeparator();
        WebservicesManager webservices_manager = WebservicesManager.getInstance();
        this._load_phylogeny_from_webservice_menu_items = new JMenuItem[webservices_manager.getAvailablePhylogeniesWebserviceClients().size()];
        int i = 0;
        while (i < webservices_manager.getAvailablePhylogeniesWebserviceClients().size()) {
            PhylogeniesWebserviceClient client = webservices_manager.getAvailablePhylogeniesWebserviceClient(i);
            this._load_phylogeny_from_webservice_menu_items[i] = new JMenuItem(client.getMenuName());
            this._file_jmenu.add(this._load_phylogeny_from_webservice_menu_items[i]);
            ++i;
        }
        if (this.getConfiguration().isEditable()) {
            this._file_jmenu.addSeparator();
            this._new_item = new JMenuItem("New");
            this._file_jmenu.add(this._new_item);
            this._new_item.setToolTipText("to create a new tree with one node, as source for manual tree construction");
        }
        this._file_jmenu.addSeparator();
        this._save_item = new JMenuItem("Save Tree As...");
        this._file_jmenu.add(this._save_item);
        this._save_all_item = new JMenuItem("Save All Trees As...");
        this._file_jmenu.add(this._save_all_item);
        this._save_all_item.setToolTipText("Write all phylogenies to one file.");
        this._save_all_item.setEnabled(false);
        this._file_jmenu.addSeparator();
        this._write_to_pdf_item = new JMenuItem("Export to PDF file ...");
        this._file_jmenu.add(this._write_to_pdf_item);
        if (Util.canWriteFormat("tif") || Util.canWriteFormat("tiff") || Util.canWriteFormat("TIF")) {
            this._write_to_tif_item = new JMenuItem("Export to TIFF file...");
            this._file_jmenu.add(this._write_to_tif_item);
        }
        this._write_to_png_item = new JMenuItem("Export to PNG file...");
        this._file_jmenu.add(this._write_to_png_item);
        this._write_to_jpg_item = new JMenuItem("Export to JPG file...");
        this._file_jmenu.add(this._write_to_jpg_item);
        if (Util.canWriteFormat("gif")) {
            this._write_to_gif_item = new JMenuItem("Export to GIF file...");
            this._file_jmenu.add(this._write_to_gif_item);
        }
        if (Util.canWriteFormat("bmp")) {
            this._write_to_bmp_item = new JMenuItem("Export to BMP file...");
            this._file_jmenu.add(this._write_to_bmp_item);
        }
        this._file_jmenu.addSeparator();
        this._print_item = new JMenuItem("Print...");
        this._file_jmenu.add(this._print_item);
        this._file_jmenu.addSeparator();
        this._close_item = new JMenuItem("Close Tab");
        this._file_jmenu.add(this._close_item);
        this._close_item.setToolTipText("To close the current pane.");
        this._close_item.setEnabled(true);
        this._file_jmenu.addSeparator();
        this._exit_item = new JMenuItem("Exit");
        this._file_jmenu.add(this._exit_item);
        this.customizeJMenuItem(this._open_item);
        this.customizeJMenuItem(this._open_url_item);
        i = 0;
        while (i < webservices_manager.getAvailablePhylogeniesWebserviceClients().size()) {
            this.customizeJMenuItem(this._load_phylogeny_from_webservice_menu_items[i]);
            ++i;
        }
        this.customizeJMenuItem(this._save_item);
        if (this.getConfiguration().isEditable()) {
            this.customizeJMenuItem(this._new_item);
        }
        this.customizeJMenuItem(this._close_item);
        this.customizeJMenuItem(this._save_all_item);
        this.customizeJMenuItem(this._write_to_pdf_item);
        this.customizeJMenuItem(this._write_to_png_item);
        this.customizeJMenuItem(this._write_to_jpg_item);
        this.customizeJMenuItem(this._write_to_gif_item);
        this.customizeJMenuItem(this._write_to_tif_item);
        this.customizeJMenuItem(this._write_to_bmp_item);
        this.customizeJMenuItem(this._print_item);
        this.customizeJMenuItem(this._exit_item);
        this._jmenubar.add(this._file_jmenu);
    }

    void buildOptionsMenu() {
        this._options_jmenu = MainFrame.createMenu("Options", this.getConfiguration());
        this._options_jmenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.setOvPlacementColorChooseMenuItem(MainFrameApplication.this._overview_placment_mi, MainFrameApplication.this.getCurrentTreePanel());
                MainFrame.setTextColorChooseMenuItem(MainFrameApplication.this._switch_colors_mi, MainFrameApplication.this.getCurrentTreePanel());
                MainFrame.setTextMinSupportMenuItem(MainFrameApplication.this._choose_minimal_confidence_mi, MainFrameApplication.this.getOptions(), MainFrameApplication.this.getCurrentTreePanel());
                MainFrame.setTextForFontChooserMenuItem(MainFrameApplication.this._choose_font_mi, MainFrame.createCurrentFontDesc(MainFrameApplication.this.getMainPanel().getTreeFontSet()));
                MainFrameApplication.setTextForGraphicsSizeChooserMenuItem(MainFrameApplication.this._print_size_mi, MainFrameApplication.this.getOptions());
                MainFrameApplication.setTextForPdfLineWidthChooserMenuItem(MainFrameApplication.this._choose_pdf_width_mi, MainFrameApplication.this.getOptions());
                MainFrame.updateOptionsMenuDependingOnPhylogenyType(MainFrameApplication.this.getMainPanel(), MainFrameApplication.this._show_scale_cbmi, MainFrameApplication.this._show_branch_length_values_cbmi, MainFrameApplication.this._non_lined_up_cladograms_rbmi, MainFrameApplication.this._uniform_cladograms_rbmi, MainFrameApplication.this._ext_node_dependent_cladogram_rbmi, MainFrameApplication.this._label_direction_cbmi);
            }
        });
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Display:"), this.getConfiguration()));
        this._ext_node_dependent_cladogram_rbmi = new JRadioButtonMenuItem("External Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._ext_node_dependent_cladogram_rbmi);
        this._uniform_cladograms_rbmi = new JRadioButtonMenuItem("Total Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._uniform_cladograms_rbmi);
        this._non_lined_up_cladograms_rbmi = new JRadioButtonMenuItem("Non-Lined Up Cladograms");
        this._options_jmenu.add(this._non_lined_up_cladograms_rbmi);
        this._radio_group_1 = new ButtonGroup();
        this._radio_group_1.add(this._ext_node_dependent_cladogram_rbmi);
        this._radio_group_1.add(this._uniform_cladograms_rbmi);
        this._radio_group_1.add(this._non_lined_up_cladograms_rbmi);
        this._show_node_boxes_cbmi = new JCheckBoxMenuItem("Display Node Boxes");
        this._options_jmenu.add(this._show_node_boxes_cbmi);
        this._show_scale_cbmi = new JCheckBoxMenuItem("Display Scale");
        this._options_jmenu.add(this._show_scale_cbmi);
        this._show_branch_length_values_cbmi = new JCheckBoxMenuItem("Display Branch Length Values");
        this._options_jmenu.add(this._show_branch_length_values_cbmi);
        this._show_overview_cbmi = new JCheckBoxMenuItem("Show Overview");
        this._options_jmenu.add(this._show_overview_cbmi);
        this._label_direction_cbmi = new JCheckBoxMenuItem("Radial Labels");
        this._options_jmenu.add(this._label_direction_cbmi);
        this._label_direction_cbmi.setToolTipText("To use radial node labels in radial and unrooted display types");
        this._screen_antialias_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._screen_antialias_cbmi);
        this._background_gradient_cbmi = new JCheckBoxMenuItem("Background Color Gradient");
        this._options_jmenu.add(this._background_gradient_cbmi);
        this._choose_minimal_confidence_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_minimal_confidence_mi);
        this._overview_placment_mi = new JMenuItem("");
        this._options_jmenu.add(this._overview_placment_mi);
        this._switch_colors_mi = new JMenuItem("");
        this._options_jmenu.add(this._switch_colors_mi);
        this._choose_font_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_font_mi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Search:"), this.getConfiguration()));
        this._search_case_senstive_cbmi = new JCheckBoxMenuItem("Case Sensitive");
        this._options_jmenu.add(this._search_case_senstive_cbmi);
        this._search_whole_words_only_cbmi = new JCheckBoxMenuItem("Match Complete Terms Only");
        this._options_jmenu.add(this._search_whole_words_only_cbmi);
        this._inverse_search_result_cbmi = new JCheckBoxMenuItem("Negate Result");
        this._options_jmenu.add(this._inverse_search_result_cbmi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Graphics Export & Printing:"), this.getConfiguration()));
        this._antialias_print_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._antialias_print_cbmi);
        this._print_black_and_white_cbmi = new JCheckBoxMenuItem("Export in Black and White");
        this._options_jmenu.add(this._print_black_and_white_cbmi);
        this._print_using_actual_size_cbmi = new JCheckBoxMenuItem("Use Current Image Size for PDF export and Printing");
        this._options_jmenu.add(this._print_using_actual_size_cbmi);
        this._graphics_export_using_actual_size_cbmi = new JCheckBoxMenuItem("Use Current Image Size for PNG, JPG, and GIF export");
        this._options_jmenu.add(this._graphics_export_using_actual_size_cbmi);
        this._graphics_export_visible_only_cbmi = new JCheckBoxMenuItem("Limit to Visible ('Screenshot') for PNG, JPG, and GIF export");
        this._options_jmenu.add(this._graphics_export_visible_only_cbmi);
        this._print_size_mi = new JMenuItem("");
        this._options_jmenu.add(this._print_size_mi);
        this._choose_pdf_width_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_pdf_width_mi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Newick/NHX/Nexus Parsing:"), this.getConfiguration()));
        this._internal_number_are_confidence_for_nh_parsing_cbmi = new JCheckBoxMenuItem("Internal Numbers Are Confidence Values");
        this._options_jmenu.add(this._internal_number_are_confidence_for_nh_parsing_cbmi);
        this._replace_underscores_cbmi = new JCheckBoxMenuItem("Replace Underscores with Spaces");
        this._options_jmenu.add(this._replace_underscores_cbmi);
        this._ignore_quotes_in_nh_parsing_cbmi = new JCheckBoxMenuItem("Ignore Quotation Marks and Spaces in Labels");
        this._options_jmenu.add(this._ignore_quotes_in_nh_parsing_cbmi);
        this._extract_pfam_style_tax_codes_cbmi = new JCheckBoxMenuItem("Extract Taxonomy Codes from Pfam-style Labels");
        this._options_jmenu.add(this._extract_pfam_style_tax_codes_cbmi);
        this.customizeJMenuItem(this._choose_font_mi);
        this.customizeJMenuItem(this._choose_minimal_confidence_mi);
        this.customizeJMenuItem(this._switch_colors_mi);
        this.customizeJMenuItem(this._print_size_mi);
        this.customizeJMenuItem(this._choose_pdf_width_mi);
        this.customizeJMenuItem(this._overview_placment_mi);
        this.customizeCheckBoxMenuItem(this._show_node_boxes_cbmi, this.getOptions().isShowNodeBoxes());
        this.customizeCheckBoxMenuItem(this._screen_antialias_cbmi, this.getOptions().isAntialiasScreen());
        this.customizeCheckBoxMenuItem(this._background_gradient_cbmi, this.getOptions().isBackgroundColorGradient());
        this.customizeCheckBoxMenuItem(this._search_case_senstive_cbmi, this.getOptions().isSearchCaseSensitive());
        this.customizeCheckBoxMenuItem(this._show_scale_cbmi, this.getOptions().isShowScale());
        this.customizeRadioButtonMenuItem(this._non_lined_up_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP);
        this.customizeRadioButtonMenuItem(this._uniform_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        this.customizeRadioButtonMenuItem(this._ext_node_dependent_cladogram_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        this.customizeCheckBoxMenuItem(this._show_branch_length_values_cbmi, this.getOptions().isShowBranchLengthValues());
        this.customizeCheckBoxMenuItem(this._show_overview_cbmi, this.getOptions().isShowOverview());
        this.customizeCheckBoxMenuItem(this._label_direction_cbmi, this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL);
        this.customizeCheckBoxMenuItem(this._antialias_print_cbmi, this.getOptions().isAntialiasPrint());
        this.customizeCheckBoxMenuItem(this._print_black_and_white_cbmi, this.getOptions().isPrintBlackAndWhite());
        this.customizeCheckBoxMenuItem(this._internal_number_are_confidence_for_nh_parsing_cbmi, this.getOptions().isInternalNumberAreConfidenceForNhParsing());
        this.customizeCheckBoxMenuItem(this._extract_pfam_style_tax_codes_cbmi, this.getOptions().isExtractPfamTaxonomyCodesInNhParsing());
        this.customizeCheckBoxMenuItem(this._replace_underscores_cbmi, this.getOptions().isReplaceUnderscoresInNhParsing());
        this.customizeCheckBoxMenuItem(this._ignore_quotes_in_nh_parsing_cbmi, this.getOptions().isNhParsingIgnoreQuotes());
        this.customizeCheckBoxMenuItem(this._search_whole_words_only_cbmi, this.getOptions().isMatchWholeTermsOnly());
        this.customizeCheckBoxMenuItem(this._inverse_search_result_cbmi, this.getOptions().isInverseSearchResult());
        this.customizeCheckBoxMenuItem(this._graphics_export_visible_only_cbmi, this.getOptions().isGraphicsExportVisibleOnly());
        this.customizeCheckBoxMenuItem(this._print_using_actual_size_cbmi, this.getOptions().isPrintUsingActualSize());
        this.customizeCheckBoxMenuItem(this._graphics_export_using_actual_size_cbmi, this.getOptions().isGraphicsExportUsingActualSize());
        this._jmenubar.add(this._options_jmenu);
    }

    private void choosePdfWidth() {
        String s = (String)JOptionPane.showInputDialog(this, "Please enter the default line width for PDF export.\n[current value: " + this.getOptions().getPrintLineWidth() + "]\n", "Line Width for PDF Export", 3, null, null, Float.valueOf(this.getOptions().getPrintLineWidth()));
        if (!ForesterUtil.isEmpty(s)) {
            boolean success = true;
            float f = 0.0f;
            String m_str = s.trim();
            if (!ForesterUtil.isEmpty(m_str)) {
                try {
                    f = Float.parseFloat(m_str);
                }
                catch (Exception ex) {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && (double)f > 0.0) {
                this.getOptions().setPrintLineWidth(f);
            }
        }
    }

    private void choosePrintSize() {
        String s = (String)JOptionPane.showInputDialog(this, "Please enter values for width and height,\nseparated by a comma.\n[current values: " + this.getOptions().getPrintSizeX() + ", " + this.getOptions().getPrintSizeY() + "]\n" + "[A4: " + 595 + ", " + 845 + "]\n" + "[US Letter: " + 612 + ", " + 792 + "]", "Default Size for Graphics Export", 3, null, null, String.valueOf(this.getOptions().getPrintSizeX()) + ", " + this.getOptions().getPrintSizeY());
        if (!ForesterUtil.isEmpty(s) && s.indexOf(44) > 0) {
            boolean success = true;
            int x = 0;
            int y = 0;
            String[] str_ary = s.split(",");
            if (str_ary.length == 2) {
                String x_str = str_ary[0].trim();
                String y_str = str_ary[1].trim();
                if (!ForesterUtil.isEmpty(x_str) && !ForesterUtil.isEmpty(y_str)) {
                    try {
                        x = Integer.parseInt(x_str);
                        y = Integer.parseInt(y_str);
                    }
                    catch (Exception ex) {
                        success = false;
                    }
                } else {
                    success = false;
                }
            } else {
                success = false;
            }
            if (success && x > 1 && y > 1) {
                this.getOptions().setPrintSizeX(x);
                this.getOptions().setPrintSizeY(y);
            }
        }
    }

    @Override
    void close() {
        int r;
        if (this.isUnsavedDataPresent() && (r = JOptionPane.showConfirmDialog(this, "Exit despite potentially unsaved changes?", "Exit?", 0)) != 0) {
            return;
        }
        this.exit();
    }

    private void closeCurrentPane() {
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            int r;
            if (this.getMainPanel().getCurrentTreePanel().isEdited() && (r = JOptionPane.showConfirmDialog(this, "Close tab despite potentially unsaved changes?", "Close Tab?", 0)) != 0) {
                return;
            }
            this.getMainPanel().closeCurrentPane();
            this.activateSaveAllIfNeeded();
        }
    }

    void executeGSDI() {
        if (!this.isOKforSDI(false, true)) {
            return;
        }
        if (!this._mainpanel.getCurrentPhylogeny().isRooted()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not rooted.", "Cannot execute GSDI", 0);
            return;
        }
        Phylogeny gene_tree = this._mainpanel.getCurrentPhylogeny().copy();
        gene_tree.setAllNodesToNotCollapse();
        gene_tree.recalculateNumberOfExternalDescendants(false);
        GSDI gsdi = null;
        int duplications = -1;
        try {
            gsdi = new GSDI(gene_tree, this._species_tree.copy(), true);
            duplications = gsdi.getDuplicationsSum();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Error during GSDI", 0);
        }
        gene_tree.setRerootable(false);
        this._mainpanel.getCurrentTreePanel().setTree(gene_tree);
        this.getControlPanel().setShowEvents(true);
        this.showWhole();
        JOptionPane.showMessageDialog(this, "Number of duplications: " + duplications, "GSDI successfully completed", 1);
    }

    void executeSDI() {
        if (!this.isOKforSDI(true, true)) {
            return;
        }
        if (!this._mainpanel.getCurrentPhylogeny().isRooted()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not rooted", "Cannot execute SDI", 0);
            return;
        }
        Phylogeny gene_tree = this._mainpanel.getCurrentPhylogeny().copy();
        gene_tree.setAllNodesToNotCollapse();
        gene_tree.recalculateNumberOfExternalDescendants(false);
        SDIse sdi2 = null;
        int duplications = -1;
        try {
            sdi2 = new SDIse(gene_tree, this._species_tree.copy());
            duplications = sdi2.getDuplicationsSum();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Error during SDI", 0);
        }
        gene_tree.setRerootable(false);
        this._mainpanel.getCurrentTreePanel().setTree(gene_tree);
        this.getControlPanel().setShowEvents(true);
        this.showWhole();
        JOptionPane.showMessageDialog(this, "Number of duplications: " + duplications, "SDI successfully completed", 1);
    }

    void executeSDIR(boolean minimize_cost) {
        if (!this.isOKforSDI(true, true)) {
            return;
        }
        Phylogeny gene_tree = this._mainpanel.getCurrentPhylogeny().copy();
        SDIR sdiunrooted = new SDIR();
        gene_tree.setAllNodesToNotCollapse();
        gene_tree.recalculateNumberOfExternalDescendants(false);
        try {
            gene_tree = sdiunrooted.infer(gene_tree, this._species_tree, minimize_cost, !minimize_cost, true, true, 1)[0];
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString(), "Error during SDIR", 0);
            return;
        }
        int duplications = sdiunrooted.getMinimalDuplications();
        gene_tree.setRerootable(false);
        this._mainpanel.getCurrentTreePanel().setTree(gene_tree);
        this.getControlPanel().setShowEvents(true);
        this.showWhole();
        JOptionPane.showMessageDialog(this, "Number of duplications: " + duplications, "SDIR successfully completed", 1);
    }

    void exit() {
        this.removeTextFrame();
        this._mainpanel.terminate();
        this._contentpane.removeAll();
        this.setVisible(false);
        this.dispose();
    }

    private ControlPanel getControlPanel() {
        return this.getMainPanel().getControlPanel();
    }

    private File getCurrentDir() {
        if (!(this._current_dir != null && this._current_dir.canRead() || ForesterUtil.OS_NAME.toLowerCase().indexOf("win") <= -1)) {
            try {
                this._current_dir = new File(WindowsUtils.getCurrentUserDesktopPath());
            }
            catch (Exception e) {
                this._current_dir = null;
            }
        }
        if (this._current_dir == null || !this._current_dir.canRead()) {
            if (System.getProperty("user.home") != null) {
                this._current_dir = new File(System.getProperty("user.home"));
            } else if (System.getProperty("user.dir") != null) {
                this._current_dir = new File(System.getProperty("user.dir"));
            }
        }
        return this._current_dir;
    }

    @Override
    MainPanel getMainPanel() {
        return this._mainpanel;
    }

    boolean isOKforSDI(boolean species_tree_has_to_binary, boolean gene_tree_has_to_binary) {
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            return false;
        }
        if (this._species_tree == null || this._species_tree.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No species tree loaded", "Cannot execute SDI", 0);
            return false;
        }
        if (species_tree_has_to_binary && !this._species_tree.isCompletelyBinary()) {
            JOptionPane.showMessageDialog(this, "Species tree is not completely binary", "Cannot execute SDI", 0);
            return false;
        }
        if (gene_tree_has_to_binary && !this._mainpanel.getCurrentPhylogeny().isCompletelyBinary()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not completely binary", "Cannot execute SDI", 0);
            return false;
        }
        return true;
    }

    private boolean isUnsavedDataPresent() {
        List<TreePanel> tps = this.getMainPanel().getTreePanels();
        for (TreePanel tp : tps) {
            if (!tp.isEdited()) continue;
            return true;
        }
        return false;
    }

    private void newTree() {
        Phylogeny[] phys = new Phylogeny[1];
        Phylogeny phy = new Phylogeny();
        PhylogenyNode node = new PhylogenyNode();
        phy.setRoot(node);
        phy.setRooted(true);
        phys[0] = phy;
        Util.addPhylogeniesToTabs(phys, "", "", this.getConfiguration(), this.getMainPanel());
        this._mainpanel.getControlPanel().showWhole();
        this._mainpanel.getCurrentTreePanel().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        this._mainpanel.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        if (this.getMainPanel().getMainFrame() == null) {
            ((ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet()).setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        } else {
            this.getMainPanel().getMainFrame().setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        }
        this.activateSaveAllIfNeeded();
        System.gc();
    }

    private void print() {
        if (this.getCurrentTreePanel() == null || this.getCurrentTreePanel().getPhylogeny() == null || this.getCurrentTreePanel().getPhylogeny().isEmpty()) {
            return;
        }
        if (!this.getOptions().isPrintUsingActualSize()) {
            this.getCurrentTreePanel().setParametersForPainting(this.getOptions().getPrintSizeX() - 80, this.getOptions().getPrintSizeY() - 140, true);
            this.getCurrentTreePanel().resetPreferredSize();
            this.getCurrentTreePanel().repaint();
        }
        String job_name = "Archaeopteryx";
        boolean error = false;
        String printer_name = null;
        try {
            printer_name = Printer.print(this.getCurrentTreePanel(), "Archaeopteryx");
        }
        catch (Exception e) {
            error = true;
            JOptionPane.showMessageDialog(this, e.getMessage(), "Printing Error", 0);
        }
        if (!error && printer_name != null) {
            String msg = "Printing data sent to printer";
            if (printer_name.length() > 1) {
                msg = String.valueOf(msg) + " [" + printer_name + "]";
            }
            JOptionPane.showMessageDialog(this, msg, "Printing...", 1);
        }
        if (!this.getOptions().isPrintUsingActualSize()) {
            this.getControlPanel().showWhole();
        }
    }

    private void printPhylogenyToPdf(String file_name) {
        if (!this.getOptions().isPrintUsingActualSize()) {
            this.getCurrentTreePanel().setParametersForPainting(this.getOptions().getPrintSizeX(), this.getOptions().getPrintSizeY(), true);
            this.getCurrentTreePanel().resetPreferredSize();
            this.getCurrentTreePanel().repaint();
        }
        String pdf_written_to = "";
        boolean error = false;
        try {
            pdf_written_to = this.getOptions().isPrintUsingActualSize() ? PdfExporter.writePhylogenyToPdf(file_name, this.getCurrentTreePanel(), this.getCurrentTreePanel().getWidth(), this.getCurrentTreePanel().getHeight()) : PdfExporter.writePhylogenyToPdf(file_name, this.getCurrentTreePanel(), this.getOptions().getPrintSizeX(), this.getOptions().getPrintSizeY());
        }
        catch (IOException e) {
            error = true;
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
        if (!error) {
            if (!ForesterUtil.isEmpty(pdf_written_to)) {
                JOptionPane.showMessageDialog(this, "Wrote PDF to: " + pdf_written_to, "Information", 1);
            } else {
                JOptionPane.showMessageDialog(this, "There was an unknown problem when attempting to write to PDF file: \"" + file_name + "\"", "Error", 0);
            }
        }
        if (!this.getOptions().isPrintUsingActualSize()) {
            this.getControlPanel().showWhole();
        }
    }

    private void readPhylogeniesFromFile() {
        boolean exception = false;
        Phylogeny[] phys = null;
        File my_dir = this.getCurrentDir();
        this._open_filechooser.setMultiSelectionEnabled(true);
        if (my_dir != null) {
            this._open_filechooser.setCurrentDirectory(my_dir);
        }
        int result = this._open_filechooser.showOpenDialog(this._contentpane);
        File[] files = this._open_filechooser.getSelectedFiles();
        this.setCurrentDir(this._open_filechooser.getCurrentDirectory());
        boolean nhx_or_nexus = false;
        if (files != null && files.length > 0 && result == 0) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file != null && !file.isDirectory()) {
                    if (this._mainpanel.getCurrentTreePanel() != null) {
                        this._mainpanel.getCurrentTreePanel().setWaitCursor();
                    } else {
                        this._mainpanel.setWaitCursor();
                    }
                    if (this._open_filechooser.getFileFilter() == nhfilter || this._open_filechooser.getFileFilter() == nhxfilter) {
                        try {
                            NHXParser nhx = new NHXParser();
                            this.setSpecialOptionsForNhxParser(nhx);
                            phys = Util.readPhylogenies(nhx, file);
                            nhx_or_nexus = true;
                        }
                        catch (Exception e) {
                            exception = true;
                            this.exceptionOccuredDuringOpenFile(e);
                        }
                    } else if (this._open_filechooser.getFileFilter() == xmlfilter) {
                        MainFrameApplication.warnIfNotPhyloXmlValidation(this.getConfiguration());
                        try {
                            PhyloXmlParser xml_parser = this.createPhyloXmlParser();
                            phys = Util.readPhylogenies(xml_parser, file);
                        }
                        catch (Exception e) {
                            exception = true;
                            this.exceptionOccuredDuringOpenFile(e);
                        }
                    } else if (this._open_filechooser.getFileFilter() == tolfilter) {
                        try {
                            phys = Util.readPhylogenies(new TolParser(), file);
                        }
                        catch (Exception e) {
                            exception = true;
                            this.exceptionOccuredDuringOpenFile(e);
                        }
                    } else if (this._open_filechooser.getFileFilter() == nexusfilter) {
                        try {
                            NexusPhylogeniesParser nex = new NexusPhylogeniesParser();
                            this.setSpecialOptionsForNexParser(nex);
                            phys = Util.readPhylogenies(nex, file);
                            nhx_or_nexus = true;
                        }
                        catch (Exception e) {
                            exception = true;
                            this.exceptionOccuredDuringOpenFile(e);
                        }
                    } else {
                        try {
                            PhylogenyParser parser = ForesterUtil.createParserDependingOnFileType(file, this.getConfiguration().isValidatePhyloXmlAgainstSchema());
                            if (parser instanceof NexusPhylogeniesParser) {
                                NexusPhylogeniesParser nex = (NexusPhylogeniesParser)parser;
                                this.setSpecialOptionsForNexParser(nex);
                                nhx_or_nexus = true;
                            } else if (parser instanceof NHXParser) {
                                NHXParser nhx = (NHXParser)parser;
                                this.setSpecialOptionsForNhxParser(nhx);
                                nhx_or_nexus = true;
                            } else if (parser instanceof PhyloXmlParser) {
                                MainFrameApplication.warnIfNotPhyloXmlValidation(this.getConfiguration());
                            }
                            phys = Util.readPhylogenies(parser, file);
                        }
                        catch (Exception e) {
                            exception = true;
                            this.exceptionOccuredDuringOpenFile(e);
                        }
                    }
                    if (this._mainpanel.getCurrentTreePanel() != null) {
                        this._mainpanel.getCurrentTreePanel().setArrowCursor();
                    } else {
                        this._mainpanel.setArrowCursor();
                    }
                    if (!exception && phys != null && phys.length > 0) {
                        if (nhx_or_nexus && this.getOptions().isInternalNumberAreConfidenceForNhParsing()) {
                            Phylogeny[] phylogenyArray = phys;
                            int n3 = phys.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Phylogeny phy = phylogenyArray[n4];
                                ForesterUtil.transferInternalNodeNamesToConfidence(phy);
                                ++n4;
                            }
                        }
                        Util.addPhylogeniesToTabs(phys, file.getName(), file.getAbsolutePath(), this.getConfiguration(), this.getMainPanel());
                        this._mainpanel.getControlPanel().showWhole();
                    }
                }
                ++n2;
            }
        }
        this.activateSaveAllIfNeeded();
        System.gc();
    }

    static void warnIfNotPhyloXmlValidation(Configuration c) {
        if (!c.isValidatePhyloXmlAgainstSchema()) {
            JOptionPane.showMessageDialog(null, ForesterUtil.wordWrap("phyloXML XSD-based validation is turned off [enable with line 'validate_against_phyloxml_xsd_schem: true' in configuration file]", 80), "Warning", 2);
        }
    }

    private PhyloXmlParser createPhyloXmlParser() {
        PhyloXmlParser xml_parser = null;
        if (this.getConfiguration().isValidatePhyloXmlAgainstSchema()) {
            try {
                xml_parser = PhyloXmlParser.createPhyloXmlParserXsdValidating();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "failed to create validating XML parser", 2);
            }
        }
        if (xml_parser == null) {
            xml_parser = new PhyloXmlParser();
        }
        return xml_parser;
    }

    /*
     * Exception decompiling
     */
    @Override
    void readPhylogeniesFromURL() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void readSpeciesTreeFromFile() {
        Phylogeny t = null;
        boolean exception = false;
        File my_dir = this.getCurrentDir();
        this._open_filechooser_for_species_tree.setSelectedFile(new File(""));
        if (my_dir != null) {
            this._open_filechooser_for_species_tree.setCurrentDirectory(my_dir);
        }
        int result = this._open_filechooser_for_species_tree.showOpenDialog(this._contentpane);
        File file = this._open_filechooser_for_species_tree.getSelectedFile();
        if (file != null && result == 0) {
            Phylogeny[] trees;
            if (this._open_filechooser_for_species_tree.getFileFilter() == xmlfilter) {
                try {
                    trees = Util.readPhylogenies(new PhyloXmlParser(), file);
                    t = trees[0];
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringOpenFile(e);
                }
            } else if (this._open_filechooser_for_species_tree.getFileFilter() == tolfilter) {
                try {
                    trees = Util.readPhylogenies(new TolParser(), file);
                    t = trees[0];
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringOpenFile(e);
                }
            } else {
                try {
                    trees = Util.readPhylogenies(new PhyloXmlParser(), file);
                    t = trees[0];
                }
                catch (Exception e) {
                    exception = true;
                    this.exceptionOccuredDuringOpenFile(e);
                }
            }
            if (!exception && t != null && !t.isRooted()) {
                exception = true;
                t = null;
                JOptionPane.showMessageDialog(this, "Species tree is not rooted", "Species tree not loaded", 0);
            }
            if (!exception && t != null) {
                HashSet<Taxonomy> tax_set = new HashSet<Taxonomy>();
                PhylogenyNodeIterator it = t.iteratorExternalForward();
                while (it.hasNext()) {
                    PhylogenyNode node = it.next();
                    if (!node.getNodeData().isHasTaxonomy()) {
                        exception = true;
                        t = null;
                        JOptionPane.showMessageDialog(this, "Species tree contains external node(s) without taxonomy information", "Species tree not loaded", 0);
                        break;
                    }
                    if (tax_set.contains(node.getNodeData().getTaxonomy())) {
                        exception = true;
                        t = null;
                        JOptionPane.showMessageDialog(this, "Taxonomy [" + node.getNodeData().getTaxonomy().asSimpleText() + "] is not unique in species tree", "Species tree not loaded", 0);
                        break;
                    }
                    tax_set.add(node.getNodeData().getTaxonomy());
                }
            }
            if (!exception && t != null) {
                this._species_tree = t;
                JOptionPane.showMessageDialog(this, "Species tree successfully loaded", "Species tree loaded", 1);
            }
            this._contentpane.repaint();
            System.gc();
        }
    }

    private void setCurrentDir(File current_dir) {
        this._current_dir = current_dir;
    }

    private void setSpecialOptionsForNexParser(NexusPhylogeniesParser nex) {
        nex.setReplaceUnderscores(this.getOptions().isReplaceUnderscoresInNhParsing());
        nex.setIgnoreQuotes(this.getOptions().isNhParsingIgnoreQuotes());
    }

    private void setSpecialOptionsForNhxParser(NHXParser nhx) {
        nhx.setReplaceUnderscores(this.getOptions().isReplaceUnderscoresInNhParsing());
        nhx.setIgnoreQuotes(this.getOptions().isNhParsingIgnoreQuotes());
        NHXParser.TAXONOMY_EXTRACTION te = NHXParser.TAXONOMY_EXTRACTION.NO;
        if (this.getOptions().isExtractPfamTaxonomyCodesInNhParsing()) {
            te = NHXParser.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY;
        }
        nhx.setTaxonomyExtraction(te);
    }

    private void writeAllToFile() {
        if (this.getMainPanel().getTabbedPane() == null || this.getMainPanel().getTabbedPane().getTabCount() < 1) {
            return;
        }
        File my_dir = this.getCurrentDir();
        if (my_dir != null) {
            this._save_filechooser.setCurrentDirectory(my_dir);
        }
        this._save_filechooser.setSelectedFile(new File(""));
        int result = this._save_filechooser.showSaveDialog(this._contentpane);
        File file = this._save_filechooser.getSelectedFile();
        this.setCurrentDir(this._save_filechooser.getCurrentDirectory());
        if (file != null && result == 0) {
            if (file.exists()) {
                int i = JOptionPane.showConfirmDialog(this, file + " already exists. Overwrite?", "Warning", 2, 2);
                if (i != 0) {
                    return;
                }
                try {
                    file.delete();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Failed to delete: " + file, "Error", 2);
                }
            }
            int count = this.getMainPanel().getTabbedPane().getTabCount();
            ArrayList<Phylogeny> trees = new ArrayList<Phylogeny>();
            int i = 0;
            while (i < count) {
                trees.add(this.getMainPanel().getPhylogeny(i));
                this.getMainPanel().getTreePanels().get(i).setEdited(false);
                ++i;
            }
            PhylogenyWriter writer = new PhylogenyWriter();
            try {
                writer.toPhyloXML(file, trees, 0, ForesterUtil.LINE_SEPARATOR);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Failed to write to: " + file, "Error", 2);
            }
        }
    }

    private boolean writeAsNewHampshire(Phylogeny t, boolean exception, File file) {
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toNewHampshire(t, false, true, file);
        }
        catch (Exception e) {
            exception = true;
            this.exceptionOccuredDuringSaveAs(e);
        }
        return exception;
    }

    private boolean writeAsNexus(Phylogeny t, boolean exception, File file) {
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toNexus(file, t);
        }
        catch (Exception e) {
            exception = true;
            this.exceptionOccuredDuringSaveAs(e);
        }
        return exception;
    }

    private boolean writeAsNHX(Phylogeny t, boolean exception, File file) {
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toNewHampshireX(t, file);
        }
        catch (Exception e) {
            exception = true;
            this.exceptionOccuredDuringSaveAs(e);
        }
        return exception;
    }

    private boolean writeAsPhyloXml(Phylogeny t, boolean exception, File file) {
        try {
            PhylogenyWriter writer = new PhylogenyWriter();
            writer.toPhyloXML(file, t, 0);
        }
        catch (Exception e) {
            exception = true;
            this.exceptionOccuredDuringSaveAs(e);
        }
        return exception;
    }

    private void writePhylogenyToGraphicsFile(String file_name, Util.GraphicsExportType type) {
        this._mainpanel.getCurrentTreePanel().setParametersForPainting(this._mainpanel.getCurrentTreePanel().getWidth(), this._mainpanel.getCurrentTreePanel().getHeight(), true);
        String file_written_to = "";
        boolean error = false;
        try {
            file_written_to = Util.writePhylogenyToGraphicsFile(file_name, this._mainpanel.getCurrentTreePanel().getWidth(), this._mainpanel.getCurrentTreePanel().getHeight(), this._mainpanel.getCurrentTreePanel(), this._mainpanel.getControlPanel(), type, this.getOptions());
        }
        catch (IOException e) {
            error = true;
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
        if (!error) {
            if (file_written_to != null && file_written_to.length() > 0) {
                JOptionPane.showMessageDialog(this, "Wrote image to: " + file_written_to, "Graphics Export", 1);
            } else {
                JOptionPane.showMessageDialog(this, "There was an unknown problem when attempting to write to an image file: \"" + file_name + "\"", "Error", 0);
            }
        }
        this._contentpane.repaint();
    }

    private void writeToFile(Phylogeny t) {
        if (t == null) {
            return;
        }
        String initial_filename = null;
        if (this.getMainPanel().getCurrentTreePanel().getTreeFile() != null) {
            try {
                initial_filename = this.getMainPanel().getCurrentTreePanel().getTreeFile().getCanonicalPath();
            }
            catch (IOException e) {
                initial_filename = null;
            }
        }
        if (!ForesterUtil.isEmpty(initial_filename)) {
            this._save_filechooser.setSelectedFile(new File(initial_filename));
        } else {
            this._save_filechooser.setSelectedFile(new File(""));
        }
        File my_dir = this.getCurrentDir();
        if (my_dir != null) {
            this._save_filechooser.setCurrentDirectory(my_dir);
        }
        int result = this._save_filechooser.showSaveDialog(this._contentpane);
        File file = this._save_filechooser.getSelectedFile();
        this.setCurrentDir(this._save_filechooser.getCurrentDirectory());
        boolean exception = false;
        if (file != null && result == 0) {
            String file_name;
            if (file.exists()) {
                int i = JOptionPane.showConfirmDialog(this, file + " already exists. Overwrite?", "Overwrite?", 2, 2);
                if (i != 0) {
                    return;
                }
                try {
                    file.delete();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Failed to delete: " + file, "Error", 2);
                }
            }
            if (!(exception = this._save_filechooser.getFileFilter() == nhfilter ? this.writeAsNewHampshire(t, exception, file) : (this._save_filechooser.getFileFilter() == nhxfilter ? this.writeAsNHX(t, exception, file) : (this._save_filechooser.getFileFilter() == xmlfilter ? this.writeAsPhyloXml(t, exception, file) : (this._save_filechooser.getFileFilter() == nexusfilter ? this.writeAsNexus(t, exception, file) : ((file_name = file.getName().trim().toLowerCase()).endsWith(".nh") || file_name.endsWith(".newick") || file_name.endsWith(".phy") || file_name.endsWith(".tree") ? this.writeAsNewHampshire(t, exception, file) : (file_name.endsWith(".nhx") ? this.writeAsNHX(t, exception, file) : (file_name.endsWith(".nex") || file_name.endsWith(".nexus") ? this.writeAsNexus(t, exception, file) : this.writeAsPhyloXml(t, exception, file))))))))) {
                this.getMainPanel().getCurrentTreePanel().setTreeFile(file);
                this.getMainPanel().getCurrentTreePanel().setEdited(false);
            }
        }
    }

    private void writeToGraphicsFile(Phylogeny t, Util.GraphicsExportType type) {
        if (t == null || t.isEmpty()) {
            return;
        }
        String initial_filename = "";
        if (this.getMainPanel().getCurrentTreePanel().getTreeFile() != null) {
            initial_filename = this.getMainPanel().getCurrentTreePanel().getTreeFile().toString();
        }
        if (initial_filename.indexOf(46) > 0) {
            initial_filename = initial_filename.substring(0, initial_filename.lastIndexOf(46));
        }
        initial_filename = String.valueOf(initial_filename) + "." + (Object)((Object)type);
        this._writetographics_filechooser.setSelectedFile(new File(initial_filename));
        File my_dir = this.getCurrentDir();
        if (my_dir != null) {
            this._writetographics_filechooser.setCurrentDirectory(my_dir);
        }
        int result = this._writetographics_filechooser.showSaveDialog(this._contentpane);
        File file = this._writetographics_filechooser.getSelectedFile();
        this.setCurrentDir(this._writetographics_filechooser.getCurrentDirectory());
        if (file != null && result == 0) {
            if (!file.toString().toLowerCase().endsWith(type.toString())) {
                file = new File(String.valueOf(file.toString()) + "." + (Object)((Object)type));
            }
            if (file.exists()) {
                int i = JOptionPane.showConfirmDialog(this, file + " already exists. Overwrite?", "Warning", 2, 2);
                if (i != 0) {
                    return;
                }
                try {
                    file.delete();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Failed to delete: " + file, "Error", 2);
                }
            }
            this.writePhylogenyToGraphicsFile(file.toString(), type);
        }
    }

    private void writeToPdf(Phylogeny t) {
        if (t == null || t.isEmpty()) {
            return;
        }
        String initial_filename = "";
        if (this.getMainPanel().getCurrentTreePanel().getTreeFile() != null) {
            initial_filename = this.getMainPanel().getCurrentTreePanel().getTreeFile().toString();
        }
        if (initial_filename.indexOf(46) > 0) {
            initial_filename = initial_filename.substring(0, initial_filename.lastIndexOf(46));
        }
        initial_filename = String.valueOf(initial_filename) + ".pdf";
        this._writetopdf_filechooser.setSelectedFile(new File(initial_filename));
        File my_dir = this.getCurrentDir();
        if (my_dir != null) {
            this._writetopdf_filechooser.setCurrentDirectory(my_dir);
        }
        int result = this._writetopdf_filechooser.showSaveDialog(this._contentpane);
        File file = this._writetopdf_filechooser.getSelectedFile();
        this.setCurrentDir(this._writetopdf_filechooser.getCurrentDirectory());
        if (file != null && result == 0) {
            int i;
            if (!file.toString().toLowerCase().endsWith(".pdf")) {
                file = new File(String.valueOf(file.toString()) + ".pdf");
            }
            if (file.exists() && (i = JOptionPane.showConfirmDialog(this, file + " already exists. Overwrite?", "WARNING", 2, 2)) != 0) {
                return;
            }
            this.printPhylogenyToPdf(file.toString());
        }
    }

    static MainFrame createInstance(Phylogeny[] phys, Configuration config, String title) {
        return new MainFrameApplication(phys, config, title);
    }

    static MainFrame createInstance(Phylogeny[] phys, String config_file_name, String title) {
        return new MainFrameApplication(phys, config_file_name, title);
    }

    static void setTextForGraphicsSizeChooserMenuItem(JMenuItem mi, Options o) {
        mi.setText("Enter Default Size for Graphics Export... (current: " + o.getPrintSizeX() + ", " + o.getPrintSizeY() + ")");
    }

    static void setTextForPdfLineWidthChooserMenuItem(JMenuItem mi, Options o) {
        mi.setText("Enter Default Line Width for PDF Export... (current: " + o.getPrintLineWidth() + ")");
    }
}

