/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.forester.archaeopteryx.TreePanel;

final class MouseListener
extends MouseAdapter
implements MouseMotionListener {
    private final TreePanel _treepanel;
    private boolean _being_dragged = false;
    private final Point _click_point = new Point();

    MouseListener(TreePanel tp) {
        this._treepanel = tp;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this._click_point.setLocation(e.getX(), e.getY());
        this._treepanel.mouseClicked(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getModifiersEx() == 1024 || e.getModifiersEx() == 4096) {
            if (!this._treepanel.inOvRectangle(e)) {
                if (!this._being_dragged) {
                    this._being_dragged = true;
                    this._treepanel.setLastMouseDragPointX(e.getX());
                    this._treepanel.setLastMouseDragPointY(e.getY());
                }
                this._treepanel.mouseDragInBrowserPanel(e);
            } else {
                if (!this._being_dragged) {
                    this._being_dragged = true;
                    this._treepanel.setLastMouseDragPointX(e.getX());
                    this._treepanel.setLastMouseDragPointY(e.getY());
                }
                this._treepanel.mouseDragInOvRectangle(e);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this._treepanel.mouseMoved(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getModifiersEx() == 1024) {
            if (!this._being_dragged) {
                this._being_dragged = true;
                this._treepanel.setLastMouseDragPointX(e.getX());
                this._treepanel.setLastMouseDragPointY(e.getY());
            }
            if (!this._treepanel.inOvRectangle(e)) {
                this._treepanel.mouseDragInBrowserPanel(e);
            } else {
                this._treepanel.mouseDragInOvRectangle(e);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this._being_dragged) {
            this._being_dragged = false;
        }
        this._treepanel.mouseReleasedInBrowserPanel(e);
    }
}

