/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.util.List;
import java.util.SortedMap;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.forester.archaeopteryx.Constants;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Reference;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;

class NodePanel
extends JPanel
implements TreeSelectionListener {
    static final String DIST_ALTITUDE = "Altitude";
    static final String DIST_LONGITUDE = "Longitude";
    static final String DIST_LATITUDE = "Latitude";
    static final String DIST_GEODETIC_DATUM = "Geodetic datum";
    static final String DIST_DESCRIPTION = "Description";
    static final String DATE_UNIT = "Unit";
    static final String DATE_MAX = "Max";
    static final String DATE_MIN = "Min";
    static final String DATE_VALUE = "Value";
    static final String DATE_DESCRIPTION = "Description";
    static final String TAXONOMY_IDENTIFIER = "Identifier";
    static final String SEQ_ACCESSION = "Accession";
    static final String CONFIDENCE = "Confidence";
    static final String PROP = "Properties";
    static final String BINARY_CHARACTERS = "Binary characters";
    static final String REFERENCE = "Reference";
    static final String LIT_REFERENCE = "Reference";
    static final String LIT_REFERENCE_DESC = "Description";
    static final String LIT_REFERENCE_DOI = "DOI";
    static final String DISTRIBUTION = "Distribution";
    static final String DATE = "Date";
    static final String EVENTS = "Events";
    static final String SEQUENCE = "Sequence";
    static final String TAXONOMY = "Taxonomy";
    static final String BASIC = "Basic";
    static final String TAXONOMY_SCIENTIFIC_NAME = "Scientific name";
    static final String SEQ_MOL_SEQ = "Mol seq";
    static final String SEQ_TYPE = "Type";
    static final String SEQ_LOCATION = "Location";
    static final String SEQ_SYMBOL = "Symbol";
    static final String SEQ_URI = "URI";
    static final String NODE_BRANCH_LENGTH = "Branch length";
    static final String NODE_NAME = "Name";
    static final String TAXONOMY_URI = "URI";
    static final String TAXONOMY_RANK = "Rank";
    static final String TAXONOMY_SYNONYM = "Synonym";
    static final String TAXONOMY_COMMON_NAME = "Common name";
    static final String TAXONOMY_AUTHORITY = "Authority";
    static final String TAXONOMY_CODE = "Code";
    static final String SEQ_NAME = "Name";
    static final String EVENTS_GENE_LOSSES = "Gene losses";
    static final String EVENTS_SPECIATIONS = "Speciations";
    static final String EVENTS_DUPLICATIONS = "Duplications";
    private static final long serialVersionUID = 5120159904388100771L;
    static final String CONFIDENCE_TYPE = "type";
    private final JTree _tree;
    private final JEditorPane _pane;

    public NodePanel(PhylogenyNode phylogeny_node) {
        String node_name = "";
        if (!ForesterUtil.isEmpty(phylogeny_node.getNodeName())) {
            node_name = String.valueOf(phylogeny_node.getNodeName()) + " ";
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("Node " + node_name);
        NodePanel.createNodes(top, phylogeny_node);
        this._tree = new JTree(top);
        this._tree.setEditable(false);
        this.getJTree().setToggleClickCount(1);
        this.expandPath(BASIC);
        this.expandPath(TAXONOMY);
        this.expandPath(SEQUENCE);
        this.expandPath(EVENTS);
        JScrollPane tree_view = new JScrollPane(this.getJTree());
        this._pane = new JEditorPane();
        this._pane.setEditable(false);
        JScrollPane data_view = new JScrollPane(this._pane);
        JSplitPane split_pane = new JSplitPane(0);
        split_pane.setTopComponent(tree_view);
        split_pane.setBottomComponent(data_view);
        data_view.setMinimumSize(Constants.NODE_PANEL_SPLIT_MINIMUM_SIZE);
        tree_view.setMinimumSize(Constants.NODE_PANEL_SPLIT_MINIMUM_SIZE);
        split_pane.setDividerLocation(400);
        split_pane.setPreferredSize(Constants.NODE_PANEL_SIZE);
        this.add(split_pane);
    }

    private void expandPath(String name) {
        TreePath tp = this.getJTree().getNextMatch(name, 0, Position.Bias.Forward);
        if (tp != null) {
            this.getJTree().expandPath(tp);
        }
    }

    private JTree getJTree() {
        return this._tree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
    }

    private static void addAnnotation(DefaultMutableTreeNode top, Annotation ann, String name) {
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        NodePanel.addSubelement(category, "Reference", ann.getRef());
        NodePanel.addSubelement(category, "Description", ann.getDesc());
        NodePanel.addSubelement(category, "Source", ann.getSource());
        NodePanel.addSubelement(category, SEQ_TYPE, ann.getType());
        NodePanel.addSubelement(category, "Evidence", ann.getEvidence());
        if (ann.getConfidence() != null) {
            NodePanel.addSubelement(category, CONFIDENCE, ann.getConfidence().asText().toString());
        }
        if (ann.getProperties() != null) {
            NodePanel.addProperties(category, ann.getProperties(), PROP);
        }
    }

    private static void addAnnotations(DefaultMutableTreeNode top, List<PhylogenyData> annotations, DefaultMutableTreeNode category) {
        if (annotations != null && annotations.size() > 0) {
            category.add(new DefaultMutableTreeNode("Annotations"));
            DefaultMutableTreeNode last = top.getLastLeaf();
            int i = 0;
            for (PhylogenyData ann : annotations) {
                NodePanel.addAnnotation(last, (Annotation)ann, "Annotation " + i++);
            }
        }
    }

    private static void addBasics(DefaultMutableTreeNode top, PhylogenyNode phylogeny_node, String name) {
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        NodePanel.addSubelement(category, "Name", phylogeny_node.getNodeName());
        if (phylogeny_node.getDistanceToParent() != -1024.0) {
            NodePanel.addSubelement(category, NODE_BRANCH_LENGTH, ForesterUtil.FORMATTER_6.format(phylogeny_node.getDistanceToParent()));
        }
        if (phylogeny_node.getBranchData().isHasConfidences()) {
            for (PhylogenyData phylogenyData : phylogeny_node.getBranchData().getConfidences()) {
                NodePanel.addSubelement(category, CONFIDENCE, phylogenyData.asText().toString());
            }
        }
        if (!phylogeny_node.isExternal()) {
            NodePanel.addSubelement(category, "Children", String.valueOf(phylogeny_node.getNumberOfDescendants()));
            NodePanel.addSubelement(category, "External children", String.valueOf(phylogeny_node.getAllExternalDescendants().size()));
            int n = PhylogenyMethods.calculateSumOfDistinctTaxonomies(phylogeny_node);
            if (n > 0) {
                NodePanel.addSubelement(category, "Distinct external taxonomies", String.valueOf(n));
            }
        }
        if (!phylogeny_node.isRoot()) {
            NodePanel.addSubelement(category, "Depth", String.valueOf(PhylogenyMethods.calculateDepth(phylogeny_node)));
            double d = PhylogenyMethods.calculateDistanceToRoot(phylogeny_node);
            if (d > 0.0) {
                NodePanel.addSubelement(category, "Distance to root", String.valueOf(ForesterUtil.FORMATTER_6.format(d)));
            }
        }
    }

    private static void addBinaryCharacters(DefaultMutableTreeNode top, BinaryCharacters bc, String name) {
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        NodePanel.addSubelement(category, "Gained", String.valueOf(bc.getGainedCount()));
        NodePanel.addSubelement(category, "Lost", String.valueOf(bc.getLostCount()));
        NodePanel.addSubelement(category, "Present", String.valueOf(bc.getPresentCount()));
        DefaultMutableTreeNode chars = new DefaultMutableTreeNode("Lists");
        category.add(chars);
        NodePanel.addSubelement(chars, "Gained", bc.getGainedCharactersAsStringBuffer().toString());
        NodePanel.addSubelement(chars, "Lost", bc.getLostCharactersAsStringBuffer().toString());
        NodePanel.addSubelement(chars, "Present", bc.getPresentCharactersAsStringBuffer().toString());
    }

    private static void addDate(DefaultMutableTreeNode top, Date date, String name) {
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        NodePanel.addSubelement(category, "Description", date.getDesc());
        NodePanel.addSubelement(category, DATE_VALUE, String.valueOf(date.getValue()));
        NodePanel.addSubelement(category, DATE_MIN, String.valueOf(date.getMin()));
        NodePanel.addSubelement(category, DATE_MAX, String.valueOf(date.getMax()));
        NodePanel.addSubelement(category, DATE_UNIT, date.getUnit());
    }

    private static void addDistribution(DefaultMutableTreeNode top, Distribution dist, String name) {
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        NodePanel.addSubelement(category, "Description", dist.getDesc());
        NodePanel.addSubelement(category, DIST_GEODETIC_DATUM, dist.getGeodeticDatum());
        NodePanel.addSubelement(category, DIST_LATITUDE, String.valueOf(dist.getLatitude()));
        NodePanel.addSubelement(category, DIST_LONGITUDE, String.valueOf(dist.getLongitude()));
        NodePanel.addSubelement(category, DIST_ALTITUDE, String.valueOf(dist.getAltitude()));
    }

    private static void addEvents(DefaultMutableTreeNode top, Event events, String name) {
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        if (events.getNumberOfDuplications() > 0) {
            NodePanel.addSubelement(category, EVENTS_DUPLICATIONS, String.valueOf(events.getNumberOfDuplications()));
        }
        if (events.getNumberOfSpeciations() > 0) {
            NodePanel.addSubelement(category, EVENTS_SPECIATIONS, String.valueOf(events.getNumberOfSpeciations()));
        }
        if (events.getNumberOfGeneLosses() > 0) {
            NodePanel.addSubelement(category, EVENTS_GENE_LOSSES, String.valueOf(events.getNumberOfGeneLosses()));
        }
        NodePanel.addSubelement(category, SEQ_TYPE, events.getEventType().toString());
        if (events.getConfidence() != null) {
            NodePanel.addSubelement(category, CONFIDENCE, events.getConfidence().asText().toString());
        }
    }

    private static void addProperties(DefaultMutableTreeNode top, PropertiesMap properties, String string) {
        SortedMap<String, Property> properties_map = properties.getProperties();
        DefaultMutableTreeNode category = new DefaultMutableTreeNode("Properties ");
        top.add(category);
        for (String key : properties_map.keySet()) {
            Property prop = (Property)properties_map.get(key);
            category.add(new DefaultMutableTreeNode(String.valueOf(prop.getRef()) + " " + prop.getValue() + " " + prop.getUnit() + " [" + prop.getAppliesTo().toString() + "]"));
        }
    }

    private static void addReference(DefaultMutableTreeNode top, Reference ref, String name) {
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        NodePanel.addSubelement(category, LIT_REFERENCE_DOI, ref.getDoi());
        NodePanel.addSubelement(category, "Description", ref.getValue());
    }

    private static void addSequence(DefaultMutableTreeNode top, Sequence seq, String name) {
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        NodePanel.addSubelement(category, "Name", seq.getName());
        NodePanel.addSubelement(category, SEQ_SYMBOL, seq.getSymbol());
        if (seq.getAccession() != null) {
            NodePanel.addSubelement(category, SEQ_ACCESSION, seq.getAccession().asText().toString());
        }
        NodePanel.addSubelement(category, SEQ_LOCATION, seq.getLocation());
        NodePanel.addSubelement(category, SEQ_TYPE, seq.getType());
        NodePanel.addSubelement(category, SEQ_MOL_SEQ, seq.getMolecularSequence());
        if (seq.getUri() != null) {
            NodePanel.addSubelement(category, "URI", seq.getUri().toString());
        }
        NodePanel.addAnnotations(top, seq.getAnnotations(), category);
    }

    private static void addSubelement(DefaultMutableTreeNode node, String name, String value) {
        if (!ForesterUtil.isEmpty(value)) {
            node.add(new DefaultMutableTreeNode(String.valueOf(name) + ": " + value));
        }
    }

    private static void addTaxonomy(DefaultMutableTreeNode top, Taxonomy tax, String name) {
        DefaultMutableTreeNode category = new DefaultMutableTreeNode(name);
        top.add(category);
        if (tax.getIdentifier() != null) {
            NodePanel.addSubelement(category, TAXONOMY_IDENTIFIER, tax.getIdentifier().asText().toString());
        }
        NodePanel.addSubelement(category, TAXONOMY_CODE, tax.getTaxonomyCode());
        NodePanel.addSubelement(category, TAXONOMY_SCIENTIFIC_NAME, tax.getScientificName());
        NodePanel.addSubelement(category, TAXONOMY_AUTHORITY, tax.getAuthority());
        NodePanel.addSubelement(category, TAXONOMY_COMMON_NAME, tax.getCommonName());
        for (String syn : tax.getSynonyms()) {
            NodePanel.addSubelement(category, TAXONOMY_SYNONYM, syn);
        }
        NodePanel.addSubelement(category, TAXONOMY_RANK, tax.getRank());
        if (tax.getUri() != null) {
            NodePanel.addSubelement(category, "URI", tax.getUri().toString());
        }
    }

    private static void createNodes(DefaultMutableTreeNode top, PhylogenyNode phylogeny_node) {
        NodePanel.addBasics(top, phylogeny_node, BASIC);
        if (phylogeny_node.getNodeData().isHasTaxonomy()) {
            NodePanel.addTaxonomy(top, phylogeny_node.getNodeData().getTaxonomy(), TAXONOMY);
        }
        if (phylogeny_node.getNodeData().isHasSequence()) {
            NodePanel.addSequence(top, phylogeny_node.getNodeData().getSequence(), SEQUENCE);
        }
        if (phylogeny_node.getNodeData().isHasEvent()) {
            NodePanel.addEvents(top, phylogeny_node.getNodeData().getEvent(), EVENTS);
        }
        if (phylogeny_node.getNodeData().isHasDate()) {
            NodePanel.addDate(top, phylogeny_node.getNodeData().getDate(), DATE);
        }
        if (phylogeny_node.getNodeData().isHasDistribution()) {
            NodePanel.addDistribution(top, phylogeny_node.getNodeData().getDistribution(), DISTRIBUTION);
        }
        if (phylogeny_node.getNodeData().isHasReference()) {
            NodePanel.addReference(top, phylogeny_node.getNodeData().getReference(), "Reference");
        }
        if (phylogeny_node.getNodeData().isHasBinaryCharacters()) {
            NodePanel.addBinaryCharacters(top, phylogeny_node.getNodeData().getBinaryCharacters(), BINARY_CHARACTERS);
        }
        if (phylogeny_node.getNodeData().isHasProperties()) {
            NodePanel.addProperties(top, phylogeny_node.getNodeData().getProperties(), PROP);
        }
    }
}

