/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Font;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.Util;
import org.forester.util.ForesterUtil;

final class Options {
    static final double MIN_CONFIDENCE_DEFAULT = 0.0;
    private boolean _show_node_boxes;
    private boolean _show_branch_length_values;
    private boolean _internal_number_are_confidence_for_nh_parsing;
    private boolean _show_scale;
    private boolean _show_overview;
    private boolean _antialias_screen;
    private boolean _antialias_print;
    private boolean _graphics_export_visible_only;
    private int _print_size_x;
    private int _print_size_y;
    private double _min_confidence_value;
    private boolean _print_black_and_white;
    private boolean _print_using_actual_size;
    private boolean _graphics_export_using_actual_size;
    private PHYLOGENY_GRAPHICS_TYPE _phylogeny_graphics_type;
    private CLADOGRAM_TYPE _cladogram_type;
    private OVERVIEW_PLACEMENT_TYPE _ov_placement;
    private NODE_LABEL_DIRECTION _node_label_direction;
    private Font _base_font;
    private boolean _match_whole_terms_only;
    private boolean _search_case_sensitive;
    private float _print_line_width;
    private boolean _inverse_search_result;
    private double _scale_bar_length;
    private short _number_of_digits_after_comma_for_confidence_values;
    private short _number_of_digits_after_comma_for_branch_length_values;
    private boolean _nh_parsing_replace_underscores;
    private boolean _nh_parsing_extract_pfam_taxonomy_codes;
    private boolean _nh_parsing_ignore_quotes;
    private boolean _editable;
    private boolean _background_color_gradient;

    private Options() {
        this.init();
    }

    final Font getBaseFont() {
        return this._base_font;
    }

    final CLADOGRAM_TYPE getCladogramType() {
        return this._cladogram_type;
    }

    final double getMinConfidenceValue() {
        return this._min_confidence_value;
    }

    final NODE_LABEL_DIRECTION getNodeLabelDirection() {
        return this._node_label_direction;
    }

    final short getNumberOfDigitsAfterCommaForBranchLengthValues() {
        return this._number_of_digits_after_comma_for_branch_length_values;
    }

    final short getNumberOfDigitsAfterCommaForConfidenceValues() {
        return this._number_of_digits_after_comma_for_confidence_values;
    }

    final OVERVIEW_PLACEMENT_TYPE getOvPlacement() {
        return this._ov_placement;
    }

    final PHYLOGENY_GRAPHICS_TYPE getPhylogenyGraphicsType() {
        return this._phylogeny_graphics_type;
    }

    final float getPrintLineWidth() {
        return this._print_line_width;
    }

    final int getPrintSizeX() {
        return this._print_size_x;
    }

    final int getPrintSizeY() {
        return this._print_size_y;
    }

    final double getScaleBarLength() {
        return this._scale_bar_length;
    }

    private final void init() {
        this._show_node_boxes = false;
        this._show_branch_length_values = false;
        this._internal_number_are_confidence_for_nh_parsing = false;
        this._show_scale = false;
        this._antialias_screen = true;
        this._antialias_print = true;
        this._graphics_export_visible_only = false;
        this._editable = true;
        this._background_color_gradient = false;
        if (Util.isUsOrCanada()) {
            this._print_size_x = 612;
            this._print_size_y = 792;
        } else {
            this._print_size_x = 595;
            this._print_size_y = 845;
        }
        this._min_confidence_value = 0.0;
        this._print_black_and_white = false;
        this._print_using_actual_size = false;
        this._graphics_export_using_actual_size = true;
        this._phylogeny_graphics_type = PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR;
        this._base_font = new Font(Configuration.getDefaultFontFamilyName(), 0, 10);
        this._match_whole_terms_only = false;
        this._search_case_sensitive = false;
        this._print_line_width = 0.5f;
        this._show_overview = true;
        this._ov_placement = OVERVIEW_PLACEMENT_TYPE.UPPER_LEFT;
        this._node_label_direction = NODE_LABEL_DIRECTION.HORIZONTAL;
        this._inverse_search_result = false;
        this._scale_bar_length = 0.0;
        this._number_of_digits_after_comma_for_branch_length_values = (short)2;
        this._number_of_digits_after_comma_for_confidence_values = 1;
        this._nh_parsing_replace_underscores = false;
        this._nh_parsing_extract_pfam_taxonomy_codes = false;
        this._nh_parsing_ignore_quotes = true;
        this._cladogram_type = Constants.CLADOGRAM_TYPE_DEFAULT;
    }

    final boolean isAntialiasPrint() {
        return this._antialias_print;
    }

    final boolean isAntialiasScreen() {
        return this._antialias_screen;
    }

    final boolean isEditable() {
        return this._editable;
    }

    final boolean isExtractPfamTaxonomyCodesInNhParsing() {
        return this._nh_parsing_extract_pfam_taxonomy_codes;
    }

    final boolean isGraphicsExportUsingActualSize() {
        return this._graphics_export_using_actual_size;
    }

    final boolean isGraphicsExportVisibleOnly() {
        return this._graphics_export_visible_only;
    }

    final boolean isInternalNumberAreConfidenceForNhParsing() {
        return this._internal_number_are_confidence_for_nh_parsing;
    }

    final boolean isInverseSearchResult() {
        return this._inverse_search_result;
    }

    final boolean isMatchWholeTermsOnly() {
        return this._match_whole_terms_only;
    }

    final boolean isNhParsingIgnoreQuotes() {
        return this._nh_parsing_ignore_quotes;
    }

    final boolean isPrintBlackAndWhite() {
        return this._print_black_and_white;
    }

    final boolean isPrintUsingActualSize() {
        return this._print_using_actual_size;
    }

    final boolean isReplaceUnderscoresInNhParsing() {
        return this._nh_parsing_replace_underscores;
    }

    final boolean isSearchCaseSensitive() {
        return this._search_case_sensitive;
    }

    final boolean isShowBranchLengthValues() {
        return this._show_branch_length_values;
    }

    final boolean isShowNodeBoxes() {
        return this._show_node_boxes;
    }

    final boolean isShowOverview() {
        return this._show_overview;
    }

    final boolean isShowScale() {
        return this._show_scale;
    }

    final void setAntialiasPrint(boolean antialias_print) {
        this._antialias_print = antialias_print;
    }

    final void setAntialiasScreen(boolean antialias_screen) {
        this._antialias_screen = antialias_screen;
    }

    final void setBaseFont(Font base_font) {
        this._base_font = base_font;
    }

    final void setCladogramType(CLADOGRAM_TYPE cladogram_type) {
        this._cladogram_type = cladogram_type;
    }

    final void setEditable(boolean editable) {
        this._editable = editable;
    }

    final void setExtractPfamTaxonomyCodesInNhParsing(boolean nh_parsing_extract_pfam_taxonomy_codes) {
        this._nh_parsing_extract_pfam_taxonomy_codes = nh_parsing_extract_pfam_taxonomy_codes;
    }

    final void setGraphicsExportUsingActualSize(boolean graphics_export_using_actual_size) {
        this._graphics_export_using_actual_size = graphics_export_using_actual_size;
        if (!graphics_export_using_actual_size) {
            this.setGraphicsExportVisibleOnly(false);
        }
    }

    final void setGraphicsExportVisibleOnly(boolean graphics_export_visible_only) {
        this._graphics_export_visible_only = graphics_export_visible_only;
        if (graphics_export_visible_only) {
            this.setGraphicsExportUsingActualSize(true);
        }
    }

    final void setInternalNumberAreConfidenceForNhParsing(boolean internal_number_are_confidence_for_nh_parsing) {
        this._internal_number_are_confidence_for_nh_parsing = internal_number_are_confidence_for_nh_parsing;
    }

    final void setInverseSearchResult(boolean inverse_search_result) {
        this._inverse_search_result = inverse_search_result;
    }

    final void setMatchWholeTermsOnly(boolean search_whole_words_only) {
        this._match_whole_terms_only = search_whole_words_only;
    }

    final void setMinConfidenceValue(double min_confidence_value) {
        this._min_confidence_value = min_confidence_value;
    }

    final void setNhParsingIgnoreQuotes(boolean nh_parsing_ignore_quotes) {
        this._nh_parsing_ignore_quotes = nh_parsing_ignore_quotes;
    }

    final void setNodeLabelDirection(NODE_LABEL_DIRECTION node_label_direction) {
        this._node_label_direction = node_label_direction;
    }

    private final void setNumberOfDigitsAfterCommaForBranchLength(short number_of_digits_after_comma_for_branch_length_values) {
        this._number_of_digits_after_comma_for_branch_length_values = number_of_digits_after_comma_for_branch_length_values;
    }

    private final void setNumberOfDigitsAfterCommaForConfidenceValues(short number_of_digits_after_comma_for_confidence_values) {
        this._number_of_digits_after_comma_for_confidence_values = number_of_digits_after_comma_for_confidence_values;
    }

    final void setOvPlacement(OVERVIEW_PLACEMENT_TYPE ov_placement) {
        this._ov_placement = ov_placement;
    }

    final void setPhylogenyGraphicsType(PHYLOGENY_GRAPHICS_TYPE phylogeny_graphics_type) {
        this._phylogeny_graphics_type = phylogeny_graphics_type;
    }

    final void setPrintBlackAndWhite(boolean print_black_and_white) {
        this._print_black_and_white = print_black_and_white;
    }

    final void setPrintLineWidth(float print_line_width) {
        this._print_line_width = print_line_width;
    }

    final void setPrintSizeX(int print_size_x) {
        this._print_size_x = print_size_x;
    }

    final void setPrintSizeY(int print_size_y) {
        this._print_size_y = print_size_y;
    }

    final void setPrintUsingActualSize(boolean print_using_actual_size) {
        this._print_using_actual_size = print_using_actual_size;
    }

    final void setReplaceUnderscoresInNhParsing(boolean nh_parsing_replace_underscores) {
        this._nh_parsing_replace_underscores = nh_parsing_replace_underscores;
    }

    final void setScaleBarLength(double scale_bar_length) {
        this._scale_bar_length = scale_bar_length;
    }

    final void setSearchCaseSensitive(boolean search_case_sensitive) {
        this._search_case_sensitive = search_case_sensitive;
    }

    final void setShowBranchLengthValues(boolean show_branch_length_values) {
        this._show_branch_length_values = show_branch_length_values;
    }

    final void setShowNodeBoxes(boolean show_node_boxes) {
        this._show_node_boxes = show_node_boxes;
    }

    final void setShowOverview(boolean show_overview) {
        this._show_overview = show_overview;
    }

    final void setShowScale(boolean show_scale) {
        this._show_scale = show_scale;
    }

    static final Options createDefaultInstance() {
        return new Options();
    }

    static final Options createInstance(Configuration configuration) {
        Options instance = Options.createDefaultInstance();
        if (configuration != null) {
            instance.setAntialiasScreen(configuration.isAntialiasScreen());
            instance.setShowScale(configuration.isShowScale());
            instance.setShowBranchLengthValues(configuration.isShowBranchLengthValues());
            instance.setShowOverview(configuration.isShowOverview());
            instance.setCladogramType(configuration.getCladogramType());
            instance.setOvPlacement(configuration.getOvPlacement());
            instance.setPrintLineWidth(configuration.getPrintLineWidth());
            instance.setNodeLabelDirection(configuration.getNodeLabelDirection());
            instance.setBackgroundColorGradient(configuration.isBackgroundColorGradient());
            if (configuration.getNumberOfDigitsAfterCommaForBranchLengthValues() >= 0) {
                instance.setNumberOfDigitsAfterCommaForBranchLength(configuration.getNumberOfDigitsAfterCommaForBranchLengthValues());
            }
            if (configuration.getNumberOfDigitsAfterCommaForConfidenceValues() >= 0) {
                instance.setNumberOfDigitsAfterCommaForConfidenceValues(configuration.getNumberOfDigitsAfterCommaForConfidenceValues());
            }
            instance.setExtractPfamTaxonomyCodesInNhParsing(configuration.isExtractPfamTaxonomyCodesInNhParsing());
            instance.setReplaceUnderscoresInNhParsing(configuration.isReplaceUnderscoresInNhParsing());
            instance.setInternalNumberAreConfidenceForNhParsing(configuration.isInternalNumberAreConfidenceForNhParsing());
            instance.setNhParsingIgnoreQuotes(configuration.isNhParsingIgnoreQuotes());
            instance.setEditable(configuration.isEditable());
            if (configuration.getMinConfidenceValue() != 0.0) {
                instance.setMinConfidenceValue(configuration.getMinConfidenceValue());
            }
            if (configuration.getGraphicsExportX() > 0) {
                instance.setPrintSizeX(configuration.getGraphicsExportX());
            }
            if (configuration.getGraphicsExportY() > 0) {
                instance.setPrintSizeY(configuration.getGraphicsExportY());
            }
            if (configuration.getBaseFontSize() > 0) {
                instance.setBaseFont(instance.getBaseFont().deriveFont((float)configuration.getBaseFontSize()));
            }
            if (!ForesterUtil.isEmpty(configuration.getBaseFontFamilyName())) {
                instance.setBaseFont(new Font(configuration.getBaseFontFamilyName(), 0, instance.getBaseFont().getSize()));
            }
            if (configuration.getPhylogenyGraphicsType() != null) {
                instance.setPhylogenyGraphicsType(configuration.getPhylogenyGraphicsType());
            }
        }
        return instance;
    }

    public void setBackgroundColorGradient(boolean background_color_gradient) {
        this._background_color_gradient = background_color_gradient;
    }

    public boolean isBackgroundColorGradient() {
        return this._background_color_gradient;
    }

    static enum CLADOGRAM_TYPE {
        NON_LINED_UP,
        EXT_NODE_SUM_DEP,
        TOTAL_NODE_SUM_DEP;

    }

    static enum NODE_LABEL_DIRECTION {
        HORIZONTAL,
        RADIAL;

    }

    static enum OVERVIEW_PLACEMENT_TYPE {
        UPPER_LEFT("upper left"),
        UPPER_RIGHT("upper right"),
        LOWER_LEFT("lower left"),
        LOWER_RIGHT("lower right");

        private final String _name;

        private OVERVIEW_PLACEMENT_TYPE(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public String toTag() {
            return this.toString().replaceAll(" ", "_");
        }
    }

    static enum PHYLOGENY_GRAPHICS_TYPE {
        RECTANGULAR,
        TRIANGULAR,
        EURO_STYLE,
        ROUNDED,
        CONVEX,
        CURVED,
        UNROOTED,
        CIRCULAR;

    }
}

