/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreePanel;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.tol.TolParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;

final class Util {
    private static final String[] AVAILABLE_FONT_FAMILIES_SORTED = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

    static {
        Arrays.sort(AVAILABLE_FONT_FAMILIES_SORTED);
    }

    Util() {
    }

    static final void addPhylogeniesToTabs(Phylogeny[] phys, String default_name, String full_path, Configuration configuration, MainPanel main_panel) {
        if (phys.length > 100) {
            JOptionPane.showMessageDialog(main_panel, "Attempt to load " + phys.length + " phylogenies,\ngoing to load only the first " + 100, "Archaeopteryx more than 100 phylogenies", 2);
        }
        int i = 1;
        Phylogeny[] phylogenyArray = phys;
        int n = phys.length;
        int n2 = 0;
        while (n2 < n) {
            Phylogeny phy = phylogenyArray[n2];
            if (i <= 100) {
                String my_name = "";
                String my_name_for_file = "";
                if (phys.length > 1) {
                    if (!ForesterUtil.isEmpty(default_name)) {
                        my_name = new String(default_name);
                    }
                    if (!ForesterUtil.isEmpty(full_path)) {
                        my_name_for_file = new String(full_path);
                    } else if (!ForesterUtil.isEmpty(default_name)) {
                        my_name_for_file = new String(default_name);
                    }
                    String suffix = "";
                    if (my_name_for_file.indexOf(46) > 0) {
                        suffix = my_name_for_file.substring(my_name_for_file.lastIndexOf(46), my_name_for_file.length());
                        my_name_for_file = my_name_for_file.substring(0, my_name_for_file.lastIndexOf(46));
                    }
                    if (!ForesterUtil.isEmpty(my_name_for_file)) {
                        my_name_for_file = String.valueOf(my_name_for_file) + "_";
                    }
                    if (!ForesterUtil.isEmpty(phy.getName())) {
                        my_name_for_file = String.valueOf(my_name_for_file) + phy.getName().replaceAll(" ", "_");
                    } else if (phy.getIdentifier() != null) {
                        StringBuffer sb = new StringBuffer();
                        if (!ForesterUtil.isEmpty(phy.getIdentifier().getProvider())) {
                            sb.append(phy.getIdentifier().getProvider());
                            sb.append("_");
                        }
                        sb.append(phy.getIdentifier().getValue());
                        my_name_for_file = String.valueOf(my_name_for_file) + sb;
                    } else {
                        my_name_for_file = String.valueOf(my_name_for_file) + i;
                    }
                    if (!ForesterUtil.isEmpty(my_name) && ForesterUtil.isEmpty(phy.getName()) && phy.getIdentifier() == null) {
                        my_name = String.valueOf(my_name) + " [" + i + "]";
                    }
                    if (!ForesterUtil.isEmpty(suffix)) {
                        my_name_for_file = String.valueOf(my_name_for_file) + suffix;
                    }
                } else {
                    if (!ForesterUtil.isEmpty(default_name)) {
                        my_name = new String(default_name);
                    }
                    my_name_for_file = "";
                    if (!ForesterUtil.isEmpty(full_path)) {
                        my_name_for_file = new String(full_path);
                    } else if (!ForesterUtil.isEmpty(default_name)) {
                        my_name_for_file = new String(default_name);
                    }
                    if (ForesterUtil.isEmpty(my_name_for_file)) {
                        if (!ForesterUtil.isEmpty(phy.getName())) {
                            my_name_for_file = new String(phy.getName()).replaceAll(" ", "_");
                        } else if (phy.getIdentifier() != null) {
                            StringBuffer sb = new StringBuffer();
                            if (!ForesterUtil.isEmpty(phy.getIdentifier().getProvider())) {
                                sb.append(phy.getIdentifier().getProvider());
                                sb.append("_");
                            }
                            sb.append(phy.getIdentifier().getValue());
                            my_name_for_file = new String(sb.toString().replaceAll(" ", "_"));
                        }
                    }
                }
                main_panel.addPhylogenyInNewTab(phy, configuration, my_name, full_path);
                main_panel.getCurrentTreePanel().setTreeFile(new File(my_name_for_file));
                Util.lookAtSomeTreePropertiesForAptxControlSettings(phy, main_panel.getControlPanel(), configuration);
            }
            ++i;
            ++n2;
        }
    }

    static final void addPhylogenyToPanel(Phylogeny[] phys, Configuration configuration, MainPanel main_panel) {
        Phylogeny phy = phys[0];
        main_panel.addPhylogenyInPanel(phy, configuration);
        Util.lookAtSomeTreePropertiesForAptxControlSettings(phy, main_panel.getControlPanel(), configuration);
    }

    static final Color calculateColorFromString(String str) {
        String species_uc = str.toUpperCase();
        char first = species_uc.charAt(0);
        int second = 32;
        char third = ' ';
        if (species_uc.length() > 1) {
            second = species_uc.charAt(1);
            if (species_uc.length() > 2) {
                third = species_uc.indexOf(" ") > 0 ? species_uc.charAt(species_uc.indexOf(" ") + 1) : species_uc.charAt(2);
            }
        }
        first = Util.normalizeCharForRGB(first);
        second = Util.normalizeCharForRGB((char)second);
        third = Util.normalizeCharForRGB(third);
        if (first > '\u00eb' && second > 235 && third > '\u00eb') {
            first = '\u0000';
        } else if (first < 'P' && second < 80 && third < 'P') {
            second = 255;
        }
        return new Color(first, second, third);
    }

    static final boolean canWriteFormat(String format_name) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(format_name);
        return iter.hasNext();
    }

    public static final void collapseSpeciesSpecificSubtrees(Phylogeny phy) {
        boolean inferred = false;
        PhylogenyNodeIterator it = phy.iteratorPreorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.isExternal() || n.isCollapse() || n.getNumberOfDescendants() <= 1) continue;
            if (PhylogenyMethods.calculateSumOfDistinctTaxonomies(n) == 1) {
                Util.collapseSubtree(n, true);
                if (!n.getNodeData().isHasTaxonomy()) {
                    n.getNodeData().setTaxonomy((Taxonomy)n.getAllExternalDescendants().get(0).getNodeData().getTaxonomy().copy());
                }
                inferred = true;
                continue;
            }
            n.setCollapse(false);
        }
        if (inferred) {
            phy.setRerootable(false);
        }
    }

    static final void collapseSubtree(PhylogenyNode node, boolean collapse) {
        node.setCollapse(collapse);
        if (node.isExternal()) {
            return;
        }
        PreorderTreeIterator it = new PreorderTreeIterator(node);
        while (it.hasNext()) {
            it.next().setCollapse(collapse);
        }
    }

    static final void colorPhylogenyAccordingToConfidenceValues(Phylogeny tree, TreePanel tree_panel) {
        double max_conf = 0.0;
        PhylogenyNodeIterator it = tree.iteratorPreorder();
        while (it.hasNext()) {
            double conf;
            PhylogenyNode n = it.next();
            n.getBranchData().setBranchColor(null);
            if (!n.getBranchData().isHasConfidences() || !((conf = PhylogenyMethods.getConfidenceValue(n)) > max_conf)) continue;
            max_conf = conf;
        }
        if (max_conf > 0.0) {
            Color bg = tree_panel.getTreeColorSet().getBackgroundColor();
            Color br = tree_panel.getTreeColorSet().getBranchColor();
            PhylogenyNodeIterator it2 = tree.iteratorPreorder();
            while (it2.hasNext()) {
                PhylogenyNode n = it2.next();
                if (!n.getBranchData().isHasConfidences()) continue;
                double conf = PhylogenyMethods.getConfidenceValue(n);
                BranchColor c = new BranchColor(ForesterUtil.calcColor(conf, 0.0, max_conf, bg, br));
                n.getBranchData().setBranchColor(c);
                Set<PhylogenyNode> descs = PhylogenyMethods.getAllDescendants(n);
                for (PhylogenyNode desc : descs) {
                    desc.getBranchData().setBranchColor(c);
                }
            }
        }
    }

    static final void colorPhylogenyAccordingToExternalTaxonomy(Phylogeny tree, TreePanel tree_panel) {
        PhylogenyNodeIterator it = tree.iteratorPreorder();
        while (it.hasNext()) {
            it.next().getBranchData().setBranchColor(null);
        }
        it = tree.iteratorPreorder();
        while (it.hasNext()) {
            Taxonomy tax;
            PhylogenyNode n = it.next();
            if (n.getBranchData().isHasBranchColor() || (tax = PhylogenyMethods.getExternalDescendantsTaxonomy(n)) == null) continue;
            n.getBranchData().setBranchColor(new BranchColor(tree_panel.calculateTaxonomyBasedColor(tax)));
            Set<PhylogenyNode> descs = PhylogenyMethods.getAllDescendants(n);
            for (PhylogenyNode desc : descs) {
                desc.getBranchData().setBranchColor(new BranchColor(tree_panel.calculateTaxonomyBasedColor(tax)));
            }
        }
    }

    static final String createDescriptionForTab(Phylogeny phy, String full_path) {
        StringBuilder desc = new StringBuilder();
        if (phy != null && !phy.isEmpty()) {
            if (!ForesterUtil.isEmpty(phy.getName())) {
                desc.append("name: ");
                desc.append(phy.getName());
                desc.append("; ");
            }
            if (phy.getIdentifier() != null) {
                desc.append("id: ");
                desc.append(phy.getIdentifier());
                desc.append("; ");
            }
            desc.append("rooted: ");
            desc.append(phy.isRooted());
            desc.append("; ");
            desc.append("rerootable: ");
            desc.append(phy.isRerootable());
            desc.append("; ");
            desc.append("external nodes: ");
            desc.append(phy.getNumberOfExternalNodes());
            desc.append("; ");
            desc.append("branches: ");
            desc.append(phy.getNumberOfBranches());
            desc.append("; ");
            desc.append("maximum descendants: ");
            desc.append(PhylogenyMethods.calculateMaximumNumberOfDescendantsPerNode(phy));
            if (!ForesterUtil.isEmpty(full_path) && full_path.length() <= 50) {
                desc.append("; ");
                desc.append("path: ");
                desc.append(full_path);
            }
        }
        return desc.toString();
    }

    static final void dieWithSystemError(String message) {
        System.out.println();
        System.out.println("Archaeopteryx encountered the following system error: " + message);
        System.out.println("Please contact the authors.");
        System.out.println("Archaeopteryx needs to close.");
        System.out.println();
        System.exit(-1);
    }

    static final String[] getAvailableFontFamiliesSorted() {
        return AVAILABLE_FONT_FAMILIES_SORTED;
    }

    static final void inferCommonPartOfScientificNames(Phylogeny tree) {
        boolean inferred = false;
        PhylogenyNodeIterator it = tree.iteratorPostorder();
        while (it.hasNext()) {
            String sn;
            PhylogenyNode n = it.next();
            if (n.getNodeData().isHasTaxonomy() || n.isExternal() || ForesterUtil.isEmpty(sn = PhylogenyMethods.inferCommonPartOfScientificNameOfDescendants(n))) continue;
            n.getNodeData().setTaxonomy(new Taxonomy());
            n.getNodeData().getTaxonomy().setScientificName(sn);
            inferred = true;
        }
        if (inferred) {
            tree.setRerootable(false);
        }
    }

    static final boolean isHasAssignedEvent(PhylogenyNode node) {
        if (!node.getNodeData().isHasEvent()) {
            return false;
        }
        return !node.getNodeData().getEvent().isUnassigned();
    }

    static final boolean isMac() {
        try {
            String s = ForesterUtil.OS_NAME.toLowerCase();
            return s.startsWith("mac");
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "minor error: " + e);
            return false;
        }
    }

    static final boolean isJava15() {
        try {
            String s = ForesterUtil.JAVA_VERSION;
            return s.startsWith("1.5");
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "minor error: " + e);
            return false;
        }
    }

    static final boolean isUsOrCanada() {
        try {
            return Locale.getDefault().equals(Locale.CANADA) || Locale.getDefault().equals(Locale.US);
        }
        catch (Exception e) {
            return false;
        }
    }

    static final boolean isWindows() {
        try {
            String s = ForesterUtil.OS_NAME.toLowerCase();
            return s.indexOf("win") > -1;
        }
        catch (Exception e) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "minor error: " + e);
            return false;
        }
    }

    static final void launchWebBrowser(URI uri, boolean is_applet, JApplet applet, String frame_name) throws IOException {
        if (is_applet) {
            applet.getAppletContext().showDocument(uri.toURL(), frame_name);
        } else {
            try {
                Util.openUrlInWebBrowser(uri.toString());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    static final void lookAtSomeTreePropertiesForAptxControlSettings(Phylogeny t, ControlPanel atv_control, Configuration configuration) {
        if (t != null && !t.isEmpty()) {
            if (!ForesterUtil.isHasAtLeastOneBranchLengthLargerThanZero(t)) {
                atv_control.setDrawPhylogram(false);
                atv_control.setDrawPhylogramEnabled(false);
            }
            if (configuration.doGuessCheckOption(0) && atv_control.getDisplayAsPhylogramCb() != null) {
                if (ForesterUtil.isHasAtLeastOneBranchLengthLargerThanZero(t)) {
                    atv_control.setDrawPhylogram(true);
                    atv_control.setDrawPhylogramEnabled(true);
                } else {
                    atv_control.setDrawPhylogram(false);
                }
            }
            if (configuration.doGuessCheckOption(4) && atv_control.getWriteConfidenceCb() != null) {
                if (ForesterUtil.isHasAtLeastOneBranchWithSupportValues(t)) {
                    atv_control.setCheckbox(4, true);
                } else {
                    atv_control.setCheckbox(4, false);
                }
            }
            if (configuration.doGuessCheckOption(5) && atv_control.getShowEventsCb() != null) {
                if (ForesterUtil.isHasAtLeastNodeWithEvent(t)) {
                    atv_control.setCheckbox(5, true);
                } else {
                    atv_control.setCheckbox(5, false);
                }
            }
        }
    }

    private static final char normalizeCharForRGB(char c) {
        c = (char)(c - 65);
        c = (char)((c = (char)((double)c * 10.2)) > '\u00ff' ? 255 : (int)c);
        c = c < '\u0000' ? (char)'\u0000' : c;
        return c;
    }

    private static final void openUrlInWebBrowser(String url) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InterruptedException {
        String os = System.getProperty("os.name");
        Runtime runtime = Runtime.getRuntime();
        if (os.toLowerCase().startsWith("win")) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else if (Util.isMac()) {
            Class<?> file_mgr = Class.forName("com.apple.eio.FileManager");
            Method open_url = file_mgr.getDeclaredMethod("openURL", String.class);
            open_url.invoke(null, url);
        } else {
            String[] browsers = new String[]{"firefox", "opera", "konqueror", "mozilla", "netscape", "epiphany"};
            String browser = null;
            int i = 0;
            while (i < browsers.length && browser == null) {
                if (runtime.exec(new String[]{"which", browsers[i]}).waitFor() == 0) {
                    browser = browsers[i];
                }
                ++i;
            }
            if (browser == null) {
                throw new IOException("could not find a web browser to open [" + url + "] in");
            }
            runtime.exec(new String[]{browser, url});
        }
    }

    static final void openWebsite(String url, boolean is_applet, JApplet applet) throws IOException {
        try {
            Util.launchWebBrowser(new URI(url), is_applet, applet, "Archaeopteryx");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    static final void printAppletMessage(String applet_name, String message) {
        System.out.println("[" + applet_name + "] > " + message);
    }

    static final Phylogeny[] readPhylogenies(PhylogenyParser parser, File file) throws IOException {
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        Phylogeny[] trees = factory.create(file, parser);
        if (trees == null || trees.length == 0) {
            throw new PhylogenyParserException("Unable to parse phylogeny from file: " + file);
        }
        return trees;
    }

    static final Phylogeny[] readPhylogeniesFromUrl(URL url, boolean phyloxml_validate_against_xsd) throws FileNotFoundException, IOException {
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        PhylogenyParser parser = null;
        parser = url.getHost().toLowerCase().indexOf("tolweb") >= 0 ? new TolParser() : ForesterUtil.createParserDependingOnUrlContents(url, phyloxml_validate_against_xsd);
        return factory.create(url.openStream(), parser);
    }

    static final void removeBranchColors(Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorPreorder();
        while (it.hasNext()) {
            it.next().getBranchData().setBranchColor(null);
        }
    }

    static final void showErrorMessage(Component parent, String error_msg) {
        Util.printAppletMessage("Archaeopteryx", error_msg);
        JOptionPane.showMessageDialog(parent, error_msg, "[Archaeopteryx 0.955 beta x] Error", 0);
    }

    static final void unexpectedError(Error err) {
        err.printStackTrace();
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = err.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement s = stackTraceElementArray[n2];
            sb.append(s + "\n");
            ++n2;
        }
        JOptionPane.showMessageDialog(null, "An unexpected (possibly severe) error has occured - terminating. \nPlease contact: cmzmasek@yahoo.com \nError: " + err + "\n" + sb, "Unexpected Severe Error [Archaeopteryx 0.955 beta x]", 0);
        System.exit(-1);
    }

    static final void unexpectedException(Exception ex) {
        ex.printStackTrace();
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = ex.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement s = stackTraceElementArray[n2];
            sb.append(s + "\n");
            ++n2;
        }
        JOptionPane.showMessageDialog(null, "An unexpected exception has occured. \nPlease contact: cmzmasek@yahoo.com \nException: " + ex + "\n" + sb, "Unexpected Exception [Archaeopteryx0.955 beta x]", 0);
    }

    static final String writePhylogenyToGraphicsFile(String file_name, int width, int height, TreePanel tree_panel, ControlPanel ac, GraphicsExportType type, Options options) throws IOException {
        if (!options.isGraphicsExportUsingActualSize()) {
            if (options.isGraphicsExportVisibleOnly()) {
                throw new IllegalArgumentException("cannot export visible rectangle only without exporting in actual size");
            }
            tree_panel.setParametersForPainting(options.getPrintSizeX(), options.getPrintSizeY(), true);
            tree_panel.resetPreferredSize();
            tree_panel.repaint();
        }
        RenderingHints rendering_hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        rendering_hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (options.isAntialiasPrint()) {
            rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Phylogeny phylogeny = tree_panel.getPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return "";
        }
        File file = new File(file_name);
        if (file.isDirectory()) {
            throw new IOException("\"" + file_name + "\" is a directory");
        }
        Rectangle visible = null;
        if (!options.isGraphicsExportUsingActualSize()) {
            width = options.getPrintSizeX();
            height = options.getPrintSizeY();
        } else if (options.isGraphicsExportVisibleOnly()) {
            visible = tree_panel.getVisibleRect();
            width = visible.width;
            height = visible.height;
        }
        BufferedImage buffered_img = new BufferedImage(width, height, 1);
        Graphics2D g2d = buffered_img.createGraphics();
        g2d.setRenderingHints(rendering_hints);
        int x = 0;
        int y = 0;
        if (options.isGraphicsExportVisibleOnly()) {
            g2d = (Graphics2D)g2d.create(-visible.x, -visible.y, visible.width, visible.height);
            g2d.setClip(null);
            x = visible.x;
            y = visible.y;
        }
        tree_panel.paintPhylogeny(g2d, false, true, width, height, x, y);
        if (type == GraphicsExportType.TIFF) {
            Util.writeToTiff(file, buffered_img);
        } else {
            ImageIO.write((RenderedImage)buffered_img, type.toString(), file);
        }
        g2d.dispose();
        System.gc();
        if (!options.isGraphicsExportUsingActualSize()) {
            tree_panel.getMainPanel().getControlPanel().showWhole();
        }
        String msg = file.toString();
        if (width > 0 && height > 0) {
            msg = String.valueOf(msg) + " [size: " + width + ", " + height + "]";
        }
        return msg;
    }

    static final void writeToTiff(File file, BufferedImage image) throws IOException {
        String[] t;
        ImageWriter writer = null;
        ImageOutputStream ios = null;
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("TIF");
        if (!it.hasNext()) {
            throw new IOException("failed to get TIFF image writer");
        }
        writer = it.next();
        ios = ImageIO.createImageOutputStream(file);
        writer.setOutput(ios);
        ImageWriteParam image_write_param = new ImageWriteParam(Locale.getDefault());
        image_write_param.setCompressionMode(2);
        image_write_param.setCompressionType("PackBits");
        String[] stringArray = t = image_write_param.getCompressionTypes();
        int n = t.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            System.out.println(string);
            ++n2;
        }
        IIOImage iio_image = new IIOImage(image, null, null);
        writer.write(null, iio_image, image_write_param);
    }

    static enum GraphicsExportType {
        GIF("gif"),
        JPG("jpg"),
        PDF("pdf"),
        PNG("png"),
        TIFF("tif"),
        BMP("bmp");

        private final String _suffix;

        private GraphicsExportType(String suffix) {
            this._suffix = suffix;
        }

        public String toString() {
            return this._suffix;
        }
    }
}

