/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.io.IOException;
import java.io.Writer;
import org.forester.development.AminoAcid;
import org.forester.phylogeny.data.PhylogenyData;

public class AminoAcidSequence
implements PhylogenyData {
    private final byte[] _sequence;
    private final String _name;

    public AminoAcidSequence(int length) {
        this._sequence = new byte[length];
        this._name = "";
    }

    public AminoAcidSequence(String name, byte[] sequence) {
        this._sequence = new byte[sequence.length];
        this._name = new String(name);
        int i = 0;
        while (i < sequence.length) {
            this.setStateAt(i, sequence[i]);
            ++i;
        }
    }

    public AminoAcidSequence(String name, String sequence) {
        this._sequence = new byte[sequence.length()];
        this._name = new String(name);
        int i = 0;
        while (i < sequence.length()) {
            this.setResidueAt(i, sequence.charAt(i));
            ++i;
        }
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getName());
    }

    @Override
    public StringBuffer asText() {
        return new StringBuffer(this.getName()).append(": ").append(this.getSequenceAsString());
    }

    @Override
    public AminoAcidSequence copy() {
        return new AminoAcidSequence(this.getName(), this._sequence);
    }

    public int getLength() {
        return this._sequence.length;
    }

    public String getName() {
        return this._name;
    }

    public char getResidueAt(int position) {
        return AminoAcid.getResidue(this.getStateAt(position));
    }

    public String getSequenceAsString() {
        StringBuffer sb = new StringBuffer(this.getLength());
        int i = 0;
        while (i < this.getLength()) {
            sb.append(this.getResidueAt(i));
            ++i;
        }
        return sb.toString();
    }

    public byte getStateAt(int position) {
        return this._sequence[position];
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        return false;
    }

    public void setResidueAt(int position, char residue) {
        this.setStateAt(position, AminoAcid.getState(residue));
    }

    public void setStateAt(int position, byte state) {
        if (AminoAcid.isUnassignable(state)) {
            state = (byte)20;
        }
        this._sequence[position] = state;
    }

    @Override
    public StringBuffer toNHX() {
        return null;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        writer.write("<sequence type=\"aminoacid\">\n");
        writer.write("<name>");
        writer.write(this.getName());
        writer.write("</name>\n");
        writer.write("<sequence>");
        writer.write(this.getSequenceAsString());
        writer.write("</sequence>\n");
        writer.write("</sequence>\n");
    }

    public String toString() {
        return this.asText().toString();
    }
}

