/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.util.Random;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;

public final class DevelopmentTools {
    private DevelopmentTools() {
    }

    public static Phylogeny createBalancedPhylogeny(int levels, int children_per_node) {
        PhylogenyNode root = new PhylogenyNode();
        Phylogeny p = new Phylogeny();
        p.setRoot(root);
        p.setRooted(true);
        DevelopmentTools.createBalancedPhylogenyRecursion(levels, children_per_node, root);
        return p;
    }

    private static void createBalancedPhylogenyRecursion(int current_level, int children_per_node, PhylogenyNode current_node) {
        if (current_level > 0) {
            --current_level;
            int i = 0;
            while (i < children_per_node) {
                PhylogenyNode new_node = new PhylogenyNode();
                current_node.addAsChild(new_node);
                DevelopmentTools.createBalancedPhylogenyRecursion(current_level, children_per_node, new_node);
                ++i;
            }
        }
    }

    public static void intervalNumberSpecies(Phylogeny t, int i) {
        if (t == null || t.isEmpty()) {
            return;
        }
        PhylogenyNode n = t.getFirstExternalNode();
        int j = 1;
        boolean odd = true;
        while (n != null) {
            if (odd) {
                PhylogenyMethods.setScientificName(n, String.valueOf(j));
            } else {
                PhylogenyMethods.setScientificName(n, String.valueOf(j + i));
                ++j;
            }
            odd = !odd;
            n = n.getNextExternalNode();
        }
    }

    public static void numberSpeciesInDescOrder(Phylogeny t) {
        if (t == null || t.isEmpty()) {
            return;
        }
        PhylogenyNode n = t.getFirstExternalNode();
        int j = t.getRoot().getNumberOfExternalNodes();
        while (n != null) {
            PhylogenyMethods.setTaxonomyCode(n, String.valueOf(j));
            --j;
            n = n.getNextExternalNode();
        }
    }

    public static void numberSpeciesInOrder(Phylogeny t) {
        if (t == null || t.isEmpty()) {
            return;
        }
        PhylogenyNode n = t.getFirstExternalNode();
        int j = 1;
        while (n != null) {
            PhylogenyMethods.setScientificName(n, String.valueOf(j));
            ++j;
            n = n.getNextExternalNode();
        }
    }

    public static void randomizeSpecies(int min, int max, Phylogeny t) {
        if (t == null || t.isEmpty()) {
            return;
        }
        int mi = Math.abs(min);
        int ma = Math.abs(max);
        Random r = new Random();
        PhylogenyNode n = t.getFirstExternalNode();
        while (n != null) {
            String code = String.valueOf(Math.abs(r.nextInt()) % (ma - mi + 1) + mi);
            PhylogenyMethods.setTaxonomyCode(n, code);
            n = n.getNextExternalNode();
        }
    }
}

