/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import org.forester.go.GoId;
import org.forester.go.GoRelationship;

public class BasicGoRelationship
implements GoRelationship {
    final GoRelationship.Type _type;
    final GoId _go_id;

    public BasicGoRelationship(String s) {
        String[] sa = s.split(" ");
        if (sa.length != 2) {
            throw new IllegalArgumentException("unexpected format for GO relationship: " + s);
        }
        String type = sa[0].trim();
        String go_id = sa[1].trim();
        if (type.toLowerCase().equals("part_of")) {
            this._type = GoRelationship.Type.PART_OF;
        } else if (type.toLowerCase().equals("regulates")) {
            this._type = GoRelationship.Type.REGULATES;
        } else if (type.toLowerCase().equals("negatively_regulates")) {
            this._type = GoRelationship.Type.NEGATIVELY_REGULATES;
        } else if (type.toLowerCase().equals("positively_regulates")) {
            this._type = GoRelationship.Type.POSITIVELY_REGULATES;
        } else {
            throw new IllegalArgumentException("unknown GO relationship type: " + type);
        }
        this._go_id = new GoId(go_id);
    }

    public BasicGoRelationship(String type, String go_id) {
        if (!type.toLowerCase().equals("part_of")) {
            throw new IllegalArgumentException("unknown GO relationship type: " + type);
        }
        this._type = GoRelationship.Type.PART_OF;
        this._go_id = new GoId(go_id);
    }

    public BasicGoRelationship(GoRelationship.Type type, GoId go_id) {
        this._type = type;
        this._go_id = go_id;
    }

    @Override
    public int compareTo(GoRelationship rel) {
        return this.getGoId().compareTo(rel.getGoId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check go relationship equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check go relationship equality to " + o + " [" + o.getClass() + "]");
        }
        return this.getType().equals((Object)((GoRelationship)o).getType()) && this.getGoId().equals(((GoRelationship)o).getGoId());
    }

    @Override
    public GoId getGoId() {
        return this._go_id;
    }

    @Override
    public GoRelationship.Type getType() {
        return this._type;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.getType()) {
            case PART_OF: {
                sb.append("part_of");
                break;
            }
            case NEGATIVELY_REGULATES: {
                sb.append("negatively_regulates");
                break;
            }
            case POSITIVELY_REGULATES: {
                sb.append("positively_regulates");
                break;
            }
            case REGULATES: {
                sb.append("regulates");
                break;
            }
            default: {
                new AssertionError((Object)("unknown type: " + (Object)((Object)this.getType())));
            }
        }
        sb.append(": ");
        sb.append(this.getGoId().toString());
        return sb.toString();
    }
}

