/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nexus;

import java.io.BufferedReader;
import java.io.IOException;
import org.forester.io.parsers.ParserUtils;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.nexus.NexusFormatException;
import org.forester.phylogenyinference.BasicCharacterStateMatrix;
import org.forester.phylogenyinference.CharacterStateMatrix;

public class NexusBinaryStatesMatrixParser {
    private Object _nexus_source;
    private CharacterStateMatrix<CharacterStateMatrix.BinaryStates> _matrix;
    private int _nchar;
    private int _ntax;

    public CharacterStateMatrix<CharacterStateMatrix.BinaryStates> getMatrix() {
        return this._matrix;
    }

    public int getNChar() {
        return this._nchar;
    }

    private Object getNexusSource() {
        return this._nexus_source;
    }

    public int getNTax() {
        return this._ntax;
    }

    public void parse() throws IOException {
        String line;
        this.reset();
        BufferedReader reader = ParserUtils.createReader(this.getNexusSource());
        boolean in_matrix = false;
        int identifier_index = 0;
        int max_character_index = -1;
        while ((line = reader.readLine()) != null) {
            String s;
            if ((line = line.trim()).length() <= 0 || line.startsWith("#") || line.startsWith(">")) continue;
            if (line.toLowerCase().indexOf("NChar".toLowerCase()) >= 0) {
                int i = line.toLowerCase().indexOf("NChar".toLowerCase());
                s = line.toLowerCase().substring(i + 6);
                s = s.replace(';', ' ').trim();
                this.setNChar(Integer.parseInt(s));
                continue;
            }
            if (line.toLowerCase().indexOf("NTax".toLowerCase()) >= 0) {
                int i = line.toLowerCase().indexOf("NTax".toLowerCase());
                s = line.toLowerCase().substring(i + 5);
                s = s.replace(';', ' ').trim();
                this.setNTax(Integer.parseInt(s));
                continue;
            }
            if (line.toLowerCase().startsWith("Matrix".toLowerCase())) {
                in_matrix = true;
                if (this.getNTax() < 1) {
                    throw new NexusFormatException("did not encounter NTax");
                }
                if (this.getNChar() < 1) {
                    throw new NexusFormatException("did not encounter NChar");
                }
                if (this.getMatrix() != null) {
                    throw new NexusFormatException("more than one matrix present");
                }
                this.setMatrix(new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(this.getNTax(), this.getNChar()));
                continue;
            }
            if (line.toLowerCase().startsWith("End;".toLowerCase())) {
                in_matrix = false;
                continue;
            }
            if (!in_matrix) continue;
            String[] line_ary = line.split("\\s+");
            String label = line_ary[0].trim();
            String states_str = line_ary[1].trim();
            if (states_str.endsWith(";")) {
                in_matrix = false;
                states_str = states_str.substring(0, states_str.length() - 1);
            }
            char[] states = states_str.toCharArray();
            this.getMatrix().setIdentifier(identifier_index, label);
            int character_index = 0;
            char[] cArray = states;
            int n = states.length;
            int n2 = 0;
            while (n2 < n) {
                char state = cArray[n2];
                if (state == CharacterStateMatrix.BinaryStates.PRESENT.toChar()) {
                    try {
                        this.getMatrix().setState(identifier_index, character_index, CharacterStateMatrix.BinaryStates.PRESENT);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        throw new NexusFormatException("problem at line " + line + " [" + ex + "]");
                    }
                } else if (state == CharacterStateMatrix.BinaryStates.ABSENT.toChar()) {
                    try {
                        this.getMatrix().setState(identifier_index, character_index, CharacterStateMatrix.BinaryStates.ABSENT);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        throw new NexusFormatException("problem at line " + line + " [" + ex + "]");
                    }
                } else {
                    throw new NexusFormatException("illegal state " + state);
                }
                ++character_index;
                ++n2;
            }
            if (max_character_index > 0 && max_character_index != character_index) {
                throw new NexusFormatException("unequal number of characters at line " + line);
            }
            max_character_index = character_index;
            ++identifier_index;
        }
    }

    private void reset() {
        this.setMatrix(null);
        this.setNChar(-1);
        this.setNTax(-1);
    }

    private void setMatrix(CharacterStateMatrix<CharacterStateMatrix.BinaryStates> matrix) {
        this._matrix = matrix;
    }

    private void setNChar(int nchar) {
        this._nchar = nchar;
    }

    private void setNTax(int ntax) {
        this._ntax = ntax;
    }

    public void setSource(Object nexus_source) throws PhylogenyParserException, IOException {
        if (nexus_source == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        this._nexus_source = nexus_source;
    }
}

