/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nhx;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public final class NHXParser
implements PhylogenyParser {
    public static final boolean LIMIT_SPECIES_NAMES_TO_FIVE_CHARS = true;
    public static final TAXONOMY_EXTRACTION TAXONOMY_EXTRACTION_DEFAULT = TAXONOMY_EXTRACTION.NO;
    private static final boolean GUESS_ROOTEDNESS_DEFAULT = true;
    private static final boolean GUESS_IF_SUPPORT_VALUES = true;
    private static final boolean IGNORE_QUOTES_DEFAULT = true;
    public static final boolean REPLACE_UNDERSCORES_DEFAULT = false;
    private boolean _saw_closing_paren;
    private static final byte STRING = 0;
    private static final byte STRING_BUFFER = 1;
    private static final byte CHAR_ARRAY = 2;
    private static final byte BUFFERED_READER = 3;
    private boolean _guess_rootedness;
    private boolean _has_next;
    private boolean _ignore_quotes;
    private byte _input_type;
    private int _source_length;
    private PhylogenyNode _current_node;
    private StringBuilder _current_anotation;
    private Object _nhx_source;
    private int _clade_level;
    private List<Phylogeny> _phylogenies;
    private Phylogeny _current_phylogeny;
    private TAXONOMY_EXTRACTION _taxonomy_extraction;
    private boolean _replace_underscores;
    private static final Pattern UC_LETTERS_NUMBERS_PATTERN = Pattern.compile("^[A-Z0-9]+$");
    private static final Pattern NUMBERS_ONLY_PATTERN = Pattern.compile("^[0-9]+$");

    public NHXParser() {
        this.init();
    }

    private void decreaseCladeLevel() throws PhylogenyParserException {
        if (this.getCladeLevel() < 0) {
            throw new PhylogenyParserException("error in NH (Newick)/NHX formatted data: most likely cause: number of close parens is larger than number of open parens");
        }
        --this._clade_level;
    }

    private void finishPhylogeny() throws PhylogenyParserException, NHXFormatException {
        this.setCladeLevel(0);
        if (this.getCurrentPhylogeny() != null) {
            PhylogenyNode root;
            NHXParser.parseNHX(this.getCurrentAnotation().toString(), this.getCurrentPhylogeny().getRoot(), this.getTaxonomyExtraction(), this.isReplaceUnderscores());
            if (NHXParser.isBranchLengthsLikeBootstrapValues(this.getCurrentPhylogeny())) {
                NHXParser.moveBranchLengthsToBootstrapValues(this.getCurrentPhylogeny());
            }
            if (this.isGuessRootedness() && ((root = this.getCurrentPhylogeny().getRoot()).getDistanceToParent() >= 0.0 || !ForesterUtil.isEmpty(root.getNodeName()) || !ForesterUtil.isEmpty(PhylogenyMethods.getSpecies(root)) || root.isHasAssignedEvent())) {
                this.getCurrentPhylogeny().setRooted(true);
            }
            this.getPhylogenies().add(this.getCurrentPhylogeny());
        }
    }

    private void finishSingleNodePhylogeny() throws PhylogenyParserException, NHXFormatException {
        this.setCladeLevel(0);
        PhylogenyNode new_node = new PhylogenyNode();
        NHXParser.parseNHX(this.getCurrentAnotation().toString(), new_node, this.getTaxonomyExtraction(), this.isReplaceUnderscores());
        this.setCurrentPhylogeny(new Phylogeny());
        this.getCurrentPhylogeny().setRoot(new_node);
        this.getPhylogenies().add(this.getCurrentPhylogeny());
    }

    private int getCladeLevel() {
        return this._clade_level;
    }

    private StringBuilder getCurrentAnotation() {
        return this._current_anotation;
    }

    private PhylogenyNode getCurrentNode() {
        return this._current_node;
    }

    private Phylogeny getCurrentPhylogeny() {
        return this._current_phylogeny;
    }

    private byte getInputType() {
        return this._input_type;
    }

    private Object getNhxSource() {
        return this._nhx_source;
    }

    private List<Phylogeny> getPhylogenies() {
        return this._phylogenies;
    }

    private Phylogeny[] getPhylogeniesAsArray() {
        Phylogeny[] p = new Phylogeny[this.getPhylogenies().size()];
        int i = 0;
        while (i < this.getPhylogenies().size()) {
            p[i] = this.getPhylogenies().get(i);
            ++i;
        }
        return p;
    }

    private int getSourceLength() {
        return this._source_length;
    }

    public TAXONOMY_EXTRACTION getTaxonomyExtraction() {
        return this._taxonomy_extraction;
    }

    public boolean hasNext() {
        return this._has_next;
    }

    private void increaseCladeLevel() {
        ++this._clade_level;
    }

    private void init() {
        this.setTaxonomyExtraction(TAXONOMY_EXTRACTION_DEFAULT);
        this.setReplaceUnderscores(false);
        this.setGuessRootedness(true);
        this.setIgnoreQuotes(true);
        this.setHasNext(false);
    }

    private boolean isGuessRootedness() {
        return this._guess_rootedness;
    }

    private boolean isIgnoreQuotes() {
        return this._ignore_quotes;
    }

    private boolean isReplaceUnderscores() {
        return this._replace_underscores;
    }

    private boolean isSawClosingParen() {
        return this._saw_closing_paren;
    }

    private void newCurrentAnotation() {
        this.setCurrentAnotation(new StringBuilder());
    }

    @Override
    public Phylogeny[] parse() throws IOException, NHXFormatException {
        this.setHasNext(false);
        boolean in_comment = false;
        boolean saw_colon = false;
        boolean saw_open_bracket = false;
        boolean in_double_quote = false;
        boolean in_single_quote = false;
        this.setPhylogenies(new ArrayList<Phylogeny>());
        this.setCladeLevel(0);
        this.newCurrentAnotation();
        int i = 0;
        while (true) {
            char c = '\b';
            if (this.getInputType() == 3) {
                int ci = ((BufferedReader)this.getNhxSource()).read();
                if (ci < 0) break;
                c = (char)ci;
            } else {
                if (i >= this.getSourceLength()) break;
                switch (this.getInputType()) {
                    case 0: {
                        c = ((String)this.getNhxSource()).charAt(i);
                        break;
                    }
                    case 1: {
                        c = ((StringBuffer)this.getNhxSource()).charAt(i);
                        break;
                    }
                    case 2: {
                        c = ((char[])this.getNhxSource())[i];
                    }
                }
            }
            if (!in_single_quote && !in_double_quote) {
                if (c == ':') {
                    saw_colon = true;
                } else if (c >= '!' && c <= '~' && saw_colon && c != '[' && c != '.' && (c < '0' || c > '9')) {
                    saw_colon = false;
                }
            }
            if (!(this.isIgnoreQuotes() && (c < '!' || c > '~' || c == '\"' || c == '\'' || this.getCladeLevel() == 0 && c == ';') || !this.isIgnoreQuotes() && (c < ' ' || c > '~' || this.getCladeLevel() == 0 && c == ';') || c == ' ' && !in_single_quote && !in_double_quote)) {
                if (in_comment) {
                    if (c == ']') {
                        in_comment = false;
                    }
                } else if (in_double_quote) {
                    if (c == '\"') {
                        in_double_quote = false;
                    } else {
                        this.getCurrentAnotation().append(c);
                    }
                } else if (c == '\"') {
                    in_double_quote = true;
                } else if (in_single_quote) {
                    if (c == '\'') {
                        in_single_quote = false;
                    } else {
                        this.getCurrentAnotation().append(c);
                    }
                } else if (c == '\'') {
                    in_single_quote = true;
                } else if (c == '[') {
                    saw_open_bracket = true;
                } else if (saw_open_bracket) {
                    if (c != ']') {
                        if (c == '&') {
                            this.getCurrentAnotation().append("[&");
                        } else if (saw_colon) {
                            this.getCurrentAnotation().append("[" + c);
                        } else {
                            in_comment = true;
                        }
                    }
                    saw_open_bracket = false;
                } else if (c == '(') {
                    this.processOpenParen();
                } else if (c == ')') {
                    this.processCloseParen();
                } else if (c == ',') {
                    this.processComma();
                } else {
                    this.getCurrentAnotation().append(c);
                }
            }
            ++i;
        }
        if (this.getCladeLevel() != 0) {
            this.setPhylogenies(null);
            throw new PhylogenyParserException("error in NH (Newick)/NHX formatted data: most likely cause: number of open parens does not equal number of close parens");
        }
        if (this.getCurrentPhylogeny() != null) {
            this.finishPhylogeny();
        } else if (this.getCurrentAnotation().length() > 0) {
            this.finishSingleNodePhylogeny();
        } else if (this.getPhylogenies().size() < 1) {
            this.getPhylogenies().add(new Phylogeny());
        }
        return this.getPhylogeniesAsArray();
    }

    public Phylogeny parseNext() throws IOException, NHXFormatException {
        return null;
    }

    private void processCloseParen() throws PhylogenyParserException, NHXFormatException {
        this.decreaseCladeLevel();
        if (!this.isSawClosingParen()) {
            PhylogenyNode new_node = new PhylogenyNode();
            NHXParser.parseNHX(this.getCurrentAnotation().toString(), new_node, this.getTaxonomyExtraction(), this.isReplaceUnderscores());
            this.newCurrentAnotation();
            this.getCurrentNode().addAsChild(new_node);
        } else {
            NHXParser.parseNHX(this.getCurrentAnotation().toString(), this.getCurrentNode().getLastChildNode(), this.getTaxonomyExtraction(), this.isReplaceUnderscores());
            this.newCurrentAnotation();
        }
        if (!this.getCurrentNode().isRoot()) {
            this.setCurrentNode(this.getCurrentNode().getParent());
        }
        this.setSawClosingParen(true);
    }

    private void processComma() throws PhylogenyParserException, NHXFormatException {
        if (!this.isSawClosingParen()) {
            PhylogenyNode new_node = new PhylogenyNode();
            NHXParser.parseNHX(this.getCurrentAnotation().toString(), new_node, this.getTaxonomyExtraction(), this.isReplaceUnderscores());
            if (this.getCurrentNode() == null) {
                throw new NHXFormatException("format might not be NH or NHX");
            }
            this.getCurrentNode().addAsChild(new_node);
        } else {
            NHXParser.parseNHX(this.getCurrentAnotation().toString(), this.getCurrentNode().getLastChildNode(), this.getTaxonomyExtraction(), this.isReplaceUnderscores());
        }
        this.newCurrentAnotation();
        this.setSawClosingParen(false);
    }

    private void processOpenParen() throws PhylogenyParserException, NHXFormatException {
        PhylogenyNode new_node = new PhylogenyNode();
        if (this.getCladeLevel() == 0) {
            if (this.getCurrentPhylogeny() != null) {
                this.finishPhylogeny();
            }
            this.setCladeLevel(1);
            this.newCurrentAnotation();
            this.setCurrentPhylogeny(new Phylogeny());
            this.getCurrentPhylogeny().setRoot(new_node);
        } else {
            this.increaseCladeLevel();
            this.getCurrentNode().addAsChild(new_node);
        }
        this.setCurrentNode(new_node);
        this.setSawClosingParen(false);
    }

    private void setCladeLevel(int clade_level) {
        if (clade_level < 0) {
            throw new IllegalArgumentException("Attempt to set clade level to a number smaller than zero.");
        }
        this._clade_level = clade_level;
    }

    private void setCurrentAnotation(StringBuilder current_anotation) {
        this._current_anotation = current_anotation;
    }

    private void setCurrentNode(PhylogenyNode current_node) {
        this._current_node = current_node;
    }

    private void setCurrentPhylogeny(Phylogeny current_phylogeny) {
        this._current_phylogeny = current_phylogeny;
    }

    public void setGuessRootedness(boolean guess_rootedness) {
        this._guess_rootedness = guess_rootedness;
    }

    private void setHasNext(boolean has_next) {
        this._has_next = has_next;
    }

    public void setIgnoreQuotes(boolean ignore_quotes) {
        this._ignore_quotes = ignore_quotes;
    }

    private void setInputType(byte input_type) {
        this._input_type = input_type;
    }

    private void setNhxSource(Object nhx_source) {
        this._nhx_source = nhx_source;
    }

    private void setPhylogenies(ArrayList<Phylogeny> phylogenies) {
        this._phylogenies = phylogenies;
    }

    public void setReplaceUnderscores(boolean replace_underscores) {
        this._replace_underscores = replace_underscores;
    }

    private void setSawClosingParen(boolean saw_closing_paren) {
        this._saw_closing_paren = saw_closing_paren;
    }

    @Override
    public void setSource(Object nhx_source) throws PhylogenyParserException, IOException {
        if (nhx_source == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        if (nhx_source instanceof String) {
            this.setInputType((byte)0);
            this.setSourceLength(((String)nhx_source).length());
            this.setNhxSource(nhx_source);
        } else if (nhx_source instanceof StringBuffer) {
            this.setInputType((byte)1);
            this.setSourceLength(((StringBuffer)nhx_source).length());
            this.setNhxSource(nhx_source);
        } else if (nhx_source instanceof char[]) {
            this.setInputType((byte)2);
            this.setSourceLength(((char[])nhx_source).length);
            this.setNhxSource(nhx_source);
        } else if (nhx_source instanceof File) {
            this.setInputType((byte)3);
            this.setSourceLength(0);
            File f = (File)nhx_source;
            String error = ForesterUtil.isReadableFile(f);
            if (!ForesterUtil.isEmpty(error)) {
                throw new PhylogenyParserException(error);
            }
            this.setNhxSource(new BufferedReader(new FileReader(f)));
        } else if (nhx_source instanceof InputStream) {
            this.setInputType((byte)3);
            this.setSourceLength(0);
            InputStreamReader isr = new InputStreamReader((InputStream)nhx_source);
            this.setNhxSource(new BufferedReader(isr));
        } else {
            throw new IllegalArgumentException(this.getClass() + " can only parse objects of type String," + " StringBuffer, char[], File," + " or InputStream " + " [attempt to parse object of " + nhx_source.getClass() + "].");
        }
        this.setHasNext(true);
    }

    private void setSourceLength(int source_length) {
        this._source_length = source_length;
    }

    public void setTaxonomyExtraction(TAXONOMY_EXTRACTION taxonomy_extraction) {
        this._taxonomy_extraction = taxonomy_extraction;
    }

    private static double doubleValue(String str) throws NHXFormatException {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException ex) {
            throw new NHXFormatException("error in NH/NHX formatted data: failed to parse number from :\"" + str + "\"");
        }
    }

    private static String extractTaxonomyCodeFromNHname(String name, boolean limit_to_five, TAXONOMY_EXTRACTION taxonomy_extraction) {
        String[] s;
        if (!(name.indexOf("_") <= 0 || name.length() >= 25 || name.lastIndexOf("_") != name.indexOf("_") || name.indexOf("|") >= 0 || name.indexOf(".") >= 0 || taxonomy_extraction == TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY && name.indexOf("/") < 0 || name.indexOf("/") >= 0 && name.indexOf("/") <= name.indexOf("_") || (s = name.split("[_/]")).length <= 1)) {
            Matcher letters_and_numbers;
            String str = s[1];
            if (limit_to_five) {
                if (str.length() > 5) {
                    str = str.substring(0, 5);
                } else if (str.length() < 5 && (str.startsWith("RAT") || str.startsWith("PIG"))) {
                    str = str.substring(0, 3);
                }
            }
            if (!(letters_and_numbers = UC_LETTERS_NUMBERS_PATTERN.matcher(str)).matches()) {
                return null;
            }
            Matcher numbers_only = NUMBERS_ONLY_PATTERN.matcher(str);
            if (numbers_only.matches()) {
                return null;
            }
            return str;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isBranchLengthsLikeBootstrapValues(Phylogeny p) {
        it = p.iteratorExternalForward();
        d0 = it.next().getDistanceToParent();
        if (!(d0 < 10.0) && it.hasNext()) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            d = it.next().getDistanceToParent();
            if (d == d0 && !(d < 10.0)) continue;
            return false;
lbl8:
            // 2 sources

            ** while (it.hasNext())
        }
lbl9:
        // 1 sources

        return true;
    }

    private static void moveBranchLengthsToBootstrapValues(Phylogeny p) {
        PhylogenyNodeIterator it = p.iteratorPostorder();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            PhylogenyMethods.setBootstrapConfidence(n, n.getDistanceToParent());
            n.setDistanceToParent(-1024.0);
        }
    }

    public static void parseNHX(String s, PhylogenyNode node_to_annotate, TAXONOMY_EXTRACTION taxonomy_extraction, boolean replace_underscores) throws NHXFormatException {
        if (taxonomy_extraction != TAXONOMY_EXTRACTION.NO && replace_underscores) {
            throw new IllegalArgumentException("cannot extract taxonomies and replace under scores at the same time");
        }
        if (s != null && s.length() > 0) {
            if (replace_underscores) {
                s = s.replaceAll("_+", " ");
            }
            int ob = 0;
            int cb = 0;
            String a = "";
            String b = "";
            StringTokenizer t = null;
            boolean is_nhx = false;
            ob = s.indexOf("[");
            cb = s.indexOf("]");
            if (ob > -1) {
                a = "";
                b = "";
                is_nhx = true;
                if (cb < 0) {
                    throw new NHXFormatException("error in NHX formatted data: no closing \"]\"");
                }
                if (s.indexOf("&&NHX") == ob + 1) {
                    b = s.substring(ob + 6, cb);
                } else {
                    String bracketed = s.substring(ob + 1, cb);
                    Matcher numbers_only = NUMBERS_ONLY_PATTERN.matcher(bracketed);
                    if (numbers_only.matches()) {
                        b = ":B=" + bracketed;
                    }
                }
                a = s.substring(0, ob);
                s = String.valueOf(a) + b;
                if (s.indexOf("[") > -1 || s.indexOf("]") > -1) {
                    throw new NHXFormatException("error in NHX formatted data: more than one \"]\" or \"[\"");
                }
            }
            if ((t = new StringTokenizer(s, ":")).countTokens() >= 1) {
                if (!s.startsWith(":")) {
                    String tax;
                    node_to_annotate.setName(t.nextToken());
                    if (!(replace_underscores || is_nhx || taxonomy_extraction == TAXONOMY_EXTRACTION.NO || ForesterUtil.isEmpty(tax = NHXParser.extractTaxonomyCodeFromNHname(node_to_annotate.getNodeName(), true, taxonomy_extraction)))) {
                        if (!node_to_annotate.getNodeData().isHasTaxonomy()) {
                            node_to_annotate.getNodeData().setTaxonomy(new Taxonomy());
                        }
                        node_to_annotate.getNodeData().getTaxonomy().setTaxonomyCode(tax);
                    }
                }
                while (t.hasMoreTokens()) {
                    s = t.nextToken();
                    if (s.startsWith("S=")) {
                        if (!node_to_annotate.getNodeData().isHasTaxonomy()) {
                            node_to_annotate.getNodeData().setTaxonomy(new Taxonomy());
                        }
                        node_to_annotate.getNodeData().getTaxonomy().setScientificName(s.substring(2));
                        continue;
                    }
                    if (s.startsWith("AN=")) {
                        if (!node_to_annotate.getNodeData().isHasSequence()) {
                            node_to_annotate.getNodeData().setSequence(new Sequence());
                        }
                        Annotation annotation = new Annotation();
                        annotation.setDesc(s.substring(3));
                        node_to_annotate.getNodeData().getSequence().addAnnotation(annotation);
                        continue;
                    }
                    if (s.startsWith("D=")) {
                        if (s.charAt(2) == 'Y' || s.charAt(2) == 'T') {
                            node_to_annotate.getNodeData().setEvent(Event.createSingleDuplicationEvent());
                            continue;
                        }
                        if (s.charAt(2) == 'N' || s.charAt(2) == 'F') {
                            node_to_annotate.getNodeData().setEvent(Event.createSingleSpeciationEvent());
                            continue;
                        }
                        if (s.charAt(2) == '?') {
                            node_to_annotate.getNodeData().setEvent(Event.createSingleSpeciationOrDuplicationEvent());
                            continue;
                        }
                        throw new NHXFormatException("error in NHX formatted data: :D=Y or :D=N or :D=?");
                    }
                    if (s.startsWith("B=")) {
                        PhylogenyMethods.setConfidence(node_to_annotate, NHXParser.doubleValue(s.substring(2)));
                        continue;
                    }
                    if (s.startsWith("T=")) {
                        if (!node_to_annotate.getNodeData().isHasTaxonomy()) {
                            node_to_annotate.getNodeData().setTaxonomy(new Taxonomy());
                        }
                        node_to_annotate.getNodeData().getTaxonomy().setIdentifier(new Identifier(s.substring(2)));
                        continue;
                    }
                    if (s.startsWith("W=")) {
                        PhylogenyMethods.setBranchWidthValue(node_to_annotate, Integer.parseInt(s.substring(2)));
                        continue;
                    }
                    if (s.startsWith("C=")) {
                        Color c = NHXParser.stringToColor(s.substring(2));
                        if (c == null) continue;
                        PhylogenyMethods.setBranchColorValue(node_to_annotate, c);
                        continue;
                    }
                    if (s.startsWith("XN=")) {
                        if (!node_to_annotate.getNodeData().isHasProperties()) {
                            node_to_annotate.getNodeData().setProperties(new PropertiesMap());
                        }
                        node_to_annotate.getNodeData().getProperties().addProperty(Property.createFromNhxString(s));
                        continue;
                    }
                    if (s.startsWith("DS=")) {
                        if (!node_to_annotate.getNodeData().isHasSequence()) {
                            node_to_annotate.getNodeData().setSequence(new Sequence());
                        }
                        node_to_annotate.getNodeData().getSequence().setDomainArchitecture(new DomainArchitecture(s.substring(3)));
                        continue;
                    }
                    if (s.startsWith("ID=")) {
                        node_to_annotate.getNodeData().setNodeIdentifier(new Identifier(s.substring(3)));
                        continue;
                    }
                    if (s.startsWith("AC=")) {
                        if (!node_to_annotate.getNodeData().isHasSequence()) {
                            node_to_annotate.getNodeData().setSequence(new Sequence());
                        }
                        node_to_annotate.getNodeData().getSequence().setAccession(new Accession(s.substring(3), "?"));
                        continue;
                    }
                    if (s.startsWith("GN=")) {
                        if (!node_to_annotate.getNodeData().isHasSequence()) {
                            node_to_annotate.getNodeData().setSequence(new Sequence());
                        }
                        node_to_annotate.getNodeData().getSequence().setName(s.substring(3));
                        continue;
                    }
                    if (s.startsWith("G=")) {
                        if (!node_to_annotate.getNodeData().isHasSequence()) {
                            node_to_annotate.getNodeData().setSequence(new Sequence());
                        }
                        node_to_annotate.getNodeData().getSequence().setName(s.substring(2));
                        continue;
                    }
                    if (s.indexOf(61) >= 0) continue;
                    if (node_to_annotate.getDistanceToParent() != -1024.0) {
                        throw new NHXFormatException("error in NHX formatted data: more than one distance to parent:\"" + s + "\"");
                    }
                    node_to_annotate.setDistanceToParent(NHXParser.doubleValue(s));
                }
            }
        }
    }

    private static Color stringToColor(String s) {
        StringTokenizer st = new StringTokenizer(s, ".");
        if (st.countTokens() != 3) {
            throw new IllegalArgumentException("illegal format for color: " + s);
        }
        int red = ForesterUtil.limitRangeForColor(Integer.parseInt(st.nextToken()));
        int green = ForesterUtil.limitRangeForColor(Integer.parseInt(st.nextToken()));
        int blu = ForesterUtil.limitRangeForColor(Integer.parseInt(st.nextToken()));
        return new Color(red, green, blu);
    }

    public static enum TAXONOMY_EXTRACTION {
        NO,
        YES,
        PFAM_STYLE_ONLY;

    }
}

