/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class PhyloXmlUtil {
    public static final Pattern SEQUENCE_SYMBOL_PATTERN = Pattern.compile("\\S{1,20}");
    public static final Pattern TAXOMONY_CODE_PATTERN = Pattern.compile("[a-zA-Z0-9_]{1,10}");
    public static final Pattern LIT_REF_DOI_PATTERN = Pattern.compile("[a-zA-Z0-9_\\.]+\\S+");
    public static final Set<String> SEQUENCE_TYPES = new HashSet<String>();
    public static final Set<String> TAXONOMY_RANKS = new HashSet<String>();
    public static final int ROUNDING_DIGITS_FOR_PHYLOXML_DOUBLE_OUTPUT = 9;

    static {
        SEQUENCE_TYPES.add("rna");
        SEQUENCE_TYPES.add("protein");
        SEQUENCE_TYPES.add("dna");
        TAXONOMY_RANKS.add("domain");
        TAXONOMY_RANKS.add("kingdom");
        TAXONOMY_RANKS.add("subkingdom");
        TAXONOMY_RANKS.add("branch");
        TAXONOMY_RANKS.add("infrakingdom");
        TAXONOMY_RANKS.add("superphylum");
        TAXONOMY_RANKS.add("phylum");
        TAXONOMY_RANKS.add("subphylum");
        TAXONOMY_RANKS.add("infraphylum");
        TAXONOMY_RANKS.add("microphylum");
        TAXONOMY_RANKS.add("superdivision");
        TAXONOMY_RANKS.add("division");
        TAXONOMY_RANKS.add("subdivision");
        TAXONOMY_RANKS.add("infradivision");
        TAXONOMY_RANKS.add("superclass");
        TAXONOMY_RANKS.add("class");
        TAXONOMY_RANKS.add("subclass");
        TAXONOMY_RANKS.add("infraclass");
        TAXONOMY_RANKS.add("superlegion");
        TAXONOMY_RANKS.add("legion");
        TAXONOMY_RANKS.add("sublegion");
        TAXONOMY_RANKS.add("infralegion");
        TAXONOMY_RANKS.add("supercohort");
        TAXONOMY_RANKS.add("cohort");
        TAXONOMY_RANKS.add("subcohort");
        TAXONOMY_RANKS.add("infracohort");
        TAXONOMY_RANKS.add("superorder");
        TAXONOMY_RANKS.add("order");
        TAXONOMY_RANKS.add("suborder");
        TAXONOMY_RANKS.add("superfamily");
        TAXONOMY_RANKS.add("family");
        TAXONOMY_RANKS.add("subfamily");
        TAXONOMY_RANKS.add("supertribe");
        TAXONOMY_RANKS.add("tribe");
        TAXONOMY_RANKS.add("subtribe");
        TAXONOMY_RANKS.add("infratribe");
        TAXONOMY_RANKS.add("genus");
        TAXONOMY_RANKS.add("subgenus");
        TAXONOMY_RANKS.add("superspecies");
        TAXONOMY_RANKS.add("species");
        TAXONOMY_RANKS.add("subspecies");
        TAXONOMY_RANKS.add("variety");
        TAXONOMY_RANKS.add("subvariety");
        TAXONOMY_RANKS.add("form");
        TAXONOMY_RANKS.add("subform");
        TAXONOMY_RANKS.add("cultivar");
        TAXONOMY_RANKS.add("unknown");
        TAXONOMY_RANKS.add("other");
    }
}

