/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.AccessionParser;
import org.forester.io.parsers.phyloxml.phylogenydata.AnnotationParser;
import org.forester.io.parsers.phyloxml.phylogenydata.DomainArchitectureParser;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.phylogenydata.UriParser;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Uri;

public class SequenceParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    static {
        try {
            _instance = new SequenceParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private SequenceParser() {
    }

    @Override
    public Sequence parse(XmlElement element) throws PhylogenyParserException {
        Sequence sequence = new Sequence();
        if (element.isHasAttribute("type")) {
            sequence.setType(element.getAttribute("type"));
        }
        int i = 0;
        while (i < element.getNumberOfChildElements()) {
            XmlElement child_element = element.getChildElement(i);
            if (child_element.getQualifiedName().equals("location")) {
                sequence.setLocation(child_element.getValueAsString());
            } else if (child_element.getQualifiedName().equals("name")) {
                sequence.setName(child_element.getValueAsString());
            } else if (child_element.getQualifiedName().equals("mol_seq")) {
                sequence.setMolecularSequence(child_element.getValueAsString());
            } else if (child_element.getQualifiedName().equals("accession")) {
                sequence.setAccession((Accession)AccessionParser.getInstance().parse(child_element));
            } else if (child_element.getQualifiedName().equals("symbol")) {
                sequence.setSymbol(child_element.getValueAsString());
            } else if (child_element.getQualifiedName().equals("annotation")) {
                sequence.addAnnotation((Annotation)AnnotationParser.getInstance().parse(child_element));
            } else if (child_element.getQualifiedName().equals("domain_architecture")) {
                sequence.setDomainArchitecture((DomainArchitecture)DomainArchitectureParser.getInstance().parse(child_element));
            } else if (child_element.getQualifiedName().equals("uri")) {
                sequence.setUri((Uri)UriParser.getInstance().parse(child_element));
            }
            ++i;
        }
        return sequence;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }
}

