/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.IdentifierParser;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.phylogenydata.UriParser;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.data.Uri;

public class TaxonomyParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    static {
        try {
            _instance = new TaxonomyParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private TaxonomyParser() {
    }

    @Override
    public Taxonomy parse(XmlElement element) throws PhylogenyParserException {
        Taxonomy taxonomy = new Taxonomy();
        int i = 0;
        while (i < element.getNumberOfChildElements()) {
            XmlElement child_element = element.getChildElement(i);
            if (child_element.isHasValue()) {
                if (child_element.getQualifiedName().equals("code")) {
                    taxonomy.setTaxonomyCode(child_element.getValueAsString());
                } else if (child_element.getQualifiedName().equals("common_name")) {
                    taxonomy.setCommonName(child_element.getValueAsString());
                } else if (child_element.getQualifiedName().equals("authority")) {
                    taxonomy.setAuthority(child_element.getValueAsString());
                } else if (child_element.getQualifiedName().equals("synonym")) {
                    taxonomy.getSynonyms().add(child_element.getValueAsString());
                } else if (child_element.getQualifiedName().equals("id")) {
                    taxonomy.setIdentifier((Identifier)IdentifierParser.getInstance().parse(child_element));
                } else if (child_element.getQualifiedName().equals("rank")) {
                    taxonomy.setRank(child_element.getValueAsString());
                } else if (child_element.getQualifiedName().equals("scientific_name")) {
                    taxonomy.setScientificName(child_element.getValueAsString());
                } else if (child_element.getQualifiedName().equals("uri")) {
                    taxonomy.setUri((Uri)UriParser.getInstance().parse(child_element));
                }
            }
            ++i;
        }
        return taxonomy;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }
}

