/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.tol;

import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class TolXmlHandler
extends DefaultHandler {
    private String _current_element_name;
    private Phylogeny _current_phylogeny;
    private List<Phylogeny> _phylogenies;
    private XmlElement _current_xml_element;
    private PhylogenyNode _current_node;
    private static final StringBuffer _buffer = new StringBuffer();

    TolXmlHandler() {
    }

    private void addNode() {
        PhylogenyNode new_node = new PhylogenyNode();
        this.getCurrentNode().addAsChild(new_node);
        this.setCurrentNode(new_node);
    }

    @Override
    public void characters(char[] chars, int start_index, int end_index) {
        if (this.getCurrentXmlElement() != null && this.getCurrentElementName() != null && !this.getCurrentElementName().equals("NODE") && !this.getCurrentElementName().equals("TREE")) {
            this.getCurrentXmlElement().setValue(new String(chars, start_index, end_index).trim());
        }
    }

    @Override
    public void endElement(String namespace_uri, String local_name, String qualified_name) throws SAXException {
        if (ForesterUtil.isEmpty(namespace_uri) || namespace_uri.startsWith("http://www.phyloxml.org")) {
            if (local_name.equals("NODE")) {
                try {
                    TolXmlHandler.mapElementToPhylogenyNode(this.getCurrentXmlElement(), this.getCurrentNode());
                    if (!this.getCurrentNode().isRoot()) {
                        this.setCurrentNode(this.getCurrentNode().getParent());
                    }
                    this.setCurrentXmlElement(this.getCurrentXmlElement().getParent());
                }
                catch (PhylogenyParserException ex) {
                    throw new SAXException(ex.getMessage());
                }
            }
            if (local_name.equals("TREE")) {
                try {
                    TolXmlHandler.mapElementToPhylogeny(this.getCurrentXmlElement(), this.getCurrentPhylogeny());
                }
                catch (PhylogenyParserException ex) {
                    throw new SAXException(ex.getMessage());
                }
                this.finishPhylogeny();
                this.reset();
            } else if (this.getCurrentPhylogeny() != null && this.getCurrentXmlElement().getParent() != null) {
                this.setCurrentXmlElement(this.getCurrentXmlElement().getParent());
            }
            this.setCurrentElementName(null);
        }
    }

    private void finishPhylogeny() throws SAXException {
        this.getCurrentPhylogeny().setRooted(true);
        this.getCurrentPhylogeny().recalculateNumberOfExternalDescendants(false);
        this.getPhylogenies().add(this.getCurrentPhylogeny());
    }

    private String getCurrentElementName() {
        return this._current_element_name;
    }

    private PhylogenyNode getCurrentNode() {
        return this._current_node;
    }

    private Phylogeny getCurrentPhylogeny() {
        return this._current_phylogeny;
    }

    private XmlElement getCurrentXmlElement() {
        return this._current_xml_element;
    }

    List<Phylogeny> getPhylogenies() {
        return this._phylogenies;
    }

    private void init() {
        this.reset();
        this.setPhylogenies(new ArrayList<Phylogeny>());
    }

    private void initCurrentNode() {
        if (this.getCurrentNode() != null) {
            throw new IllegalStateException("attempt to create new current node when current node already exists");
        }
        if (this.getCurrentPhylogeny() == null) {
            throw new IllegalStateException("attempt to create new current node for non-existing phylogeny");
        }
        PhylogenyNode node = new PhylogenyNode();
        this.getCurrentPhylogeny().setRoot(node);
        this.setCurrentNode(this.getCurrentPhylogeny().getRoot());
    }

    private void newClade() {
        if (this.getCurrentNode() == null) {
            this.initCurrentNode();
        } else {
            this.addNode();
        }
    }

    private void newPhylogeny() {
        this.setCurrentPhylogeny(new Phylogeny());
    }

    private void reset() {
        this.setCurrentPhylogeny(null);
        this.setCurrentNode(null);
        this.setCurrentElementName(null);
        this.setCurrentXmlElement(null);
    }

    private void setCurrentElementName(String element_name) {
        this._current_element_name = element_name;
    }

    private void setCurrentNode(PhylogenyNode current_node) {
        this._current_node = current_node;
    }

    private void setCurrentPhylogeny(Phylogeny phylogeny) {
        this._current_phylogeny = phylogeny;
    }

    private void setCurrentXmlElement(XmlElement element) {
        this._current_xml_element = element;
    }

    private void setPhylogenies(List<Phylogeny> phylogenies) {
        this._phylogenies = phylogenies;
    }

    @Override
    public void startDocument() throws SAXException {
        this.init();
    }

    @Override
    public void startElement(String namespace_uri, String local_name, String qualified_name, Attributes attributes) throws SAXException {
        this.setCurrentElementName(local_name);
        if (local_name.equals("NODE")) {
            XmlElement element = new XmlElement(namespace_uri, local_name, local_name, attributes);
            this.getCurrentXmlElement().addChildElement(element);
            this.setCurrentXmlElement(element);
            this.newClade();
        } else if (local_name.equals("TREE")) {
            this.setCurrentXmlElement(new XmlElement("", "", "", null));
            this.newPhylogeny();
        } else if (this.getCurrentPhylogeny() != null) {
            XmlElement element = new XmlElement(namespace_uri, local_name, local_name, attributes);
            this.getCurrentXmlElement().addChildElement(element);
            this.setCurrentXmlElement(element);
        }
    }

    public static boolean attributeEqualsValue(XmlElement element, String attributeName, String attributeValue) {
        String attr = element.getAttribute(attributeName);
        return attr != null && attr.equals(attributeValue);
    }

    public static String getAtttributeValue(XmlElement element, String attributeName) {
        String attr = element.getAttribute(attributeName);
        if (attr != null) {
            return attr;
        }
        return "";
    }

    private static void mapElementToPhylogeny(XmlElement xml_element, Phylogeny phylogeny) throws PhylogenyParserException {
    }

    private static void mapElementToPhylogenyNode(XmlElement xml_element, PhylogenyNode node) throws PhylogenyParserException {
        String ital;
        String id;
        if (xml_element.isHasAttribute("ID") && !ForesterUtil.isEmpty(id = xml_element.getAttribute("ID"))) {
            if (!node.getNodeData().isHasTaxonomy()) {
                node.getNodeData().setTaxonomy(new Taxonomy());
            }
            node.getNodeData().getTaxonomy().setIdentifier(new Identifier(id, "tol"));
        }
        boolean put_into_scientific_name = false;
        if (xml_element.isHasAttribute("ITALICIZENAME") && !ForesterUtil.isEmpty(ital = xml_element.getAttribute("ITALICIZENAME")) && ital.equals("1")) {
            put_into_scientific_name = true;
        }
        int i = 0;
        while (i < xml_element.getNumberOfChildElements()) {
            XmlElement element = xml_element.getChildElement(i);
            String qualified_name = element.getQualifiedName();
            if (qualified_name.equals("NAME")) {
                String name = element.getValueAsString();
                if (!ForesterUtil.isEmpty(name)) {
                    if (!node.getNodeData().isHasTaxonomy()) {
                        node.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    if (put_into_scientific_name) {
                        node.getNodeData().getTaxonomy().setScientificName(name);
                    } else {
                        node.getNodeData().getTaxonomy().setCommonName(name);
                    }
                }
            } else if (qualified_name.equals("AUTHORITY")) {
                String auth = element.getValueAsString();
                if (!ForesterUtil.isEmpty(auth) && !auth.equalsIgnoreCase("null")) {
                    if (!node.getNodeData().isHasTaxonomy()) {
                        node.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    auth = auth.replaceAll("&amp;", "&");
                    node.getNodeData().getTaxonomy().setAuthority(auth);
                }
            } else if (qualified_name.equals("AUTHDATE")) {
                String authdate = element.getValueAsString();
                if (!ForesterUtil.isEmpty(authdate) && !authdate.equalsIgnoreCase("null") && node.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getAuthority())) {
                    _buffer.setLength(0);
                    _buffer.append(node.getNodeData().getTaxonomy().getAuthority());
                    _buffer.append(" ");
                    _buffer.append(authdate);
                    node.getNodeData().getTaxonomy().setAuthority(_buffer.toString());
                }
            } else if (qualified_name.equals("OTHERNAMES")) {
                int j = 0;
                while (j < element.getNumberOfChildElements()) {
                    XmlElement element_j = element.getChildElement(j);
                    if (element_j.getQualifiedName().equals("OTHERNAME")) {
                        int z = 0;
                        while (z < element_j.getNumberOfChildElements()) {
                            String syn;
                            XmlElement element_z = element_j.getChildElement(z);
                            if (element_z.getQualifiedName().equals("NAME") && !ForesterUtil.isEmpty(syn = element_z.getValueAsString()) && !syn.equalsIgnoreCase("null")) {
                                if (!node.getNodeData().isHasTaxonomy()) {
                                    node.getNodeData().setTaxonomy(new Taxonomy());
                                }
                                node.getNodeData().getTaxonomy().getSynonyms().add(syn);
                            }
                            ++z;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

