/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import org.forester.pccx.Coverage;
import org.forester.pccx.CoverageCalculationOptions;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class ExternalNodeBasedCoverage
implements Coverage {
    private final double _av_normalized_score;
    private final double _av_raw_score;
    private final int _n;
    private final double _sd;
    private final double _max;
    private final double _min;

    public ExternalNodeBasedCoverage(DescriptiveStatistics stats, double average_raw_score, CoverageCalculationOptions options) {
        this._av_normalized_score = stats.arithmeticMean();
        this._av_raw_score = average_raw_score;
        this._n = stats.getN();
        this._sd = this._n > 1 ? stats.sampleStandardDeviation() : 0.0;
        this._max = stats.getMax();
        this._min = stats.getMin();
    }

    @Override
    public String asString() {
        StringBuffer sb = new StringBuffer();
        if (this.getN() == 1) {
            sb.append("Normalized score: " + this.getScore() + ForesterUtil.getLineSeparator());
            sb.append("Raw score       : " + this.getAvarageRawScore());
        } else {
            sb.append("Avarage normalized score: " + this.getScore() + " [sd=" + this.getSD() + " min=" + this.getMin() + " max=" + this.getMax() + " n=" + this.getN() + "]" + ForesterUtil.getLineSeparator());
            sb.append("Avarage raw score       : " + this.getAvarageRawScore());
        }
        return sb.toString();
    }

    public double getAvarageNormalizedScore() {
        return this._av_normalized_score;
    }

    public double getAvarageRawScore() {
        return this._av_raw_score;
    }

    public double getMax() {
        return this._max;
    }

    public double getMin() {
        return this._min;
    }

    public int getN() {
        return this._n;
    }

    @Override
    public double getScore() {
        return this.getAvarageNormalizedScore();
    }

    public double getSD() {
        return this._sd;
    }
}

