/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import org.forester.phylogeny.Edge;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.PhylogenyData;

public class PhylogenyBranch
implements Edge {
    private final PhylogenyNode _node_1;
    private final PhylogenyNode _node_2;
    private PhylogenyData _data;
    private final boolean _is_directed;
    private boolean _towards_1;

    public PhylogenyBranch(PhylogenyNode first_node, PhylogenyNode second_node) {
        if (first_node == null || second_node == null) {
            throw new IllegalArgumentException("Attempt to create a branch with a null node");
        }
        this._node_1 = first_node;
        this._node_2 = second_node;
        this._is_directed = false;
    }

    public PhylogenyBranch(PhylogenyNode first_node, PhylogenyNode second_node, boolean direction_towards_first) {
        if (first_node == null || second_node == null) {
            throw new IllegalArgumentException("Attempt to create a branch with a null node");
        }
        this._node_1 = first_node;
        this._node_2 = second_node;
        this._is_directed = true;
        this._towards_1 = direction_towards_first;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhylogenyBranch other = (PhylogenyBranch)obj;
        return this.hashCode() == other.hashCode();
    }

    public PhylogenyNode getConnectedNode(PhylogenyNode node) throws IllegalArgumentException {
        if (node == this._node_1) {
            return this._node_2;
        }
        if (node == this._node_2) {
            return this._node_1;
        }
        throw new IllegalArgumentException("Attempt to get connected node on branch with node which is not connected by the branch");
    }

    @Override
    public PhylogenyData getData() {
        return this._data;
    }

    @Override
    public PhylogenyNode getFirstNode() {
        return this._node_1;
    }

    @Override
    public PhylogenyNode getSecondNode() {
        return this._node_2;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        int node_1_hc = this._node_1.hashCode();
        int node_2_hc = this._node_2.hashCode();
        int hc_1 = 0;
        int hc_2 = 0;
        if (!this._is_directed) {
            if (node_1_hc > node_2_hc) {
                hc_1 = node_2_hc;
                hc_2 = node_1_hc;
            } else {
                hc_1 = node_1_hc;
                hc_2 = node_2_hc;
            }
        } else if (this._towards_1) {
            hc_1 = node_2_hc;
            hc_2 = node_1_hc;
        } else {
            hc_1 = node_1_hc;
            hc_2 = node_2_hc;
        }
        result = 31 * result + (this._data == null ? 0 : this._data.hashCode());
        result = 31 * result + (this._is_directed ? 1231 : 1237);
        result = 31 * result + hc_1;
        result = 31 * result + hc_2;
        return result;
    }

    public boolean isDirected() {
        return this._is_directed;
    }

    public boolean isDirectionTowards(PhylogenyNode node) throws IllegalStateException {
        if (!this.isDirected()) {
            throw new IllegalStateException("Attempt to get direction of undirected branch");
        }
        return node == this._node_1 && this._towards_1;
    }

    public void setDirectionTowards(PhylogenyNode node) {
        this._towards_1 = node == this._node_1;
    }

    public String toString() {
        if (this.isDirected()) {
            if (this.isDirectionTowards(this.getFirstNode())) {
                return String.valueOf(this.getSecondNode().getNodeName()) + " -> " + this.getFirstNode().getNodeName();
            }
            return String.valueOf(this.getFirstNode().getNodeName()) + " -> " + this.getSecondNode().getNodeName();
        }
        return String.valueOf(this.getFirstNode().getNodeName()) + " -- " + this.getSecondNode().getNodeName();
    }
}

