/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public class PhylogenyMethods {
    private static PhylogenyMethods _instance = null;
    private final Set<PhylogenyNode> _temp_hash_set = new HashSet<PhylogenyNode>();
    private PhylogenyNode _farthest_1 = null;
    private PhylogenyNode _farthest_2 = null;

    private PhylogenyMethods() {
    }

    public double calculateDistance(PhylogenyNode node1, PhylogenyNode node2) {
        PhylogenyNode lca = this.getLCA(node1, node2);
        PhylogenyNode n1 = node1;
        PhylogenyNode n2 = node2;
        return PhylogenyMethods.getDistance(n1, lca) + PhylogenyMethods.getDistance(n2, lca);
    }

    public double calculateFurthestDistance(Phylogeny phylogeny) {
        this._farthest_1 = null;
        this._farthest_2 = null;
        if (phylogeny.getNumberOfExternalNodes() < 2) {
            return 0.0;
        }
        PhylogenyNode node_1 = null;
        PhylogenyNode node_2 = null;
        double farthest_d = -1.7976931348623157E308;
        PhylogenyMethods methods = PhylogenyMethods.getInstance();
        List<PhylogenyNode> ext_nodes = phylogeny.getRoot().getAllExternalDescendants();
        int i = 1;
        while (i < ext_nodes.size()) {
            int j = 0;
            while (j < i) {
                double d = methods.calculateDistance(ext_nodes.get(i), ext_nodes.get(j));
                if (d > farthest_d) {
                    farthest_d = d;
                    node_1 = ext_nodes.get(i);
                    node_2 = ext_nodes.get(j);
                }
                ++j;
            }
            ++i;
        }
        this._farthest_1 = node_1;
        this._farthest_2 = node_2;
        return farthest_d;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public PhylogenyNode getFarthestNode1() {
        return this._farthest_1;
    }

    public PhylogenyNode getFarthestNode2() {
        return this._farthest_2;
    }

    public PhylogenyNode getLCA(PhylogenyNode node1, PhylogenyNode node2) {
        this._temp_hash_set.clear();
        boolean done_with_1 = false;
        boolean done_with_2 = false;
        PhylogenyNode n1 = node1;
        PhylogenyNode n2 = node2;
        while (!done_with_1 || !done_with_2) {
            if (n1 == n2) {
                return n1;
            }
            if (!done_with_1) {
                this._temp_hash_set.add(n1);
            }
            if (!done_with_2) {
                this._temp_hash_set.add(n2);
            }
            if (!done_with_1) {
                if (!n1.isRoot()) {
                    if (this._temp_hash_set.contains(n1 = n1.getParent())) {
                        return n1;
                    }
                } else {
                    done_with_1 = true;
                }
            }
            if (done_with_2) continue;
            if (!n2.isRoot()) {
                if (!this._temp_hash_set.contains(n2 = n2.getParent())) continue;
                return n2;
            }
            done_with_2 = true;
        }
        throw new IllegalArgumentException("attempt to get LCA of two nodes which do not share a common root");
    }

    public List<PhylogenyNode> getOrthologousNodes(Phylogeny phy, PhylogenyNode node) {
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode temp_node = it.next();
            if (temp_node == node || !this.isAreOrthologous(node, temp_node)) continue;
            nodes.add(temp_node);
        }
        return nodes;
    }

    public boolean isAreOrthologous(PhylogenyNode node1, PhylogenyNode node2) {
        return !this.getLCA(node1, node2).isDuplication();
    }

    static double addPhylogenyDistances(double a, double b) {
        if (a >= 0.0 && b >= 0.0) {
            return a + b;
        }
        if (a >= 0.0) {
            return a;
        }
        if (b >= 0.0) {
            return b;
        }
        return -1024.0;
    }

    public static boolean areAllChildrenDuplications(PhylogenyNode n) {
        if (n.isExternal()) {
            return false;
        }
        if (n.isDuplication()) {
            for (PhylogenyNode desc : n.getDescendants()) {
                if (PhylogenyMethods.areAllChildrenDuplications(desc)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int calculateDepth(PhylogenyNode node) {
        PhylogenyNode n = node;
        int steps = 0;
        while (!n.isRoot()) {
            ++steps;
            n = n.getParent();
        }
        return steps;
    }

    public static double calculateDistanceToRoot(PhylogenyNode node) {
        PhylogenyNode n = node;
        double d = 0.0;
        while (!n.isRoot()) {
            if (n.getDistanceToParent() > 0.0) {
                d += n.getDistanceToParent();
            }
            n = n.getParent();
        }
        return d;
    }

    public static short calculateMaxBranchesToLeaf(PhylogenyNode node) {
        if (node.isExternal()) {
            return 0;
        }
        short max = 0;
        for (PhylogenyNode d : node.getAllExternalDescendants()) {
            short steps = 0;
            while (d != node) {
                steps = d.isCollapse() ? (short)0 : (short)(steps + 1);
                d = d.getParent();
            }
            if (max >= steps) continue;
            max = steps;
        }
        return max;
    }

    public static int calculateMaxDepth(Phylogeny phy) {
        int max = 0;
        PhylogenyNodeIterator iter = phy.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            int steps = PhylogenyMethods.calculateDepth(node);
            if (steps <= max) continue;
            max = steps;
        }
        return max;
    }

    public static double calculateMaxDistanceToRoot(Phylogeny phy) {
        double max = 0.0;
        PhylogenyNodeIterator iter = phy.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            double d = PhylogenyMethods.calculateDistanceToRoot(node);
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public static int calculateMaximumNumberOfDescendantsPerNode(Phylogeny phy) {
        int max = 0;
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            if (node.getNumberOfDescendants() <= max) continue;
            max = node.getNumberOfDescendants();
        }
        return max;
    }

    public static int calculateSumOfDistinctTaxonomies(PhylogenyNode node) {
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        HashSet<Taxonomy> tax_set = new HashSet<Taxonomy>();
        for (PhylogenyNode n : descs) {
            if (!n.getNodeData().isHasTaxonomy() || n.getNodeData().getTaxonomy().isEmpty()) {
                return 0;
            }
            tax_set.add(n.getNodeData().getTaxonomy());
        }
        return tax_set.size();
    }

    static PhylogenyNode copySubTree(PhylogenyNode source) {
        if (source == null) {
            return null;
        }
        PhylogenyNode newnode = source.copyNodeData();
        if (!source.isExternal()) {
            int i = 0;
            while (i < source.getNumberOfDescendants()) {
                newnode.setChildNode(i, PhylogenyMethods.copySubTree(source.getChildNode(i)));
                ++i;
            }
        }
        return newnode;
    }

    public static void deleteExternalNodesNegativeSelection(Set<Integer> to_delete, Phylogeny phy) {
        phy.hashIDs();
        for (Integer id : to_delete) {
            phy.deleteSubtree(phy.getNode(id), true);
        }
        phy.hashIDs();
    }

    public static void deleteExternalNodesNegativeSelection(String[] node_names_to_delete, Phylogeny p) throws IllegalArgumentException {
        int i = 0;
        while (i < node_names_to_delete.length) {
            if (!ForesterUtil.isEmpty(node_names_to_delete[i])) {
                List<PhylogenyNode> nodes = null;
                nodes = p.getNodes(node_names_to_delete[i]);
                for (PhylogenyNode n : nodes) {
                    if (!n.isExternal()) {
                        throw new IllegalArgumentException("attempt to delete non-external node \"" + node_names_to_delete[i] + "\"");
                    }
                    p.deleteSubtree(n, true);
                }
            }
            ++i;
        }
    }

    public static void deleteExternalNodesPositiveSelection(Set<Taxonomy> species_to_keep, Phylogeny phy) {
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.getNodeData().isHasTaxonomy()) {
                if (species_to_keep.contains(n.getNodeData().getTaxonomy())) continue;
                phy.deleteSubtree(n, true);
                continue;
            }
            throw new IllegalArgumentException("node " + n.getNodeId() + " has no taxonomic data");
        }
        phy.hashIDs();
        phy.externalNodesHaveChanged();
    }

    public static void deleteExternalNodesPositiveSelection(String[] node_names_to_keep, Phylogeny p) {
        PhylogenyNodeIterator it = p.iteratorExternalForward();
        String[] to_delete = new String[p.getNumberOfExternalNodes()];
        int i = 0;
        Arrays.sort(node_names_to_keep);
        while (it.hasNext()) {
            String curent_name = it.next().getNodeName();
            if (Arrays.binarySearch(node_names_to_keep, curent_name) >= 0) continue;
            to_delete[i++] = curent_name;
        }
        PhylogenyMethods.deleteExternalNodesNegativeSelection(to_delete, p);
    }

    public static Set<PhylogenyNode> getAllDescendants(PhylogenyNode node) {
        HashSet<PhylogenyNode> descs = new HashSet<PhylogenyNode>();
        if (!node.isExternal()) {
            List<PhylogenyNode> exts = node.getAllExternalDescendants();
            for (PhylogenyNode current : exts) {
                descs.add(current);
                while (current != node) {
                    if (descs.contains(current = current.getParent())) continue;
                    descs.add(current);
                }
            }
        }
        return descs;
    }

    public static Color getBranchColorValue(PhylogenyNode node) {
        if (node.getBranchData().getBranchColor() == null) {
            return null;
        }
        return node.getBranchData().getBranchColor().getValue();
    }

    public static double getBranchWidthValue(PhylogenyNode node) {
        if (!node.getBranchData().isHasBranchWidth()) {
            return 1.0;
        }
        return node.getBranchData().getBranchWidth().getValue();
    }

    public static double getConfidenceValue(PhylogenyNode node) {
        if (!node.getBranchData().isHasConfidences()) {
            return -9999.0;
        }
        return node.getBranchData().getConfidence(0).getValue();
    }

    public static double[] getConfidenceValuesAsArray(PhylogenyNode node) {
        if (!node.getBranchData().isHasConfidences()) {
            return new double[0];
        }
        double[] values = new double[node.getBranchData().getConfidences().size()];
        int i = 0;
        for (Confidence c : node.getBranchData().getConfidences()) {
            values[i++] = c.getValue();
        }
        return values;
    }

    private static double getDistance(PhylogenyNode n1, PhylogenyNode n2) {
        double d = 0.0;
        while (n1 != n2) {
            if (n1.getDistanceToParent() > 0.0) {
                d += n1.getDistanceToParent();
            }
            n1 = n1.getParent();
        }
        return d;
    }

    public static Taxonomy getExternalDescendantsTaxonomy(PhylogenyNode node) {
        List<PhylogenyNode> descs = node.getAllExternalDescendants();
        Taxonomy tax = null;
        for (PhylogenyNode n : descs) {
            if (!n.getNodeData().isHasTaxonomy() || n.getNodeData().getTaxonomy().isEmpty()) {
                return null;
            }
            if (tax == null) {
                tax = n.getNodeData().getTaxonomy();
                continue;
            }
            if (!n.getNodeData().getTaxonomy().isEmpty() && tax.isEqual(n.getNodeData().getTaxonomy())) continue;
            return null;
        }
        return tax;
    }

    public static PhylogenyNode getFurthestDescendant(PhylogenyNode node) {
        List<PhylogenyNode> children = node.getAllExternalDescendants();
        PhylogenyNode farthest = null;
        double longest = -1.7976931348623157E308;
        for (PhylogenyNode child : children) {
            if (!(PhylogenyMethods.getDistance(child, node) > longest)) continue;
            farthest = child;
            longest = PhylogenyMethods.getDistance(child, node);
        }
        return farthest;
    }

    public static PhylogenyMethods getInstance() {
        if (_instance == null) {
            _instance = new PhylogenyMethods();
        }
        return _instance;
    }

    public static double getMaximumConfidenceValue(Phylogeny phy) {
        double max = -1.7976931348623157E308;
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            double s = PhylogenyMethods.getConfidenceValue(iter.next());
            if (s == -9999.0 || !(s > max)) continue;
            max = s;
        }
        return max;
    }

    public static String getSpecies(PhylogenyNode node) {
        if (!node.getNodeData().isHasTaxonomy()) {
            return "";
        }
        if (!ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getTaxonomyCode())) {
            return node.getNodeData().getTaxonomy().getTaxonomyCode();
        }
        if (!ForesterUtil.isEmpty(node.getNodeData().getTaxonomy().getScientificName())) {
            return node.getNodeData().getTaxonomy().getScientificName();
        }
        return node.getNodeData().getTaxonomy().getCommonName();
    }

    /*
     * Unable to fully structure code
     */
    public static List<PhylogenyNode> getSuperOrthologousNodes(PhylogenyNode n) {
        node = n;
        deepest = null;
        v = new ArrayList<PhylogenyNode>();
        if (node.isExternal()) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParent();
lbl7:
            // 2 sources

            ** while (!node.isRoot() && !node.getParent().isDuplication())
        }
lbl8:
        // 1 sources

        deepest = node;
        deepest.setIndicatorsToZero();
        do {
            if (!node.isExternal()) {
                if (node.getIndicator() == 0) {
                    node.setIndicator((byte)1);
                    if (!node.isDuplication()) {
                        node = node.getChildNode1();
                    }
                }
                if (node.getIndicator() == 1) {
                    node.setIndicator((byte)2);
                    if (!node.isDuplication()) {
                        node = node.getChildNode2();
                    }
                }
                if (node == deepest || node.getIndicator() != 2) continue;
                node = node.getParent();
                continue;
            }
            if (node != n) {
                v.add(node);
            }
            if (node != deepest) {
                node = node.getParent();
                continue;
            }
            node.setIndicator((byte)2);
        } while (node != deepest || deepest.getIndicator() != 2);
        return v;
    }

    public static String getTaxonomyIdentifier(PhylogenyNode node) {
        if (!node.getNodeData().isHasTaxonomy() || node.getNodeData().getTaxonomy().getIdentifier() == null) {
            return "";
        }
        return node.getNodeData().getTaxonomy().getIdentifier().getValue();
    }

    /*
     * Unable to fully structure code
     */
    public static List<PhylogenyNode> getUltraParalogousNodes(PhylogenyNode n) {
        node = n;
        if (node.isExternal()) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParent();
lbl5:
            // 2 sources

            ** while (!node.isRoot() && node.getParent().isDuplication() && PhylogenyMethods.areAllChildrenDuplications((PhylogenyNode)node.getParent()))
        }
lbl6:
        // 1 sources

        nodes = node.getAllExternalDescendants();
        nodes.remove(n);
        return nodes;
    }

    public static String inferCommonPartOfScientificNameOfDescendants(PhylogenyNode node) {
        List<PhylogenyNode> descs = node.getDescendants();
        String sn = null;
        for (PhylogenyNode n : descs) {
            if (!n.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(n.getNodeData().getTaxonomy().getScientificName())) {
                return null;
            }
            if (sn == null) {
                sn = n.getNodeData().getTaxonomy().getScientificName().trim();
                continue;
            }
            String sn_current = n.getNodeData().getTaxonomy().getScientificName().trim();
            if (sn.equals(sn_current)) continue;
            boolean overlap = false;
            while (sn.indexOf(32) >= 0 || sn_current.indexOf(32) >= 0) {
                if (ForesterUtil.countChars(sn, ' ') > ForesterUtil.countChars(sn_current, ' ')) {
                    sn = sn.substring(0, sn.lastIndexOf(32)).trim();
                } else {
                    sn_current = sn_current.substring(0, sn_current.lastIndexOf(32)).trim();
                }
                if (!sn.equals(sn_current)) continue;
                overlap = true;
                break;
            }
            if (overlap) continue;
            return null;
        }
        return sn;
    }

    public static boolean isHasExternalDescendant(PhylogenyNode node) {
        int i = 0;
        while (i < node.getNumberOfDescendants()) {
            if (node.getChildNode(i).isExternal()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean match(String s, String query, boolean case_sensitive, boolean partial) {
        if (ForesterUtil.isEmpty(s) || ForesterUtil.isEmpty(query)) {
            return false;
        }
        String my_s = s.trim();
        String my_query = query.trim();
        if (!case_sensitive) {
            my_s = my_s.toLowerCase();
            my_query = my_query.toLowerCase();
        }
        if (partial) {
            return my_s.indexOf(my_query) >= 0;
        }
        return my_s.equals(my_query);
    }

    public static void midpointRoot(Phylogeny phylogeny) {
        if (phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        PhylogenyMethods methods = PhylogenyMethods.getInstance();
        double farthest_d = methods.calculateFurthestDistance(phylogeny);
        PhylogenyNode f1 = methods.getFarthestNode1();
        PhylogenyNode f2 = methods.getFarthestNode2();
        if (farthest_d <= 0.0) {
            return;
        }
        double x = farthest_d / 2.0;
        PhylogenyNode n = f1;
        if (PhylogenyMethods.getDistance(f1, phylogeny.getRoot()) < PhylogenyMethods.getDistance(f2, phylogeny.getRoot())) {
            n = f2;
        }
        while (x > n.getDistanceToParent()) {
            x -= n.getDistanceToParent();
            n = n.getParent();
        }
        phylogeny.reRoot(n, x);
        phylogeny.recalculateNumberOfExternalDescendants(true);
        PhylogenyNode a = PhylogenyMethods.getFurthestDescendant(phylogeny.getRoot().getChildNode1());
        PhylogenyNode b = PhylogenyMethods.getFurthestDescendant(phylogeny.getRoot().getChildNode2());
        double da = PhylogenyMethods.getDistance(a, phylogeny.getRoot());
        double db = PhylogenyMethods.getDistance(b, phylogeny.getRoot());
        if (Math.abs(da - db) > 1.0E-6) {
            throw new IllegalStateException(" THIS SHOULD NOT HAVE HAPPENED \n midpoint rooting failed:  da=" + da + ",  db=" + db + ",  diff=" + Math.abs(da - db));
        }
    }

    public static void normalizeBootstrapValues(Phylogeny phylogeny, double max_bootstrap_value, double max_normalized_value) {
        PhylogenyNodeIterator iter = phylogeny.iteratorPreorder();
        while (iter.hasNext()) {
            double confidence;
            PhylogenyNode node = iter.next();
            if (!node.isInternal() || (confidence = PhylogenyMethods.getConfidenceValue(node)) == -9999.0) continue;
            if (confidence >= max_bootstrap_value) {
                PhylogenyMethods.setBootstrapConfidence(node, max_normalized_value);
                continue;
            }
            PhylogenyMethods.setBootstrapConfidence(node, confidence * max_normalized_value / max_bootstrap_value);
        }
    }

    public static Set<PhylogenyNode> obtainAllNodesAsSet(Phylogeny phy) {
        HashSet<PhylogenyNode> nodes = new HashSet<PhylogenyNode>();
        if (phy.isEmpty()) {
            return nodes;
        }
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            nodes.add(iter.next());
        }
        return nodes;
    }

    public static void postorderBranchColorAveragingExternalNodeBased(Phylogeny p) {
        PhylogenyNodeIterator iter = p.iteratorPostorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            double red = 0.0;
            double green = 0.0;
            double blue = 0.0;
            int n = 0;
            if (!node.isInternal()) continue;
            PhylogenyNodeIterator iterator = node.iterateChildNodesForward();
            while (iterator.hasNext()) {
                PhylogenyNode child_node = iterator.next();
                Color child_color = PhylogenyMethods.getBranchColorValue(child_node);
                if (child_color == null) continue;
                ++n;
                red += (double)child_color.getRed();
                green += (double)child_color.getGreen();
                blue += (double)child_color.getBlue();
            }
            PhylogenyMethods.setBranchColorValue(node, new Color(ForesterUtil.roundToInt(red / (double)n), ForesterUtil.roundToInt(green / (double)n), ForesterUtil.roundToInt(blue / (double)n)));
        }
    }

    public static void removeNode(PhylogenyNode remove_me, Phylogeny phylogeny) {
        if (remove_me.isRoot()) {
            throw new IllegalArgumentException("ill advised attempt to remove root node");
        }
        if (remove_me.isExternal()) {
            phylogeny.deleteSubtree(remove_me, false);
        } else {
            PhylogenyNode parent = remove_me.getParent();
            List<PhylogenyNode> descs = remove_me.getDescendants();
            parent.removeChildNode(remove_me);
            for (PhylogenyNode desc : descs) {
                parent.addAsChild(desc);
                desc.setDistanceToParent(PhylogenyMethods.addPhylogenyDistances(remove_me.getDistanceToParent(), desc.getDistanceToParent()));
            }
            remove_me.setParent(null);
            phylogeny.setIdHash(null);
            phylogeny.externalNodesHaveChanged();
        }
    }

    public static Set<PhylogenyNode> searchData(String query, Phylogeny phy, boolean case_sensitive, boolean partial) {
        HashSet<PhylogenyNode> nodes = new HashSet<PhylogenyNode>();
        if (phy.isEmpty() || query == null) {
            return nodes;
        }
        if (ForesterUtil.isEmpty(query)) {
            return nodes;
        }
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            boolean match = false;
            if (PhylogenyMethods.match(node.getNodeName(), query, case_sensitive, partial)) {
                match = true;
            } else if (node.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getTaxonomyCode(), query, case_sensitive, partial)) {
                match = true;
            } else if (node.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getCommonName(), query, case_sensitive, partial)) {
                match = true;
            } else if (node.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getScientificName(), query, case_sensitive, partial)) {
                match = true;
            } else if (node.getNodeData().isHasTaxonomy() && node.getNodeData().getTaxonomy().getIdentifier() != null && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getIdentifier().getValue(), query, case_sensitive, partial)) {
                match = true;
            } else if (node.getNodeData().isHasSequence() && PhylogenyMethods.match(node.getNodeData().getSequence().getName(), query, case_sensitive, partial)) {
                match = true;
            } else if (node.getNodeData().isHasSequence() && PhylogenyMethods.match(node.getNodeData().getSequence().getSymbol(), query, case_sensitive, partial)) {
                match = true;
            } else if (node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getAccession() != null && PhylogenyMethods.match(node.getNodeData().getSequence().getAccession().getValue(), query, case_sensitive, partial)) {
                match = true;
            } else if (node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getDomainArchitecture() != null) {
                DomainArchitecture da = node.getNodeData().getSequence().getDomainArchitecture();
                int i = 0;
                while (i < da.getNumberOfDomains()) {
                    if (PhylogenyMethods.match(da.getDomain(i).getName(), query, case_sensitive, partial)) {
                        match = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!match) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static Set<PhylogenyNode> searchDataLogicalAnd(String[] queries, Phylogeny phy, boolean case_sensitive, boolean partial) {
        HashSet<PhylogenyNode> nodes = new HashSet<PhylogenyNode>();
        if (phy.isEmpty() || queries == null || queries.length < 1) {
            return nodes;
        }
        PhylogenyNodeIterator iter = phy.iteratorPreorder();
        while (iter.hasNext()) {
            PhylogenyNode node = iter.next();
            boolean all_matched = true;
            String[] stringArray = queries;
            int n = queries.length;
            int n2 = 0;
            while (n2 < n) {
                String query = stringArray[n2];
                boolean match = false;
                if (!ForesterUtil.isEmpty(query)) {
                    if (PhylogenyMethods.match(node.getNodeName(), query, case_sensitive, partial)) {
                        match = true;
                    } else if (node.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getTaxonomyCode(), query, case_sensitive, partial)) {
                        match = true;
                    } else if (node.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getCommonName(), query, case_sensitive, partial)) {
                        match = true;
                    } else if (node.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getScientificName(), query, case_sensitive, partial)) {
                        match = true;
                    } else if (node.getNodeData().isHasTaxonomy() && node.getNodeData().getTaxonomy().getIdentifier() != null && PhylogenyMethods.match(node.getNodeData().getTaxonomy().getIdentifier().getValue(), query, case_sensitive, partial)) {
                        match = true;
                    } else if (node.getNodeData().isHasSequence() && PhylogenyMethods.match(node.getNodeData().getSequence().getName(), query, case_sensitive, partial)) {
                        match = true;
                    } else if (node.getNodeData().isHasSequence() && PhylogenyMethods.match(node.getNodeData().getSequence().getSymbol(), query, case_sensitive, partial)) {
                        match = true;
                    } else if (node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getAccession() != null && PhylogenyMethods.match(node.getNodeData().getSequence().getAccession().getValue(), query, case_sensitive, partial)) {
                        match = true;
                    } else if (node.getNodeData().isHasSequence() && node.getNodeData().getSequence().getDomainArchitecture() != null) {
                        DomainArchitecture da = node.getNodeData().getSequence().getDomainArchitecture();
                        int i = 0;
                        while (i < da.getNumberOfDomains()) {
                            if (PhylogenyMethods.match(da.getDomain(i).getName(), query, case_sensitive, partial)) {
                                match = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (!match) {
                        all_matched = false;
                        break;
                    }
                }
                ++n2;
            }
            if (!all_matched) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public static void setBootstrapConfidence(PhylogenyNode node, double bootstrap_confidence_value) {
        PhylogenyMethods.setConfidence(node, bootstrap_confidence_value, "bootstrap");
    }

    public static void setBranchColorValue(PhylogenyNode node, Color color) {
        if (node.getBranchData().getBranchColor() == null) {
            node.getBranchData().setBranchColor(new BranchColor());
        }
        node.getBranchData().getBranchColor().setValue(color);
    }

    public static void setBranchWidthValue(PhylogenyNode node, double branch_width_value) {
        node.getBranchData().setBranchWidth(new BranchWidth(branch_width_value));
    }

    public static void setConfidence(PhylogenyNode node, double confidence_value) {
        PhylogenyMethods.setConfidence(node, confidence_value, "");
    }

    public static void setConfidence(PhylogenyNode node, double confidence_value, String type) {
        Confidence c = null;
        if (node.getBranchData().getNumberOfConfidences() > 0) {
            c = node.getBranchData().getConfidence(0);
        } else {
            c = new Confidence();
            node.getBranchData().addConfidence(c);
        }
        c.setType(type);
        c.setValue(confidence_value);
    }

    public static void setScientificName(PhylogenyNode node, String scientific_name) {
        if (!node.getNodeData().isHasTaxonomy()) {
            node.getNodeData().setTaxonomy(new Taxonomy());
        }
        node.getNodeData().getTaxonomy().setScientificName(scientific_name);
    }

    public static void setTaxonomyCode(PhylogenyNode node, String taxonomy_code) {
        if (!node.getNodeData().isHasTaxonomy()) {
            node.getNodeData().setTaxonomy(new Taxonomy());
        }
        node.getNodeData().getTaxonomy().setTaxonomyCode(taxonomy_code);
    }

    public static int taxonomyBasedDeletionOfExternalNodes(Phylogeny reference, Phylogeny to_be_stripped) {
        HashSet<String> ref_ext_taxo = new HashSet<String>();
        ArrayList<PhylogenyNode> nodes_to_delete = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator it = reference.iteratorExternalForward();
        while (it.hasNext()) {
            ref_ext_taxo.add(PhylogenyMethods.getSpecies(it.next()));
        }
        it = to_be_stripped.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (ref_ext_taxo.contains(PhylogenyMethods.getSpecies(n))) continue;
            nodes_to_delete.add(n);
        }
        for (PhylogenyNode phylogenyNode : nodes_to_delete) {
            to_be_stripped.deleteSubtree(phylogenyNode, true);
        }
        return nodes_to_delete.size();
    }
}

