/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Accession
implements PhylogenyData {
    final String _value;
    final String _source;

    public Accession(String value, String source) {
        this._value = value;
        this._source = source;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getSource())) {
            sb.append("[");
            sb.append(this.getSource());
            sb.append("] ");
        }
        sb.append(this.getValue());
        return sb;
    }

    @Override
    public PhylogenyData copy() {
        return new Accession(new String(this.getValue()), new String(this.getSource()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        return this.isEqual((Accession)o);
    }

    public String getSource() {
        return this._source;
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        if (this.getSource() != null) {
            return (String.valueOf(this.getSource()) + this.getValue()).hashCode();
        }
        return this.getValue().hashCode();
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        if (this == data) {
            return true;
        }
        if (data == null || this.getValue() == null) {
            return false;
        }
        Accession a = (Accession)data;
        if (this.getSource() != null && a.getSource() != null) {
            return a.getValue().equals(this.getValue()) && a.getSource().equals(this.getSource());
        }
        return a.getValue().equals(this.getValue());
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        sb.append(":");
        sb.append("AC=");
        sb.append(ForesterUtil.replaceIllegalNhxCharacters(this.getValue()));
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (ForesterUtil.isEmpty(this.getSource())) {
            PhylogenyDataUtil.appendElement(writer, "accession", this.getValue(), "source", "unknown", indentation);
        } else {
            PhylogenyDataUtil.appendElement(writer, "accession", this.getValue(), "source", this.getSource(), indentation);
        }
    }

    public String toString() {
        return this.asText().toString();
    }
}

