/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Uri;
import org.forester.util.ForesterUtil;

public class Annotation
implements PhylogenyData {
    private String _desc;
    private String _type;
    private String _source;
    private String _ref;
    private String _evidence;
    private Confidence _confidence;
    private PropertiesMap _properties;
    private Uri _uri;

    public Annotation() {
        this.init();
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getDesc());
    }

    @Override
    public StringBuffer asText() {
        return new StringBuffer(this.getDesc());
    }

    @Override
    public PhylogenyData copy() {
        Annotation ann = new Annotation();
        if (this.getConfidence() != null) {
            ann.setConfidence((Confidence)this.getConfidence().copy());
        } else {
            ann.setConfidence(null);
        }
        ann.setType(new String(this.getType()));
        ann.setDesc(new String(this.getDesc()));
        ann.setEvidence(new String(this.getEvidence()));
        ann.setRef(new String(this.getRef()));
        ann.setSource(new String(this.getSource()));
        if (this.getProperties() != null) {
            ann.setProperties((PropertiesMap)this.getProperties().copy());
        } else {
            ann.setProperties(null);
        }
        return ann;
    }

    public Confidence getConfidence() {
        return this._confidence;
    }

    public String getDesc() {
        return this._desc;
    }

    public String getEvidence() {
        return this._evidence;
    }

    public PropertiesMap getProperties() {
        return this._properties;
    }

    public String getRef() {
        return this._ref;
    }

    public String getSource() {
        return this._source;
    }

    public String getType() {
        return this._type;
    }

    public Uri getUri() {
        return this._uri;
    }

    private void init() {
        this._desc = "";
        this._type = "";
        this._source = "";
        this._ref = "";
        this._evidence = "";
        this._confidence = null;
        this._properties = null;
        this._uri = null;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        if (ForesterUtil.isEmpty(this.getDesc())) {
            return false;
        }
        return this.getDesc().equals(((Annotation)data).getDesc());
    }

    public void setConfidence(Confidence confidence) {
        this._confidence = confidence;
    }

    public void setDesc(String desc) {
        this._desc = desc;
    }

    public void setEvidence(String evidence) {
        this._evidence = evidence;
    }

    public void setProperties(PropertiesMap property) {
        this._properties = property;
    }

    public void setRef(String ref) {
        this._ref = ref;
    }

    public void setSource(String source) {
        this._source = source;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setUri(Uri uri) {
        this._uri = uri;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        sb.append("AN=");
        sb.append(ForesterUtil.replaceIllegalNhxCharacters(this.getDesc().toString()));
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.getConfidence() != null || this.getProperties() != null || this.getUri() != null || !ForesterUtil.isEmpty(this.getDesc())) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(indentation);
            PhylogenyDataUtil.appendOpen(writer, "annotation", "ref", this.getRef(), "evidence", this.getEvidence(), "type", this.getType(), "source", this.getSource());
            if (!ForesterUtil.isEmpty(this.getDesc())) {
                PhylogenyDataUtil.appendElement(writer, "desc", this.getDesc(), indentation);
            }
            if (this.getConfidence() != null) {
                this.getConfidence().toPhyloXML(writer, level, String.valueOf(indentation) + "  ");
            }
            if (this.getProperties() != null) {
                this.getProperties().toPhyloXML(writer, level, indentation);
            }
            if (this.getUri() != null) {
                this.getUri().toPhyloXML(writer, level, indentation);
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(indentation);
            PhylogenyDataUtil.appendClose(writer, "annotation");
        } else {
            PhylogenyDataUtil.appendElement(writer, "annotation", "ref", this.getRef(), "evidence", this.getEvidence(), "type", this.getType(), "source", this.getSource(), indentation);
        }
    }

    public String toString() {
        return this.asText().toString();
    }
}

