/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class BranchColor
implements PhylogenyData {
    private Color _color;

    public BranchColor() {
        this._color = null;
    }

    public BranchColor(Color color) {
        this._color = color;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue().toString());
    }

    @Override
    public StringBuffer asText() {
        return new StringBuffer(this.getValue().toString());
    }

    @Override
    public PhylogenyData copy() {
        BranchColor bc = new BranchColor();
        bc.setValue(this.getValue());
        return bc;
    }

    public Color getValue() {
        return this._color;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        return this.getValue().equals(((BranchColor)data).getValue());
    }

    public void setValue(Color color) {
        this._color = color;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        sb.append("C=");
        sb.append(this.getValue().getRed());
        sb.append(".");
        sb.append(this.getValue().getGreen());
        sb.append(".");
        sb.append(this.getValue().getBlue());
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "color");
        PhylogenyDataUtil.appendElement(writer, "red", String.valueOf(this.getValue().getRed()), indentation);
        PhylogenyDataUtil.appendElement(writer, "green", String.valueOf(this.getValue().getGreen()), indentation);
        PhylogenyDataUtil.appendElement(writer, "blue", String.valueOf(this.getValue().getBlue()), indentation);
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "color");
    }

    public String toString() {
        return this.asText().toString();
    }
}

