/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class BranchWidth
implements PhylogenyData {
    public static final double BRANCH_WIDTH_DEFAULT_VALUE = 1.0;
    private final double _value;

    public BranchWidth() {
        this._value = 1.0;
    }

    public BranchWidth(double value) {
        this._value = value;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(String.valueOf(this.getValue()));
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        return new BranchWidth(this.getValue());
    }

    public double getValue() {
        return this._value;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        return this.getValue() == ((BranchWidth)data).getValue();
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        sb.append("W=");
        sb.append(this.getValue());
        return sb;
    }

    @Override
    public void toPhyloXML(Writer w, int level, String indentation) throws IOException {
        w.write(ForesterUtil.LINE_SEPARATOR);
        w.write(indentation);
        PhylogenyDataUtil.appendElement(w, "width", String.valueOf(this.getValue()));
    }

    public String toString() {
        return this.asText().toString();
    }
}

