/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Distribution
implements PhylogenyData {
    private String _desc;
    private BigDecimal _latitude;
    private BigDecimal _longitude;
    private BigDecimal _altitude;
    private String _geodetic_datum;

    public Distribution(String desc) {
        this._desc = desc;
        this._latitude = null;
        this._longitude = null;
        this._altitude = null;
        this._geodetic_datum = "";
    }

    public Distribution(String desc, BigDecimal latitude, BigDecimal longitude, BigDecimal altitude, String geodetic_datum) {
        this._desc = desc;
        this._latitude = latitude;
        this._longitude = longitude;
        this._altitude = altitude;
        this._geodetic_datum = geodetic_datum;
    }

    @Override
    public StringBuffer asSimpleText() {
        if (this.getLatitude() != null || this.getLongitude() != null || this.getAltitude() != null) {
            return new StringBuffer(String.valueOf(this.getDesc()) + " [" + this.getLatitude().toPlainString() + "," + this.getLongitude().toPlainString() + "," + this.getAltitude().toPlainString() + "] [" + this.getGeodeticDatum() + "]");
        }
        return new StringBuffer(this.getDesc());
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        return new Distribution(new String(this.getDesc()), new BigDecimal(this.getLatitude().toPlainString()), new BigDecimal(this.getLongitude().toPlainString()), new BigDecimal(this.getAltitude().toPlainString()), new String(this.getGeodeticDatum()));
    }

    public BigDecimal getAltitude() {
        return this._altitude;
    }

    public String getDesc() {
        return this._desc;
    }

    public String getGeodeticDatum() {
        return this._geodetic_datum;
    }

    public BigDecimal getLatitude() {
        return this._latitude;
    }

    public BigDecimal getLongitude() {
        return this._longitude;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        throw new UnsupportedOperationException();
    }

    public void setAltitude(BigDecimal altitude) {
        this._altitude = altitude;
    }

    public void setDescription(String desc) {
        this._desc = desc;
    }

    public void setGeodeticDatum(String datum) {
        this._geodetic_datum = datum;
    }

    public void setLatitude(BigDecimal latitude) {
        this._latitude = latitude;
    }

    public void setLongitude(BigDecimal longitud) {
        this._longitude = longitud;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "distribution");
        if (!ForesterUtil.isEmpty(this.getDesc())) {
            PhylogenyDataUtil.appendElement(writer, "desc", this.getDesc(), indentation);
        }
        if (this.getLatitude() != null || this.getLongitude() != null || this.getAltitude() != null) {
            PhylogenyDataUtil.appendOpen(writer, "point", "geodetic_datum", this.getGeodeticDatum());
            PhylogenyDataUtil.appendElement(writer, "latitude", this.getLatitude().toPlainString(), indentation);
            PhylogenyDataUtil.appendElement(writer, "longitude", this.getLongitude().toPlainString(), indentation);
            PhylogenyDataUtil.appendElement(writer, "alt", this.getAltitude().toPlainString(), indentation);
            PhylogenyDataUtil.appendClose(writer, "point");
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "distribution");
    }

    public String toString() {
        return this.asSimpleText().toString();
    }
}

