/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.ProteinDomain;
import org.forester.util.ForesterUtil;

public class DomainArchitecture
implements PhylogenyData {
    public static final String NHX_SEPARATOR = ">";
    private static final double INCREASE_KEY = 1.0E-4;
    private SortedMap<Double, ProteinDomain> _domains;
    private int _total_length;

    public DomainArchitecture() {
        this.init();
    }

    public DomainArchitecture(List<PhylogenyData> domains, int total_length) {
        this.init();
        for (PhylogenyData phylogenyData : domains) {
            ProteinDomain pd = (ProteinDomain)phylogenyData;
            this.addDomain(pd);
        }
        this._total_length = total_length;
    }

    public DomainArchitecture(String da_str) {
        this.init();
        int total_length = 0;
        int to = -1;
        try {
            StringTokenizer st = new StringTokenizer(da_str, NHX_SEPARATOR);
            String length_str = (String)st.nextElement();
            total_length = new Integer(length_str);
            while (st.hasMoreElements()) {
                String from_str = (String)st.nextElement();
                String to_str = (String)st.nextElement();
                String support_str = (String)st.nextElement();
                String name = (String)st.nextElement();
                to = new Integer(to_str);
                int from = new Integer(from_str);
                double support = new Double(support_str);
                ProteinDomain pd = new ProteinDomain(name, from, to, support);
                this.addDomain(pd);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed format for domain structure \"" + da_str + "\": " + e.getMessage());
        }
        if (to > total_length) {
            throw new IllegalArgumentException("total length of domain structure is too short");
        }
        this._total_length = total_length;
    }

    public void addDomain(ProteinDomain pd) {
        Double key = new Double(pd.getFrom());
        while (this._domains.containsKey(key)) {
            key = new Double(key + 1.0E-4);
        }
        this._domains.put(key, pd);
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.getDomains().size()) {
            if (i > 0) {
                sb.append("~");
            }
            sb.append(this.getDomain(i).asSimpleText());
            ++i;
        }
        return sb;
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.getDomains().size()) {
            if (i > 0) {
                sb.append("~");
            }
            sb.append(this.getDomain(i).asText());
            ++i;
        }
        return sb;
    }

    @Override
    public PhylogenyData copy() {
        ArrayList<PhylogenyData> domains = new ArrayList<PhylogenyData>(this.getDomains().size());
        int i = 0;
        while (i < this.getDomains().size()) {
            domains.add(this.getDomain(i).copy());
            ++i;
        }
        return new DomainArchitecture(domains, this.getTotalLength());
    }

    public ProteinDomain getDomain(int i) {
        return (ProteinDomain)this._domains.values().toArray()[i];
    }

    public SortedMap<Double, ProteinDomain> getDomains() {
        return this._domains;
    }

    public int getNumberOfDomains() {
        return this._domains.size();
    }

    public int getTotalLength() {
        return this._total_length;
    }

    private void init() {
        this._domains = new TreeMap<Double, ProteinDomain>();
        this._total_length = 0;
    }

    @Override
    public boolean isEqual(PhylogenyData domain_architecture) {
        if (domain_architecture == null) {
            return false;
        }
        if (!(domain_architecture instanceof DomainArchitecture)) {
            return false;
        }
        DomainArchitecture d = (DomainArchitecture)domain_architecture;
        if (this.getDomains().size() != d.getDomains().size()) {
            return false;
        }
        int i = 0;
        while (i < this.getDomains().size()) {
            if (!this.getDomain(i).getName().equals(d.getDomain(i).getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setTotalLength(int total_length) {
        this._total_length = total_length;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        sb.append(":");
        sb.append("DS=");
        sb.append(this.getTotalLength());
        if (this.getDomains() != null) {
            int i = 0;
            while (i < this.getDomains().size()) {
                sb.append(NHX_SEPARATOR);
                sb.append(this.getDomain(i).getFrom());
                sb.append(NHX_SEPARATOR);
                sb.append(this.getDomain(i).getTo());
                sb.append(NHX_SEPARATOR);
                sb.append(this.getDomain(i).getConfidence());
                sb.append(NHX_SEPARATOR);
                sb.append(ForesterUtil.replaceIllegalNhxCharacters(this.getDomain(i).getName()));
                ++i;
            }
        }
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "domain_architecture", "length", String.valueOf(this.getTotalLength()));
        if (this.getDomains() != null) {
            int i = 0;
            while (i < this.getDomains().size()) {
                this.getDomain(i).toPhyloXML(writer, level, String.valueOf(indentation) + "  ");
                ++i;
            }
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "domain_architecture");
    }

    public String toString() {
        return this.asText().toString();
    }
}

