/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Identifier
implements PhylogenyData {
    final String _value;
    final String _provider;

    public Identifier() {
        this._value = "";
        this._provider = "";
    }

    public Identifier(String value) {
        this._value = value;
        this._provider = "";
    }

    public Identifier(String value, String provider) {
        this._value = value;
        this._provider = provider;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getProvider())) {
            sb.append("[");
            sb.append(this.getProvider());
            sb.append("] ");
        }
        sb.append(this.getValue());
        return sb;
    }

    @Override
    public PhylogenyData copy() {
        return new Identifier(new String(this.getValue()), new String(this.getProvider()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        return this.isEqual((Identifier)o);
    }

    public String getProvider() {
        return this._provider;
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        if (this.getProvider() != null) {
            return (String.valueOf(this.getProvider()) + this.getValue()).hashCode();
        }
        return this.getValue().hashCode();
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        if (this == data) {
            return true;
        }
        if (data == null || this.getValue() == null) {
            return false;
        }
        Identifier a = (Identifier)data;
        if (this.getProvider() != null && a.getProvider() != null) {
            return a.getValue().equals(this.getValue()) && a.getProvider().equals(this.getProvider());
        }
        return a.getValue().equals(this.getValue());
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        sb.append(":");
        sb.append("ID=");
        sb.append(ForesterUtil.replaceIllegalNhxCharacters(this.getValue()));
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (!ForesterUtil.isEmpty(this.getProvider())) {
            PhylogenyDataUtil.appendElement(writer, "id", this.getValue(), "provider", this.getProvider(), indentation);
        } else {
            PhylogenyDataUtil.appendElement(writer, "id", this.getValue(), indentation);
        }
    }

    public String toString() {
        return this.asText().toString();
    }
}

