/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Reference;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;

public class NodeData
implements PhylogenyData {
    private Event _event;
    private Sequence _sequence;
    private Identifier _node_identifier;
    private Taxonomy _taxonomy;
    private Distribution _distribution;
    private Date _date;
    private BinaryCharacters _binary_characters;
    private PropertiesMap _properties;
    private Reference _reference;

    @Override
    public StringBuffer asSimpleText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer asText() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PhylogenyData copy() {
        NodeData new_pnd = new NodeData();
        if (this.isHasSequence()) {
            new_pnd.setSequence((Sequence)this.getSequence().copy());
        }
        if (this.isHasEvent()) {
            new_pnd.setEvent((Event)this.getEvent().copy());
        }
        if (this.isHasNodeIdentifier()) {
            new_pnd.setNodeIdentifier((Identifier)this.getNodeIdentifier().copy());
        }
        if (this.isHasTaxonomy()) {
            new_pnd.setTaxonomy((Taxonomy)this.getTaxonomy().copy());
        }
        if (this.isHasBinaryCharacters()) {
            new_pnd.setBinaryCharacters((BinaryCharacters)this.getBinaryCharacters().copy());
        }
        if (this.isHasReference()) {
            new_pnd.setReference((Reference)this.getReference().copy());
        }
        if (this.isHasDistribution()) {
            new_pnd.setDistribution((Distribution)this.getDistribution().copy());
        }
        if (this.isHasDate()) {
            new_pnd.setDate((Date)this.getDate().copy());
        }
        if (this.isHasProperties()) {
            new_pnd.setProperties((PropertiesMap)this.getProperties().copy());
        }
        return new_pnd;
    }

    public BinaryCharacters getBinaryCharacters() {
        return this._binary_characters;
    }

    public Date getDate() {
        return this._date;
    }

    public Distribution getDistribution() {
        return this._distribution;
    }

    public Event getEvent() {
        return this._event;
    }

    public Identifier getNodeIdentifier() {
        return this._node_identifier;
    }

    public PropertiesMap getProperties() {
        return this._properties;
    }

    public Reference getReference() {
        return this._reference;
    }

    public Sequence getSequence() {
        return this._sequence;
    }

    public Taxonomy getTaxonomy() {
        return this._taxonomy;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        throw new UnsupportedOperationException();
    }

    public boolean isHasBinaryCharacters() {
        return this.getBinaryCharacters() != null;
    }

    public boolean isHasDate() {
        return this.getDate() != null && (!ForesterUtil.isEmpty(this.getDate().getDesc()) || !ForesterUtil.isNull(this.getDate().getMax()) || !ForesterUtil.isNull(this.getDate().getMin()) || !ForesterUtil.isNull(this.getDate().getValue()) || !ForesterUtil.isEmpty(this.getDate().getUnit()));
    }

    public boolean isHasDistribution() {
        return this.getDistribution() != null && (!ForesterUtil.isEmpty(this.getDistribution().getDesc()) || !ForesterUtil.isNull(this.getDistribution().getLatitude()) || !ForesterUtil.isNull(this.getDistribution().getLongitude()) || !ForesterUtil.isNull(this.getDistribution().getAltitude()) || !ForesterUtil.isEmpty(this.getDistribution().getGeodeticDatum()));
    }

    public boolean isHasEvent() {
        return this.getEvent() != null;
    }

    public boolean isHasNodeIdentifier() {
        return this.getNodeIdentifier() != null;
    }

    public boolean isHasProperties() {
        return this.getProperties() != null;
    }

    public boolean isHasReference() {
        return this.getReference() != null && (!ForesterUtil.isEmpty(this.getReference().getDoi()) || !ForesterUtil.isEmpty(this.getReference().getValue()));
    }

    public boolean isHasSequence() {
        return this.getSequence() != null;
    }

    public boolean isHasTaxonomy() {
        return this.getTaxonomy() != null;
    }

    public void setBinaryCharacters(BinaryCharacters binary_characters) {
        this._binary_characters = binary_characters;
    }

    public void setDate(Date date) {
        this._date = date;
    }

    public void setDistribution(Distribution distribution) {
        this._distribution = distribution;
    }

    public void setEvent(Event event) {
        this._event = event;
    }

    public void setNodeIdentifier(Identifier node_identifier) {
        this._node_identifier = node_identifier;
    }

    public void setProperties(PropertiesMap custom_data) {
        this._properties = custom_data;
    }

    public void setReference(Reference reference) {
        this._reference = reference;
    }

    public void setSequence(Sequence sequence) {
        this._sequence = sequence;
    }

    public void setTaxonomy(Taxonomy taxonomy) {
        this._taxonomy = taxonomy;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        if (this.isHasNodeIdentifier()) {
            sb.append(this.getNodeIdentifier().toNHX());
        }
        if (this.isHasTaxonomy()) {
            sb.append(this.getTaxonomy().toNHX());
        }
        if (this.isHasSequence()) {
            sb.append(this.getSequence().toNHX());
        }
        if (this.isHasEvent()) {
            sb.append(this.getEvent().toNHX());
        }
        if (this.isHasProperties()) {
            sb.append(this.getProperties().toNHX());
        }
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.isHasNodeIdentifier()) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(indentation);
        }
        if (this.isHasTaxonomy()) {
            this.getTaxonomy().toPhyloXML(writer, level, indentation);
        }
        if (this.isHasSequence()) {
            this.getSequence().toPhyloXML(writer, level, indentation);
        }
        if (this.isHasEvent()) {
            this.getEvent().toPhyloXML(writer, level, indentation);
        }
        if (this.isHasBinaryCharacters()) {
            this.getBinaryCharacters().toPhyloXML(writer, level, indentation);
        }
        if (this.isHasDistribution()) {
            this.getDistribution().toPhyloXML(writer, level, indentation);
        }
        if (this.isHasDate()) {
            this.getDate().toPhyloXML(writer, level, indentation);
        }
        if (this.isHasReference()) {
            this.getReference().toPhyloXML(writer, level, indentation);
        }
        if (this.isHasProperties()) {
            this.getProperties().toPhyloXML(writer, level, indentation.substring(0, indentation.length() - 3));
        }
    }
}

