/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.util.ForesterUtil;

public class Reference
implements PhylogenyData {
    String _value;
    String _doi;

    public Reference(String value) {
        this._value = value;
        this._doi = "";
    }

    public Reference(String value, String doi) {
        this._value = value;
        this._doi = doi;
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(this.getValue());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer sb = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getDoi())) {
            sb.append("[doi:");
            sb.append(this.getDoi());
            sb.append("] ");
        }
        sb.append(this.getValue());
        return sb;
    }

    @Override
    public PhylogenyData copy() {
        return new Reference(new String(this.getValue()), new String(this.getDoi()));
    }

    public String getDoi() {
        return this._doi;
    }

    public String getValue() {
        return this._value;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        if (data == null || this.getValue() == null) {
            return false;
        }
        return ((Reference)data).getValue().equals(this.getValue()) && ((Reference)data).getDoi().equals(this.getDoi());
    }

    public void setDoi(String doi) {
        if (!ForesterUtil.isEmpty(doi) && !PhyloXmlUtil.LIT_REF_DOI_PATTERN.matcher(doi).matches()) {
            throw new PhyloXmlDataFormatException("illegal doi: [" + doi + "]");
        }
        this._doi = doi;
    }

    public void setValue(String value) {
        this._value = value;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "reference", "doi", this.getDoi());
        if (!ForesterUtil.isEmpty(this.getValue())) {
            PhylogenyDataUtil.appendElement(writer, "desc", this.getValue(), indentation);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "reference");
    }

    public String toString() {
        return this.asText().toString();
    }
}

