/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlUtil;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.Uri;
import org.forester.util.ForesterUtil;

public class Sequence
implements PhylogenyData {
    private String _mol_sequence;
    private String _name;
    private Accession _accession;
    private String _symbol;
    private String _location;
    private String _type;
    private List<PhylogenyData> _annotations;
    private DomainArchitecture _da;
    private Uri _uri;

    public Sequence() {
        this.init();
    }

    public void addAnnotation(Annotation annotation) {
        this.getAnnotations().add(annotation);
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer sb = new StringBuffer();
        if (this.getAccession() != null) {
            sb.append("[");
            sb.append(this.getAccession());
            sb.append("] ");
        }
        if (!ForesterUtil.isEmpty(this.getName())) {
            sb.append(this.getName());
            sb.append(" ");
        }
        if (!ForesterUtil.isEmpty(this.getLocation())) {
            sb.append(this.getLocation());
        }
        return sb;
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        Sequence seq = new Sequence();
        seq.setAnnotations(this.getAnnotations());
        seq.setName(new String(this.getName()));
        seq.setSymbol(new String(this.getSymbol()));
        seq.setMolecularSequence(new String(this.getMolecularSequence()));
        seq.setLocation(new String(this.getLocation()));
        if (this.getAccession() != null) {
            seq.setAccession((Accession)this.getAccession().copy());
        } else {
            seq.setAccession(null);
        }
        seq.setType(new String(this.getType()));
        if (this.getUri() != null) {
            seq.setUri((Uri)this.getUri().copy());
        } else {
            seq.setUri(null);
        }
        if (this.getDomainArchitecture() != null) {
            seq.setDomainArchitecture((DomainArchitecture)this.getDomainArchitecture().copy());
        } else {
            seq.setDomainArchitecture(null);
        }
        return seq;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        return this.isEqual((Sequence)o);
    }

    public Accession getAccession() {
        return this._accession;
    }

    public PhylogenyData getAnnotation(int index) {
        return this.getAnnotations().get(index);
    }

    public List<PhylogenyData> getAnnotations() {
        return this._annotations;
    }

    public DomainArchitecture getDomainArchitecture() {
        return this._da;
    }

    public String getLocation() {
        return this._location;
    }

    public String getMolecularSequence() {
        return this._mol_sequence;
    }

    public String getName() {
        return this._name;
    }

    public String getSymbol() {
        return this._symbol;
    }

    public String getType() {
        return this._type;
    }

    public Uri getUri() {
        return this._uri;
    }

    public int hashCode() {
        if (this.getAccession() != null) {
            return this.getAccession().hashCode();
        }
        int result = this.getSymbol().hashCode();
        if (this.getName().length() > 0) {
            result ^= this.getName().hashCode();
        }
        if (this.getMolecularSequence().length() > 0) {
            result ^= this.getMolecularSequence().hashCode();
        }
        return result;
    }

    public void init() {
        this.setAnnotations(new ArrayList<PhylogenyData>());
        this.setName("");
        this.setMolecularSequence("");
        this.setLocation("");
        this.setAccession(null);
        this.setSymbol("");
        this.setType("");
        this.setDomainArchitecture(null);
        this.setUri(null);
    }

    public boolean isEmpty() {
        return this.getAccession() == null && ForesterUtil.isEmpty(this.getName()) && ForesterUtil.isEmpty(this.getSymbol()) && ForesterUtil.isEmpty(this.getType()) && ForesterUtil.isEmpty(this.getLocation()) && ForesterUtil.isEmpty(this.getMolecularSequence()) && this.getDomainArchitecture() == null && this.getAnnotations().isEmpty() && this.getUri() == null;
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        if (this == data) {
            return true;
        }
        Sequence s = (Sequence)data;
        if (this.getAccession() != null && s.getAccession() != null) {
            return this.getAccession().isEqual(s.getAccession());
        }
        return s.getMolecularSequence().equals(this.getMolecularSequence()) && s.getName().equals(this.getName()) && s.getSymbol().equals(this.getSymbol());
    }

    public void setAccession(Accession accession) {
        this._accession = accession;
    }

    private void setAnnotations(List<PhylogenyData> annotations) {
        this._annotations = annotations;
    }

    public void setDomainArchitecture(DomainArchitecture ds) {
        this._da = ds;
    }

    public void setLocation(String description) {
        this._location = description;
    }

    public void setMolecularSequence(String mol_sequence) {
        this._mol_sequence = mol_sequence;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setSymbol(String symbol) {
        if (!ForesterUtil.isEmpty(symbol) && !PhyloXmlUtil.SEQUENCE_SYMBOL_PATTERN.matcher(symbol).matches()) {
            throw new PhyloXmlDataFormatException("illegal sequence symbol: [" + symbol + "]");
        }
        this._symbol = symbol;
    }

    public void setType(String type) {
        if (!ForesterUtil.isEmpty(type) && !PhyloXmlUtil.SEQUENCE_TYPES.contains(type)) {
            throw new PhyloXmlDataFormatException("illegal sequence type: [" + type + "]");
        }
        this._type = type;
    }

    public void setUri(Uri uri) {
        this._uri = uri;
    }

    @Override
    public StringBuffer toNHX() {
        StringBuffer sb = new StringBuffer();
        if (this.getName().length() > 0) {
            sb.append(":");
            sb.append("GN=");
            sb.append(ForesterUtil.replaceIllegalNhxCharacters(this.getName()));
        }
        if (this.getAccession() != null) {
            this.getAccession().toNHX();
        }
        if (this.getDomainArchitecture() != null) {
            sb.append(this.getDomainArchitecture().toNHX());
        }
        return sb;
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        String my_ind = String.valueOf(indentation) + "  ";
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "sequence", "type", this.getType());
        if (!ForesterUtil.isEmpty(this.getSymbol())) {
            PhylogenyDataUtil.appendElement(writer, "symbol", this.getSymbol(), indentation);
        }
        if (this.getAccession() != null && !ForesterUtil.isEmpty(this.getAccession().getValue())) {
            this.getAccession().toPhyloXML(writer, level, indentation);
        }
        if (!ForesterUtil.isEmpty(this.getName())) {
            PhylogenyDataUtil.appendElement(writer, "name", this.getName(), indentation);
        }
        if (!ForesterUtil.isEmpty(this.getLocation())) {
            PhylogenyDataUtil.appendElement(writer, "location", this.getLocation(), indentation);
        }
        if (!ForesterUtil.isEmpty(this.getMolecularSequence())) {
            PhylogenyDataUtil.appendElement(writer, "mol_seq", this.getMolecularSequence(), indentation);
        }
        if (this.getUri() != null) {
            this.getUri().toPhyloXML(writer, level, indentation);
        }
        if (!this.getAnnotations().isEmpty()) {
            for (PhylogenyData annotation : this.getAnnotations()) {
                annotation.toPhyloXML(writer, level, my_ind);
            }
        }
        if (this.getDomainArchitecture() != null) {
            this.getDomainArchitecture().toPhyloXML(writer, level, my_ind);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "sequence");
    }

    public String toString() {
        return this.asText().toString();
    }
}

