/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.factories;

import java.io.IOException;
import java.util.List;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.BasicPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.util.ForesterUtil;

public class ParserBasedPhylogenyFactory
extends BasicPhylogenyFactory {
    private static final PhylogenyFactory _instance;

    static {
        try {
            _instance = new ParserBasedPhylogenyFactory();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private ParserBasedPhylogenyFactory() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public synchronized Phylogeny[] create(Object source, Object parser, List<Object> parameters) throws IOException {
        if (!(parser instanceof PhylogenyParser)) {
            throw new IllegalArgumentException("attempt to use object of type other than PhylogenyParser as creator for ParserBasedPhylogenyFactory");
        }
        PhylogenyParser my_parser = (PhylogenyParser)parser;
        my_parser.setSource(source);
        return my_parser.parse();
    }

    public synchronized Phylogeny[] create(Object source, Object parser, String schema_location, List<Object> parameters) throws IOException {
        if (!(parser instanceof PhylogenyParser)) {
            throw new IllegalArgumentException("attempt to use object of type other than PhylogenyParser as creator for ParserBasedPhylogenyFactory.");
        }
        if (!(parser instanceof PhyloXmlParser)) {
            throw new IllegalArgumentException("attempt to use schema location with other than phyloXML parser");
        }
        PhyloXmlParser xml_parser = (PhyloXmlParser)parser;
        if (!ForesterUtil.isEmpty(schema_location)) {
            xml_parser.setValidateAgainstSchema(schema_location);
        }
        xml_parser.setSource(source);
        return xml_parser.parse();
    }

    public static PhylogenyFactory getInstance() {
        return _instance;
    }
}

