/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.iterators;

import java.util.NoSuchElementException;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class ChildNodeIteratorForward
implements PhylogenyNodeIterator {
    private int _i;
    private final PhylogenyNode _node;

    public ChildNodeIteratorForward(PhylogenyNode node) throws IllegalArgumentException {
        if (node.getNumberOfDescendants() < 1) {
            throw new IllegalArgumentException("Attempt to use ChildNodeIteratorForward on node with no child nodes.");
        }
        this._node = node;
        this.reset();
    }

    private int getI() {
        return this._i;
    }

    private PhylogenyNode getNode() {
        return this._node;
    }

    @Override
    public boolean hasNext() {
        return this.getI() < this.getNode().getNumberOfDescendants();
    }

    private void increaseI() {
        ++this._i;
    }

    @Override
    public PhylogenyNode next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Attempt to call \"next()\" on iterator which has no more next elements.");
        }
        PhylogenyNode n = this.getNode().getChildNode(this.getI());
        this.increaseI();
        return n;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.setI(0);
    }

    private void setI(int i) {
        this._i = i;
    }
}

