/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.iterators;

import java.util.NoSuchElementException;
import org.forester.datastructures.Queue;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;

public class LevelOrderTreeIterator
implements PhylogenyNodeIterator {
    private final Queue _queue = new Queue();
    private final PhylogenyNode _root;

    public LevelOrderTreeIterator(Phylogeny phylogeny) throws IllegalArgumentException {
        this(phylogeny.getRoot());
        if (phylogeny.isEmpty()) {
            throw new IllegalArgumentException("Attempt to use LevelOrderTreeIterator on an empty phylogeny.");
        }
    }

    public LevelOrderTreeIterator(PhylogenyNode node) {
        this._root = node;
        this.reset();
    }

    private Queue getQueue() {
        return this._queue;
    }

    private PhylogenyNode getRoot() {
        return this._root;
    }

    @Override
    public boolean hasNext() {
        return !this.getQueue().isEmpty();
    }

    @Override
    public PhylogenyNode next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Attempt to call \"next()\" on iterator which has no more next elements.");
        }
        PhylogenyNode node = (PhylogenyNode)this.getQueue().dequeue();
        int i = 0;
        while (i < node.getNumberOfDescendants()) {
            this.getQueue().enqueue(node.getChildNode(i));
            ++i;
        }
        return node;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.getQueue().clear();
        this.getQueue().enqueue(this.getRoot());
    }
}

