/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenyinference;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;
import java.util.StringTokenizer;
import org.forester.phylogenyinference.DistanceMatrix;
import org.forester.util.ForesterUtil;

public class BasicSymmetricalDistanceMatrix
implements DistanceMatrix {
    NumberFormat nf1 = NumberFormat.getInstance();
    private static final NumberFormat PHYLIP_FORMATTER = new DecimalFormat("0.000000");
    final double[][] _values;
    final String[] _identifiers;

    public BasicSymmetricalDistanceMatrix(int size) {
        this._values = new double[size][size];
        this._identifiers = new String[size];
    }

    @Override
    public String getIdentifier(int i) {
        return this._identifiers[i];
    }

    @Override
    public int getIndex(String identifier) {
        int i = 0;
        while (i < this._identifiers.length) {
            if (this.getIdentifier(i).equals(identifier)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("identifier [" + identifier + "] not found in distance matrix");
    }

    @Override
    public int getSize() {
        return this._values.length;
    }

    @Override
    public double getValue(int col, int row) {
        if (col == row) {
            if (col >= this.getSize()) {
                throw new IndexOutOfBoundsException("");
            }
            return 0.0;
        }
        if (col > row) {
            return this._values[row][col];
        }
        return this._values[col][row];
    }

    public void randomize(long seed) {
        Random r = new Random(seed);
        int j = 0;
        while (j < this.getSize()) {
            int i = 0;
            while (i < j) {
                this.setValue(i, j, r.nextDouble());
                ++i;
            }
            ++j;
        }
    }

    @Override
    public void setIdentifier(int i, String identifier) {
        this._identifiers[i] = identifier;
    }

    public void setRow(String s, int row) {
        StringTokenizer tk = new StringTokenizer(s);
        int i = 0;
        while (tk.hasMoreElements()) {
            this.setValue(i, row, new Double(tk.nextToken()));
            ++i;
        }
    }

    @Override
    public void setValue(int col, int row, double d) {
        if (col == row && d != 0.0) {
            throw new IllegalArgumentException("attempt to set a non-zero value on the diagonal of a symmetrical distance matrix");
        }
        if (col > row) {
            this._values[row][col] = d;
        }
        this._values[col][row] = d;
    }

    private StringBuffer toPhylip() {
        StringBuffer sb = new StringBuffer();
        sb.append(' ');
        sb.append(' ');
        sb.append(' ');
        sb.append(' ');
        sb.append(this.getSize());
        sb.append(ForesterUtil.LINE_SEPARATOR);
        int row = 0;
        while (row < this.getSize()) {
            if (ForesterUtil.isEmpty(this.getIdentifier(row))) {
                throw new IllegalStateException("PHYLIP format does not allow empty identifiers");
            }
            sb.append(ForesterUtil.pad(this.getIdentifier(row), 10, ' ', false));
            sb.append(' ');
            sb.append(' ');
            sb.append("");
            int col = 0;
            while (col < this.getSize()) {
                sb.append(PHYLIP_FORMATTER.format(this.getValue(col, row)));
                if (col < this.getSize() - 1) {
                    sb.append(' ');
                    sb.append(' ');
                }
                ++col;
            }
            if (row < this.getSize() - 1) {
                sb.append(ForesterUtil.LINE_SEPARATOR);
            }
            ++row;
        }
        return sb;
    }

    public String toString() {
        return this.toPhylip().toString();
    }

    @Override
    public StringBuffer toStringBuffer(DistanceMatrix.Format format) {
        switch (format) {
            case PHYLIP: {
                return this.toPhylip();
            }
        }
        throw new IllegalArgumentException("Unknown format:" + (Object)((Object)format));
    }
}

