/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenyinference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogenyinference.BasicCharacterStateMatrix;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.util.ForesterUtil;

public class SankoffParsimony<STATE_TYPE> {
    private static final CharacterStateMatrix.BinaryStates PRESENT = CharacterStateMatrix.BinaryStates.PRESENT;
    private static final CharacterStateMatrix.BinaryStates ABSENT = CharacterStateMatrix.BinaryStates.ABSENT;
    private static final CharacterStateMatrix.GainLossStates LOSS = CharacterStateMatrix.GainLossStates.LOSS;
    private static final CharacterStateMatrix.GainLossStates GAIN = CharacterStateMatrix.GainLossStates.GAIN;
    private static final CharacterStateMatrix.GainLossStates UNCHANGED_PRESENT = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
    private static final CharacterStateMatrix.GainLossStates UNCHANGED_ABSENT = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
    private static final boolean RETURN_INTERNAL_STATES_DEFAULT = false;
    private static final boolean RETURN_GAIN_LOSS_MATRIX_DEFAULT = false;
    private static final boolean RANDOMIZE_DEFAULT = false;
    private static final long RANDOM_NUMBER_SEED_DEFAULT = 21L;
    private static final boolean USE_LAST_DEFAULT = false;
    private boolean _return_internal_states = false;
    private boolean _return_gain_loss = false;
    private int _total_gains;
    private int _total_losses;
    private int _total_unchanged;
    private CharacterStateMatrix<List<STATE_TYPE>> _internal_states_matrix_prior_to_traceback;
    private CharacterStateMatrix<STATE_TYPE> _internal_states_matrix_after_traceback;
    private CharacterStateMatrix<CharacterStateMatrix.GainLossStates> _gain_loss_matrix;
    private boolean _randomize;
    private boolean _use_last;
    private int _cost;
    private long _random_number_seed;
    private Random _random_generator;

    public SankoffParsimony() {
        this.init();
    }

    private int determineIndex(SortedSet<STATE_TYPE> current_node_states, int i) {
        if (this.isRandomize()) {
            i = this.getRandomGenerator().nextInt(current_node_states.size());
        } else if (this.isUseLast()) {
            i = current_node_states.size() - 1;
        }
        return i;
    }

    public void execute(Phylogeny p, CharacterStateMatrix<STATE_TYPE> external_node_states_matrix) {
        if (!p.isRooted()) {
            throw new IllegalArgumentException("attempt to execute Fitch parsimony on unroored phylogeny");
        }
        if (external_node_states_matrix.isEmpty()) {
            throw new IllegalArgumentException("character matrix is empty");
        }
        if (external_node_states_matrix.getNumberOfIdentifiers() != p.getNumberOfExternalNodes()) {
            throw new IllegalArgumentException("number of external nodes in phylogeny [" + p.getNumberOfExternalNodes() + "] and number of indentifiers [" + external_node_states_matrix.getNumberOfIdentifiers() + "] in matrix are not equal");
        }
        this.reset();
        if (this.isReturnInternalStates()) {
            this.initializeInternalStates(p, external_node_states_matrix);
        }
        if (this.isReturnGainLossMatrix()) {
            this.initializeGainLossMatrix(p, external_node_states_matrix);
        }
        int character_index = 0;
        while (character_index < external_node_states_matrix.getNumberOfCharacters()) {
            this.executeForOneCharacter(p, this.getStatesForCharacter(p, external_node_states_matrix, character_index), this.getStatesForCharacterForTraceback(p, external_node_states_matrix, character_index), character_index);
            ++character_index;
        }
        if (external_node_states_matrix.getState(0, 0) instanceof CharacterStateMatrix.BinaryStates && external_node_states_matrix.getNumberOfCharacters() * p.getNumberOfBranches() != this.getTotalGains() + this.getTotalLosses() + this.getTotalUnchanged()) {
            throw new IllegalStateException("this should not have happened: something is deeply wrong with Fitch parsimony implementation");
        }
    }

    private void executeForOneCharacter(Phylogeny p, Map<PhylogenyNode, SortedSet<STATE_TYPE>> states, Map<PhylogenyNode, STATE_TYPE> traceback_states, int character_state_column) {
        this.postOrderTraversal(p, states);
        this.preOrderTraversal(p, states, traceback_states, character_state_column);
    }

    public int getCost() {
        return this._cost;
    }

    public CharacterStateMatrix<CharacterStateMatrix.GainLossStates> getGainLossMatrix() {
        if (!this.isReturnGainLossMatrix()) {
            throw new IllegalStateException("creation of gain-loss matrix has not been enabled");
        }
        return this._gain_loss_matrix;
    }

    public CharacterStateMatrix<STATE_TYPE> getInternalStatesMatrix() {
        if (!this.isReturnInternalStates()) {
            throw new IllegalStateException("creation of internal state matrix has not been enabled");
        }
        return this._internal_states_matrix_after_traceback;
    }

    public CharacterStateMatrix<List<STATE_TYPE>> getInternalStatesMatrixPriorToTraceback() {
        if (!this.isReturnInternalStates()) {
            throw new IllegalStateException("creation of internal state matrix has not been enabled");
        }
        return this._internal_states_matrix_prior_to_traceback;
    }

    private SortedSet<STATE_TYPE> getIntersectionOfStatesOfChildNodes(Map<PhylogenyNode, SortedSet<STATE_TYPE>> states, PhylogenyNode node) throws AssertionError {
        TreeSet states_in_child_nodes = new TreeSet();
        int i = 0;
        while (i < node.getNumberOfDescendants()) {
            PhylogenyNode node_child = node.getChildNode(i);
            if (!states.containsKey(node_child)) {
                throw new AssertionError((Object)("this should not have happened: node [" + node_child.getNodeName() + "] not found in node state map"));
            }
            if (i == 0) {
                states_in_child_nodes.addAll(states.get(node_child));
            } else {
                states_in_child_nodes.retainAll((Collection)states.get(node_child));
            }
            ++i;
        }
        return states_in_child_nodes;
    }

    private Random getRandomGenerator() {
        return this._random_generator;
    }

    private long getRandomNumberSeed() {
        return this._random_number_seed;
    }

    private STATE_TYPE getStateAt(int i, SortedSet<STATE_TYPE> states) {
        Iterator it = states.iterator();
        int j = 0;
        while (j < i) {
            it.next();
            ++j;
        }
        return (STATE_TYPE)it.next();
    }

    private Map<PhylogenyNode, SortedSet<STATE_TYPE>> getStatesForCharacter(Phylogeny p, CharacterStateMatrix<STATE_TYPE> matrix, int character_index) {
        HashMap<PhylogenyNode, SortedSet<STATE_TYPE>> states = new HashMap<PhylogenyNode, SortedSet<STATE_TYPE>>(matrix.getNumberOfIdentifiers());
        int indentifier_index = 0;
        while (indentifier_index < matrix.getNumberOfIdentifiers()) {
            STATE_TYPE state = matrix.getState(indentifier_index, character_index);
            if (state == null) {
                throw new IllegalArgumentException("value at [" + indentifier_index + ", " + character_index + "] is null");
            }
            TreeSet<STATE_TYPE> l = new TreeSet<STATE_TYPE>();
            l.add(state);
            states.put(p.getNode(matrix.getIdentifier(indentifier_index)), l);
            ++indentifier_index;
        }
        return states;
    }

    private Map<PhylogenyNode, STATE_TYPE> getStatesForCharacterForTraceback(Phylogeny p, CharacterStateMatrix<STATE_TYPE> matrix, int character_index) {
        HashMap<PhylogenyNode, STATE_TYPE> states = new HashMap<PhylogenyNode, STATE_TYPE>(matrix.getNumberOfIdentifiers());
        int indentifier_index = 0;
        while (indentifier_index < matrix.getNumberOfIdentifiers()) {
            STATE_TYPE state = matrix.getState(indentifier_index, character_index);
            if (state == null) {
                throw new IllegalArgumentException("value at [" + indentifier_index + ", " + character_index + "] is null");
            }
            states.put(p.getNode(matrix.getIdentifier(indentifier_index)), state);
            ++indentifier_index;
        }
        return states;
    }

    public int getTotalGains() {
        return this._total_gains;
    }

    public int getTotalLosses() {
        return this._total_losses;
    }

    public int getTotalUnchanged() {
        return this._total_unchanged;
    }

    private SortedSet<STATE_TYPE> getUnionOfStatesOfChildNodes(Map<PhylogenyNode, SortedSet<STATE_TYPE>> states, PhylogenyNode node) throws AssertionError {
        TreeSet states_in_child_nodes = new TreeSet();
        int i = 0;
        while (i < node.getNumberOfDescendants()) {
            PhylogenyNode node_child = node.getChildNode(i);
            if (!states.containsKey(node_child)) {
                throw new AssertionError((Object)("this should not have happened: node [" + node_child.getNodeName() + "] not found in node state map"));
            }
            states_in_child_nodes.addAll(states.get(node_child));
            ++i;
        }
        return states_in_child_nodes;
    }

    private void increaseCost() {
        ++this._cost;
    }

    private void init() {
        this.setReturnInternalStates(false);
        this.setReturnGainLossMatrix(false);
        this.setRandomize(false);
        this.setUseLast(false);
        this._random_number_seed = 21L;
        this.reset();
    }

    private void initializeGainLossMatrix(Phylogeny p, CharacterStateMatrix<STATE_TYPE> external_node_states_matrix) {
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator postorder = p.iteratorPostorder();
        while (postorder.hasNext()) {
            nodes.add(postorder.next());
        }
        this.setGainLossMatrix(new BasicCharacterStateMatrix<CharacterStateMatrix.GainLossStates>(nodes.size(), external_node_states_matrix.getNumberOfCharacters()));
        int identifier_index = 0;
        for (PhylogenyNode node : nodes) {
            this.getGainLossMatrix().setIdentifier(identifier_index++, ForesterUtil.isEmpty(node.getNodeName()) ? String.valueOf(node.getNodeId()) : node.getNodeName());
        }
        int character_index = 0;
        while (character_index < external_node_states_matrix.getNumberOfCharacters()) {
            this.getGainLossMatrix().setCharacter(character_index, external_node_states_matrix.getCharacter(character_index));
            ++character_index;
        }
    }

    private void initializeInternalStates(Phylogeny p, CharacterStateMatrix<STATE_TYPE> external_node_states_matrix) {
        ArrayList<PhylogenyNode> internal_nodes = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator postorder = p.iteratorPostorder();
        while (postorder.hasNext()) {
            PhylogenyNode node = postorder.next();
            if (!node.isInternal()) continue;
            internal_nodes.add(node);
        }
        this.setInternalStatesMatrixPriorToTraceback(new BasicCharacterStateMatrix<List<STATE_TYPE>>(internal_nodes.size(), external_node_states_matrix.getNumberOfCharacters()));
        this.setInternalStatesMatrixTraceback(new BasicCharacterStateMatrix(internal_nodes.size(), external_node_states_matrix.getNumberOfCharacters()));
        int identifier_index = 0;
        for (PhylogenyNode node : internal_nodes) {
            this.getInternalStatesMatrix().setIdentifier(identifier_index, ForesterUtil.isEmpty(node.getNodeName()) ? String.valueOf(node.getNodeId()) : node.getNodeName());
            this.getInternalStatesMatrixPriorToTraceback().setIdentifier(identifier_index, ForesterUtil.isEmpty(node.getNodeName()) ? String.valueOf(node.getNodeId()) : node.getNodeName());
            ++identifier_index;
        }
        int character_index = 0;
        while (character_index < external_node_states_matrix.getNumberOfCharacters()) {
            this.getInternalStatesMatrix().setCharacter(character_index, external_node_states_matrix.getCharacter(character_index));
            this.getInternalStatesMatrixPriorToTraceback().setCharacter(character_index, external_node_states_matrix.getCharacter(character_index));
            ++character_index;
        }
    }

    private boolean isRandomize() {
        return this._randomize;
    }

    private boolean isReturnGainLossMatrix() {
        return this._return_gain_loss;
    }

    private boolean isReturnInternalStates() {
        return this._return_internal_states;
    }

    private boolean isUseLast() {
        return this._use_last;
    }

    private void postOrderTraversal(Phylogeny p, Map<PhylogenyNode, SortedSet<STATE_TYPE>> states) throws AssertionError {
        PhylogenyNodeIterator postorder = p.iteratorPostorder();
        while (postorder.hasNext()) {
            PhylogenyNode node = postorder.next();
            if (node.isExternal()) continue;
            SortedSet<STATE_TYPE> states_in_children = this.getIntersectionOfStatesOfChildNodes(states, node);
            if (states_in_children.isEmpty()) {
                states_in_children = this.getUnionOfStatesOfChildNodes(states, node);
            }
            states.put(node, states_in_children);
        }
    }

    private void preOrderTraversal(Phylogeny p, Map<PhylogenyNode, SortedSet<STATE_TYPE>> states, Map<PhylogenyNode, STATE_TYPE> traceback_states, int character_state_column) throws AssertionError {
        PhylogenyNodeIterator preorder = p.iteratorPreorder();
        while (preorder.hasNext()) {
            PhylogenyNode current_node = preorder.next();
            SortedSet<STATE_TYPE> current_node_states = states.get(current_node);
            Object parent_state = null;
            if (current_node.isRoot()) {
                int i = 0;
                i = this.determineIndex(current_node_states, i);
                traceback_states.put(current_node, this.getStateAt(i, current_node_states));
            } else {
                parent_state = traceback_states.get(current_node.getParent());
                if (current_node_states.contains(parent_state)) {
                    traceback_states.put(current_node, parent_state);
                } else {
                    this.increaseCost();
                    int i = 0;
                    i = this.determineIndex(current_node_states, i);
                    traceback_states.put(current_node, this.getStateAt(i, current_node_states));
                }
            }
            if (this.isReturnInternalStates() && !current_node.isExternal()) {
                this.setInternalNodeStatePriorToTraceback(states, character_state_column, current_node);
                this.setInternalNodeState(traceback_states, character_state_column, current_node);
            }
            if (this.isReturnGainLossMatrix() && !current_node.isRoot()) {
                if (!(parent_state instanceof CharacterStateMatrix.BinaryStates)) {
                    throw new IllegalStateException("attempt to create gain loss matrix for not binary states");
                }
                CharacterStateMatrix.BinaryStates parent_binary_state = (CharacterStateMatrix.BinaryStates)((Object)parent_state);
                CharacterStateMatrix.BinaryStates current_binary_state = (CharacterStateMatrix.BinaryStates)((Object)traceback_states.get(current_node));
                if (parent_binary_state == PRESENT && current_binary_state == ABSENT) {
                    ++this._total_losses;
                    this.setGainLossState(character_state_column, current_node, LOSS);
                    continue;
                }
                if ((parent_binary_state == ABSENT || parent_binary_state == null) && current_binary_state == PRESENT) {
                    ++this._total_gains;
                    this.setGainLossState(character_state_column, current_node, GAIN);
                    continue;
                }
                ++this._total_unchanged;
                if (current_binary_state == PRESENT) {
                    this.setGainLossState(character_state_column, current_node, UNCHANGED_PRESENT);
                    continue;
                }
                if (current_binary_state != ABSENT) continue;
                this.setGainLossState(character_state_column, current_node, UNCHANGED_ABSENT);
                continue;
            }
            if (!this.isReturnGainLossMatrix() || !current_node.isRoot()) continue;
            CharacterStateMatrix.BinaryStates current_binary_state = (CharacterStateMatrix.BinaryStates)((Object)traceback_states.get(current_node));
            ++this._total_unchanged;
            if (current_binary_state == PRESENT) {
                this.setGainLossState(character_state_column, current_node, UNCHANGED_PRESENT);
                continue;
            }
            if (current_binary_state != ABSENT) continue;
            this.setGainLossState(character_state_column, current_node, UNCHANGED_ABSENT);
        }
    }

    private void reset() {
        this.setCost(0);
        this.setTotalLosses(0);
        this.setTotalGains(0);
        this.setTotalUnchanged(0);
        this.setRandomGenerator(new Random(this.getRandomNumberSeed()));
    }

    private void setCost(int cost) {
        this._cost = cost;
    }

    private void setGainLossMatrix(CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gain_loss_matrix) {
        this._gain_loss_matrix = gain_loss_matrix;
    }

    private void setGainLossState(int character_state_column, PhylogenyNode node, CharacterStateMatrix.GainLossStates state) {
        this.getGainLossMatrix().setState(ForesterUtil.isEmpty(node.getNodeName()) ? String.valueOf(node.getNodeId()) : node.getNodeName(), character_state_column, state);
    }

    private void setInternalNodeState(Map<PhylogenyNode, STATE_TYPE> states, int character_state_column, PhylogenyNode node) {
        this.getInternalStatesMatrix().setState(ForesterUtil.isEmpty(node.getNodeName()) ? String.valueOf(node.getNodeId()) : node.getNodeName(), character_state_column, states.get(node));
    }

    private void setInternalNodeStatePriorToTraceback(Map<PhylogenyNode, SortedSet<STATE_TYPE>> states, int character_state_column, PhylogenyNode node) {
        this.getInternalStatesMatrixPriorToTraceback().setState(ForesterUtil.isEmpty(node.getNodeName()) ? String.valueOf(node.getNodeId()) : node.getNodeName(), character_state_column, this.toListSorted(states.get(node)));
    }

    private void setInternalStatesMatrixPriorToTraceback(CharacterStateMatrix<List<STATE_TYPE>> internal_states_matrix_prior_to_traceback) {
        this._internal_states_matrix_prior_to_traceback = internal_states_matrix_prior_to_traceback;
    }

    private void setInternalStatesMatrixTraceback(CharacterStateMatrix<STATE_TYPE> internal_states_matrix_after_traceback) {
        this._internal_states_matrix_after_traceback = internal_states_matrix_after_traceback;
    }

    private void setRandomGenerator(Random random_generator) {
        this._random_generator = random_generator;
    }

    public void setRandomize(boolean randomize) {
        if (randomize && this.isUseLast()) {
            throw new IllegalArgumentException("attempt to allways use last state (ordered) if more than one choices and randomization at the same time");
        }
        this._randomize = randomize;
    }

    public void setRandomNumberSeed(long random_number_seed) {
        if (!this.isRandomize()) {
            throw new IllegalArgumentException("attempt to set random number generator seed without randomization enabled");
        }
        this._random_number_seed = random_number_seed;
    }

    public void setReturnGainLossMatrix(boolean return_gain_loss) {
        this._return_gain_loss = return_gain_loss;
    }

    public void setReturnInternalStates(boolean return_internal_states) {
        this._return_internal_states = return_internal_states;
    }

    private void setTotalGains(int total_gains) {
        this._total_gains = total_gains;
    }

    private void setTotalLosses(int total_losses) {
        this._total_losses = total_losses;
    }

    private void setTotalUnchanged(int total_unchanged) {
        this._total_unchanged = total_unchanged;
    }

    public void setUseLast(boolean use_last) {
        if (use_last && this.isRandomize()) {
            throw new IllegalArgumentException("attempt to allways use last state (ordered) if more than one choices and randomization at the same time");
        }
        this._use_last = use_last;
    }

    private List<STATE_TYPE> toListSorted(SortedSet<STATE_TYPE> states) {
        ArrayList l = new ArrayList(states.size());
        for (Object state : states) {
            l.add(state);
        }
        return l;
    }
}

