/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogenyinference;

import java.io.File;
import java.io.StringWriter;
import java.util.Date;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogenyinference.BasicCharacterStateMatrix;
import org.forester.phylogenyinference.BasicSymmetricalDistanceMatrix;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.phylogenyinference.DistanceMatrix;
import org.forester.phylogenyinference.DolloParsimony;
import org.forester.phylogenyinference.FitchParsimony;
import org.forester.phylogenyinference.NeighborJoining;
import org.forester.phylogenyinference.SymmetricalDistanceMatrixParser;
import org.forester.util.ForesterUtil;

public class TestPhylogenyReconstruction {
    private static final double ZERO_DIFF = 1.0E-9;
    private static final boolean TIME = false;

    public static boolean isEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-9;
    }

    public static void main(String[] args) {
        TestPhylogenyReconstruction.timeNeighborJoining();
    }

    public static boolean test(File test_dir) {
        System.out.print("  Basic symmetrical distance matrix: ");
        if (!TestPhylogenyReconstruction.testBasicSymmetricalDistanceMatrix()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Basic character state matrix: ");
        if (!TestPhylogenyReconstruction.testBasicCharacterStateMatrix()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Symmetrical distance matrix parser: ");
        if (!TestPhylogenyReconstruction.testSymmetricalDistanceMatrixParser()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Neighbor Joining: ");
        if (!TestPhylogenyReconstruction.testNeighborJoining()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Dollo Parsimony: ");
        if (!TestPhylogenyReconstruction.testDolloParsimony()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Dollo Parsimony on non binary trees: ");
        if (!TestPhylogenyReconstruction.testDolloParsimonyOnNonBinaryTree()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        System.out.print("  Fitch Parsimony: ");
        if (!TestPhylogenyReconstruction.testFitchParsimony()) {
            System.out.println("failed.");
            return false;
        }
        System.out.println("OK.");
        return true;
    }

    private static boolean testBasicCharacterStateMatrix() {
        block65: {
            CharacterStateMatrix pivot00;
            BasicCharacterStateMatrix<String> matrix_00;
            block64: {
                BasicCharacterStateMatrix<String> matrix_0;
                block63: {
                    CharacterStateMatrix pivot0;
                    block62: {
                        block61: {
                            CharacterStateMatrix clone00;
                            CharacterStateMatrix clone0;
                            block60: {
                                block59: {
                                    block58: {
                                        BasicCharacterStateMatrix<Integer> matrix_000;
                                        block57: {
                                            block56: {
                                                block55: {
                                                    block54: {
                                                        block53: {
                                                            block52: {
                                                                block51: {
                                                                    block50: {
                                                                        block49: {
                                                                            block48: {
                                                                                block47: {
                                                                                    block46: {
                                                                                        block45: {
                                                                                            block44: {
                                                                                                block43: {
                                                                                                    block42: {
                                                                                                        block41: {
                                                                                                            block40: {
                                                                                                                block39: {
                                                                                                                    block38: {
                                                                                                                        block37: {
                                                                                                                            block36: {
                                                                                                                                block35: {
                                                                                                                                    block34: {
                                                                                                                                        try {
                                                                                                                                            matrix_0 = new BasicCharacterStateMatrix<String>(4, 8);
                                                                                                                                            matrix_00 = new BasicCharacterStateMatrix<String>(4, 8);
                                                                                                                                            matrix_0.setIdentifier(0, "A");
                                                                                                                                            matrix_0.setIdentifier(1, "B");
                                                                                                                                            matrix_0.setIdentifier(2, "C");
                                                                                                                                            matrix_0.setIdentifier(3, "D");
                                                                                                                                            matrix_0.setCharacter(0, "0");
                                                                                                                                            matrix_0.setCharacter(1, "1");
                                                                                                                                            matrix_0.setCharacter(2, "2");
                                                                                                                                            matrix_0.setCharacter(3, "3");
                                                                                                                                            matrix_0.setCharacter(4, "4");
                                                                                                                                            matrix_0.setCharacter(5, "5");
                                                                                                                                            matrix_0.setCharacter(6, "6");
                                                                                                                                            matrix_0.setCharacter(7, "7");
                                                                                                                                            matrix_00.setIdentifier(0, "A");
                                                                                                                                            matrix_00.setIdentifier(1, "B");
                                                                                                                                            matrix_00.setIdentifier(2, "C");
                                                                                                                                            matrix_00.setIdentifier(3, "D");
                                                                                                                                            matrix_00.setCharacter(3, "3");
                                                                                                                                            matrix_00.setCharacter(4, "4");
                                                                                                                                            if (matrix_0.getCharacter(1).equals("1")) break block34;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        catch (Exception e) {
                                                                                                                                            e.printStackTrace(System.out);
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    if (matrix_0.getIdentifier(0).equals("A")) break block35;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                matrix_0.setState(0, 0, "00");
                                                                                                                                matrix_00.setState(0, 0, "00");
                                                                                                                                if (((String)matrix_0.getState(0, 0)).equals("00")) break block36;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            matrix_0.setState(0, 1, "01");
                                                                                                                            matrix_00.setState(0, 1, "01");
                                                                                                                            if (((String)matrix_0.getState(0, 1)).equals("01")) break block37;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        matrix_0.setState(1, 1, "11");
                                                                                                                        matrix_00.setState(1, 1, "11");
                                                                                                                        if (((String)matrix_0.getState(1, 1)).equals("11")) break block38;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    matrix_0.setState(1, 0, "10");
                                                                                                                    matrix_00.setState(1, 0, "10");
                                                                                                                    if (((String)matrix_0.getState(1, 0)).equals("10")) break block39;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                matrix_0.setState(1, 2, "12");
                                                                                                                matrix_00.setState(1, 2, "12");
                                                                                                                if (((String)matrix_0.getState(1, 2)).equals("12")) break block40;
                                                                                                                return false;
                                                                                                            }
                                                                                                            matrix_0.setState(3, 7, "37");
                                                                                                            matrix_00.setState(3, 7, "37");
                                                                                                            if (((String)matrix_0.getState(3, 7)).equals("37")) break block41;
                                                                                                            return false;
                                                                                                        }
                                                                                                        matrix_0.setState(2, 6, "26");
                                                                                                        matrix_00.setState(2, 6, "26");
                                                                                                        if (((String)matrix_0.getState(2, 6)).equals("26")) break block42;
                                                                                                        return false;
                                                                                                    }
                                                                                                    matrix_0.setState("D", "3", "33");
                                                                                                    matrix_00.setState("D", "3", "33");
                                                                                                    if (((String)matrix_0.getState(3, 3)).equals("33")) break block43;
                                                                                                    return false;
                                                                                                }
                                                                                                if (((String)matrix_0.getState("D", "3")).equals("33")) break block44;
                                                                                                return false;
                                                                                            }
                                                                                            matrix_0.setState("C", "4", "24");
                                                                                            matrix_00.setState("C", "4", "24");
                                                                                            if (((String)matrix_0.getState(2, 4)).equals("24")) break block45;
                                                                                            return false;
                                                                                        }
                                                                                        if (((String)matrix_0.getState("C", "4")).equals("24")) break block46;
                                                                                        return false;
                                                                                    }
                                                                                    if (!matrix_0.isEmpty()) break block47;
                                                                                    return false;
                                                                                }
                                                                                if (matrix_0.getNumberOfIdentifiers() == 4) break block48;
                                                                                return false;
                                                                            }
                                                                            if (matrix_0.getNumberOfCharacters() == 8) break block49;
                                                                            return false;
                                                                        }
                                                                        if (((Object)matrix_0).equals(matrix_0)) break block50;
                                                                        return false;
                                                                    }
                                                                    if (((Object)matrix_0).equals(matrix_00)) break block51;
                                                                    return false;
                                                                }
                                                                matrix_00.setState("C", "4", "123");
                                                                if (!((Object)matrix_0).equals(matrix_00)) break block52;
                                                                return false;
                                                            }
                                                            Integer[][] ints = new Integer[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}};
                                                            matrix_000 = new BasicCharacterStateMatrix<Integer>(ints);
                                                            matrix_000.toString();
                                                            if (matrix_000.getNumberOfCharacters() == 4) break block53;
                                                            return false;
                                                        }
                                                        if (matrix_000.getNumberOfIdentifiers() == 3) break block54;
                                                        return false;
                                                    }
                                                    if ((Integer)matrix_000.getState(0, 1) == 2) break block55;
                                                    return false;
                                                }
                                                if ((Integer)matrix_000.getState(2, 3) == 12) break block56;
                                                return false;
                                            }
                                            Integer[][] ints0 = new Integer[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}};
                                            BasicCharacterStateMatrix<Integer> matrix_0000 = new BasicCharacterStateMatrix<Integer>(ints0);
                                            if (((Object)matrix_000).equals(matrix_0000)) break block57;
                                            return false;
                                        }
                                        Integer[][] ints00 = new Integer[][]{{1, 2, 3, -4}, {5, 6, 7, 8}, {9, 10, 11, 12}};
                                        BasicCharacterStateMatrix<Integer> matrix_00000 = new BasicCharacterStateMatrix<Integer>(ints00);
                                        if (!((Object)matrix_000).equals(matrix_00000)) break block58;
                                        return false;
                                    }
                                    clone0 = matrix_0.copy();
                                    clone00 = matrix_00.copy();
                                    if (clone0.equals(matrix_0)) break block59;
                                    return false;
                                }
                                if (clone00.equals(matrix_00)) break block60;
                                return false;
                            }
                            if (!clone00.equals(clone0)) break block61;
                            return false;
                        }
                        pivot0 = matrix_0.pivot();
                        pivot00 = matrix_00.pivot();
                        if (((String)pivot0.getState(1, 0)).equals("01")) break block62;
                        return false;
                    }
                    if (((String)pivot0.getState(6, 2)).equals("26")) break block63;
                    return false;
                }
                if (((String)matrix_0.getState(2, 6)).equals("26")) break block64;
                return false;
            }
            CharacterStateMatrix pivotpivot00 = pivot00.pivot();
            if (pivotpivot00.equals(matrix_00)) break block65;
            return false;
        }
        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> nex = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(4, 3);
        nex.setIdentifier(0, "amphioxus");
        nex.setIdentifier(1, "sponge");
        nex.setIdentifier(2, "sea_anemone");
        nex.setIdentifier(3, "cobra");
        nex.setCharacter(0, "notch");
        nex.setCharacter(1, "homeobox");
        nex.setCharacter(2, "wnt");
        nex.setState(0, 0, CharacterStateMatrix.BinaryStates.ABSENT);
        nex.setState(0, 1, CharacterStateMatrix.BinaryStates.ABSENT);
        nex.setState(0, 2, CharacterStateMatrix.BinaryStates.ABSENT);
        nex.setState(1, 0, CharacterStateMatrix.BinaryStates.PRESENT);
        nex.setState(1, 1, CharacterStateMatrix.BinaryStates.PRESENT);
        nex.setState(1, 2, CharacterStateMatrix.BinaryStates.ABSENT);
        nex.setState(2, 0, CharacterStateMatrix.BinaryStates.PRESENT);
        nex.setState(2, 1, CharacterStateMatrix.BinaryStates.PRESENT);
        nex.setState(2, 2, CharacterStateMatrix.BinaryStates.PRESENT);
        nex.setState(3, 0, CharacterStateMatrix.BinaryStates.PRESENT);
        nex.setState(3, 1, CharacterStateMatrix.BinaryStates.ABSENT);
        nex.setState(3, 2, CharacterStateMatrix.BinaryStates.ABSENT);
        StringWriter w = new StringWriter();
        nex.toWriter(w, CharacterStateMatrix.Format.NEXUS_BINARY);
        w = new StringWriter();
        nex.pivot().toWriter(w, CharacterStateMatrix.Format.NEXUS_BINARY);
        return true;
    }

    private static boolean testBasicSymmetricalDistanceMatrix() {
        BasicSymmetricalDistanceMatrix matrix_0;
        block39: {
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        block31: {
                                            block30: {
                                                block29: {
                                                    block28: {
                                                        block27: {
                                                            block26: {
                                                                block25: {
                                                                    block24: {
                                                                        block23: {
                                                                            block22: {
                                                                                block21: {
                                                                                    try {
                                                                                        matrix_0 = new BasicSymmetricalDistanceMatrix(4);
                                                                                        matrix_0.setIdentifier(0, "A");
                                                                                        matrix_0.setIdentifier(1, "B");
                                                                                        matrix_0.setIdentifier(2, "C");
                                                                                        matrix_0.setIdentifier(3, "0123456789012");
                                                                                        matrix_0.setValue(1, 0, 1.0E-5);
                                                                                        matrix_0.setValue(0, 2, 9.0E-7);
                                                                                        matrix_0.setValue(3, 0, 3.0);
                                                                                        matrix_0.setValue(1, 2, 4.0);
                                                                                        matrix_0.setValue(3, 1, 5.0);
                                                                                        matrix_0.setValue(2, 3, 6.0);
                                                                                        if (matrix_0.getIdentifier(0).equals("A")) break block21;
                                                                                        return false;
                                                                                    }
                                                                                    catch (Exception e) {
                                                                                        e.printStackTrace(System.out);
                                                                                        return false;
                                                                                    }
                                                                                }
                                                                                if (matrix_0.getIdentifier(1).equals("B")) break block22;
                                                                                return false;
                                                                            }
                                                                            if (matrix_0.getIdentifier(2).equals("C")) break block23;
                                                                            return false;
                                                                        }
                                                                        if (matrix_0.getIdentifier(3).equals("0123456789012")) break block24;
                                                                        return false;
                                                                    }
                                                                    if (matrix_0.getSize() == 4) break block25;
                                                                    return false;
                                                                }
                                                                if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(0, 0), 0.0)) break block26;
                                                                return false;
                                                            }
                                                            if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(3, 3), 0.0)) break block27;
                                                            return false;
                                                        }
                                                        if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(0, 1), 1.0E-5)) break block28;
                                                        return false;
                                                    }
                                                    if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(0, 2), 9.0E-7)) break block29;
                                                    return false;
                                                }
                                                if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(0, 3), 3.0)) break block30;
                                                return false;
                                            }
                                            if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(1, 0), 1.0E-5)) break block31;
                                            return false;
                                        }
                                        if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(1, 2), 4.0)) break block32;
                                        return false;
                                    }
                                    if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(1, 3), 5.0)) break block33;
                                    return false;
                                }
                                if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(2, 0), 9.0E-7)) break block34;
                                return false;
                            }
                            if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(2, 1), 4.0)) break block35;
                            return false;
                        }
                        if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(2, 3), 6.0)) break block36;
                        return false;
                    }
                    if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(3, 0), 3.0)) break block37;
                    return false;
                }
                if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(3, 1), 5.0)) break block38;
                return false;
            }
            if (TestPhylogenyReconstruction.isEqual(matrix_0.getValue(3, 2), 6.0)) break block39;
            return false;
        }
        StringBuffer matrix_0_phylip = new StringBuffer();
        matrix_0_phylip.append("    4");
        matrix_0_phylip.append(ForesterUtil.LINE_SEPARATOR);
        matrix_0_phylip.append("A           0.000000  0.000010  0.000001  3.000000");
        matrix_0_phylip.append(ForesterUtil.LINE_SEPARATOR);
        matrix_0_phylip.append("B           0.000010  0.000000  4.000000  5.000000");
        matrix_0_phylip.append(ForesterUtil.LINE_SEPARATOR);
        matrix_0_phylip.append("C           0.000001  4.000000  0.000000  6.000000");
        matrix_0_phylip.append(ForesterUtil.LINE_SEPARATOR);
        matrix_0_phylip.append("0123456789  3.000000  5.000000  6.000000  0.000000");
        return matrix_0_phylip.toString().equals(matrix_0.toStringBuffer(DistanceMatrix.Format.PHYLIP).toString());
    }

    private static boolean testDolloParsimony() {
        DolloParsimony dollo10;
        block135: {
            CharacterStateMatrix.BinaryStates ABSENT;
            CharacterStateMatrix.BinaryStates PRESENT;
            block134: {
                DolloParsimony dollo9;
                block133: {
                    BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m1;
                    block132: {
                        CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m;
                        CharacterStateMatrix.GainLossStates UNCHANGED_PRESENT;
                        block131: {
                            CharacterStateMatrix<CharacterStateMatrix.BinaryStates> i_m;
                            block130: {
                                block129: {
                                    block128: {
                                        block127: {
                                            block126: {
                                                block125: {
                                                    block124: {
                                                        block123: {
                                                            block122: {
                                                                block121: {
                                                                    block120: {
                                                                        block119: {
                                                                            block118: {
                                                                                block117: {
                                                                                    block116: {
                                                                                        block115: {
                                                                                            block114: {
                                                                                                block113: {
                                                                                                    block112: {
                                                                                                        block111: {
                                                                                                            block110: {
                                                                                                                block109: {
                                                                                                                    block108: {
                                                                                                                        block107: {
                                                                                                                            block106: {
                                                                                                                                block105: {
                                                                                                                                    block104: {
                                                                                                                                        block103: {
                                                                                                                                            block102: {
                                                                                                                                                block101: {
                                                                                                                                                    block100: {
                                                                                                                                                        block99: {
                                                                                                                                                            block98: {
                                                                                                                                                                block97: {
                                                                                                                                                                    block96: {
                                                                                                                                                                        block95: {
                                                                                                                                                                            block94: {
                                                                                                                                                                                block93: {
                                                                                                                                                                                    block92: {
                                                                                                                                                                                        block91: {
                                                                                                                                                                                            block90: {
                                                                                                                                                                                                block89: {
                                                                                                                                                                                                    block88: {
                                                                                                                                                                                                        block87: {
                                                                                                                                                                                                            block86: {
                                                                                                                                                                                                                block85: {
                                                                                                                                                                                                                    block84: {
                                                                                                                                                                                                                        block83: {
                                                                                                                                                                                                                            DolloParsimony dollo2;
                                                                                                                                                                                                                            block82: {
                                                                                                                                                                                                                                block81: {
                                                                                                                                                                                                                                    block80: {
                                                                                                                                                                                                                                        DolloParsimony dollo1;
                                                                                                                                                                                                                                        block79: {
                                                                                                                                                                                                                                            block78: {
                                                                                                                                                                                                                                                Phylogeny p1;
                                                                                                                                                                                                                                                block77: {
                                                                                                                                                                                                                                                    block76: {
                                                                                                                                                                                                                                                        block75: {
                                                                                                                                                                                                                                                            block74: {
                                                                                                                                                                                                                                                                block73: {
                                                                                                                                                                                                                                                                    block72: {
                                                                                                                                                                                                                                                                        block71: {
                                                                                                                                                                                                                                                                            block70: {
                                                                                                                                                                                                                                                                                block69: {
                                                                                                                                                                                                                                                                                    try {
                                                                                                                                                                                                                                                                                        PRESENT = CharacterStateMatrix.BinaryStates.PRESENT;
                                                                                                                                                                                                                                                                                        ABSENT = CharacterStateMatrix.BinaryStates.ABSENT;
                                                                                                                                                                                                                                                                                        UNCHANGED_PRESENT = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
                                                                                                                                                                                                                                                                                        dollo1 = DolloParsimony.createInstance();
                                                                                                                                                                                                                                                                                        PhylogenyFactory factory1 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                                                                        String p1_str = "((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r";
                                                                                                                                                                                                                                                                                        p1 = factory1.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r", new NHXParser())[0];
                                                                                                                                                                                                                                                                                        m1 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(9, 1);
                                                                                                                                                                                                                                                                                        m1.setIdentifier(0, "a");
                                                                                                                                                                                                                                                                                        m1.setIdentifier(1, "b");
                                                                                                                                                                                                                                                                                        m1.setIdentifier(2, "c");
                                                                                                                                                                                                                                                                                        m1.setIdentifier(3, "d");
                                                                                                                                                                                                                                                                                        m1.setIdentifier(4, "e");
                                                                                                                                                                                                                                                                                        m1.setIdentifier(5, "f");
                                                                                                                                                                                                                                                                                        m1.setIdentifier(6, "g");
                                                                                                                                                                                                                                                                                        m1.setIdentifier(7, "h");
                                                                                                                                                                                                                                                                                        m1.setIdentifier(8, "i");
                                                                                                                                                                                                                                                                                        m1.setCharacter(0, "0");
                                                                                                                                                                                                                                                                                        m1.setState("a", "0", PRESENT);
                                                                                                                                                                                                                                                                                        m1.setState("b", "0", ABSENT);
                                                                                                                                                                                                                                                                                        m1.setState("c", "0", PRESENT);
                                                                                                                                                                                                                                                                                        m1.setState("d", "0", ABSENT);
                                                                                                                                                                                                                                                                                        m1.setState("e", "0", ABSENT);
                                                                                                                                                                                                                                                                                        m1.setState("f", "0", ABSENT);
                                                                                                                                                                                                                                                                                        m1.setState("g", "0", ABSENT);
                                                                                                                                                                                                                                                                                        m1.setState("h", "0", ABSENT);
                                                                                                                                                                                                                                                                                        m1.setState("i", "0", ABSENT);
                                                                                                                                                                                                                                                                                        dollo1.execute(p1, m1);
                                                                                                                                                                                                                                                                                        if (dollo1.getTotalGains() == 1) break block69;
                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    catch (Exception e) {
                                                                                                                                                                                                                                                                                        e.printStackTrace(System.out);
                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (dollo1.getTotalLosses() == 1) break block70;
                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (dollo1.getTotalUnchanged() == 15) break block71;
                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        m1.setState("b", "0", PRESENT);
                                                                                                                                                                                                                                                                        dollo1.execute(p1, m1);
                                                                                                                                                                                                                                                                        if (dollo1.getTotalGains() == 1) break block72;
                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (dollo1.getTotalLosses() == 0) break block73;
                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (dollo1.getTotalUnchanged() == 16) break block74;
                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            m1.setState("b", "0", ABSENT);
                                                                                                                                                                                                                                                            m1.setState("e", "0", PRESENT);
                                                                                                                                                                                                                                                            dollo1.execute(p1, m1);
                                                                                                                                                                                                                                                            if (dollo1.getTotalGains() == 1) break block75;
                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (dollo1.getTotalLosses() == 3) break block76;
                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (dollo1.getTotalUnchanged() == 13) break block77;
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                m1.setState("a", "0", ABSENT);
                                                                                                                                                                                                                                                m1.setState("c", "0", ABSENT);
                                                                                                                                                                                                                                                m1.setState("g", "0", PRESENT);
                                                                                                                                                                                                                                                dollo1.setReturnInternalStates(true);
                                                                                                                                                                                                                                                dollo1.setReturnGainLossMatrix(true);
                                                                                                                                                                                                                                                dollo1.execute(p1, m1);
                                                                                                                                                                                                                                                if (dollo1.getTotalGains() == 1) break block78;
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (dollo1.getTotalLosses() == 3) break block79;
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (dollo1.getTotalUnchanged() == 13) break block80;
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    dollo2 = DolloParsimony.createInstance();
                                                                                                                                                                                                                                    PhylogenyFactory factory2 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                    String p2_str = "((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h,i)gi)ai,((j,k,l)jl,(m,n,o)mo,(p,q,r)pr)jr)root";
                                                                                                                                                                                                                                    Phylogeny p2 = factory2.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h,i)gi)ai,((j,k,l)jl,(m,n,o)mo,(p,q,r)pr)jr)root", new NHXParser())[0];
                                                                                                                                                                                                                                    BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m2 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(18, 4);
                                                                                                                                                                                                                                    m2.setIdentifier(0, "a");
                                                                                                                                                                                                                                    m2.setIdentifier(1, "b");
                                                                                                                                                                                                                                    m2.setIdentifier(2, "c");
                                                                                                                                                                                                                                    m2.setIdentifier(3, "d");
                                                                                                                                                                                                                                    m2.setIdentifier(4, "e");
                                                                                                                                                                                                                                    m2.setIdentifier(5, "f");
                                                                                                                                                                                                                                    m2.setIdentifier(6, "g");
                                                                                                                                                                                                                                    m2.setIdentifier(7, "h");
                                                                                                                                                                                                                                    m2.setIdentifier(8, "i");
                                                                                                                                                                                                                                    m2.setIdentifier(9, "j");
                                                                                                                                                                                                                                    m2.setIdentifier(10, "k");
                                                                                                                                                                                                                                    m2.setIdentifier(11, "l");
                                                                                                                                                                                                                                    m2.setIdentifier(12, "m");
                                                                                                                                                                                                                                    m2.setIdentifier(13, "n");
                                                                                                                                                                                                                                    m2.setIdentifier(14, "o");
                                                                                                                                                                                                                                    m2.setIdentifier(15, "p");
                                                                                                                                                                                                                                    m2.setIdentifier(16, "q");
                                                                                                                                                                                                                                    m2.setIdentifier(17, "r");
                                                                                                                                                                                                                                    m2.setCharacter(0, "0");
                                                                                                                                                                                                                                    m2.setCharacter(1, "1");
                                                                                                                                                                                                                                    m2.setCharacter(2, "2");
                                                                                                                                                                                                                                    m2.setCharacter(3, "3");
                                                                                                                                                                                                                                    m2.setState("a", "0", PRESENT);
                                                                                                                                                                                                                                    m2.setState("b", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("c", "0", PRESENT);
                                                                                                                                                                                                                                    m2.setState("d", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("e", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("f", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("g", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("h", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("i", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("j", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("k", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("l", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("m", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("n", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("o", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("p", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("q", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("r", "0", ABSENT);
                                                                                                                                                                                                                                    m2.setState("a", "1", PRESENT);
                                                                                                                                                                                                                                    m2.setState("b", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("c", "1", PRESENT);
                                                                                                                                                                                                                                    m2.setState("d", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("e", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("f", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("g", "1", PRESENT);
                                                                                                                                                                                                                                    m2.setState("h", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("i", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("j", "1", PRESENT);
                                                                                                                                                                                                                                    m2.setState("k", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("l", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("m", "1", PRESENT);
                                                                                                                                                                                                                                    m2.setState("n", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("o", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("p", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("q", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("r", "1", ABSENT);
                                                                                                                                                                                                                                    m2.setState("a", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("b", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("c", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("d", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("e", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("f", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("g", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("h", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("i", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("j", "2", PRESENT);
                                                                                                                                                                                                                                    m2.setState("k", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("l", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("m", "2", PRESENT);
                                                                                                                                                                                                                                    m2.setState("n", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("o", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("p", "2", PRESENT);
                                                                                                                                                                                                                                    m2.setState("q", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("r", "2", ABSENT);
                                                                                                                                                                                                                                    m2.setState("a", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("b", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("c", "3", PRESENT);
                                                                                                                                                                                                                                    m2.setState("d", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("e", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("f", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("g", "3", PRESENT);
                                                                                                                                                                                                                                    m2.setState("h", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("i", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("j", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("k", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("l", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("m", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("n", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("o", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("p", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("q", "3", ABSENT);
                                                                                                                                                                                                                                    m2.setState("r", "3", ABSENT);
                                                                                                                                                                                                                                    dollo2.setReturnInternalStates(true);
                                                                                                                                                                                                                                    dollo2.setReturnGainLossMatrix(true);
                                                                                                                                                                                                                                    dollo2.execute(p2, m2);
                                                                                                                                                                                                                                    i_m = dollo2.getInternalStatesMatrix();
                                                                                                                                                                                                                                    gl_m = dollo2.getGainLossMatrix();
                                                                                                                                                                                                                                    if (dollo2.getTotalGains() == 3) break block81;
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (dollo2.getTotalLosses() == 22) break block82;
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (dollo2.getTotalUnchanged() == 95) break block83;
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (i_m.getState("ab", "0") == PRESENT) break block84;
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (i_m.getState("ac", "0") == PRESENT) break block85;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (i_m.getState("ad", "0") == ABSENT) break block86;
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (i_m.getState("af", "0") == ABSENT) break block87;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (i_m.getState("ef", "0") == ABSENT) break block88;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (i_m.getState("ai", "0") == ABSENT) break block89;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (i_m.getState("gi", "0") == ABSENT) break block90;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (i_m.getState("jl", "0") == ABSENT) break block91;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (i_m.getState("mo", "0") == ABSENT) break block92;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (i_m.getState("pr", "0") == ABSENT) break block93;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                if (i_m.getState("jr", "0") == ABSENT) break block94;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            if (i_m.getState("root", "0") == ABSENT) break block95;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (i_m.getState("ab", "1") == PRESENT) break block96;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (i_m.getState("ac", "1") == PRESENT) break block97;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (i_m.getState("ad", "1") == PRESENT) break block98;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (i_m.getState("af", "1") == PRESENT) break block99;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (i_m.getState("ef", "1") == ABSENT) break block100;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (i_m.getState("ai", "1") == PRESENT) break block101;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (i_m.getState("gi", "1") == PRESENT) break block102;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (i_m.getState("jl", "1") == PRESENT) break block103;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (i_m.getState("mo", "1") == PRESENT) break block104;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (i_m.getState("pr", "1") == ABSENT) break block105;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (i_m.getState("jr", "1") == PRESENT) break block106;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (i_m.getState("root", "1") == PRESENT) break block107;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (i_m.getState("ab", "2") == ABSENT) break block108;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (i_m.getState("ac", "2") == ABSENT) break block109;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (i_m.getState("ad", "2") == ABSENT) break block110;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (i_m.getState("af", "2") == ABSENT) break block111;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (i_m.getState("ef", "2") == ABSENT) break block112;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (i_m.getState("ai", "2") == ABSENT) break block113;
                                                                                                    return false;
                                                                                                }
                                                                                                if (i_m.getState("gi", "2") == ABSENT) break block114;
                                                                                                return false;
                                                                                            }
                                                                                            if (i_m.getState("jl", "2") == PRESENT) break block115;
                                                                                            return false;
                                                                                        }
                                                                                        if (i_m.getState("mo", "2") == PRESENT) break block116;
                                                                                        return false;
                                                                                    }
                                                                                    if (i_m.getState("pr", "2") == PRESENT) break block117;
                                                                                    return false;
                                                                                }
                                                                                if (i_m.getState("jr", "2") == PRESENT) break block118;
                                                                                return false;
                                                                            }
                                                                            if (i_m.getState("root", "2") == ABSENT) break block119;
                                                                            return false;
                                                                        }
                                                                        if (i_m.getState("ab", "3") == ABSENT) break block120;
                                                                        return false;
                                                                    }
                                                                    if (i_m.getState("ac", "3") == PRESENT) break block121;
                                                                    return false;
                                                                }
                                                                if (i_m.getState("ad", "3") == PRESENT) break block122;
                                                                return false;
                                                            }
                                                            if (i_m.getState("af", "3") == PRESENT) break block123;
                                                            return false;
                                                        }
                                                        if (i_m.getState("ef", "3") == ABSENT) break block124;
                                                        return false;
                                                    }
                                                    if (i_m.getState("ai", "3") == PRESENT) break block125;
                                                    return false;
                                                }
                                                if (i_m.getState("gi", "3") == PRESENT) break block126;
                                                return false;
                                            }
                                            if (i_m.getState("jl", "3") == ABSENT) break block127;
                                            return false;
                                        }
                                        if (i_m.getState("mo", "3") == ABSENT) break block128;
                                        return false;
                                    }
                                    if (i_m.getState("pr", "3") == ABSENT) break block129;
                                    return false;
                                }
                                if (i_m.getState("jr", "3") == ABSENT) break block130;
                                return false;
                            }
                            if (i_m.getState("root", "3") == ABSENT) break block131;
                            return false;
                        }
                        if (gl_m.getState("a", "0") == UNCHANGED_PRESENT) break block132;
                        return false;
                    }
                    dollo9 = DolloParsimony.createInstance();
                    PhylogenyFactory factory9 = ParserBasedPhylogenyFactory.getInstance();
                    String p9_str = "((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r";
                    Phylogeny p9 = factory9.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r", new NHXParser())[0];
                    m1 = new BasicCharacterStateMatrix(9, 3);
                    m1.setIdentifier(0, "a");
                    m1.setIdentifier(1, "b");
                    m1.setIdentifier(2, "c");
                    m1.setIdentifier(3, "d");
                    m1.setIdentifier(4, "e");
                    m1.setIdentifier(5, "f");
                    m1.setIdentifier(6, "g");
                    m1.setIdentifier(7, "h");
                    m1.setIdentifier(8, "i");
                    m1.setState(0, 0, PRESENT);
                    m1.setState(1, 0, ABSENT);
                    m1.setState(2, 0, PRESENT);
                    m1.setState(3, 0, ABSENT);
                    m1.setState(4, 0, ABSENT);
                    m1.setState(5, 0, ABSENT);
                    m1.setState(6, 0, ABSENT);
                    m1.setState(7, 0, ABSENT);
                    m1.setState(8, 0, ABSENT);
                    m1.setState(0, 1, PRESENT);
                    m1.setState(1, 1, PRESENT);
                    m1.setState(2, 1, PRESENT);
                    m1.setState(3, 1, PRESENT);
                    m1.setState(4, 1, ABSENT);
                    m1.setState(5, 1, ABSENT);
                    m1.setState(6, 1, ABSENT);
                    m1.setState(7, 1, ABSENT);
                    m1.setState(8, 1, ABSENT);
                    m1.setState(0, 2, PRESENT);
                    m1.setState(1, 2, ABSENT);
                    m1.setState(2, 2, ABSENT);
                    m1.setState(3, 2, ABSENT);
                    m1.setState(4, 2, ABSENT);
                    m1.setState(5, 2, ABSENT);
                    m1.setState(6, 2, ABSENT);
                    m1.setState(7, 2, PRESENT);
                    m1.setState(8, 2, ABSENT);
                    dollo9.execute(p9, m1);
                    if (dollo9.getTotalGains() == 3) break block133;
                    return false;
                }
                if (dollo9.getTotalLosses() == 6) break block134;
                return false;
            }
            dollo10 = DolloParsimony.createInstance();
            PhylogenyFactory factory10 = ParserBasedPhylogenyFactory.getInstance();
            String p10_str = "((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r";
            Phylogeny p10 = factory10.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r", new NHXParser())[0];
            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m10 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(9, 1);
            m10.setIdentifier(0, "a");
            m10.setIdentifier(1, "b");
            m10.setIdentifier(2, "c");
            m10.setIdentifier(3, "d");
            m10.setIdentifier(4, "e");
            m10.setIdentifier(5, "f");
            m10.setIdentifier(6, "g");
            m10.setIdentifier(7, "h");
            m10.setIdentifier(8, "i");
            m10.setState(0, 0, PRESENT);
            m10.setState(1, 0, ABSENT);
            m10.setState(2, 0, PRESENT);
            m10.setState(3, 0, ABSENT);
            m10.setState(4, 0, ABSENT);
            m10.setState(5, 0, ABSENT);
            m10.setState(6, 0, ABSENT);
            m10.setState(7, 0, ABSENT);
            m10.setState(8, 0, ABSENT);
            dollo10.execute(p10, m10);
            if (dollo10.getTotalGains() == 1) break block135;
            return false;
        }
        return dollo10.getTotalLosses() == 1;
    }

    private static boolean testDolloParsimonyOnNonBinaryTree() {
        CharacterStateMatrix<CharacterStateMatrix.BinaryStates> i_m2;
        CharacterStateMatrix.BinaryStates ABSENT;
        block83: {
            block82: {
                block81: {
                    CharacterStateMatrix.BinaryStates PRESENT;
                    block80: {
                        block79: {
                            DolloParsimony dollo2;
                            block78: {
                                block77: {
                                    block76: {
                                        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m2;
                                        Phylogeny p2;
                                        block75: {
                                            block74: {
                                                block73: {
                                                    block72: {
                                                        block71: {
                                                            block70: {
                                                                block69: {
                                                                    block68: {
                                                                        block67: {
                                                                            block66: {
                                                                                block65: {
                                                                                    block64: {
                                                                                        block63: {
                                                                                            block62: {
                                                                                                block61: {
                                                                                                    block60: {
                                                                                                        block59: {
                                                                                                            block58: {
                                                                                                                block57: {
                                                                                                                    block56: {
                                                                                                                        block55: {
                                                                                                                            block54: {
                                                                                                                                DolloParsimony dollo1;
                                                                                                                                block53: {
                                                                                                                                    block52: {
                                                                                                                                        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m1;
                                                                                                                                        Phylogeny p1;
                                                                                                                                        block51: {
                                                                                                                                            block50: {
                                                                                                                                                block49: {
                                                                                                                                                    block48: {
                                                                                                                                                        block47: {
                                                                                                                                                            block46: {
                                                                                                                                                                block45: {
                                                                                                                                                                    block44: {
                                                                                                                                                                        block43: {
                                                                                                                                                                            try {
                                                                                                                                                                                PRESENT = CharacterStateMatrix.BinaryStates.PRESENT;
                                                                                                                                                                                ABSENT = CharacterStateMatrix.BinaryStates.ABSENT;
                                                                                                                                                                                dollo1 = DolloParsimony.createInstance();
                                                                                                                                                                                PhylogenyFactory factory1 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                String p1_str = "((((((a,b,y)aby,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r";
                                                                                                                                                                                p1 = factory1.create("((((((a,b,y)aby,c)ac,d)ad,(e,f)ef)af,(g,h)gh)ah,i)r", new NHXParser())[0];
                                                                                                                                                                                m1 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(10, 1);
                                                                                                                                                                                m1.setIdentifier(0, "a");
                                                                                                                                                                                m1.setIdentifier(1, "b");
                                                                                                                                                                                m1.setIdentifier(2, "y");
                                                                                                                                                                                m1.setIdentifier(3, "c");
                                                                                                                                                                                m1.setIdentifier(4, "d");
                                                                                                                                                                                m1.setIdentifier(5, "e");
                                                                                                                                                                                m1.setIdentifier(6, "f");
                                                                                                                                                                                m1.setIdentifier(7, "g");
                                                                                                                                                                                m1.setIdentifier(8, "h");
                                                                                                                                                                                m1.setIdentifier(9, "i");
                                                                                                                                                                                m1.setCharacter(0, "0");
                                                                                                                                                                                m1.setState("a", "0", PRESENT);
                                                                                                                                                                                m1.setState("b", "0", ABSENT);
                                                                                                                                                                                m1.setState("y", "0", PRESENT);
                                                                                                                                                                                m1.setState("c", "0", PRESENT);
                                                                                                                                                                                m1.setState("d", "0", ABSENT);
                                                                                                                                                                                m1.setState("e", "0", ABSENT);
                                                                                                                                                                                m1.setState("f", "0", ABSENT);
                                                                                                                                                                                m1.setState("g", "0", ABSENT);
                                                                                                                                                                                m1.setState("h", "0", ABSENT);
                                                                                                                                                                                m1.setState("i", "0", ABSENT);
                                                                                                                                                                                dollo1.execute(p1, m1);
                                                                                                                                                                                if (dollo1.getTotalGains() == 1) break block43;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            catch (Exception e) {
                                                                                                                                                                                e.printStackTrace(System.out);
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                        if (dollo1.getTotalLosses() == 1) break block44;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (dollo1.getTotalUnchanged() == 16) break block45;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                m1.setState("b", "0", PRESENT);
                                                                                                                                                                dollo1.execute(p1, m1);
                                                                                                                                                                if (dollo1.getTotalGains() == 1) break block46;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (dollo1.getTotalLosses() == 0) break block47;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (dollo1.getTotalUnchanged() == 17) break block48;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    m1.setState("a", "0", ABSENT);
                                                                                                                                                    m1.setState("b", "0", ABSENT);
                                                                                                                                                    dollo1.execute(p1, m1);
                                                                                                                                                    if (dollo1.getTotalGains() == 1) break block49;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (dollo1.getTotalLosses() == 2) break block50;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (dollo1.getTotalUnchanged() == 15) break block51;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        m1.setState("y", "0", ABSENT);
                                                                                                                                        dollo1.execute(p1, m1);
                                                                                                                                        if (dollo1.getTotalGains() == 1) break block52;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (dollo1.getTotalLosses() == 0) break block53;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (dollo1.getTotalUnchanged() == 17) break block54;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            dollo2 = DolloParsimony.createInstance();
                                                                                                                            PhylogenyFactory factory2 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                            String p2_str = "((((((a,b,y)aby,c,d)cad,e,f)af,(g,h)gh)ah,i))r";
                                                                                                                            p2 = factory2.create("((((((a,b,y)aby,c,d)cad,e,f)af,(g,h)gh)ah,i))r", new NHXParser())[0];
                                                                                                                            m2 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(10, 1);
                                                                                                                            m2.setIdentifier(0, "a");
                                                                                                                            m2.setIdentifier(1, "b");
                                                                                                                            m2.setIdentifier(2, "y");
                                                                                                                            m2.setIdentifier(3, "c");
                                                                                                                            m2.setIdentifier(4, "d");
                                                                                                                            m2.setIdentifier(5, "e");
                                                                                                                            m2.setIdentifier(6, "f");
                                                                                                                            m2.setIdentifier(7, "g");
                                                                                                                            m2.setIdentifier(8, "h");
                                                                                                                            m2.setIdentifier(9, "i");
                                                                                                                            m2.setCharacter(0, "0");
                                                                                                                            m2.setState("a", "0", PRESENT);
                                                                                                                            m2.setState("b", "0", ABSENT);
                                                                                                                            m2.setState("y", "0", PRESENT);
                                                                                                                            m2.setState("c", "0", PRESENT);
                                                                                                                            m2.setState("d", "0", ABSENT);
                                                                                                                            m2.setState("e", "0", ABSENT);
                                                                                                                            m2.setState("f", "0", ABSENT);
                                                                                                                            m2.setState("g", "0", ABSENT);
                                                                                                                            m2.setState("h", "0", ABSENT);
                                                                                                                            m2.setState("i", "0", ABSENT);
                                                                                                                            dollo2.setReturnInternalStates(true);
                                                                                                                            dollo2.execute(p2, m2);
                                                                                                                            i_m2 = dollo2.getInternalStatesMatrix();
                                                                                                                            if (i_m2.getState("aby", "0") == PRESENT) break block55;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (i_m2.getState("cad", "0") == PRESENT) break block56;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (i_m2.getState("af", "0") == ABSENT) break block57;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (i_m2.getState("gh", "0") == ABSENT) break block58;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (i_m2.getState("ah", "0") == ABSENT) break block59;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (i_m2.getState("r", "0") == ABSENT) break block60;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (dollo2.getTotalGains() == 1) break block61;
                                                                                                    return false;
                                                                                                }
                                                                                                if (dollo2.getTotalLosses() == 2) break block62;
                                                                                                return false;
                                                                                            }
                                                                                            if (dollo2.getTotalUnchanged() == 14) break block63;
                                                                                            return false;
                                                                                        }
                                                                                        m2.setState("b", "0", PRESENT);
                                                                                        dollo2.execute(p2, m2);
                                                                                        if (dollo2.getTotalGains() == 1) break block64;
                                                                                        return false;
                                                                                    }
                                                                                    if (dollo2.getTotalLosses() == 1) break block65;
                                                                                    return false;
                                                                                }
                                                                                if (dollo2.getTotalUnchanged() == 15) break block66;
                                                                                return false;
                                                                            }
                                                                            m2.setState("a", "0", ABSENT);
                                                                            m2.setState("b", "0", ABSENT);
                                                                            dollo2.execute(p2, m2);
                                                                            if (dollo2.getTotalGains() == 1) break block67;
                                                                            return false;
                                                                        }
                                                                        if (dollo2.getTotalLosses() == 3) break block68;
                                                                        return false;
                                                                    }
                                                                    if (dollo2.getTotalUnchanged() == 13) break block69;
                                                                    return false;
                                                                }
                                                                m2.setState("y", "0", ABSENT);
                                                                dollo2.execute(p2, m2);
                                                                if (dollo2.getTotalGains() == 1) break block70;
                                                                return false;
                                                            }
                                                            if (dollo2.getTotalLosses() == 0) break block71;
                                                            return false;
                                                        }
                                                        if (dollo2.getTotalUnchanged() == 16) break block72;
                                                        return false;
                                                    }
                                                    m2.setState("c", "0", ABSENT);
                                                    dollo2.execute(p2, m2);
                                                    if (dollo2.getTotalGains() == 0) break block73;
                                                    return false;
                                                }
                                                if (dollo2.getTotalLosses() == 0) break block74;
                                                return false;
                                            }
                                            if (dollo2.getTotalUnchanged() == 17) break block75;
                                            return false;
                                        }
                                        m2.setState("y", "0", PRESENT);
                                        m2.setState("e", "0", PRESENT);
                                        dollo2.execute(p2, m2);
                                        if (dollo2.getTotalGains() == 1) break block76;
                                        return false;
                                    }
                                    if (dollo2.getTotalLosses() == 5) break block77;
                                    return false;
                                }
                                if (dollo2.getTotalUnchanged() == 11) break block78;
                                return false;
                            }
                            i_m2 = dollo2.getInternalStatesMatrix();
                            if (i_m2.getState("aby", "0") == PRESENT) break block79;
                            return false;
                        }
                        if (i_m2.getState("cad", "0") == PRESENT) break block80;
                        return false;
                    }
                    if (i_m2.getState("af", "0") == PRESENT) break block81;
                    return false;
                }
                if (i_m2.getState("gh", "0") == ABSENT) break block82;
                return false;
            }
            if (i_m2.getState("ah", "0") == ABSENT) break block83;
            return false;
        }
        return i_m2.getState("r", "0") == ABSENT;
    }

    private static boolean testFitchParsimony() {
        CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_10b;
        CharacterStateMatrix.GainLossStates UNCHANGED_ABSENT;
        block377: {
            block376: {
                block375: {
                    block374: {
                        block373: {
                            CharacterStateMatrix.GainLossStates GAIN;
                            block372: {
                                block371: {
                                    block370: {
                                        block369: {
                                            FitchParsimony fitch10;
                                            block368: {
                                                block367: {
                                                    block366: {
                                                        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m10;
                                                        Phylogeny p10;
                                                        block365: {
                                                            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_10a;
                                                            block364: {
                                                                block363: {
                                                                    block362: {
                                                                        block361: {
                                                                            block360: {
                                                                                block359: {
                                                                                    block358: {
                                                                                        block357: {
                                                                                            block356: {
                                                                                                block355: {
                                                                                                    block354: {
                                                                                                        block353: {
                                                                                                            CharacterStateMatrix.BinaryStates ABSENT;
                                                                                                            CharacterStateMatrix.BinaryStates PRESENT;
                                                                                                            block352: {
                                                                                                                FitchParsimony fitch9;
                                                                                                                block351: {
                                                                                                                    block350: {
                                                                                                                        block349: {
                                                                                                                            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m9;
                                                                                                                            Phylogeny p9;
                                                                                                                            block348: {
                                                                                                                                CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_9b;
                                                                                                                                CharacterStateMatrix.GainLossStates UNCHANGED_PRESENT;
                                                                                                                                block347: {
                                                                                                                                    block346: {
                                                                                                                                        block345: {
                                                                                                                                            CharacterStateMatrix.GainLossStates LOSS;
                                                                                                                                            block344: {
                                                                                                                                                block343: {
                                                                                                                                                    block342: {
                                                                                                                                                        block341: {
                                                                                                                                                            block340: {
                                                                                                                                                                block339: {
                                                                                                                                                                    block338: {
                                                                                                                                                                        block337: {
                                                                                                                                                                            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_9a;
                                                                                                                                                                            block336: {
                                                                                                                                                                                block335: {
                                                                                                                                                                                    block334: {
                                                                                                                                                                                        block333: {
                                                                                                                                                                                            block332: {
                                                                                                                                                                                                block331: {
                                                                                                                                                                                                    block330: {
                                                                                                                                                                                                        block329: {
                                                                                                                                                                                                            block328: {
                                                                                                                                                                                                                block327: {
                                                                                                                                                                                                                    block326: {
                                                                                                                                                                                                                        CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_8;
                                                                                                                                                                                                                        block325: {
                                                                                                                                                                                                                            block324: {
                                                                                                                                                                                                                                FitchParsimony fitch8;
                                                                                                                                                                                                                                block323: {
                                                                                                                                                                                                                                    block322: {
                                                                                                                                                                                                                                        block321: {
                                                                                                                                                                                                                                            block320: {
                                                                                                                                                                                                                                                CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_71;
                                                                                                                                                                                                                                                block319: {
                                                                                                                                                                                                                                                    block318: {
                                                                                                                                                                                                                                                        block317: {
                                                                                                                                                                                                                                                            block316: {
                                                                                                                                                                                                                                                                block315: {
                                                                                                                                                                                                                                                                    FitchParsimony fitch7;
                                                                                                                                                                                                                                                                    block314: {
                                                                                                                                                                                                                                                                        block313: {
                                                                                                                                                                                                                                                                            block312: {
                                                                                                                                                                                                                                                                                BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m7;
                                                                                                                                                                                                                                                                                Phylogeny p7;
                                                                                                                                                                                                                                                                                block311: {
                                                                                                                                                                                                                                                                                    CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_7;
                                                                                                                                                                                                                                                                                    block310: {
                                                                                                                                                                                                                                                                                        block309: {
                                                                                                                                                                                                                                                                                            block308: {
                                                                                                                                                                                                                                                                                                block307: {
                                                                                                                                                                                                                                                                                                    block306: {
                                                                                                                                                                                                                                                                                                        block305: {
                                                                                                                                                                                                                                                                                                            block304: {
                                                                                                                                                                                                                                                                                                                block303: {
                                                                                                                                                                                                                                                                                                                    block302: {
                                                                                                                                                                                                                                                                                                                        CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_6;
                                                                                                                                                                                                                                                                                                                        block301: {
                                                                                                                                                                                                                                                                                                                            block300: {
                                                                                                                                                                                                                                                                                                                                block299: {
                                                                                                                                                                                                                                                                                                                                    block298: {
                                                                                                                                                                                                                                                                                                                                        FitchParsimony fitch6;
                                                                                                                                                                                                                                                                                                                                        block297: {
                                                                                                                                                                                                                                                                                                                                            block296: {
                                                                                                                                                                                                                                                                                                                                                block295: {
                                                                                                                                                                                                                                                                                                                                                    block294: {
                                                                                                                                                                                                                                                                                                                                                        CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_5;
                                                                                                                                                                                                                                                                                                                                                        block293: {
                                                                                                                                                                                                                                                                                                                                                            block292: {
                                                                                                                                                                                                                                                                                                                                                                block291: {
                                                                                                                                                                                                                                                                                                                                                                    block290: {
                                                                                                                                                                                                                                                                                                                                                                        block289: {
                                                                                                                                                                                                                                                                                                                                                                            FitchParsimony fitch5;
                                                                                                                                                                                                                                                                                                                                                                            block288: {
                                                                                                                                                                                                                                                                                                                                                                                block287: {
                                                                                                                                                                                                                                                                                                                                                                                    block286: {
                                                                                                                                                                                                                                                                                                                                                                                        block285: {
                                                                                                                                                                                                                                                                                                                                                                                            CharacterStateMatrix<CharacterStateMatrix.GainLossStates> gl_m_4;
                                                                                                                                                                                                                                                                                                                                                                                            block284: {
                                                                                                                                                                                                                                                                                                                                                                                                block283: {
                                                                                                                                                                                                                                                                                                                                                                                                    block282: {
                                                                                                                                                                                                                                                                                                                                                                                                        block281: {
                                                                                                                                                                                                                                                                                                                                                                                                            block280: {
                                                                                                                                                                                                                                                                                                                                                                                                                FitchParsimony fitch4;
                                                                                                                                                                                                                                                                                                                                                                                                                block279: {
                                                                                                                                                                                                                                                                                                                                                                                                                    block278: {
                                                                                                                                                                                                                                                                                                                                                                                                                        block277: {
                                                                                                                                                                                                                                                                                                                                                                                                                            block276: {
                                                                                                                                                                                                                                                                                                                                                                                                                                CharacterStateMatrix i_m_all3;
                                                                                                                                                                                                                                                                                                                                                                                                                                block275: {
                                                                                                                                                                                                                                                                                                                                                                                                                                    block274: {
                                                                                                                                                                                                                                                                                                                                                                                                                                        block273: {
                                                                                                                                                                                                                                                                                                                                                                                                                                            block272: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                block271: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    block270: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        block269: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            block268: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                block267: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block266: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block265: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block264: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block263: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block262: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block261: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            CharacterStateMatrix i_m3;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block260: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block259: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block258: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block257: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block256: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block255: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CharacterStateMatrix i_m_all21;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block254: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block253: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block252: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block251: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CharacterStateMatrix i_m21;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block250: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block249: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block248: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block247: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    BasicCharacterStateMatrix<String> m2;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Phylogeny p2;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    FitchParsimony fitch2;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block246: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        CharacterStateMatrix i_m_all2;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block245: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block244: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block243: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block242: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block241: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block240: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block239: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CharacterStateMatrix i_m2;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block238: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block237: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block236: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block235: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block234: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        CharacterStateMatrix i_m_all;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block233: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block232: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block231: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block230: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block229: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block228: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block227: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block226: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block225: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block224: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block223: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block222: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block221: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block220: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block219: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block218: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block217: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block216: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block215: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block214: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block213: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block212: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block211: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block210: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block209: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block208: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block207: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block206: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block205: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block204: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block203: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block202: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block201: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block200: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block199: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CharacterStateMatrix i_m;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block198: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block197: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block196: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block195: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block194: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block193: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block192: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block191: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block190: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        try {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            PRESENT = CharacterStateMatrix.BinaryStates.PRESENT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ABSENT = CharacterStateMatrix.BinaryStates.ABSENT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            GAIN = CharacterStateMatrix.GainLossStates.GAIN;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            LOSS = CharacterStateMatrix.GainLossStates.LOSS;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            UNCHANGED_PRESENT = CharacterStateMatrix.GainLossStates.UNCHANGED_PRESENT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            UNCHANGED_ABSENT = CharacterStateMatrix.GainLossStates.UNCHANGED_ABSENT;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            FitchParsimony fitch1 = new FitchParsimony();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            PhylogenyFactory factory1 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            String p1_str = "((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h,i)gi)ai,((j,k,l)jl,(m,n,o)mo,(p,q,r)pr)jr)root";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Phylogeny p1 = factory1.create("((((((a,b)ab,c)ac,d)ad,(e,f)ef)af,(g,h,i)gi)ai,((j,k,l)jl,(m,n,o)mo,(p,q,r)pr)jr)root", new NHXParser())[0];
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BasicCharacterStateMatrix<String> m1 = new BasicCharacterStateMatrix<String>(18, 1);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(0, "a");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(1, "b");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(2, "c");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(3, "d");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(4, "e");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(5, "f");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(6, "g");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(7, "h");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(8, "i");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(9, "j");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(10, "k");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(11, "l");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(12, "m");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(13, "n");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(14, "o");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(15, "p");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(16, "q");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setIdentifier(17, "r");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setCharacter(0, "0");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("a", "0", "A");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("b", "0", "A");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("c", "0", "B");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("d", "0", "C");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("e", "0", "D");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("f", "0", "A");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("g", "0", "A");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("h", "0", "B");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("i", "0", "C");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("j", "0", "A");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("k", "0", "B");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("l", "0", "C");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("m", "0", "B");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("n", "0", "B");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("o", "0", "B");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("p", "0", "A");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("q", "0", "C");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            m1.setState("r", "0", "D");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            fitch1.setReturnInternalStates(true);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            fitch1.setReturnGainLossMatrix(false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            fitch1.setRandomize(false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            fitch1.execute(p1, m1);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            i_m = fitch1.getInternalStatesMatrix();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            i_m_all = fitch1.getInternalStatesMatrixPriorToTraceback();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (fitch1.getCost() == 10) break block190;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        catch (Exception e) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            e.printStackTrace(System.out);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (((String)i_m.getState("ab", "0")).equals("A")) break block191;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (((String)i_m.getState("ac", "0")).equals("A")) break block192;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (((String)i_m.getState("ad", "0")).equals("A")) break block193;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (((String)i_m.getState("ef", "0")).equals("A")) break block194;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (((String)i_m.getState("ai", "0")).equals("A")) break block195;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (((String)i_m.getState("gi", "0")).equals("A")) break block196;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (((String)i_m.getState("jl", "0")).equals("A")) break block197;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (((String)i_m.getState("mo", "0")).equals("B")) break block198;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (((String)i_m.getState("pr", "0")).equals("A")) break block199;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all.getState("ab", "0").size() == 1) break block200;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all.getState("ab", "0").contains("A")) break block201;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all.getState("ac", "0").size() == 2) break block202;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all.getState("ac", "0").contains("A")) break block203;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all.getState("ac", "0").contains("B")) break block204;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all.getState("ad", "0").size() == 3) break block205;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all.getState("ad", "0").contains("A")) break block206;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all.getState("ad", "0").contains("B")) break block207;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all.getState("ad", "0").contains("C")) break block208;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all.getState("af", "0").size() == 1) break block209;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all.getState("af", "0").contains("A")) break block210;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all.getState("ef", "0").size() == 2) break block211;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all.getState("ef", "0").contains("A")) break block212;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all.getState("ef", "0").contains("D")) break block213;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all.getState("gi", "0").size() == 3) break block214;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all.getState("gi", "0").contains("A")) break block215;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all.getState("gi", "0").contains("B")) break block216;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all.getState("gi", "0").contains("C")) break block217;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all.getState("ai", "0").size() == 1) break block218;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all.getState("ai", "0").contains("A")) break block219;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all.getState("jl", "0").size() == 3) break block220;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all.getState("jl", "0").contains("A")) break block221;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all.getState("jl", "0").contains("B")) break block222;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all.getState("jl", "0").contains("C")) break block223;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all.getState("mo", "0").size() == 1) break block224;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all.getState("mo", "0").contains("B")) break block225;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all.getState("pr", "0").size() == 3) break block226;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all.getState("pr", "0").contains("A")) break block227;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all.getState("pr", "0").contains("C")) break block228;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all.getState("pr", "0").contains("D")) break block229;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all.getState("jr", "0").size() == 4) break block230;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all.getState("jr", "0").contains("A")) break block231;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all.getState("jr", "0").contains("B")) break block232;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all.getState("jr", "0").contains("C")) break block233;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all.getState("jr", "0").contains("D")) break block234;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    fitch2 = new FitchParsimony();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    PhylogenyFactory factory2 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    String p2_str = "((a,b)ab,(c,(d,e)de)cde)r";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    p2 = factory2.create("((a,b)ab,(c,(d,e)de)cde)r", new NHXParser())[0];
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m2 = new BasicCharacterStateMatrix<String>(5, 1);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m2.setIdentifier(0, "a");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m2.setIdentifier(1, "b");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m2.setIdentifier(2, "c");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m2.setIdentifier(3, "d");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m2.setIdentifier(4, "e");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m2.setCharacter(0, "0");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m2.setState("a", "0", "C");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m2.setState("b", "0", "A");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m2.setState("c", "0", "C");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m2.setState("d", "0", "A");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    m2.setState("e", "0", "G");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    fitch2.setReturnInternalStates(true);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    fitch2.setReturnGainLossMatrix(false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    fitch2.execute(p2, m2);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    i_m2 = fitch2.getInternalStatesMatrix();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    i_m_all2 = fitch2.getInternalStatesMatrixPriorToTraceback();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (fitch2.getCost() == 3) break block235;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (((String)i_m2.getState("ab", "0")).equals("A")) break block236;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (((String)i_m2.getState("de", "0")).equals("A")) break block237;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (((String)i_m2.getState("cde", "0")).equals("A")) break block238;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (((String)i_m2.getState("r", "0")).equals("A")) break block239;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all2.getState("cde", "0").size() == 3) break block240;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all2.getState("cde", "0").contains("A")) break block241;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all2.getState("cde", "0").contains("C")) break block242;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all2.getState("cde", "0").contains("G")) break block243;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all2.getState("ab", "0").size() == 2) break block244;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all2.getState("ab", "0").contains("A")) break block245;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all2.getState("ab", "0").contains("C")) break block246;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    fitch2.setReturnInternalStates(true);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    fitch2.setReturnGainLossMatrix(false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    fitch2.setUseLast(true);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    fitch2.execute(p2, m2);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    i_m21 = fitch2.getInternalStatesMatrix();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    i_m_all21 = fitch2.getInternalStatesMatrixPriorToTraceback();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (fitch2.getCost() == 3) break block247;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (((String)i_m21.getState("ab", "0")).equals("C")) break block248;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (((String)i_m21.getState("de", "0")).equals("G")) break block249;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (((String)i_m21.getState("cde", "0")).equals("C")) break block250;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (((String)i_m21.getState("r", "0")).equals("C")) break block251;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all21.getState("cde", "0").size() == 3) break block252;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all21.getState("cde", "0").contains("A")) break block253;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all21.getState("cde", "0").contains("C")) break block254;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all21.getState("cde", "0").contains("G")) break block255;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                FitchParsimony fitch3 = new FitchParsimony();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                PhylogenyFactory factory3 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                String p3_str = "(((a,b)ab,((c,d)cd,e)cde)abcde,f)r";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Phylogeny p3 = factory3.create("(((a,b)ab,((c,d)cd,e)cde)abcde,f)r", new NHXParser())[0];
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                BasicCharacterStateMatrix<String> m3 = new BasicCharacterStateMatrix<String>(6, 1);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setIdentifier(0, "a");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setIdentifier(1, "b");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setIdentifier(2, "c");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setIdentifier(3, "d");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setIdentifier(4, "e");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setIdentifier(5, "f");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setCharacter(0, "0");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setState("a", "0", "C");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setState("b", "0", "U");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setState("c", "0", "G");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setState("d", "0", "U");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setState("e", "0", "A");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                m3.setState("f", "0", "A");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                fitch3.setReturnInternalStates(true);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                fitch3.setReturnGainLossMatrix(false);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                fitch3.execute(p3, m3);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                i_m3 = fitch3.getInternalStatesMatrix();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                i_m_all3 = fitch3.getInternalStatesMatrixPriorToTraceback();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (fitch3.getCost() == 4) break block256;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (((String)i_m3.getState("ab", "0")).equals("U")) break block257;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (((String)i_m3.getState("cd", "0")).equals("U")) break block258;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (((String)i_m3.getState("cde", "0")).equals("U")) break block259;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (((String)i_m3.getState("abcde", "0")).equals("U")) break block260;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (((String)i_m3.getState("r", "0")).equals("A")) break block261;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all3.getState("cde", "0").size() == 3) break block262;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all3.getState("cde", "0").contains("A")) break block263;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all3.getState("cde", "0").contains("G")) break block264;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all3.getState("cde", "0").contains("U")) break block265;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all3.getState("ab", "0").size() == 2) break block266;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all3.getState("ab", "0").contains("C")) break block267;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all3.getState("ab", "0").contains("U")) break block268;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all3.getState("cd", "0").size() == 2) break block269;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all3.getState("cd", "0").contains("G")) break block270;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all3.getState("cd", "0").contains("U")) break block271;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all3.getState("abcde", "0").size() == 1) break block272;
                                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (i_m_all3.getState("abcde", "0").contains("U")) break block273;
                                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (i_m_all3.getState("r", "0").size() == 2) break block274;
                                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (i_m_all3.getState("r", "0").contains("A")) break block275;
                                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                if (i_m_all3.getState("r", "0").contains("U")) break block276;
                                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                            fitch4 = new FitchParsimony();
                                                                                                                                                                                                                                                                                                                                                                                                                            PhylogenyFactory factory4 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                                                                                                                                                                                                            String p4_str = "(((a,b)ab,((c,d)cd,e)cde)abcde,f)r";
                                                                                                                                                                                                                                                                                                                                                                                                                            Phylogeny p4 = factory4.create("(((a,b)ab,((c,d)cd,e)cde)abcde,f)r", new NHXParser())[0];
                                                                                                                                                                                                                                                                                                                                                                                                                            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m4 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(6, 1);
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setIdentifier(0, "a");
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setIdentifier(1, "b");
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setIdentifier(2, "c");
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setIdentifier(3, "d");
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setIdentifier(4, "e");
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setIdentifier(5, "f");
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setCharacter(0, "0");
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setState("a", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setState("b", "0", ABSENT);
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setState("c", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setState("d", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setState("e", "0", ABSENT);
                                                                                                                                                                                                                                                                                                                                                                                                                            m4.setState("f", "0", ABSENT);
                                                                                                                                                                                                                                                                                                                                                                                                                            fitch4.setReturnInternalStates(true);
                                                                                                                                                                                                                                                                                                                                                                                                                            fitch4.setReturnGainLossMatrix(true);
                                                                                                                                                                                                                                                                                                                                                                                                                            fitch4.execute(p4, m4);
                                                                                                                                                                                                                                                                                                                                                                                                                            gl_m_4 = fitch4.getGainLossMatrix();
                                                                                                                                                                                                                                                                                                                                                                                                                            if (fitch4.getCost() == 2) break block277;
                                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                        if (fitch4.getTotalLosses() == 0) break block278;
                                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                    if (fitch4.getTotalGains() == 2) break block279;
                                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                if (fitch4.getTotalUnchanged() == 9) break block280;
                                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                            if (gl_m_4.getState("a", "0") == GAIN) break block281;
                                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                        if (gl_m_4.getState("b", "0") == UNCHANGED_ABSENT) break block282;
                                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                    if (gl_m_4.getState("ab", "0") == UNCHANGED_ABSENT) break block283;
                                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                if (gl_m_4.getState("cd", "0") == GAIN) break block284;
                                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                            if (gl_m_4.getState("r", "0") == UNCHANGED_ABSENT) break block285;
                                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                        fitch5 = new FitchParsimony();
                                                                                                                                                                                                                                                                                                                                                                                        PhylogenyFactory factory5 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                                                                                                                                                                        String p5_str = "(((a,b)ab,((c,d)cd,e)cde)abcde,f)r";
                                                                                                                                                                                                                                                                                                                                                                                        Phylogeny p5 = factory5.create("(((a,b)ab,((c,d)cd,e)cde)abcde,f)r", new NHXParser())[0];
                                                                                                                                                                                                                                                                                                                                                                                        BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m5 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(6, 1);
                                                                                                                                                                                                                                                                                                                                                                                        m5.setIdentifier(0, "a");
                                                                                                                                                                                                                                                                                                                                                                                        m5.setIdentifier(1, "b");
                                                                                                                                                                                                                                                                                                                                                                                        m5.setIdentifier(2, "c");
                                                                                                                                                                                                                                                                                                                                                                                        m5.setIdentifier(3, "d");
                                                                                                                                                                                                                                                                                                                                                                                        m5.setIdentifier(4, "e");
                                                                                                                                                                                                                                                                                                                                                                                        m5.setIdentifier(5, "f");
                                                                                                                                                                                                                                                                                                                                                                                        m5.setCharacter(0, "0");
                                                                                                                                                                                                                                                                                                                                                                                        m5.setState("a", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                                                                                        m5.setState("b", "0", ABSENT);
                                                                                                                                                                                                                                                                                                                                                                                        m5.setState("c", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                                                                                        m5.setState("d", "0", ABSENT);
                                                                                                                                                                                                                                                                                                                                                                                        m5.setState("e", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                                                                                        m5.setState("f", "0", ABSENT);
                                                                                                                                                                                                                                                                                                                                                                                        fitch5.setReturnInternalStates(true);
                                                                                                                                                                                                                                                                                                                                                                                        fitch5.setReturnGainLossMatrix(true);
                                                                                                                                                                                                                                                                                                                                                                                        fitch5.execute(p5, m5);
                                                                                                                                                                                                                                                                                                                                                                                        gl_m_5 = fitch5.getGainLossMatrix();
                                                                                                                                                                                                                                                                                                                                                                                        if (fitch5.getCost() == 3) break block286;
                                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                    if (fitch5.getTotalLosses() == 2) break block287;
                                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                if (fitch5.getTotalGains() == 1) break block288;
                                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                            if (fitch5.getTotalUnchanged() == 8) break block289;
                                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                        if (gl_m_5.getState("abcde", "0") == GAIN) break block290;
                                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                    if (gl_m_5.getState("a", "0") == UNCHANGED_PRESENT) break block291;
                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                if (gl_m_5.getState("b", "0") == LOSS) break block292;
                                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            if (gl_m_5.getState("d", "0") == LOSS) break block293;
                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        if (gl_m_5.getState("r", "0") == UNCHANGED_ABSENT) break block294;
                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    fitch6 = new FitchParsimony();
                                                                                                                                                                                                                                                                                                                                                    PhylogenyFactory factory6 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                                                                                                                                    String p6_str = "(((a,b)ab,((c,d)cd,e)cde)abcde,f)r";
                                                                                                                                                                                                                                                                                                                                                    Phylogeny p6 = factory6.create("(((a,b)ab,((c,d)cd,e)cde)abcde,f)r", new NHXParser())[0];
                                                                                                                                                                                                                                                                                                                                                    BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m6 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(6, 1);
                                                                                                                                                                                                                                                                                                                                                    m6.setIdentifier(0, "a");
                                                                                                                                                                                                                                                                                                                                                    m6.setIdentifier(1, "b");
                                                                                                                                                                                                                                                                                                                                                    m6.setIdentifier(2, "c");
                                                                                                                                                                                                                                                                                                                                                    m6.setIdentifier(3, "d");
                                                                                                                                                                                                                                                                                                                                                    m6.setIdentifier(4, "e");
                                                                                                                                                                                                                                                                                                                                                    m6.setIdentifier(5, "f");
                                                                                                                                                                                                                                                                                                                                                    m6.setCharacter(0, "0");
                                                                                                                                                                                                                                                                                                                                                    m6.setState("a", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                                                    m6.setState("b", "0", ABSENT);
                                                                                                                                                                                                                                                                                                                                                    m6.setState("c", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                                                    m6.setState("d", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                                                    m6.setState("e", "0", ABSENT);
                                                                                                                                                                                                                                                                                                                                                    m6.setState("f", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                                                    fitch6.setReturnInternalStates(true);
                                                                                                                                                                                                                                                                                                                                                    fitch6.setReturnGainLossMatrix(true);
                                                                                                                                                                                                                                                                                                                                                    fitch6.execute(p6, m6);
                                                                                                                                                                                                                                                                                                                                                    gl_m_6 = fitch6.getGainLossMatrix();
                                                                                                                                                                                                                                                                                                                                                    if (fitch6.getCost() == 2) break block295;
                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                if (fitch6.getTotalLosses() == 2) break block296;
                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            if (fitch6.getTotalGains() == 0) break block297;
                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        if (fitch6.getTotalUnchanged() == 9) break block298;
                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    if (gl_m_6.getState("abcde", "0") == UNCHANGED_PRESENT) break block299;
                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                if (gl_m_6.getState("r", "0") == UNCHANGED_PRESENT) break block300;
                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            if (gl_m_6.getState("b", "0") == LOSS) break block301;
                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        if (gl_m_6.getState("e", "0") == LOSS) break block302;
                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    fitch7 = new FitchParsimony();
                                                                                                                                                                                                                                                                                                                    PhylogenyFactory factory7 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                                                                                                    String p7_str = "(((a,b)ab,(c,d)cd)abcd,((e,f)ef,(g,h)gh)efgh)r";
                                                                                                                                                                                                                                                                                                                    p7 = factory7.create("(((a,b)ab,(c,d)cd)abcd,((e,f)ef,(g,h)gh)efgh)r", new NHXParser())[0];
                                                                                                                                                                                                                                                                                                                    m7 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(8, 1);
                                                                                                                                                                                                                                                                                                                    m7.setIdentifier(0, "a");
                                                                                                                                                                                                                                                                                                                    m7.setIdentifier(1, "b");
                                                                                                                                                                                                                                                                                                                    m7.setIdentifier(2, "c");
                                                                                                                                                                                                                                                                                                                    m7.setIdentifier(3, "d");
                                                                                                                                                                                                                                                                                                                    m7.setIdentifier(4, "e");
                                                                                                                                                                                                                                                                                                                    m7.setIdentifier(5, "f");
                                                                                                                                                                                                                                                                                                                    m7.setIdentifier(6, "g");
                                                                                                                                                                                                                                                                                                                    m7.setIdentifier(7, "h");
                                                                                                                                                                                                                                                                                                                    m7.setCharacter(0, "0");
                                                                                                                                                                                                                                                                                                                    m7.setState("a", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                    m7.setState("b", "0", ABSENT);
                                                                                                                                                                                                                                                                                                                    m7.setState("c", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                    m7.setState("d", "0", ABSENT);
                                                                                                                                                                                                                                                                                                                    m7.setState("e", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                    m7.setState("f", "0", ABSENT);
                                                                                                                                                                                                                                                                                                                    m7.setState("g", "0", PRESENT);
                                                                                                                                                                                                                                                                                                                    m7.setState("h", "0", ABSENT);
                                                                                                                                                                                                                                                                                                                    fitch7.setReturnInternalStates(true);
                                                                                                                                                                                                                                                                                                                    fitch7.setReturnGainLossMatrix(true);
                                                                                                                                                                                                                                                                                                                    fitch7.execute(p7, m7);
                                                                                                                                                                                                                                                                                                                    gl_m_7 = fitch7.getGainLossMatrix();
                                                                                                                                                                                                                                                                                                                    if (fitch7.getCost() == 4) break block303;
                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (fitch7.getTotalLosses() == 0) break block304;
                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (fitch7.getTotalGains() == 4) break block305;
                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        if (fitch7.getTotalUnchanged() == 11) break block306;
                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (gl_m_7.getState("a", "0") == GAIN) break block307;
                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                if (gl_m_7.getState("c", "0") == GAIN) break block308;
                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (gl_m_7.getState("e", "0") == GAIN) break block309;
                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (gl_m_7.getState("g", "0") == GAIN) break block310;
                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (gl_m_7.getState("r", "0") == UNCHANGED_ABSENT) break block311;
                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                fitch7.setReturnInternalStates(true);
                                                                                                                                                                                                                                                                                fitch7.setReturnGainLossMatrix(true);
                                                                                                                                                                                                                                                                                fitch7.setUseLast(true);
                                                                                                                                                                                                                                                                                fitch7.execute(p7, m7);
                                                                                                                                                                                                                                                                                gl_m_71 = fitch7.getGainLossMatrix();
                                                                                                                                                                                                                                                                                if (fitch7.getCost() == 4) break block312;
                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (fitch7.getTotalLosses() == 4) break block313;
                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (fitch7.getTotalGains() == 0) break block314;
                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (fitch7.getTotalUnchanged() == 11) break block315;
                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (gl_m_71.getState("b", "0") == LOSS) break block316;
                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (gl_m_71.getState("d", "0") == LOSS) break block317;
                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (gl_m_71.getState("f", "0") == LOSS) break block318;
                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (gl_m_71.getState("h", "0") == LOSS) break block319;
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (gl_m_71.getState("r", "0") == UNCHANGED_PRESENT) break block320;
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            fitch8 = new FitchParsimony();
                                                                                                                                                                                                                                            PhylogenyFactory factory8 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                                            String p8_str = "(((a,b)ab,(c,d)cd)abcd,((e,f)ef,(g,h)gh)efgh)r";
                                                                                                                                                                                                                                            Phylogeny p8 = factory8.create("(((a,b)ab,(c,d)cd)abcd,((e,f)ef,(g,h)gh)efgh)r", new NHXParser())[0];
                                                                                                                                                                                                                                            BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates> m8 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(8, 1);
                                                                                                                                                                                                                                            m8.setIdentifier(0, "a");
                                                                                                                                                                                                                                            m8.setIdentifier(1, "b");
                                                                                                                                                                                                                                            m8.setIdentifier(2, "c");
                                                                                                                                                                                                                                            m8.setIdentifier(3, "d");
                                                                                                                                                                                                                                            m8.setIdentifier(4, "e");
                                                                                                                                                                                                                                            m8.setIdentifier(5, "f");
                                                                                                                                                                                                                                            m8.setIdentifier(6, "g");
                                                                                                                                                                                                                                            m8.setIdentifier(7, "h");
                                                                                                                                                                                                                                            m8.setCharacter(0, "0");
                                                                                                                                                                                                                                            m8.setState("a", "0", PRESENT);
                                                                                                                                                                                                                                            m8.setState("b", "0", PRESENT);
                                                                                                                                                                                                                                            m8.setState("c", "0", PRESENT);
                                                                                                                                                                                                                                            m8.setState("d", "0", ABSENT);
                                                                                                                                                                                                                                            m8.setState("e", "0", ABSENT);
                                                                                                                                                                                                                                            m8.setState("f", "0", ABSENT);
                                                                                                                                                                                                                                            m8.setState("g", "0", ABSENT);
                                                                                                                                                                                                                                            m8.setState("h", "0", ABSENT);
                                                                                                                                                                                                                                            fitch8.setReturnInternalStates(true);
                                                                                                                                                                                                                                            fitch8.setReturnGainLossMatrix(true);
                                                                                                                                                                                                                                            fitch8.execute(p8, m8);
                                                                                                                                                                                                                                            gl_m_8 = fitch8.getGainLossMatrix();
                                                                                                                                                                                                                                            if (fitch8.getCost() == 2) break block321;
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (fitch8.getTotalLosses() == 1) break block322;
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (fitch8.getTotalGains() == 1) break block323;
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (fitch8.getTotalUnchanged() == 13) break block324;
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (gl_m_8.getState("d", "0") == LOSS) break block325;
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (gl_m_8.getState("abcd", "0") == GAIN) break block326;
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    fitch9 = new FitchParsimony();
                                                                                                                                                                                                                    PhylogenyFactory factory9 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                                                                                                                                    String p9_str = "(((a,b)ab,c)abc,d)abcd";
                                                                                                                                                                                                                    p9 = factory9.create("(((a,b)ab,c)abc,d)abcd", new NHXParser())[0];
                                                                                                                                                                                                                    m9 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(4, 1);
                                                                                                                                                                                                                    m9.setIdentifier(0, "a");
                                                                                                                                                                                                                    m9.setIdentifier(1, "b");
                                                                                                                                                                                                                    m9.setIdentifier(2, "c");
                                                                                                                                                                                                                    m9.setIdentifier(3, "d");
                                                                                                                                                                                                                    m9.setCharacter(0, "0");
                                                                                                                                                                                                                    m9.setState("a", "0", PRESENT);
                                                                                                                                                                                                                    m9.setState("b", "0", ABSENT);
                                                                                                                                                                                                                    m9.setState("c", "0", PRESENT);
                                                                                                                                                                                                                    m9.setState("d", "0", ABSENT);
                                                                                                                                                                                                                    fitch9.setReturnInternalStates(true);
                                                                                                                                                                                                                    fitch9.setReturnGainLossMatrix(true);
                                                                                                                                                                                                                    fitch9.setUseLast(false);
                                                                                                                                                                                                                    fitch9.execute(p9, m9);
                                                                                                                                                                                                                    gl_m_9a = fitch9.getGainLossMatrix();
                                                                                                                                                                                                                    if (fitch9.getCost() == 2) break block327;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (fitch9.getTotalLosses() == 1) break block328;
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (fitch9.getTotalGains() == 1) break block329;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (fitch9.getTotalUnchanged() == 5) break block330;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (gl_m_9a.getState("a", "0") == UNCHANGED_PRESENT) break block331;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (gl_m_9a.getState("b", "0") == LOSS) break block332;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (gl_m_9a.getState("c", "0") == UNCHANGED_PRESENT) break block333;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (gl_m_9a.getState("d", "0") == UNCHANGED_ABSENT) break block334;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (gl_m_9a.getState("ab", "0") == UNCHANGED_PRESENT) break block335;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                if (gl_m_9a.getState("abc", "0") == GAIN) break block336;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            if (gl_m_9a.getState("abcd", "0") == UNCHANGED_ABSENT) break block337;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        fitch9.setUseLast(true);
                                                                                                                                                                        fitch9.execute(p9, m9);
                                                                                                                                                                        gl_m_9b = fitch9.getGainLossMatrix();
                                                                                                                                                                        if (fitch9.getCost() == 2) break block338;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (fitch9.getTotalLosses() == 2) break block339;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (fitch9.getTotalGains() == 0) break block340;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (fitch9.getTotalUnchanged() == 5) break block341;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        if (gl_m_9b.getState("a", "0") == UNCHANGED_PRESENT) break block342;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (gl_m_9b.getState("b", "0") == LOSS) break block343;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                if (gl_m_9b.getState("c", "0") == UNCHANGED_PRESENT) break block344;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            if (gl_m_9b.getState("d", "0") == LOSS) break block345;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (gl_m_9b.getState("ab", "0") == UNCHANGED_PRESENT) break block346;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (gl_m_9b.getState("abc", "0") == UNCHANGED_PRESENT) break block347;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (gl_m_9b.getState("abcd", "0") == UNCHANGED_PRESENT) break block348;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            fitch9.setUseLast(false);
                                                                                                                            fitch9.setRandomize(true);
                                                                                                                            fitch9.setRandomNumberSeed(8722445L);
                                                                                                                            fitch9.execute(p9, m9);
                                                                                                                            fitch9.getGainLossMatrix();
                                                                                                                            if (fitch9.getCost() == 2) break block349;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (fitch9.getTotalLosses() == 1) break block350;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (fitch9.getTotalGains() == 1) break block351;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (fitch9.getTotalUnchanged() == 5) break block352;
                                                                                                                return false;
                                                                                                            }
                                                                                                            fitch10 = new FitchParsimony();
                                                                                                            PhylogenyFactory factory10 = ParserBasedPhylogenyFactory.getInstance();
                                                                                                            String p10_str = "((((a,b)ab,c)abc,d)abcd,e)abcde";
                                                                                                            p10 = factory10.create("((((a,b)ab,c)abc,d)abcd,e)abcde", new NHXParser())[0];
                                                                                                            m10 = new BasicCharacterStateMatrix<CharacterStateMatrix.BinaryStates>(5, 1);
                                                                                                            m10.setIdentifier(0, "a");
                                                                                                            m10.setIdentifier(1, "b");
                                                                                                            m10.setIdentifier(2, "c");
                                                                                                            m10.setIdentifier(3, "d");
                                                                                                            m10.setIdentifier(4, "e");
                                                                                                            m10.setCharacter(0, "0");
                                                                                                            m10.setState("a", "0", PRESENT);
                                                                                                            m10.setState("b", "0", ABSENT);
                                                                                                            m10.setState("c", "0", ABSENT);
                                                                                                            m10.setState("d", "0", PRESENT);
                                                                                                            m10.setState("e", "0", ABSENT);
                                                                                                            fitch10.setReturnInternalStates(true);
                                                                                                            fitch10.setReturnGainLossMatrix(true);
                                                                                                            fitch10.setUseLast(false);
                                                                                                            fitch10.execute(p10, m10);
                                                                                                            gl_m_10a = fitch10.getGainLossMatrix();
                                                                                                            if (fitch10.getCost() == 2) break block353;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (fitch10.getTotalLosses() == 0) break block354;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (fitch10.getTotalGains() == 2) break block355;
                                                                                                    return false;
                                                                                                }
                                                                                                if (fitch10.getTotalUnchanged() == 7) break block356;
                                                                                                return false;
                                                                                            }
                                                                                            if (gl_m_10a.getState("a", "0") == GAIN) break block357;
                                                                                            return false;
                                                                                        }
                                                                                        if (gl_m_10a.getState("b", "0") == UNCHANGED_ABSENT) break block358;
                                                                                        return false;
                                                                                    }
                                                                                    if (gl_m_10a.getState("c", "0") == UNCHANGED_ABSENT) break block359;
                                                                                    return false;
                                                                                }
                                                                                if (gl_m_10a.getState("d", "0") == GAIN) break block360;
                                                                                return false;
                                                                            }
                                                                            if (gl_m_10a.getState("e", "0") == UNCHANGED_ABSENT) break block361;
                                                                            return false;
                                                                        }
                                                                        if (gl_m_10a.getState("ab", "0") == UNCHANGED_ABSENT) break block362;
                                                                        return false;
                                                                    }
                                                                    if (gl_m_10a.getState("abc", "0") == UNCHANGED_ABSENT) break block363;
                                                                    return false;
                                                                }
                                                                if (gl_m_10a.getState("abcd", "0") == UNCHANGED_ABSENT) break block364;
                                                                return false;
                                                            }
                                                            if (gl_m_10a.getState("abcde", "0") == UNCHANGED_ABSENT) break block365;
                                                            return false;
                                                        }
                                                        fitch10.setUseLast(true);
                                                        fitch10.execute(p10, m10);
                                                        gl_m_10b = fitch10.getGainLossMatrix();
                                                        if (fitch10.getCost() == 2) break block366;
                                                        return false;
                                                    }
                                                    if (fitch10.getTotalLosses() == 0) break block367;
                                                    return false;
                                                }
                                                if (fitch10.getTotalGains() == 2) break block368;
                                                return false;
                                            }
                                            if (fitch10.getTotalUnchanged() == 7) break block369;
                                            return false;
                                        }
                                        if (gl_m_10b.getState("a", "0") == GAIN) break block370;
                                        return false;
                                    }
                                    if (gl_m_10b.getState("b", "0") == UNCHANGED_ABSENT) break block371;
                                    return false;
                                }
                                if (gl_m_10b.getState("c", "0") == UNCHANGED_ABSENT) break block372;
                                return false;
                            }
                            if (gl_m_10b.getState("d", "0") == GAIN) break block373;
                            return false;
                        }
                        if (gl_m_10b.getState("e", "0") == UNCHANGED_ABSENT) break block374;
                        return false;
                    }
                    if (gl_m_10b.getState("ab", "0") == UNCHANGED_ABSENT) break block375;
                    return false;
                }
                if (gl_m_10b.getState("abc", "0") == UNCHANGED_ABSENT) break block376;
                return false;
            }
            if (gl_m_10b.getState("abcd", "0") == UNCHANGED_ABSENT) break block377;
            return false;
        }
        return gl_m_10b.getState("abcde", "0") == UNCHANGED_ABSENT;
    }

    private static boolean testNeighborJoining() {
        Phylogeny p3;
        block7: {
            block6: {
                block5: {
                    try {
                        BasicSymmetricalDistanceMatrix m = new BasicSymmetricalDistanceMatrix(6);
                        m.setRow("5", 1);
                        m.setRow("4 7", 2);
                        m.setRow("7 10 7", 3);
                        m.setRow("6 9 6 5", 4);
                        m.setRow("8 11 8 9 8", 5);
                        m.setIdentifier(0, "A");
                        m.setIdentifier(1, "B");
                        m.setIdentifier(2, "C");
                        m.setIdentifier(3, "D");
                        m.setIdentifier(4, "E");
                        m.setIdentifier(5, "F");
                        NeighborJoining nj2 = NeighborJoining.createInstance();
                        nj2.setVerbose(false);
                        nj2.execute(m);
                        m = new BasicSymmetricalDistanceMatrix(7);
                        m.setIdentifier(0, "Bovine");
                        m.setIdentifier(1, "Mouse");
                        m.setIdentifier(2, "Gibbon");
                        m.setIdentifier(3, "Orang");
                        m.setIdentifier(4, "Gorilla");
                        m.setIdentifier(5, "Chimp");
                        m.setIdentifier(6, "Human");
                        m.setRow("0.00000 1.68660 1.71980 1.66060 1.52430 1.60430 1.59050", 0);
                        m.setRow("1.68660 0.00000 1.52320 1.48410 1.44650 1.43890 1.46290", 1);
                        m.setRow("1.71980 1.52320 0.00000 0.71150 0.59580 0.61790 0.55830", 2);
                        m.setRow("1.66060 1.48410 0.71150 0.00000 0.46310 0.50610 0.47100", 3);
                        m.setRow("1.52430 1.44650 0.59580 0.46310 0.00000 0.34840 0.30830", 4);
                        m.setRow("1.60430 1.43890 0.61790 0.50610 0.34840 0.00000 0.26920", 5);
                        m.setRow("1.59050 1.46290 0.55830 0.47100 0.30830 0.26920 0.00000", 6);
                        nj2.execute(m);
                        m = new BasicSymmetricalDistanceMatrix(4);
                        m.setIdentifier(0, "A");
                        m.setIdentifier(1, "B");
                        m.setIdentifier(2, "C");
                        m.setIdentifier(3, "D");
                        m.setRow("0.00 0.95 0.17 0.98", 0);
                        m.setRow("0.95 0.00 1.02 1.83", 1);
                        m.setRow("0.17 1.02 0.00 1.01", 2);
                        m.setRow("0.98 1.83 1.01 0.00", 3);
                        p3 = nj2.execute(m);
                        p3.reRoot(p3.getNode("C").getParent());
                        if (TestPhylogenyReconstruction.isEqual(p3.getNode("A").getDistanceToParent(), 0.05)) break block5;
                        return false;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                        return false;
                    }
                }
                if (TestPhylogenyReconstruction.isEqual(p3.getNode("B").getDistanceToParent(), 0.9)) break block6;
                return false;
            }
            if (TestPhylogenyReconstruction.isEqual(p3.getNode("C").getDistanceToParent(), 0.1)) break block7;
            return false;
        }
        return TestPhylogenyReconstruction.isEqual(p3.getNode("D").getDistanceToParent(), 0.91);
    }

    private static boolean testSymmetricalDistanceMatrixParser() {
        DistanceMatrix[] ma5;
        block173: {
            block172: {
                block171: {
                    block170: {
                        block169: {
                            block168: {
                                block167: {
                                    block166: {
                                        block165: {
                                            block164: {
                                                block163: {
                                                    block162: {
                                                        block161: {
                                                            block160: {
                                                                block159: {
                                                                    block158: {
                                                                        SymmetricalDistanceMatrixParser p0;
                                                                        StringBuffer source;
                                                                        String l;
                                                                        block157: {
                                                                            DistanceMatrix[] ma4;
                                                                            block156: {
                                                                                block155: {
                                                                                    block154: {
                                                                                        block153: {
                                                                                            block152: {
                                                                                                block151: {
                                                                                                    block150: {
                                                                                                        block149: {
                                                                                                            block148: {
                                                                                                                block147: {
                                                                                                                    block146: {
                                                                                                                        block145: {
                                                                                                                            block144: {
                                                                                                                                block143: {
                                                                                                                                    block142: {
                                                                                                                                        block141: {
                                                                                                                                            block140: {
                                                                                                                                                block139: {
                                                                                                                                                    DistanceMatrix[] ma2;
                                                                                                                                                    block138: {
                                                                                                                                                        block137: {
                                                                                                                                                            DistanceMatrix[] ma1;
                                                                                                                                                            block136: {
                                                                                                                                                                block135: {
                                                                                                                                                                    block134: {
                                                                                                                                                                        block133: {
                                                                                                                                                                            block132: {
                                                                                                                                                                                block131: {
                                                                                                                                                                                    block130: {
                                                                                                                                                                                        block129: {
                                                                                                                                                                                            block128: {
                                                                                                                                                                                                block127: {
                                                                                                                                                                                                    block126: {
                                                                                                                                                                                                        block125: {
                                                                                                                                                                                                            block124: {
                                                                                                                                                                                                                block123: {
                                                                                                                                                                                                                    block122: {
                                                                                                                                                                                                                        block121: {
                                                                                                                                                                                                                            block120: {
                                                                                                                                                                                                                                block119: {
                                                                                                                                                                                                                                    block118: {
                                                                                                                                                                                                                                        block117: {
                                                                                                                                                                                                                                            block116: {
                                                                                                                                                                                                                                                block115: {
                                                                                                                                                                                                                                                    block114: {
                                                                                                                                                                                                                                                        block113: {
                                                                                                                                                                                                                                                            block112: {
                                                                                                                                                                                                                                                                DistanceMatrix[] ma0;
                                                                                                                                                                                                                                                                block111: {
                                                                                                                                                                                                                                                                    block110: {
                                                                                                                                                                                                                                                                        block109: {
                                                                                                                                                                                                                                                                            block108: {
                                                                                                                                                                                                                                                                                block107: {
                                                                                                                                                                                                                                                                                    block106: {
                                                                                                                                                                                                                                                                                        block105: {
                                                                                                                                                                                                                                                                                            block104: {
                                                                                                                                                                                                                                                                                                block103: {
                                                                                                                                                                                                                                                                                                    block102: {
                                                                                                                                                                                                                                                                                                        block101: {
                                                                                                                                                                                                                                                                                                            block100: {
                                                                                                                                                                                                                                                                                                                block99: {
                                                                                                                                                                                                                                                                                                                    block98: {
                                                                                                                                                                                                                                                                                                                        block97: {
                                                                                                                                                                                                                                                                                                                            block96: {
                                                                                                                                                                                                                                                                                                                                block95: {
                                                                                                                                                                                                                                                                                                                                    block94: {
                                                                                                                                                                                                                                                                                                                                        block93: {
                                                                                                                                                                                                                                                                                                                                            block92: {
                                                                                                                                                                                                                                                                                                                                                block91: {
                                                                                                                                                                                                                                                                                                                                                    block90: {
                                                                                                                                                                                                                                                                                                                                                        block89: {
                                                                                                                                                                                                                                                                                                                                                            block88: {
                                                                                                                                                                                                                                                                                                                                                                try {
                                                                                                                                                                                                                                                                                                                                                                    l = ForesterUtil.getLineSeparator();
                                                                                                                                                                                                                                                                                                                                                                    source = new StringBuffer();
                                                                                                                                                                                                                                                                                                                                                                    source.append(" 4" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append("A 0 0 0 0" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append("B 1 0 0 0" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append("C 2 4 0 0" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append("D 3 5 6 0" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append(l);
                                                                                                                                                                                                                                                                                                                                                                    source.append(" 4" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append("A 0   11  12  13" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append("B 11  0   14  15" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append("C 12  14  0   16" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append("D 13  15  16  0" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append(l);
                                                                                                                                                                                                                                                                                                                                                                    source.append(l);
                                                                                                                                                                                                                                                                                                                                                                    source.append("     " + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append(" 4" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append(" A        0     " + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append(" B            21 0" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append(" C            22 24    0  " + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append(" # 2 222 2 2 " + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append(" D            23 25 26 0" + l);
                                                                                                                                                                                                                                                                                                                                                                    source.append(l);
                                                                                                                                                                                                                                                                                                                                                                    source.append(l);
                                                                                                                                                                                                                                                                                                                                                                    source.append("     " + l);
                                                                                                                                                                                                                                                                                                                                                                    p0 = SymmetricalDistanceMatrixParser.createInstance();
                                                                                                                                                                                                                                                                                                                                                                    ma0 = p0.parse(source.toString());
                                                                                                                                                                                                                                                                                                                                                                    if (ma0.length == 3) break block88;
                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                catch (Exception e) {
                                                                                                                                                                                                                                                                                                                                                                    e.printStackTrace(System.out);
                                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma0[0].getValue(0, 0), 0.0)) break block89;
                                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma0[0].getValue(1, 0), 1.0)) break block90;
                                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma0[0].getValue(2, 0), 2.0)) break block91;
                                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma0[0].getValue(3, 0), 3.0)) break block92;
                                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma0[0].getValue(0, 1), 1.0)) break block93;
                                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma0[0].getValue(1, 1), 0.0)) break block94;
                                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma0[0].getValue(2, 1), 4.0)) break block95;
                                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma0[0].getValue(3, 1), 5.0)) break block96;
                                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma0[1].getValue(0, 0), 0.0)) break block97;
                                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma0[1].getValue(1, 0), 11.0)) break block98;
                                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma0[1].getValue(2, 0), 12.0)) break block99;
                                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma0[1].getValue(3, 0), 13.0)) break block100;
                                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma0[1].getValue(0, 1), 11.0)) break block101;
                                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma0[1].getValue(1, 1), 0.0)) break block102;
                                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma0[1].getValue(2, 1), 14.0)) break block103;
                                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma0[1].getValue(3, 1), 15.0)) break block104;
                                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma0[2].getValue(0, 0), 0.0)) break block105;
                                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma0[2].getValue(1, 0), 21.0)) break block106;
                                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma0[2].getValue(2, 0), 22.0)) break block107;
                                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma0[2].getValue(3, 0), 23.0)) break block108;
                                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma0[2].getValue(0, 1), 21.0)) break block109;
                                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma0[2].getValue(1, 1), 0.0)) break block110;
                                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma0[2].getValue(2, 1), 24.0)) break block111;
                                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma0[2].getValue(3, 1), 25.0)) break block112;
                                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            source = new StringBuffer();
                                                                                                                                                                                                                                                            source.append("A 0 0 0 0" + l);
                                                                                                                                                                                                                                                            source.append("B 1 0 0 0" + l);
                                                                                                                                                                                                                                                            source.append("C 2 4 0 0" + l);
                                                                                                                                                                                                                                                            source.append("D 3 5 6 0" + l);
                                                                                                                                                                                                                                                            source.append(" " + l);
                                                                                                                                                                                                                                                            source.append("A 0   11  12  13" + l);
                                                                                                                                                                                                                                                            source.append("B 11  0   14  15" + l);
                                                                                                                                                                                                                                                            source.append("C 12  14  0   16" + l);
                                                                                                                                                                                                                                                            source.append("D 13  15  16  0" + l);
                                                                                                                                                                                                                                                            source.append(l);
                                                                                                                                                                                                                                                            source.append(" A        0     " + l);
                                                                                                                                                                                                                                                            source.append(" B            21 0" + l);
                                                                                                                                                                                                                                                            source.append(" C            22 24    0  " + l);
                                                                                                                                                                                                                                                            source.append(" # 2 222 2 2 " + l);
                                                                                                                                                                                                                                                            source.append(" D            23 25 26 0" + l);
                                                                                                                                                                                                                                                            ma1 = p0.parse(source.toString());
                                                                                                                                                                                                                                                            if (ma1.length == 3) break block113;
                                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma1[0].getValue(0, 0), 0.0)) break block114;
                                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma1[0].getValue(1, 0), 1.0)) break block115;
                                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma1[0].getValue(2, 0), 2.0)) break block116;
                                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma1[0].getValue(3, 0), 3.0)) break block117;
                                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma1[0].getValue(0, 1), 1.0)) break block118;
                                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma1[0].getValue(1, 1), 0.0)) break block119;
                                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma1[0].getValue(2, 1), 4.0)) break block120;
                                                                                                                                                                                                                                return false;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma1[0].getValue(3, 1), 5.0)) break block121;
                                                                                                                                                                                                                            return false;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma1[1].getValue(0, 0), 0.0)) break block122;
                                                                                                                                                                                                                        return false;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma1[1].getValue(1, 0), 11.0)) break block123;
                                                                                                                                                                                                                    return false;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma1[1].getValue(2, 0), 12.0)) break block124;
                                                                                                                                                                                                                return false;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma1[1].getValue(3, 0), 13.0)) break block125;
                                                                                                                                                                                                            return false;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma1[1].getValue(0, 1), 11.0)) break block126;
                                                                                                                                                                                                        return false;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma1[1].getValue(1, 1), 0.0)) break block127;
                                                                                                                                                                                                    return false;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma1[1].getValue(2, 1), 14.0)) break block128;
                                                                                                                                                                                                return false;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma1[1].getValue(3, 1), 15.0)) break block129;
                                                                                                                                                                                            return false;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma1[2].getValue(0, 0), 0.0)) break block130;
                                                                                                                                                                                        return false;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma1[2].getValue(1, 0), 21.0)) break block131;
                                                                                                                                                                                    return false;
                                                                                                                                                                                }
                                                                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma1[2].getValue(2, 0), 22.0)) break block132;
                                                                                                                                                                                return false;
                                                                                                                                                                            }
                                                                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma1[2].getValue(3, 0), 23.0)) break block133;
                                                                                                                                                                            return false;
                                                                                                                                                                        }
                                                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma1[2].getValue(0, 1), 21.0)) break block134;
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma1[2].getValue(1, 1), 0.0)) break block135;
                                                                                                                                                                    return false;
                                                                                                                                                                }
                                                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma1[2].getValue(2, 1), 24.0)) break block136;
                                                                                                                                                                return false;
                                                                                                                                                            }
                                                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma1[2].getValue(3, 1), 25.0)) break block137;
                                                                                                                                                            return false;
                                                                                                                                                        }
                                                                                                                                                        source = new StringBuffer();
                                                                                                                                                        source.append("A 0" + l);
                                                                                                                                                        source.append("B 10 0" + l);
                                                                                                                                                        ma2 = p0.parse(source.toString());
                                                                                                                                                        if (ma2.length == 1) break block138;
                                                                                                                                                        return false;
                                                                                                                                                    }
                                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma2[0].getValue(0, 1), 10.0)) break block139;
                                                                                                                                                    return false;
                                                                                                                                                }
                                                                                                                                                source = new StringBuffer();
                                                                                                                                                source.append(" " + l);
                                                                                                                                                source.append("#" + l);
                                                                                                                                                DistanceMatrix[] ma3 = p0.parse(source.toString());
                                                                                                                                                if (ma3.length == 0) break block140;
                                                                                                                                                return false;
                                                                                                                                            }
                                                                                                                                            source = new StringBuffer();
                                                                                                                                            source.append(" " + l);
                                                                                                                                            source.append("A 0   11  12  13" + l);
                                                                                                                                            source.append("B     0   14  15" + l);
                                                                                                                                            source.append("C         0   16" + l);
                                                                                                                                            source.append("D              0" + l);
                                                                                                                                            source.append(l);
                                                                                                                                            source.append("A 0 21  22  23" + l);
                                                                                                                                            source.append("B 0 24  25" + l);
                                                                                                                                            source.append("C 0 26" + l);
                                                                                                                                            source.append("D 0" + l);
                                                                                                                                            p0.setInputMatrixType(SymmetricalDistanceMatrixParser.InputMatrixType.UPPER_TRIANGLE);
                                                                                                                                            ma4 = p0.parse(source);
                                                                                                                                            if (ma4.length == 2) break block141;
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(0, 0), 0.0)) break block142;
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(1, 0), 11.0)) break block143;
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(2, 0), 12.0)) break block144;
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(3, 0), 13.0)) break block145;
                                                                                                                            return false;
                                                                                                                        }
                                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(0, 1), 11.0)) break block146;
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(1, 1), 0.0)) break block147;
                                                                                                                    return false;
                                                                                                                }
                                                                                                                if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(2, 1), 14.0)) break block148;
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(3, 1), 15.0)) break block149;
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(0, 2), 12.0)) break block150;
                                                                                                        return false;
                                                                                                    }
                                                                                                    if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(1, 2), 14.0)) break block151;
                                                                                                    return false;
                                                                                                }
                                                                                                if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(2, 2), 0.0)) break block152;
                                                                                                return false;
                                                                                            }
                                                                                            if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(3, 2), 16.0)) break block153;
                                                                                            return false;
                                                                                        }
                                                                                        if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(0, 3), 13.0)) break block154;
                                                                                        return false;
                                                                                    }
                                                                                    if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(1, 3), 15.0)) break block155;
                                                                                    return false;
                                                                                }
                                                                                if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(2, 3), 16.0)) break block156;
                                                                                return false;
                                                                            }
                                                                            if (TestPhylogenyReconstruction.isEqual(ma4[0].getValue(3, 3), 0.0)) break block157;
                                                                            return false;
                                                                        }
                                                                        source = new StringBuffer();
                                                                        source.append(" 4 " + l);
                                                                        source.append("A 0   11  12  13" + l);
                                                                        source.append("B     0   14  15" + l);
                                                                        source.append("C         0   16" + l);
                                                                        source.append("D              0" + l);
                                                                        source.append(" 4" + l);
                                                                        source.append("A 0 21  22  23" + l);
                                                                        source.append("B 0 24  25" + l);
                                                                        source.append("C 0 26" + l);
                                                                        source.append("D 0" + l);
                                                                        source.append("     " + l);
                                                                        source.append(" 4" + l);
                                                                        source.append("A 0 21  22  23" + l);
                                                                        source.append("B 0 24  25" + l);
                                                                        source.append("C 0 26" + l);
                                                                        source.append("D 0" + l);
                                                                        source.append(l);
                                                                        source.append("A 0 21  22  23" + l);
                                                                        source.append("B 0 24  25" + l);
                                                                        source.append("C 0 26" + l);
                                                                        source.append("D 0" + l);
                                                                        p0.setInputMatrixType(SymmetricalDistanceMatrixParser.InputMatrixType.UPPER_TRIANGLE);
                                                                        ma5 = p0.parse(source);
                                                                        if (ma5.length == 4) break block158;
                                                                        return false;
                                                                    }
                                                                    if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(0, 0), 0.0)) break block159;
                                                                    return false;
                                                                }
                                                                if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(1, 0), 11.0)) break block160;
                                                                return false;
                                                            }
                                                            if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(2, 0), 12.0)) break block161;
                                                            return false;
                                                        }
                                                        if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(3, 0), 13.0)) break block162;
                                                        return false;
                                                    }
                                                    if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(0, 1), 11.0)) break block163;
                                                    return false;
                                                }
                                                if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(1, 1), 0.0)) break block164;
                                                return false;
                                            }
                                            if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(2, 1), 14.0)) break block165;
                                            return false;
                                        }
                                        if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(3, 1), 15.0)) break block166;
                                        return false;
                                    }
                                    if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(0, 2), 12.0)) break block167;
                                    return false;
                                }
                                if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(1, 2), 14.0)) break block168;
                                return false;
                            }
                            if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(2, 2), 0.0)) break block169;
                            return false;
                        }
                        if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(3, 2), 16.0)) break block170;
                        return false;
                    }
                    if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(0, 3), 13.0)) break block171;
                    return false;
                }
                if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(1, 3), 15.0)) break block172;
                return false;
            }
            if (TestPhylogenyReconstruction.isEqual(ma5[0].getValue(2, 3), 16.0)) break block173;
            return false;
        }
        return TestPhylogenyReconstruction.isEqual(ma5[0].getValue(3, 3), 0.0);
    }

    private static void timeNeighborJoining() {
        NeighborJoining nj2 = NeighborJoining.createInstance();
        int n = 3;
        while (n <= 12) {
            int x = (int)Math.pow(2.0, n);
            BasicSymmetricalDistanceMatrix mt = new BasicSymmetricalDistanceMatrix(x);
            mt.randomize(new Date().getTime());
            long start_time = new Date().getTime();
            nj2.execute(mt);
            System.out.println("Size: " + x + " -> " + (new Date().getTime() - start_time) + "ms.");
            ++n;
        }
    }
}

