/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogenyinference.DistanceMatrix;
import org.forester.phylogenyinference.SymmetricalDistanceMatrixParser;
import org.forester.sdi.SDIR;
import org.forester.sdi.Tuplet;
import org.forester.util.ForesterUtil;

public final class RIO {
    private static final boolean ROOT_BY_MINIMIZING_MAPPING_COST = false;
    private static final boolean ROOT_BY_MINIMIZING_SUM_OF_DUPS = true;
    private static final boolean ROOT_BY_MINIMIZING_TREE_HEIGHT = true;
    private static final boolean TIME = false;
    private HashMap<String, HashMap<String, Integer>> _o_hash_maps;
    private HashMap<String, HashMap<String, Integer>> _so_hash_maps;
    private HashMap<String, HashMap<String, Integer>> _up_hash_maps;
    private HashMap<String, HashMap<String, Integer>> _sn_hash_maps;
    private DistanceMatrix _m;
    private HashMap<String, Double> _l;
    private String[] _seq_names;
    private int _bootstraps;
    private int _ext_nodes_;
    private long _time;

    public RIO() {
        this.reset();
    }

    public final int getBootstraps() {
        return this._bootstraps;
    }

    private final double getBootstrapValueFromHash(HashMap<String, Integer> h, String name) {
        if (!h.containsKey(name)) {
            return 0.0;
        }
        int i = h.get(name);
        return (double)i * 100.0 / (double)this.getBootstraps();
    }

    public final double getDistance(String name) {
        double distance = 0.0;
        name = name.trim();
        if (this._l == null) {
            throw new IllegalStateException("Distance list has probably not been read in (successfully).");
        }
        if (this._l.get(name) == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " not found.");
        }
        distance = this._l.get(name);
        return distance;
    }

    public final double getDistance(String name1, String name2) {
        try {
            return this._m.getValue(this._m.getIndex(name1), this._m.getIndex(name2));
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    public final int getExtNodesOfAnalyzedGeneTrees() {
        return this._ext_nodes_;
    }

    public final HashMap<String, Integer> getInferredOrthologs(String seq_name) {
        if (this._o_hash_maps == null) {
            return null;
        }
        return this._o_hash_maps.get(seq_name);
    }

    private final HashMap<String, Integer> getInferredSubtreeNeighbors(String seq_name) {
        if (this._sn_hash_maps == null) {
            return null;
        }
        return this._sn_hash_maps.get(seq_name);
    }

    public final HashMap<String, Integer> getInferredSuperOrthologs(String seq_name) {
        if (this._so_hash_maps == null) {
            return null;
        }
        return this._so_hash_maps.get(seq_name);
    }

    public final HashMap<String, Integer> getInferredUltraParalogs(String seq_name) {
        if (this._up_hash_maps == null) {
            return null;
        }
        return this._up_hash_maps.get(seq_name);
    }

    public long getTime() {
        return this._time;
    }

    public void inferOrthologs(File gene_trees_file, Phylogeny species_tree, String query) throws IOException {
        Phylogeny[] gene_trees;
        int bs = 0;
        if (!gene_trees_file.exists()) {
            throw new IllegalArgumentException(String.valueOf(gene_trees_file.getAbsolutePath()) + " does not exist.");
        }
        if (!gene_trees_file.isFile()) {
            throw new IllegalArgumentException(String.valueOf(gene_trees_file.getAbsolutePath()) + " is not a file.");
        }
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        Phylogeny gene_tree = factory.create(gene_trees_file, new PhyloXmlParser())[0];
        PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(gene_tree, species_tree);
        PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(species_tree, gene_tree);
        this._seq_names = RIO.getAllExternalSequenceNames(gene_tree);
        if (this._seq_names == null || this._seq_names.length < 1) {
            return;
        }
        this._o_hash_maps = new HashMap();
        this._so_hash_maps = new HashMap();
        this._up_hash_maps = new HashMap();
        this._sn_hash_maps = new HashMap();
        this._o_hash_maps.put(query, new HashMap(this._seq_names.length));
        this._so_hash_maps.put(query, new HashMap(this._seq_names.length));
        this._up_hash_maps.put(query, new HashMap(this._seq_names.length));
        this._sn_hash_maps.put(query, new HashMap(this._seq_names.length));
        Phylogeny[] phylogenyArray = gene_trees = factory.create(gene_trees_file, new PhyloXmlParser());
        int n = gene_trees.length;
        int n2 = 0;
        while (n2 < n) {
            Phylogeny gt = phylogenyArray[n2];
            ++bs;
            PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(species_tree, gt);
            this.inferOrthologsHelper(gt, species_tree, query);
            ++n2;
        }
        this.setBootstraps(bs);
    }

    private void inferOrthologsHelper(Phylogeny gene_tree, Phylogeny species_tree, String query) {
        Phylogeny assigned_tree = null;
        List<PhylogenyNode> nodes = null;
        SDIR sdiunrooted = new SDIR();
        List<PhylogenyNode> orthologs = null;
        List<PhylogenyNode> super_orthologs = null;
        List<PhylogenyNode> ultra_paralogs = null;
        List<PhylogenyNode> subtree_neighbors = null;
        assigned_tree = sdiunrooted.infer(gene_tree, species_tree, false, true, true, true, 1)[0];
        this.setExtNodesOfAnalyzedGeneTrees(assigned_tree.getNumberOfExternalNodes());
        nodes = assigned_tree.getNodesViaSequenceName(query);
        if (nodes.size() > 1) {
            throw new IllegalArgumentException("node named [" + query + "] not unique");
        }
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("no node containing a sequence named [" + query + "] found");
        }
        PhylogenyNode query_node = nodes.get(0);
        PhylogenyMethods methods = PhylogenyMethods.getInstance();
        orthologs = methods.getOrthologousNodes(assigned_tree, query_node);
        this.updateHash(this._o_hash_maps, query, orthologs);
        super_orthologs = PhylogenyMethods.getSuperOrthologousNodes(query_node);
        this.updateHash(this._so_hash_maps, query, super_orthologs);
        subtree_neighbors = RIO.getSubtreeNeighbors(query_node, 2);
        this.updateHash(this._sn_hash_maps, query, subtree_neighbors);
        ultra_paralogs = PhylogenyMethods.getUltraParalogousNodes(query_node);
        this.updateHash(this._up_hash_maps, query, ultra_paralogs);
    }

    public ArrayList<String> inferredOrthologsToArrayList(String seq_name, double threshold_orthologs) {
        HashMap<String, Integer> o_hashmap = null;
        String name = null;
        double o = 0.0;
        ArrayList<String> arraylist = new ArrayList<String>();
        if (this._o_hash_maps == null) {
            throw new IllegalStateException("Orthologs have not been calculated (successfully).");
        }
        if (threshold_orthologs < 0.0) {
            threshold_orthologs = 0.0;
        } else if (threshold_orthologs > 100.0) {
            threshold_orthologs = 100.0;
        }
        o_hashmap = this.getInferredOrthologs(seq_name);
        if (o_hashmap == null) {
            throw new IllegalStateException("Orthologs for " + seq_name + " were not established.");
        }
        if (this._seq_names.length > 0) {
            int i = 0;
            while (i < this._seq_names.length) {
                name = this._seq_names[i];
                if (!name.equals(seq_name) && !((o = this.getBootstrapValueFromHash(o_hashmap, name)) < threshold_orthologs)) {
                    arraylist.add(name);
                }
                ++i;
            }
        }
        return arraylist;
    }

    public StringBuffer inferredOrthologsToString(String query_name, int sort, double threshold_orthologs, double threshold_subtreeneighborings) {
        HashMap<String, Integer> o_hashmap = null;
        HashMap<String, Integer> s_hashmap = null;
        HashMap<String, Integer> n_hashmap = null;
        String name = "";
        double o = 0.0;
        double s = 0.0;
        double sn = 0.0;
        double value1 = 0.0;
        double value2 = 0.0;
        double value3 = 0.0;
        double value4 = 0.0;
        double d = 0.0;
        ArrayList<Tuplet> nv = new ArrayList<Tuplet>();
        if (this._o_hash_maps == null || this._so_hash_maps == null || this._sn_hash_maps == null) {
            throw new IllegalStateException("Orthologs have not been calculated (successfully)");
        }
        if (sort < 0 || sort > 17) {
            sort = 12;
        }
        if (sort > 2 && this._m == null && this._l == null) {
            throw new IllegalStateException("Distance list or matrix have not been read in (successfully)");
        }
        if (threshold_orthologs < 0.0) {
            threshold_orthologs = 0.0;
        } else if (threshold_orthologs > 100.0) {
            threshold_orthologs = 100.0;
        }
        if (threshold_subtreeneighborings < 0.0) {
            threshold_subtreeneighborings = 0.0;
        } else if (threshold_subtreeneighborings > 100.0) {
            threshold_subtreeneighborings = 100.0;
        }
        o_hashmap = this.getInferredOrthologs(query_name);
        s_hashmap = this.getInferredSuperOrthologs(query_name);
        n_hashmap = this.getInferredSubtreeNeighbors(query_name);
        if (o_hashmap == null || s_hashmap == null || n_hashmap == null) {
            throw new IllegalStateException("Orthologs for " + query_name + " were not established");
        }
        StringBuffer orthologs = new StringBuffer();
        if (this._seq_names.length > 0) {
            int i = 0;
            while (i < this._seq_names.length) {
                name = this._seq_names[i];
                if (!(name.equals(query_name) || (o = this.getBootstrapValueFromHash(o_hashmap, name)) < threshold_orthologs || (sn = this.getBootstrapValueFromHash(n_hashmap, name)) < threshold_subtreeneighborings)) {
                    s = this.getBootstrapValueFromHash(s_hashmap, name);
                    if (sort >= 3) {
                        d = this._m != null ? this.getDistance(query_name, name) : this.getDistance(name);
                    }
                    switch (sort) {
                        case 0: {
                            nv.add(new Tuplet(name, o, 5));
                            break;
                        }
                        case 1: {
                            nv.add(new Tuplet(name, o, s, 5));
                            break;
                        }
                        case 2: {
                            nv.add(new Tuplet(name, s, o, 5));
                            break;
                        }
                        case 3: {
                            nv.add(new Tuplet(name, o, d, 1));
                            break;
                        }
                        case 4: {
                            nv.add(new Tuplet(name, d, o, 0));
                            break;
                        }
                        case 5: {
                            nv.add(new Tuplet(name, o, s, d, 2));
                            break;
                        }
                        case 6: {
                            nv.add(new Tuplet(name, o, d, s, 1));
                            break;
                        }
                        case 7: {
                            nv.add(new Tuplet(name, s, o, d, 2));
                            break;
                        }
                        case 8: {
                            nv.add(new Tuplet(name, s, d, o, 1));
                            break;
                        }
                        case 9: {
                            nv.add(new Tuplet(name, d, o, s, 0));
                            break;
                        }
                        case 10: {
                            nv.add(new Tuplet(name, d, s, o, 0));
                            break;
                        }
                        case 11: {
                            nv.add(new Tuplet(name, o, sn, d, 2));
                            break;
                        }
                        case 12: {
                            nv.add(new Tuplet(name, o, sn, s, d, 3));
                            break;
                        }
                        case 13: {
                            nv.add(new Tuplet(name, o, s, sn, d, 3));
                            break;
                        }
                        case 14: {
                            nv.add(new Tuplet(name, sn, o, s, d, 3));
                            break;
                        }
                        case 15: {
                            nv.add(new Tuplet(name, sn, d, o, s, 1));
                            break;
                        }
                        case 16: {
                            nv.add(new Tuplet(name, o, d, sn, s, 1));
                            break;
                        }
                        case 17: {
                            nv.add(new Tuplet(name, o, sn, d, s, 2));
                            break;
                        }
                        default: {
                            nv.add(new Tuplet(name, o, 5));
                        }
                    }
                }
                ++i;
            }
            if (nv != null && nv.size() > 0) {
                orthologs.append("[seq name]\t\t[ortho]\t[st-n]\t[sup-o]\t[dist]" + ForesterUtil.LINE_SEPARATOR);
                Object[] nv_array = new Tuplet[nv.size()];
                int j = 0;
                while (j < nv.size()) {
                    nv_array[j] = (Tuplet)nv.get(j);
                    ++j;
                }
                Arrays.sort(nv_array);
                int i2 = 0;
                while (i2 < nv_array.length) {
                    name = ((Tuplet)nv_array[i2]).getKey();
                    value1 = ((Tuplet)nv_array[i2]).getValue1();
                    value2 = ((Tuplet)nv_array[i2]).getValue2();
                    value3 = ((Tuplet)nv_array[i2]).getValue3();
                    value4 = ((Tuplet)nv_array[i2]).getValue4();
                    orthologs.append(RIO.addNameAndValues(name, value1, value2, value3, value4, sort));
                    ++i2;
                }
            }
        }
        if (orthologs == null || orthologs.length() < 1) {
            orthologs.append("-");
        }
        return orthologs;
    }

    private String inferredOrthologsToTableHelper(String name2, String[] names, int j, boolean super_orthologs) {
        HashMap<String, Integer> hashmap = null;
        String name = null;
        String orthologs = new String("");
        int value = 0;
        hashmap = !super_orthologs ? this.getInferredOrthologs(name2) : this.getInferredSuperOrthologs(name2);
        if (hashmap == null) {
            throw new RuntimeException("Unexpected failure in method inferredOrthologsToTableHelper");
        }
        int i = 0;
        while (i < names.length) {
            name = names[i];
            value = !hashmap.containsKey(name) ? 0 : hashmap.get(name);
            if (i == j) {
                if (value != 0) {
                    throw new RuntimeException("Failed sanity check in method inferredOrthologsToTableHelper: value not 0.");
                }
                orthologs = String.valueOf(orthologs) + " \t";
            } else {
                orthologs = String.valueOf(orthologs) + value + "\t";
            }
            ++i;
        }
        return orthologs;
    }

    public void inferredOrthologTableToFile(File outfile) throws IOException {
        if (this._o_hash_maps == null) {
            return;
        }
        this.inferredOrthologTableToFile(outfile, false);
    }

    private void inferredOrthologTableToFile(File outfile, boolean super_orthologs) throws IOException {
        String name = "";
        String line = "";
        PrintWriter out = null;
        if (this._seq_names == null) {
            throw new IllegalStateException("inferredOrthologTableToFile: seq_names_ is null.");
        }
        Arrays.sort(this._seq_names);
        out = new PrintWriter((Writer)new FileWriter(outfile), true);
        if (out == null) {
            throw new RuntimeException("inferredOrthologTableToFile: failure to create PrintWriter.");
        }
        line = "\t\t\t\t";
        int i = 0;
        while (i < this._seq_names.length) {
            line = String.valueOf(line) + i + ")\t";
            ++i;
        }
        line = String.valueOf(line) + "\n";
        out.println(line);
        i = 0;
        while (i < this._seq_names.length) {
            name = this._seq_names[i];
            line = name.length() < 8 ? String.valueOf(i) + ")\t" + name + "\t\t\t" : (name.length() < 16 ? String.valueOf(i) + ")\t" + name + "\t\t" : String.valueOf(i) + ")\t" + name + "\t");
            line = String.valueOf(line) + this.inferredOrthologsToTableHelper(name, this._seq_names, i, super_orthologs);
            out.println(line);
            ++i;
        }
        out.close();
    }

    public void inferredSuperOrthologTableToFile(File outfile) throws IOException {
        if (this._so_hash_maps == null) {
            return;
        }
        this.inferredOrthologTableToFile(outfile, true);
    }

    public String inferredUltraParalogsToString(String query_name, boolean return_dists, double threshold_ultra_paralogs) {
        HashMap<String, Integer> sp_hashmap = null;
        String name = "";
        String ultra_paralogs = "";
        int sort = 0;
        double sp = 0.0;
        double value1 = 0.0;
        double value2 = 0.0;
        double d = 0.0;
        ArrayList<Tuplet> nv = new ArrayList<Tuplet>();
        if (threshold_ultra_paralogs < 1.0) {
            threshold_ultra_paralogs = 1.0;
        } else if (threshold_ultra_paralogs > 100.0) {
            threshold_ultra_paralogs = 100.0;
        }
        if (this._up_hash_maps == null) {
            throw new IllegalStateException("Ultra paralogs have not been calculated (successfully).");
        }
        if (return_dists && this._m == null && this._l == null) {
            throw new IllegalStateException("Distance list or matrix have not been read in (successfully).");
        }
        sp_hashmap = this.getInferredUltraParalogs(query_name);
        if (sp_hashmap == null) {
            throw new IllegalStateException("Ultra paralogs for " + query_name + " were not established");
        }
        if (this._seq_names.length > 0) {
            int i = 0;
            while (i < this._seq_names.length) {
                name = this._seq_names[i];
                if (!name.equals(query_name) && !((sp = this.getBootstrapValueFromHash(sp_hashmap, name)) < threshold_ultra_paralogs)) {
                    if (return_dists) {
                        d = this._m != null ? this.getDistance(query_name, name) : this.getDistance(name);
                        nv.add(new Tuplet(name, sp, d, 1));
                    } else {
                        nv.add(new Tuplet(name, sp, 5));
                    }
                }
                ++i;
            }
            if (nv != null && nv.size() > 0) {
                Object[] nv_array = new Tuplet[nv.size()];
                int j = 0;
                while (j < nv.size()) {
                    nv_array[j] = (Tuplet)nv.get(j);
                    ++j;
                }
                Arrays.sort(nv_array);
                sort = return_dists ? 91 : 90;
                int i2 = 0;
                while (i2 < nv_array.length) {
                    name = ((Tuplet)nv_array[i2]).getKey();
                    value1 = ((Tuplet)nv_array[i2]).getValue1();
                    value2 = ((Tuplet)nv_array[i2]).getValue2();
                    ultra_paralogs = String.valueOf(ultra_paralogs) + RIO.addNameAndValues(name, value1, value2, 0.0, 0.0, sort);
                    ++i2;
                }
            }
        }
        if (ultra_paralogs == null || ultra_paralogs.length() < 1) {
            ultra_paralogs = "-";
        }
        return ultra_paralogs;
    }

    public final void readDistanceMatrix(File matrix_file) throws IOException {
        DistanceMatrix[] matrices = null;
        SymmetricalDistanceMatrixParser parser = SymmetricalDistanceMatrixParser.createInstance();
        matrices = parser.parse(matrix_file);
        if (matrices == null || matrices.length == 0) {
            throw new IOException("failed to parse distance matrix from [" + matrix_file + "]");
        }
        if (matrices.length > 1) {
            throw new IOException("[" + matrix_file + "] contains more than once distance matrix");
        }
        this._m = matrices[0];
    }

    private final void reset() {
        this._o_hash_maps = null;
        this._so_hash_maps = null;
        this._up_hash_maps = null;
        this._seq_names = null;
        this._m = null;
        this._l = null;
        this._bootstraps = 1;
        this._ext_nodes_ = 0;
        this._time = 0L;
    }

    private void setBootstraps(int i) {
        if (i < 1) {
            i = 1;
        }
        this._bootstraps = i;
    }

    private void setExtNodesOfAnalyzedGeneTrees(int i) {
        if (i < 1) {
            i = 0;
        }
        this._ext_nodes_ = i;
    }

    private void updateHash(HashMap<String, HashMap<String, Integer>> counter_map, String query_seq_name, List<PhylogenyNode> nodes) {
        HashMap<String, Integer> hash_map = counter_map.get(query_seq_name);
        if (hash_map == null) {
            throw new RuntimeException("Unexpected failure in method updateHash.");
        }
        int j = 0;
        while (j < nodes.size()) {
            String seq_name = nodes.get(j).getNodeData().getSequence().getName();
            if (hash_map.containsKey(seq_name)) {
                hash_map.put(seq_name, hash_map.get(seq_name) + 1);
            } else {
                hash_map.put(seq_name, 1);
            }
            ++j;
        }
    }

    private static final String addNameAndValues(String name, double value1, double value2, double value3, double value4, int sort) {
        DecimalFormat df = new DecimalFormat("0.#####");
        df.setDecimalSeparatorAlwaysShown(false);
        String line = "";
        line = name.length() < 8 ? String.valueOf(line) + name + "\t\t\t" : (name.length() < 16 ? String.valueOf(line) + name + "\t\t" : String.valueOf(line) + name + "\t");
        switch (sort) {
            case 0: {
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + "-\t";
                break;
            }
            case 1: {
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                line = String.valueOf(line) + "-\t";
                break;
            }
            case 2: {
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                break;
            }
            case 3: {
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                break;
            }
            case 4: {
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                break;
            }
            case 5: {
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                break;
            }
            case 6: {
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                break;
            }
            case 7: {
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                break;
            }
            case 8: {
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                break;
            }
            case 9: {
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                break;
            }
            case 10: {
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                break;
            }
            case 11: {
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                line = String.valueOf(line) + "-\t";
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                break;
            }
            case 12: {
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                line = String.valueOf(line) + RIO.addToLine(value4, df);
                break;
            }
            case 13: {
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                line = String.valueOf(line) + RIO.addToLine(value4, df);
                break;
            }
            case 14: {
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                line = String.valueOf(line) + RIO.addToLine(value4, df);
                break;
            }
            case 15: {
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + RIO.addToLine(value4, df);
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                break;
            }
            case 16: {
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                line = String.valueOf(line) + RIO.addToLine(value4, df);
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                break;
            }
            case 17: {
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + RIO.addToLine(value2, df);
                line = String.valueOf(line) + RIO.addToLine(value4, df);
                line = String.valueOf(line) + RIO.addToLine(value3, df);
                break;
            }
            case 90: {
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + "-\t";
                break;
            }
            case 91: {
                line = String.valueOf(line) + RIO.addToLine(value1, df);
                line = String.valueOf(line) + RIO.addToLine(value2, df);
            }
        }
        line = String.valueOf(line) + ForesterUtil.LINE_SEPARATOR;
        return line;
    }

    private static final String addToLine(double value, DecimalFormat df) {
        String s = "";
        s = value != -999.0 ? String.valueOf(df.format(value)) + "\t" : "-\t";
        return s;
    }

    private static String[] getAllExternalSequenceNames(Phylogeny phy) {
        if (phy.isEmpty()) {
            return null;
        }
        int i = 0;
        String[] names = new String[phy.getNumberOfExternalNodes()];
        PhylogenyNodeIterator iter = phy.iteratorExternalForward();
        while (iter.hasNext()) {
            names[i++] = iter.next().getNodeData().getSequence().getName();
        }
        return names;
    }

    public static final String getOrder(int sort) {
        String order = "";
        switch (sort) {
            case 0: {
                order = "orthologies";
                break;
            }
            case 1: {
                order = "orthologies > super orthologies";
                break;
            }
            case 2: {
                order = "super orthologies > orthologies";
                break;
            }
            case 3: {
                order = "orthologies > distance to query";
                break;
            }
            case 4: {
                order = "distance to query > orthologies";
                break;
            }
            case 5: {
                order = "orthologies > super orthologies > distance to query";
                break;
            }
            case 6: {
                order = "orthologies > distance to query > super orthologies";
                break;
            }
            case 7: {
                order = "super orthologies > orthologies > distance to query";
                break;
            }
            case 8: {
                order = "super orthologies > distance to query > orthologies";
                break;
            }
            case 9: {
                order = "distance to query > orthologies > super orthologies";
                break;
            }
            case 10: {
                order = "distance to query > super orthologies > orthologies";
                break;
            }
            case 11: {
                order = "orthologies > subtree neighbors > distance to query";
                break;
            }
            case 12: {
                order = "orthologies > subtree neighbors > super orthologies > distance to query";
                break;
            }
            case 13: {
                order = "orthologies > super orthologies > subtree neighbors > distance to query";
                break;
            }
            case 14: {
                order = "subtree neighbors > orthologies > super orthologies > distance to query";
                break;
            }
            case 15: {
                order = "subtree neighbors > distance to query > orthologies > super orthologies";
                break;
            }
            case 16: {
                order = "orthologies > distance to query > subtree neighbors > super orthologies";
                break;
            }
            case 17: {
                order = "orthologies > subtree neighbors > distance to query > super orthologies";
                break;
            }
            default: {
                order = "orthologies";
            }
        }
        return order;
    }

    public static final StringBuffer getOrderHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("  0: orthologies" + ForesterUtil.LINE_SEPARATOR);
        sb.append("  1: orthologies > super orthologies" + ForesterUtil.LINE_SEPARATOR);
        sb.append("  2: super orthologies > orthologies" + ForesterUtil.LINE_SEPARATOR);
        sb.append("  3: orthologies > distance to query" + ForesterUtil.LINE_SEPARATOR);
        sb.append("  4: distance to query > orthologies" + ForesterUtil.LINE_SEPARATOR);
        sb.append("  5: orthologies > super orthologies > distance to query" + ForesterUtil.LINE_SEPARATOR);
        sb.append("  6: orthologies > distance to query > super orthologies" + ForesterUtil.LINE_SEPARATOR);
        sb.append("  7: super orthologies > orthologies > distance to query" + ForesterUtil.LINE_SEPARATOR);
        sb.append("  8: super orthologies > distance to query > orthologies" + ForesterUtil.LINE_SEPARATOR);
        sb.append("  9: distance to query > orthologies > super orthologies" + ForesterUtil.LINE_SEPARATOR);
        sb.append(" 10: distance to query > super orthologies > orthologies" + ForesterUtil.LINE_SEPARATOR);
        sb.append(" 11: orthologies > subtree neighbors > distance to query" + ForesterUtil.LINE_SEPARATOR);
        sb.append(" 12: orthologies > subtree neighbors > super orthologies > distance to query" + ForesterUtil.LINE_SEPARATOR);
        sb.append(" 13: orthologies > super orthologies > subtree neighbors > distance to query" + ForesterUtil.LINE_SEPARATOR);
        sb.append(" 14: subtree neighbors > orthologies > super orthologies > distance to query" + ForesterUtil.LINE_SEPARATOR);
        sb.append(" 15: subtree neighbors > distance to query > orthologies > super orthologies" + ForesterUtil.LINE_SEPARATOR);
        sb.append(" 16: orthologies > distance to query > subtree neighbors > super orthologies" + ForesterUtil.LINE_SEPARATOR);
        sb.append(" 17: orthologies > subtree neighbors > distance to query > super orthologies" + ForesterUtil.LINE_SEPARATOR);
        return sb;
    }

    private static final List<PhylogenyNode> getSubtreeNeighbors(PhylogenyNode query, int level) {
        PhylogenyNode node = query;
        if (!node.isExternal()) {
            return null;
        }
        if (!node.isRoot()) {
            node = node.getParent();
        }
        if (level == 2) {
            if (!node.isRoot()) {
                node = node.getParent();
            }
        } else {
            throw new IllegalArgumentException("currently only supporting level 2 subtree neighbors ");
        }
        List<PhylogenyNode> sn = node.getAllExternalDescendants();
        sn.remove(query);
        return sn;
    }
}

