/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.ArrayList;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.SDIR;
import org.forester.util.GeneralTable;

public class RIOn {
    private static final boolean ROOT_BY_MINIMIZING_MAPPING_COST = false;
    private static final boolean ROOT_BY_MINIMIZING_SUM_OF_DUPS = true;
    private static final boolean ROOT_BY_MINIMIZING_TREE_HEIGHT = true;
    GeneralTable<String, Integer> _orthologs = null;
    GeneralTable<String, Integer> _paralogs = null;
    GeneralTable<String, Integer> _super_orthologs = null;
    GeneralTable<String, Integer> _ultra_paralogs = null;

    private void doInferOrthologs(Phylogeny gene_tree, Phylogeny species_tree) {
        SDIR sdiunrooted = new SDIR();
        Phylogeny assigned_tree = sdiunrooted.infer(gene_tree, species_tree, false, true, true, true, 1)[0];
        ArrayList<PhylogenyNode> external_nodes = new ArrayList<PhylogenyNode>();
        PhylogenyNodeIterator iterator = assigned_tree.iteratorExternalForward();
        while (iterator.hasNext()) {
            external_nodes.add(iterator.next());
        }
        PhylogenyMethods methods = PhylogenyMethods.getInstance();
        int i = 0;
        while (i < external_nodes.size()) {
            int j = 0;
            while (j < external_nodes.size()) {
                if (i != j) {
                    PhylogenyNode node_i = (PhylogenyNode)external_nodes.get(i);
                    PhylogenyNode node_j = (PhylogenyNode)external_nodes.get(j);
                    PhylogenyNode lca = methods.getLCA(node_i, node_j);
                    Event event = lca.getNodeData().getEvent();
                    String node_i_name = node_i.getNodeData().getSequence().getName();
                    String node_j_name = node_j.getNodeData().getSequence().getName();
                    if (event.isDuplication()) {
                        this.increaseCounter(this.getOrthologs(), node_i_name, node_j_name);
                    } else {
                        this.increaseCounter(this.getParalogs(), node_i_name, node_j_name);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public GeneralTable<String, Integer> getOrthologs() {
        return this._orthologs;
    }

    public GeneralTable<String, Integer> getParalogs() {
        return this._paralogs;
    }

    public GeneralTable<String, Integer> getSuperOrthologs() {
        return this._super_orthologs;
    }

    public GeneralTable<String, Integer> getUltraParalogs() {
        return this._ultra_paralogs;
    }

    private void increaseCounter(GeneralTable<String, Integer> table, String node_i_name, String node_j_name) {
        Integer value = table.getValue(node_i_name, node_j_name);
        if (value == null) {
            table.setValue(node_i_name, node_j_name, 1);
        } else {
            table.setValue(node_i_name, node_j_name, value + 1);
        }
    }

    private void init() {
        this._orthologs = new GeneralTable();
        this._paralogs = new GeneralTable();
        this._super_orthologs = new GeneralTable();
        this._ultra_paralogs = new GeneralTable();
    }

    private void setOrthologs(GeneralTable<String, Integer> orthologs) {
        this._orthologs = orthologs;
    }

    private void setParalogs(GeneralTable<String, Integer> paralogs) {
        this._paralogs = paralogs;
    }

    private void setSuperOrthologs(GeneralTable<String, Integer> super_orthologs) {
        this._super_orthologs = super_orthologs;
    }

    private void setUltraParalogs(GeneralTable<String, Integer> ultra_paralogs) {
        this._ultra_paralogs = ultra_paralogs;
    }
}

