/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.util.HashMap;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public abstract class SDI {
    final Phylogeny _gene_tree;
    final Phylogeny _species_tree;
    int _duplications_sum;
    int _mapping_cost;

    public SDI(Phylogeny gene_tree, Phylogeny species_tree) {
        if (species_tree.isEmpty() || gene_tree.isEmpty()) {
            throw new IllegalArgumentException("attempt to infer duplications using empty tree(s)");
        }
        if (!gene_tree.isRooted()) {
            throw new IllegalArgumentException("attempt to infer duplications on unrooted gene tree");
        }
        if (!species_tree.isRooted()) {
            throw new IllegalArgumentException("attempt to infer duplications on unrooted species tree");
        }
        this._gene_tree = gene_tree;
        this._species_tree = species_tree;
        this._duplications_sum = 0;
        this._mapping_cost = -1;
    }

    private void computeMappingCostHelper(PhylogenyNode g) {
        if (!g.isExternal()) {
            this.computeMappingCostHelper(g.getChildNode1());
            this.computeMappingCostHelper(g.getChildNode2());
            this._mapping_cost = g.getLink() != g.getChildNode1().getLink() && g.getLink() != g.getChildNode2().getLink() ? (this._mapping_cost += g.getChildNode1().getLink().getNodeId() + g.getChildNode2().getLink().getNodeId() - 2 * g.getLink().getNodeId() - 2) : (g.getLink() != g.getChildNode1().getLink() && g.getLink() == g.getChildNode2().getLink() ? (this._mapping_cost += g.getChildNode1().getLink().getNodeId() - g.getLink().getNodeId() + 1) : (g.getLink() == g.getChildNode1().getLink() && g.getLink() != g.getChildNode2().getLink() ? (this._mapping_cost += g.getChildNode2().getLink().getNodeId() - g.getLink().getNodeId() + 1) : ++this._mapping_cost));
        }
    }

    public int computeMappingCostL() {
        this._species_tree.levelOrderReID(0);
        this._mapping_cost = 0;
        this.computeMappingCostHelper(this._gene_tree.getRoot());
        return this._mapping_cost;
    }

    private TaxonomyComparisonBase determineTaxonomyComparisonBase() {
        Taxonomy tax;
        PhylogenyNode n;
        TaxonomyComparisonBase base = null;
        boolean all_have_id = true;
        boolean all_have_code = true;
        boolean all_have_sn = true;
        boolean all_have_cn = true;
        PhylogenyNodeIterator iter = this._species_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            n = iter.next();
            if (n.getNodeData().isHasTaxonomy()) {
                tax = n.getNodeData().getTaxonomy();
                if (tax.getIdentifier() == null || ForesterUtil.isEmpty(tax.getIdentifier().getValue())) {
                    all_have_id = false;
                }
                if (ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
                    all_have_code = false;
                }
                if (ForesterUtil.isEmpty(tax.getScientificName())) {
                    all_have_sn = false;
                }
                if (!ForesterUtil.isEmpty(tax.getCommonName())) continue;
                all_have_cn = false;
                continue;
            }
            throw new IllegalArgumentException("species tree node [" + n + "] has no taxonomic data");
        }
        iter = this._gene_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            n = iter.next();
            if (n.getNodeData().isHasTaxonomy()) {
                tax = n.getNodeData().getTaxonomy();
                if (tax.getIdentifier() == null || ForesterUtil.isEmpty(tax.getIdentifier().getValue())) {
                    all_have_id = false;
                }
                if (ForesterUtil.isEmpty(tax.getTaxonomyCode())) {
                    all_have_code = false;
                }
                if (ForesterUtil.isEmpty(tax.getScientificName())) {
                    all_have_sn = false;
                }
                if (!ForesterUtil.isEmpty(tax.getCommonName())) continue;
                all_have_cn = false;
                continue;
            }
            throw new IllegalArgumentException("gene tree node [" + n + "] has no taxonomic data");
        }
        if (all_have_id) {
            base = TaxonomyComparisonBase.ID;
        } else if (all_have_code) {
            base = TaxonomyComparisonBase.CODE;
        } else if (all_have_sn) {
            base = TaxonomyComparisonBase.SCIENTIFIC_NAME;
        } else if (all_have_cn) {
            base = TaxonomyComparisonBase.COMMON_NAME;
        } else {
            throw new IllegalArgumentException("gene tree and species tree have incomparable taxonomies");
        }
        return base;
    }

    public int getDuplicationsSum() {
        return this._duplications_sum;
    }

    public Phylogeny getGeneTree() {
        return this._gene_tree;
    }

    public Phylogeny getSpeciesTree() {
        return this._species_tree;
    }

    void linkNodesOfG() {
        String tax_str;
        HashMap<String, PhylogenyNode> speciestree_ext_nodes = new HashMap<String, PhylogenyNode>();
        TaxonomyComparisonBase tax_comp_base = this.determineTaxonomyComparisonBase();
        PhylogenyNodeIterator iter = this._species_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode s = iter.next();
            tax_str = SDI.taxonomyToString(s, tax_comp_base);
            if (speciestree_ext_nodes.containsKey(tax_str)) {
                throw new IllegalArgumentException("taxonomy [" + s.getNodeData().getTaxonomy() + "] is not unique in species phylogeny");
            }
            speciestree_ext_nodes.put(tax_str, s);
        }
        iter = this._gene_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode g = iter.next();
            tax_str = SDI.taxonomyToString(g, tax_comp_base);
            PhylogenyNode s = (PhylogenyNode)speciestree_ext_nodes.get(tax_str);
            if (s == null) {
                throw new IllegalArgumentException("taxonomy [" + g.getNodeData().getTaxonomy() + "] not present in species tree");
            }
            g.setLink(s);
        }
    }

    void linkNodesOfGByTaxonomyIdentifier() {
        PhylogenyNodeIterator iter;
        HashMap<String, PhylogenyNode> speciestree_ext_nodes = new HashMap<String, PhylogenyNode>();
        if (this._species_tree.getFirstExternalNode().isRoot()) {
            speciestree_ext_nodes.put(this._species_tree.getFirstExternalNode().getNodeData().getTaxonomy().getIdentifier().getValue(), this._species_tree.getFirstExternalNode());
        } else {
            iter = this._species_tree.iteratorExternalForward();
            while (iter.hasNext()) {
                PhylogenyNode s = iter.next();
                speciestree_ext_nodes.put(s.getNodeData().getTaxonomy().getIdentifier().getValue(), s);
            }
        }
        iter = this._gene_tree.iteratorExternalForward();
        while (iter.hasNext()) {
            PhylogenyNode g = iter.next();
            PhylogenyNode s = (PhylogenyNode)speciestree_ext_nodes.get(g.getNodeData().getTaxonomy().getIdentifier().getValue());
            if (s == null) {
                String message = "species [" + g.getNodeData().getTaxonomy().getIdentifier().getValue();
                message = String.valueOf(message) + "] not present in species tree";
                throw new IllegalArgumentException(message);
            }
            g.setLink(s);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass());
        sb.append(ForesterUtil.LINE_SEPARATOR);
        sb.append("Duplications sum                   : " + this.getDuplicationsSum());
        sb.append(ForesterUtil.LINE_SEPARATOR);
        sb.append("mapping cost L                     : " + this.computeMappingCostL());
        return sb.toString();
    }

    private static String taxonomyToString(PhylogenyNode n, TaxonomyComparisonBase base) {
        Taxonomy tax = n.getNodeData().getTaxonomy();
        switch (base) {
            case ID: {
                return tax.getIdentifier().getValue();
            }
            case CODE: {
                return tax.getTaxonomyCode();
            }
            case SCIENTIFIC_NAME: {
                return tax.getScientificName();
            }
            case COMMON_NAME: {
                return tax.getCommonName();
            }
        }
        throw new IllegalArgumentException("unknown comparison base for taxonomies: " + (Object)((Object)base));
    }

    static enum TaxonomyComparisonBase {
        ID,
        CODE,
        SCIENTIFIC_NAME,
        COMMON_NAME;

    }
}

