/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Event;
import org.forester.sdi.SDI;

public class SDIse
extends SDI {
    public SDIse(Phylogeny gene_tree, Phylogeny species_tree) {
        super(gene_tree, species_tree);
        this._duplications_sum = 0;
        this.getSpeciesTree().preOrderReId(0);
        this.linkNodesOfG();
        this.geneTreePostOrderTraversal(this.getGeneTree().getRoot());
    }

    private void calculateMforNode(PhylogenyNode n) {
        if (!n.isExternal()) {
            boolean was_duplication = n.isDuplication();
            PhylogenyNode a = n.getChildNode1().getLink();
            PhylogenyNode b = n.getChildNode2().getLink();
            while (a != b) {
                if (a.getNodeId() > b.getNodeId()) {
                    a = a.getParent();
                    continue;
                }
                b = b.getParent();
            }
            n.setLink(a);
            Event event = null;
            if (a == n.getChildNode1().getLink() || a == n.getChildNode2().getLink()) {
                event = Event.createSingleDuplicationEvent();
                if (!was_duplication) {
                    ++this._duplications_sum;
                }
            } else {
                event = Event.createSingleSpeciationEvent();
                if (was_duplication) {
                    --this._duplications_sum;
                }
            }
            n.getNodeData().setEvent(event);
        }
    }

    void geneTreePostOrderTraversal(PhylogenyNode g) {
        if (!g.isExternal()) {
            this.geneTreePostOrderTraversal(g.getChildNode(0));
            this.geneTreePostOrderTraversal(g.getChildNode(1));
            PhylogenyNode a = g.getChildNode(0).getLink();
            PhylogenyNode b = g.getChildNode(1).getLink();
            while (a != b) {
                if (a.getNodeId() > b.getNodeId()) {
                    a = a.getParent();
                    continue;
                }
                b = b.getParent();
            }
            g.setLink(a);
            Event event = null;
            if (a == g.getChildNode(0).getLink() || a == g.getChildNode(1).getLink()) {
                event = Event.createSingleDuplicationEvent();
                ++this._duplications_sum;
            } else {
                event = Event.createSingleSpeciationEvent();
            }
            g.getNodeData().setEvent(event);
        }
    }

    int updateM(boolean prev_root_was_dup, PhylogenyNode prev_root_c1, PhylogenyNode prev_root_c2) {
        PhylogenyNode root = this.getGeneTree().getRoot();
        if (root.getChildNode1() == prev_root_c1 || root.getChildNode2() == prev_root_c1) {
            this.calculateMforNode(prev_root_c1);
        } else {
            this.calculateMforNode(prev_root_c2);
        }
        Event event = null;
        event = prev_root_was_dup ? Event.createSingleDuplicationEvent() : Event.createSingleSpeciationEvent();
        root.getNodeData().setEvent(event);
        this.calculateMforNode(root);
        return this.getDuplicationsSum();
    }
}

