/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sdi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.SDIR;
import org.forester.util.ForesterUtil;

public class Shin {
    private void analyze(Phylogeny gene_tree, String gene_tree_file_name, Phylogeny[] species_trees, File out_dir) throws IOException {
        boolean minimize_cost = true;
        boolean minimize_sum_of_dup = true;
        boolean minimize_height = true;
        boolean trees_to_return = true;
        System.out.println(String.valueOf(gene_tree_file_name) + ": " + gene_tree.getName());
        Set<Taxonomy> species_tree_species = Shin.getAllExternalSpecies(species_trees[0]);
        PhylogenyWriter w = new PhylogenyWriter();
        Phylogeny[] phylogenyArray = species_trees;
        int n = species_trees.length;
        int n2 = 0;
        while (n2 < n) {
            Phylogeny species_tree = phylogenyArray[n2];
            PhylogenyMethods.deleteExternalNodesPositiveSelection(species_tree_species, gene_tree);
            if (gene_tree.isEmpty()) {
                System.out.println(" >> empty: " + gene_tree_file_name + ": " + gene_tree.getName());
            } else {
                File outfile = new File(out_dir + ForesterUtil.FILE_SEPARATOR + gene_tree_file_name);
                if (outfile.exists()) {
                    System.out.println(" >> already exists, skipping: " + gene_tree_file_name + ": " + gene_tree.getName());
                }
                SDIR sdir = new SDIR();
                Phylogeny[] analyzed_gene_trees = sdir.infer(gene_tree, species_tree, true, true, true, true, 1);
                int duplications = sdir.getMinimalDuplications();
                int mapping_cost = sdir.getMinimalMappingCost();
                ArrayList<Phylogeny> phys = new ArrayList<Phylogeny>();
                Phylogeny[] phylogenyArray2 = analyzed_gene_trees;
                int n3 = analyzed_gene_trees.length;
                int n4 = 0;
                while (n4 < n3) {
                    Phylogeny phy = phylogenyArray2[n4];
                    phys.add(phy);
                    ++n4;
                }
                w.toPhyloXML(outfile, phys, 0, ForesterUtil.LINE_SEPARATOR);
            }
            ++n2;
        }
    }

    private void checkSpeciesTreesForEqualNumberOfExtNodes(Phylogeny[] species_trees) {
        int ext_nodes = -1;
        Phylogeny[] phylogenyArray = species_trees;
        int n = species_trees.length;
        int n2 = 0;
        while (n2 < n) {
            Phylogeny phylogeny = phylogenyArray[n2];
            if (ext_nodes < 0) {
                ext_nodes = phylogeny.getNumberOfExternalNodes();
            } else if (ext_nodes != phylogeny.getNumberOfExternalNodes()) {
                throw new IllegalArgumentException("species trees must have all the same number of external nodes");
            }
            ++n2;
        }
    }

    public void method1(List<File> gene_tree_files, Phylogeny[] species_trees, File out_dir) throws IOException {
        this.checkSpeciesTreesForEqualNumberOfExtNodes(species_trees);
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        for (File gene_tree_file : gene_tree_files) {
            if (ForesterUtil.isReadableFile(gene_tree_file) != null) {
                throw new IOException("[" + gene_tree_file + "] is not readable");
            }
            Phylogeny[] gene_trees = null;
            gene_trees = factory.create(gene_tree_file, new PhyloXmlParser());
            if (gene_trees.length != 1) {
                throw new IOException("[" + gene_tree_file + "] contains " + gene_trees.length + " gene trees, expecting precisely one");
            }
            this.analyze(gene_trees[0], gene_tree_file.getName(), species_trees, out_dir);
        }
    }

    private static Set<Taxonomy> getAllExternalSpecies(Phylogeny phy) {
        HashSet<Taxonomy> specs = new HashSet<Taxonomy>();
        PhylogenyNodeIterator it = phy.iteratorExternalForward();
        while (it.hasNext()) {
            PhylogenyNode n = it.next();
            if (n.getNodeData().isHasTaxonomy()) {
                specs.add(n.getNodeData().getTaxonomy());
                continue;
            }
            throw new IllegalArgumentException("node " + n.getNodeId() + " has no taxonomic data");
        }
        return specs;
    }
}

