/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.DomainId;
import org.forester.util.ForesterUtil;

public class BasicBinaryDomainCombination
implements BinaryDomainCombination {
    DomainId _id_0;
    DomainId _id_1;

    BasicBinaryDomainCombination() {
        this._id_0 = null;
        this._id_1 = null;
    }

    public BasicBinaryDomainCombination(DomainId id_0, DomainId id_1) {
        if (id_0 == null || id_1 == null) {
            throw new IllegalArgumentException("attempt to create binary domain combination using null");
        }
        if (id_0.compareTo(id_1) < 0) {
            this._id_0 = id_0;
            this._id_1 = id_1;
        } else {
            this._id_0 = id_1;
            this._id_1 = id_0;
        }
    }

    public BasicBinaryDomainCombination(String id_0, String id_1) {
        this(new DomainId(id_0), new DomainId(id_1));
    }

    @Override
    public int compareTo(BinaryDomainCombination binary_domain_combination) {
        if (binary_domain_combination.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to compare [" + binary_domain_combination.getClass() + "] to " + "[" + this.getClass() + "]");
        }
        if (this.equals(binary_domain_combination)) {
            return 0;
        }
        int x = this.getId0().compareTo(binary_domain_combination.getId0());
        if (x != 0) {
            return x;
        }
        return this.getId1().compareTo(binary_domain_combination.getId1());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to [" + o.getClass() + "]");
        }
        return this.getId0().equals(((BinaryDomainCombination)o).getId0()) && this.getId1().equals(((BinaryDomainCombination)o).getId1());
    }

    @Override
    public DomainId getId0() {
        return this._id_0;
    }

    @Override
    public DomainId getId1() {
        return this._id_1;
    }

    public int hashCode() {
        return this.getId0().hashCode() + 19 * this.getId1().hashCode();
    }

    @Override
    public StringBuffer toGraphDescribingLanguage(BinaryDomainCombination.OutputFormat format, String node_attribute, String edge_attribute) {
        StringBuffer sb = new StringBuffer();
        switch (format) {
            case DOT: {
                if (ForesterUtil.isEmpty(node_attribute)) {
                    sb.append(this.getId0());
                    sb.append(" -- ");
                    sb.append(this.getId1());
                    if (!ForesterUtil.isEmpty(edge_attribute)) {
                        sb.append(" ");
                        sb.append(edge_attribute);
                    }
                    sb.append(";");
                    break;
                }
                sb.append(this.getId0());
                sb.append(" ");
                sb.append(node_attribute);
                sb.append(";");
                sb.append(ForesterUtil.LINE_SEPARATOR);
                sb.append(this.getId1());
                sb.append(" ");
                sb.append(node_attribute);
                sb.append(";");
                sb.append(ForesterUtil.LINE_SEPARATOR);
                sb.append(this.getId0());
                sb.append(" -- ");
                sb.append(this.getId1());
                if (!ForesterUtil.isEmpty(edge_attribute)) {
                    sb.append(" ");
                    sb.append(edge_attribute);
                }
                sb.append(";");
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown format:" + (Object)((Object)format)));
            }
        }
        return sb;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getId0());
        sb.append("=");
        sb.append(this.getId1());
        return sb.toString();
    }

    public static BinaryDomainCombination createInstance(String ids) {
        if (ids.indexOf("=") < 1) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + ids + "]");
        }
        String[] ids_ary = ids.split("=");
        if (ids_ary.length != 2) {
            throw new IllegalArgumentException("Unexpected format for binary domain combination [" + ids + "]");
        }
        return new BasicBinaryDomainCombination(ids_ary[0], ids_ary[1]);
    }
}

