/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import org.forester.go.GoId;
import org.forester.surfacing.Domain;
import org.forester.surfacing.DomainId;
import org.forester.util.ForesterUtil;

public class BasicDomain
implements Domain {
    private final DomainId _id;
    private final int _from;
    private final int _to;
    private final short _number;
    private final short _total_count;
    private final double _per_sequence_evalue;
    private final double _per_sequence_score;
    private final double _per_domain_evalue;
    private final double _per_domain_score;

    public BasicDomain(String id_str) {
        if (ForesterUtil.isEmpty(id_str)) {
            throw new IllegalArgumentException("attempt to create protein domain with null or empty id");
        }
        this._id = new DomainId(id_str);
        this._from = -1;
        this._to = -1;
        this._number = (short)-1;
        this._total_count = (short)-1;
        this._per_sequence_evalue = -1.0;
        this._per_sequence_score = -1.0;
        this._per_domain_evalue = -1.0;
        this._per_domain_score = -1.0;
    }

    public BasicDomain(String id_str, int from, int to, short number, short total_count, double per_sequence_evalue, double per_sequence_score) {
        if (from >= to || from < 0) {
            throw new IllegalArgumentException("attempt to create protein domain from " + from + " to " + to);
        }
        if (ForesterUtil.isEmpty(id_str)) {
            throw new IllegalArgumentException("attempt to create protein domain with null or empty id");
        }
        if (number > total_count || number < 0) {
            throw new IllegalArgumentException("attempt to create protein domain number " + number + " out of " + total_count);
        }
        if (per_sequence_evalue < 0.0) {
            throw new IllegalArgumentException("attempt to create protein domain with E-value");
        }
        this._id = new DomainId(id_str);
        this._from = from;
        this._to = to;
        this._number = number;
        this._total_count = total_count;
        this._per_sequence_evalue = per_sequence_evalue;
        this._per_sequence_score = per_sequence_score;
        this._per_domain_evalue = -1.0;
        this._per_domain_score = -1.0;
    }

    public BasicDomain(String id_str, int from, int to, short number, short total_count, double per_sequence_evalue, double per_sequence_score, double per_domain_evalue, double per_domain_score) {
        if (from >= to || from < 0) {
            throw new IllegalArgumentException("attempt to create protein domain from " + from + " to " + to);
        }
        if (ForesterUtil.isEmpty(id_str)) {
            throw new IllegalArgumentException("attempt to create protein domain with null or empty id");
        }
        if (number > total_count || number < 0) {
            throw new IllegalArgumentException("attempt to create protein domain number " + number + " out of " + total_count);
        }
        if (per_sequence_evalue < 0.0 || per_domain_evalue < 0.0) {
            throw new IllegalArgumentException("attempt to create protein domain with E-value");
        }
        this._id = new DomainId(id_str);
        this._from = from;
        this._to = to;
        this._number = number;
        this._total_count = total_count;
        this._per_sequence_evalue = per_sequence_evalue;
        this._per_sequence_score = per_sequence_score;
        this._per_domain_evalue = per_domain_evalue;
        this._per_domain_score = per_domain_score;
    }

    @Override
    public void addGoId(GoId go_id) {
        this.getDomainId().getGoIds().add(go_id);
    }

    @Override
    public int compareTo(Domain domain) {
        if (domain.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to compare [" + domain.getClass() + "] to " + "[" + this.getClass() + "]");
        }
        if (this == domain) {
            return 0;
        }
        return this.getDomainId().compareTo(domain.getDomainId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        return this.getDomainId().equals(((Domain)o).getDomainId());
    }

    @Override
    public DomainId getDomainId() {
        return this._id;
    }

    @Override
    public int getFrom() {
        return this._from;
    }

    @Override
    public GoId getGoId(int i) {
        return this.getDomainId().getGoIds().get(i);
    }

    @Override
    public short getNumber() {
        return this._number;
    }

    @Override
    public int getNumberOfGoIds() {
        return this.getDomainId().getGoIds().size();
    }

    @Override
    public double getPerDomainEvalue() {
        return this._per_domain_evalue;
    }

    @Override
    public double getPerDomainScore() {
        return this._per_domain_score;
    }

    @Override
    public double getPerSequenceEvalue() {
        return this._per_sequence_evalue;
    }

    @Override
    public double getPerSequenceScore() {
        return this._per_sequence_score;
    }

    @Override
    public int getTo() {
        return this._to;
    }

    @Override
    public short getTotalCount() {
        return this._total_count;
    }

    public int hashCode() {
        return this.getDomainId().getId().hashCode();
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.getDomainId().getId());
    }
}

