/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.surfacing.AdjactantDirectedCombinableDomains;
import org.forester.surfacing.BasicCombinableDomains;
import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DirectedCombinableDomains;
import org.forester.surfacing.Domain;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.Protein;
import org.forester.surfacing.Species;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class BasicGenomeWideCombinableDomains
implements GenomeWideCombinableDomains {
    private static final NumberFormat FORMATTER = new DecimalFormat("0.0E0");
    private static final Comparator<CombinableDomains> DESCENDING_KEY_DOMAIN_COUNT_ORDER = new Comparator<CombinableDomains>(){

        @Override
        public int compare(CombinableDomains d1, CombinableDomains d2) {
            if (d1.getKeyDomainCount() < d2.getKeyDomainCount()) {
                return 1;
            }
            if (d1.getKeyDomainCount() > d2.getKeyDomainCount()) {
                return -1;
            }
            return d1.getKeyDomain().getId().compareTo(d2.getKeyDomain().getId());
        }
    };
    private static final Comparator<CombinableDomains> DESCENDING_KEY_DOMAIN_PROTEINS_COUNT_ORDER = new Comparator<CombinableDomains>(){

        @Override
        public int compare(CombinableDomains d1, CombinableDomains d2) {
            if (d1.getKeyDomainProteinsCount() < d2.getKeyDomainProteinsCount()) {
                return 1;
            }
            if (d1.getKeyDomainProteinsCount() > d2.getKeyDomainProteinsCount()) {
                return -1;
            }
            return d1.getKeyDomain().getId().compareTo(d2.getKeyDomain().getId());
        }
    };
    private static final Comparator<CombinableDomains> DESCENDING_COMBINATIONS_COUNT_ORDER = new Comparator<CombinableDomains>(){

        @Override
        public int compare(CombinableDomains d1, CombinableDomains d2) {
            if (d1.getNumberOfCombinableDomains() < d2.getNumberOfCombinableDomains()) {
                return 1;
            }
            if (d1.getNumberOfCombinableDomains() > d2.getNumberOfCombinableDomains()) {
                return -1;
            }
            return d1.getKeyDomain().getId().compareTo(d2.getKeyDomain().getId());
        }
    };
    private final SortedMap<DomainId, CombinableDomains> _combinable_domains_map = new TreeMap<DomainId, CombinableDomains>();
    private final Species _species;
    private final BinaryDomainCombination.DomainCombinationType _dc_type;

    private BasicGenomeWideCombinableDomains(Species species, BinaryDomainCombination.DomainCombinationType dc_type) {
        this._species = species;
        this._dc_type = dc_type;
    }

    private void add(DomainId key, CombinableDomains cdc) {
        this._combinable_domains_map.put(key, cdc);
    }

    @Override
    public boolean contains(DomainId key_id) {
        return this._combinable_domains_map.containsKey(key_id);
    }

    @Override
    public CombinableDomains get(DomainId key_id) {
        return (CombinableDomains)this._combinable_domains_map.get(key_id);
    }

    @Override
    public SortedMap<DomainId, CombinableDomains> getAllCombinableDomainsIds() {
        return this._combinable_domains_map;
    }

    @Override
    public SortedSet<DomainId> getAllDomainIds() {
        TreeSet<DomainId> domains = new TreeSet<DomainId>();
        for (DomainId key : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains cb = (CombinableDomains)this.getAllCombinableDomainsIds().get(key);
            List<DomainId> ds = cb.getAllDomains();
            for (DomainId d : ds) {
                domains.add(d);
            }
        }
        return domains;
    }

    @Override
    public BinaryDomainCombination.DomainCombinationType getDomainCombinationType() {
        return this._dc_type;
    }

    @Override
    public SortedSet<DomainId> getMostPromiscuosDomain() {
        TreeSet<DomainId> doms = new TreeSet<DomainId>();
        int max = (int)this.getPerGenomeDomainPromiscuityStatistics().getMax();
        for (DomainId key : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains cb = (CombinableDomains)this.getAllCombinableDomainsIds().get(key);
            if (cb.getNumberOfCombinableDomains() != max) continue;
            doms.add(key);
        }
        return doms;
    }

    @Override
    public DescriptiveStatistics getPerGenomeDomainPromiscuityStatistics() {
        BasicDescriptiveStatistics stats = new BasicDescriptiveStatistics();
        for (DomainId key : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains cb = (CombinableDomains)this.getAllCombinableDomainsIds().get(key);
            stats.addValue(cb.getNumberOfCombinableDomains());
        }
        return stats;
    }

    @Override
    public int getSize() {
        return this._combinable_domains_map.size();
    }

    @Override
    public Species getSpecies() {
        return this._species;
    }

    @Override
    public SortedSet<BinaryDomainCombination> toBinaryDomainCombinations() {
        TreeSet<BinaryDomainCombination> binary_combinations = new TreeSet<BinaryDomainCombination>();
        for (DomainId key : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains cb = (CombinableDomains)this.getAllCombinableDomainsIds().get(key);
            for (BinaryDomainCombination b : cb.toBinaryDomainCombinations()) {
                binary_combinations.add(b);
            }
        }
        return binary_combinations;
    }

    public String toString() {
        return this.toStringBuilder(GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID).toString();
    }

    @Override
    public StringBuilder toStringBuilder(GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder sort_order) {
        StringBuilder sb = new StringBuilder();
        ArrayList<CombinableDomains> combinable_domains = new ArrayList<CombinableDomains>();
        for (DomainId key : this.getAllCombinableDomainsIds().keySet()) {
            CombinableDomains cb = (CombinableDomains)this.getAllCombinableDomainsIds().get(key);
            combinable_domains.add(cb);
        }
        if (sort_order == GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_COUNT) {
            Collections.sort(combinable_domains, DESCENDING_KEY_DOMAIN_COUNT_ORDER);
        } else if (sort_order == GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_PROTEINS_COUNT) {
            Collections.sort(combinable_domains, DESCENDING_KEY_DOMAIN_PROTEINS_COUNT_ORDER);
        } else if (sort_order == GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.COMBINATIONS_COUNT) {
            Collections.sort(combinable_domains, DESCENDING_COMBINATIONS_COUNT_ORDER);
        }
        for (CombinableDomains cb : combinable_domains) {
            sb.append(ForesterUtil.pad(new StringBuffer(cb.getKeyDomain().toString()), 18, ' ', false));
            sb.append(ForesterUtil.pad(new StringBuffer("" + cb.getKeyDomainCount()), 8, ' ', false));
            sb.append(ForesterUtil.pad(new StringBuffer("" + cb.getKeyDomainProteinsCount()), 8, ' ', false));
            sb.append(ForesterUtil.pad(new StringBuffer("" + cb.getNumberOfCombinableDomains()), 8, ' ', false));
            sb.append(ForesterUtil.pad(new StringBuffer(FORMATTER.format(cb.getKeyDomainConfidenceDescriptiveStatistics().median())), 10, ' ', false));
            sb.append((CharSequence)cb.getCombiningDomainIdsAsStringBuilder());
            sb.append(ForesterUtil.getLineSeparator());
        }
        return sb;
    }

    private static void countDomains(Map<DomainId, Integer> domain_counts, Map<DomainId, Integer> domain_protein_counts, Map<DomainId, DescriptiveStatistics> stats, Set<DomainId> saw_c, DomainId id_i, double support) {
        if (domain_counts.containsKey(id_i)) {
            domain_counts.put(id_i, 1 + domain_counts.get(id_i));
            if (!saw_c.contains(id_i)) {
                domain_protein_counts.put(id_i, 1 + domain_protein_counts.get(id_i));
            }
        } else {
            stats.put(id_i, new BasicDescriptiveStatistics());
            domain_counts.put(id_i, 1);
            domain_protein_counts.put(id_i, 1);
        }
        stats.get(id_i).addValue(support);
        saw_c.add(id_i);
    }

    public static BasicGenomeWideCombinableDomains createInstance(List<Protein> protein_list, boolean ignore_combination_with_same_domain, Species species) {
        return BasicGenomeWideCombinableDomains.createInstance(protein_list, ignore_combination_with_same_domain, species, null, BinaryDomainCombination.DomainCombinationType.BASIC);
    }

    public static BasicGenomeWideCombinableDomains createInstance(List<Protein> protein_list, boolean ignore_combination_with_same_domain, Species species, BinaryDomainCombination.DomainCombinationType dc_type) {
        return BasicGenomeWideCombinableDomains.createInstance(protein_list, ignore_combination_with_same_domain, species, null, dc_type);
    }

    public static BasicGenomeWideCombinableDomains createInstance(List<Protein> protein_list, boolean ignore_combination_with_same_domain, Species species, Map<DomainId, List<GoId>> domain_id_to_go_ids_map, BinaryDomainCombination.DomainCombinationType dc_type) {
        BasicGenomeWideCombinableDomains instance = new BasicGenomeWideCombinableDomains(species, dc_type);
        HashMap<DomainId, Integer> domain_counts = new HashMap<DomainId, Integer>();
        HashMap<DomainId, Integer> domain_protein_counts = new HashMap<DomainId, Integer>();
        HashMap<DomainId, DescriptiveStatistics> stats = new HashMap<DomainId, DescriptiveStatistics>();
        for (Protein protein : protein_list) {
            if (!protein.getSpecies().equals(species)) {
                throw new IllegalArgumentException("species (" + protein.getSpecies() + ") does not match species of combinable domains collection (" + species + ")");
            }
            HashSet<DomainId> saw_i = new HashSet<DomainId>();
            HashSet<DomainId> saw_c = new HashSet<DomainId>();
            int i = 0;
            while (i < protein.getProteinDomains().size()) {
                Domain pd_i = protein.getProteinDomain(i);
                DomainId id_i = pd_i.getDomainId();
                int current_start = pd_i.getFrom();
                BasicGenomeWideCombinableDomains.countDomains(domain_counts, domain_protein_counts, stats, saw_c, id_i, pd_i.getPerSequenceEvalue());
                if (!saw_i.contains(id_i)) {
                    if (dc_type == BinaryDomainCombination.DomainCombinationType.BASIC) {
                        saw_i.add(id_i);
                    }
                    CombinableDomains domain_combination = null;
                    if (instance.contains(id_i)) {
                        domain_combination = instance.get(id_i);
                    } else {
                        domain_combination = dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT ? new AdjactantDirectedCombinableDomains(pd_i.getDomainId(), species) : (dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED ? new DirectedCombinableDomains(pd_i.getDomainId(), species) : new BasicCombinableDomains(pd_i.getDomainId(), species));
                        if (domain_id_to_go_ids_map != null && domain_id_to_go_ids_map.containsKey(pd_i.getDomainId())) {
                            List<GoId> go_ids = domain_id_to_go_ids_map.get(pd_i.getDomainId());
                            for (GoId go_id : go_ids) {
                                domain_combination.getKeyDomain().addGoId(go_id);
                            }
                        }
                        instance.add(id_i, domain_combination);
                    }
                    HashSet<DomainId> saw_j = new HashSet<DomainId>();
                    if (ignore_combination_with_same_domain) {
                        saw_j.add(id_i);
                    }
                    Domain closest = null;
                    int j = 0;
                    while (j < protein.getNumberOfProteinDomains()) {
                        DomainId id;
                        if (!(dc_type != BinaryDomainCombination.DomainCombinationType.BASIC && current_start >= protein.getProteinDomain(j).getFrom() || i == j || saw_j.contains(id = protein.getProteinDomain(j).getDomainId()))) {
                            saw_j.add(id);
                            if (dc_type != BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) {
                                domain_combination.addCombinableDomain(protein.getProteinDomain(j).getDomainId());
                            } else if (closest == null) {
                                closest = protein.getProteinDomain(j);
                            } else if (protein.getProteinDomain(j).getFrom() < closest.getFrom()) {
                                closest = protein.getProteinDomain(j);
                            }
                        }
                        ++j;
                    }
                    if (dc_type == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT && closest != null) {
                        domain_combination.addCombinableDomain(closest.getDomainId());
                    }
                }
                ++i;
            }
        }
        for (DomainId key_id : domain_counts.keySet()) {
            instance.get(key_id).setKeyDomainCount((Integer)domain_counts.get(key_id));
            instance.get(key_id).setKeyDomainProteinsCount((Integer)domain_protein_counts.get(key_id));
            instance.get(key_id).setKeyDomainConfidenceDescriptiveStatistics((DescriptiveStatistics)stats.get(key_id));
        }
        return instance;
    }
}

