/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import org.forester.surfacing.PairwiseDomainSimilarity;

public class CountsBasedPairwiseDomainSimilarity
implements PairwiseDomainSimilarity {
    private final double _score;
    private final int _copy_number_difference;

    public CountsBasedPairwiseDomainSimilarity(int counts_difference, int counts_sum) {
        if (counts_sum <= 0) {
            throw new IllegalArgumentException("attempt to use copy sum of less than or equal to 0: " + counts_sum);
        }
        this._copy_number_difference = counts_difference;
        int abs_copy_number_difference = Math.abs(counts_difference);
        if (abs_copy_number_difference > counts_sum) {
            throw new IllegalArgumentException("attempt to use absolute copy number difference larger than copy number sum");
        }
        this._score = 1.0 - (double)abs_copy_number_difference / (double)counts_sum;
    }

    @Override
    public int getDifferenceInCounts() {
        return this._copy_number_difference;
    }

    @Override
    public double getSimilarityScore() {
        return this._score;
    }
}

