/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.GenomeWideCombinableDomains;

public class DomainArchitectureBasedGenomeSimilarityCalculator {
    public static final double MAX_SIMILARITY_SCORE = 1.0;
    public static final double MIN_SIMILARITY_SCORE = 0.0;
    private final GenomeWideCombinableDomains _combinable_domains_genome_0;
    private final GenomeWideCombinableDomains _combinable_domains_genome_1;
    private Set<DomainId> _domain_ids_to_ignore;
    private boolean _allow_domains_to_be_ignored;
    private Set<DomainId> _all_domains;
    private Set<DomainId> _shared_domains;
    private Set<DomainId> _domains_specific_to_0;
    private Set<DomainId> _domains_specific_to_1;
    private Set<BinaryDomainCombination> _all_binary_domain_combinations;
    private Set<BinaryDomainCombination> _shared_binary_domain_combinations;
    private Set<BinaryDomainCombination> _binary_domain_combinations_specific_to_0;
    private Set<BinaryDomainCombination> _binary_domain_combinations_specific_to_1;

    public DomainArchitectureBasedGenomeSimilarityCalculator(GenomeWideCombinableDomains combinable_domains_genome_0, GenomeWideCombinableDomains combinable_domains_genome_1) {
        if (combinable_domains_genome_0 == null || combinable_domains_genome_0.getSize() < 1 || combinable_domains_genome_1 == null || combinable_domains_genome_1.getSize() < 1) {
            throw new IllegalArgumentException("attempt to compare null or empty combinable domains collection");
        }
        if (combinable_domains_genome_0.getSpecies().equals(combinable_domains_genome_1.getSpecies())) {
            throw new IllegalArgumentException("attempt to compare combinable domains collection from the same species");
        }
        this._combinable_domains_genome_0 = combinable_domains_genome_0;
        this._combinable_domains_genome_1 = combinable_domains_genome_1;
        this.init();
        this.forceRecalculation();
    }

    public void addDomainIdToIgnore(DomainId domain_id_to_ignore) {
        this.forceRecalculation();
        this.getDomainIdsToIgnore().add(domain_id_to_ignore);
    }

    public double calculateSharedBinaryDomainCombinationBasedGenomeSimilarityScore() {
        double t = this.getAllBinaryDomainCombinations().size();
        double s = this.getSharedBinaryDomainCombinations().size();
        if (t == 0.0) {
            return 0.0;
        }
        return 1.0 - (t - s) / t;
    }

    public double calculateSharedDomainsBasedGenomeSimilarityScore() {
        double t = this.getAllDomains().size();
        double s = this.getSharedDomains().size();
        if (t == 0.0) {
            return 0.0;
        }
        return 1.0 - (t - s) / t;
    }

    public void deleteAllDomainIdsToIgnore() {
        this.forceRecalculation();
        this.setDomainIdsToIgnore(new HashSet<DomainId>());
    }

    private void forceRecalculation() {
        this._all_domains = null;
        this._shared_domains = null;
        this._domains_specific_to_0 = null;
        this._domains_specific_to_1 = null;
        this._all_binary_domain_combinations = null;
        this._shared_binary_domain_combinations = null;
        this._binary_domain_combinations_specific_to_0 = null;
        this._binary_domain_combinations_specific_to_1 = null;
    }

    public Set<BinaryDomainCombination> getAllBinaryDomainCombinations() {
        if (this._all_binary_domain_combinations == null) {
            HashSet<BinaryDomainCombination> all = new HashSet<BinaryDomainCombination>();
            all.addAll(this.getCombinableDomainsGenome0().toBinaryDomainCombinations());
            all.addAll(this.getCombinableDomainsGenome1().toBinaryDomainCombinations());
            this._all_binary_domain_combinations = this.isAllowDomainsToBeIgnored() && !this.getDomainIdsToIgnore().isEmpty() ? this.pruneBinaryCombinations(all) : all;
        }
        return this._all_binary_domain_combinations;
    }

    public Set<DomainId> getAllDomains() {
        if (this._all_domains == null) {
            HashSet<DomainId> all = new HashSet<DomainId>();
            all.addAll(this.getCombinableDomainsGenome0().getAllDomainIds());
            all.addAll(this.getCombinableDomainsGenome1().getAllDomainIds());
            this._all_domains = this.isAllowDomainsToBeIgnored() && !this.getDomainIdsToIgnore().isEmpty() ? this.pruneDomains(all) : all;
        }
        return this._all_domains;
    }

    private Set<BinaryDomainCombination> getBinaryDomainCombinationsSpecificToGenome(boolean specific_to_genome_0) {
        HashSet<BinaryDomainCombination> specific = new HashSet<BinaryDomainCombination>();
        SortedSet<BinaryDomainCombination> bc0 = this.getCombinableDomainsGenome0().toBinaryDomainCombinations();
        SortedSet<BinaryDomainCombination> bc1 = this.getCombinableDomainsGenome1().toBinaryDomainCombinations();
        if (specific_to_genome_0) {
            for (BinaryDomainCombination binary_domain_combination0 : bc0) {
                if (bc1.contains(binary_domain_combination0)) continue;
                specific.add(binary_domain_combination0);
            }
        } else {
            for (BinaryDomainCombination binary_domain_combination1 : bc1) {
                if (bc0.contains(binary_domain_combination1)) continue;
                specific.add(binary_domain_combination1);
            }
        }
        if (this.isAllowDomainsToBeIgnored() && !this.getDomainIdsToIgnore().isEmpty()) {
            return this.pruneBinaryCombinations(specific);
        }
        return specific;
    }

    public Set<BinaryDomainCombination> getBinaryDomainCombinationsSpecificToGenome0() {
        if (this._binary_domain_combinations_specific_to_0 == null) {
            this._binary_domain_combinations_specific_to_0 = this.getBinaryDomainCombinationsSpecificToGenome(true);
        }
        return this._binary_domain_combinations_specific_to_0;
    }

    public Set<BinaryDomainCombination> getBinaryDomainCombinationsSpecificToGenome1() {
        if (this._binary_domain_combinations_specific_to_1 == null) {
            this._binary_domain_combinations_specific_to_1 = this.getBinaryDomainCombinationsSpecificToGenome(false);
        }
        return this._binary_domain_combinations_specific_to_1;
    }

    private GenomeWideCombinableDomains getCombinableDomainsGenome0() {
        return this._combinable_domains_genome_0;
    }

    private GenomeWideCombinableDomains getCombinableDomainsGenome1() {
        return this._combinable_domains_genome_1;
    }

    private Set<DomainId> getDomainIdsToIgnore() {
        return this._domain_ids_to_ignore;
    }

    private Set<DomainId> getDomainsSpecificToGenome(boolean specific_to_genome_0) {
        HashSet<DomainId> specific = new HashSet<DomainId>();
        SortedSet<DomainId> d0 = this.getCombinableDomainsGenome0().getAllDomainIds();
        SortedSet<DomainId> d1 = this.getCombinableDomainsGenome1().getAllDomainIds();
        if (specific_to_genome_0) {
            for (DomainId domain0 : d0) {
                if (d1.contains(domain0)) continue;
                specific.add(domain0);
            }
        } else {
            for (DomainId domain1 : d1) {
                if (d0.contains(domain1)) continue;
                specific.add(domain1);
            }
        }
        if (this.isAllowDomainsToBeIgnored() && !this.getDomainIdsToIgnore().isEmpty()) {
            return this.pruneDomains(specific);
        }
        return specific;
    }

    public Set<DomainId> getDomainsSpecificToGenome0() {
        if (this._domains_specific_to_0 == null) {
            this._domains_specific_to_0 = this.getDomainsSpecificToGenome(true);
        }
        return this._domains_specific_to_0;
    }

    public Set<DomainId> getDomainsSpecificToGenome1() {
        if (this._domains_specific_to_1 == null) {
            this._domains_specific_to_1 = this.getDomainsSpecificToGenome(false);
        }
        return this._domains_specific_to_1;
    }

    public Set<BinaryDomainCombination> getSharedBinaryDomainCombinations() {
        if (this._shared_binary_domain_combinations == null) {
            HashSet<BinaryDomainCombination> shared = new HashSet<BinaryDomainCombination>();
            SortedSet<BinaryDomainCombination> bc0 = this.getCombinableDomainsGenome0().toBinaryDomainCombinations();
            SortedSet<BinaryDomainCombination> bc1 = this.getCombinableDomainsGenome1().toBinaryDomainCombinations();
            for (BinaryDomainCombination binary_domain_combination0 : bc0) {
                if (!bc1.contains(binary_domain_combination0)) continue;
                shared.add(binary_domain_combination0);
            }
            this._shared_binary_domain_combinations = shared;
            if (this.isAllowDomainsToBeIgnored() && !this.getDomainIdsToIgnore().isEmpty()) {
                this._shared_binary_domain_combinations = this.pruneBinaryCombinations(shared);
            }
        }
        return this._shared_binary_domain_combinations;
    }

    public Set<DomainId> getSharedDomains() {
        if (this._shared_domains == null) {
            HashSet<DomainId> shared = new HashSet<DomainId>();
            SortedSet<DomainId> d0 = this.getCombinableDomainsGenome0().getAllDomainIds();
            SortedSet<DomainId> d1 = this.getCombinableDomainsGenome1().getAllDomainIds();
            for (DomainId domain0 : d0) {
                if (!d1.contains(domain0)) continue;
                shared.add(domain0);
            }
            this._shared_domains = shared;
            if (this.isAllowDomainsToBeIgnored() && !this.getDomainIdsToIgnore().isEmpty()) {
                this._shared_domains = this.pruneDomains(shared);
            }
        }
        return this._shared_domains;
    }

    private void init() {
        this.deleteAllDomainIdsToIgnore();
        this.setAllowDomainsToBeIgnored(false);
    }

    private boolean isAllowDomainsToBeIgnored() {
        return this._allow_domains_to_be_ignored;
    }

    private Set<BinaryDomainCombination> pruneBinaryCombinations(Set<BinaryDomainCombination> all) {
        HashSet<BinaryDomainCombination> pruned = new HashSet<BinaryDomainCombination>();
        for (BinaryDomainCombination bc : all) {
            if (this.getDomainIdsToIgnore().contains(bc.getId0()) || this.getDomainIdsToIgnore().contains(bc.getId1())) continue;
            pruned.add(bc);
        }
        return pruned;
    }

    private Set<DomainId> pruneDomains(Set<DomainId> all) {
        HashSet<DomainId> pruned = new HashSet<DomainId>();
        for (DomainId d : all) {
            if (this.getDomainIdsToIgnore().contains(d)) continue;
            pruned.add(d);
        }
        return pruned;
    }

    public void setAllowDomainsToBeIgnored(boolean allow_domains_to_be_ignored) {
        this.forceRecalculation();
        this._allow_domains_to_be_ignored = allow_domains_to_be_ignored;
    }

    void setDomainIdsToIgnore(Set<DomainId> domain_ids_to_ignore) {
        this.forceRecalculation();
        this._domain_ids_to_ignore = domain_ids_to_ignore;
    }
}

