/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.ArrayList;
import java.util.List;
import org.forester.go.GoId;
import org.forester.util.ForesterUtil;

public class DomainId
implements Comparable<DomainId> {
    private final String _id;
    private List<GoId> _go_ids;

    public DomainId(String id) {
        if (ForesterUtil.isEmpty(id)) {
            throw new IllegalArgumentException("attempt to create domain id from empty or null string");
        }
        this._id = id.trim();
        if (this._id.indexOf(32) > -1) {
            throw new IllegalArgumentException("attempt to create domain id from string containing one ore more spaces [" + this._id + "]");
        }
        if (this._id.indexOf("=") > -1) {
            throw new IllegalArgumentException("attempt to create domain id from string containing the separator character [=] for domain combinations [" + this._id + "]");
        }
        this.setGoIds(null);
    }

    public void addGoId(GoId go_id) {
        if (this.getGoIds() == null) {
            this.setGoIds(new ArrayList<GoId>());
        }
        this.getGoIds().add(go_id);
    }

    @Override
    public int compareTo(DomainId domain_id) {
        if (this == domain_id) {
            return 0;
        }
        return this.getId().toLowerCase().compareTo(domain_id.getId().toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to null");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        return this.getId().equals(((DomainId)o).getId());
    }

    public GoId getGoId(int i) {
        return this.getGoIds().get(i);
    }

    List<GoId> getGoIds() {
        return this._go_ids;
    }

    public String getId() {
        return this._id;
    }

    public int getNumberOfGoIds() {
        if (this.getGoIds() == null) {
            return 0;
        }
        return this.getGoIds().size();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private void setGoIds(List<GoId> go_ids) {
        this._go_ids = go_ids;
    }

    public String toString() {
        return this.getId();
    }
}

