/*
 * Decompiled with CFR 0.152.
 */
package org.forester.surfacing;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.GoXRef;
import org.forester.surfacing.CombinableDomains;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.Species;
import org.forester.surfacing.SpeciesSpecificDomainSimilariyData;
import org.forester.util.ForesterUtil;

public class PrintableDomainSimilarity
implements DomainSimilarity {
    public static final String SPECIES_SEPARATOR = "  ";
    private static final char TAB = '\t';
    private static final int BEFORE = -1;
    private static final int EQUAL = 0;
    private static final int AFTER = 1;
    private static final String NO_SPECIES = "     ";
    private final double _min;
    private final double _max;
    private final double _mean;
    private final double _sd;
    private final int _n;
    private final int _max_difference_in_counts;
    private final int _max_difference;
    private DomainSimilarityCalculator.GoAnnotationOutput _go_annotation_output;
    private final CombinableDomains _combinable_domains;
    private final SortedMap<Species, SpeciesSpecificDomainSimilariyData> _species_data;
    private final DomainSimilarity.DomainSimilaritySortField _sort_field;
    private List<Species> _species_order;
    private final boolean _sort_by_species_count_first;
    private DomainSimilarityCalculator.Detailedness _detailedness;
    private Map<GoId, GoTerm> _go_id_to_term_map;
    private GoNameSpace _go_namespace_limit;
    private final boolean _treat_as_binary_comparison;

    public PrintableDomainSimilarity(CombinableDomains combinable_domains, double min, double max, double mean, double median, double sd, int n, int max_difference_in_counts, int max_difference, SortedMap<Species, SpeciesSpecificDomainSimilariyData> species_data, DomainSimilarity.DomainSimilaritySortField sort_field, boolean sort_by_species_count_first, boolean treat_as_binary_comparison) {
        if (combinable_domains == null) {
            throw new IllegalArgumentException("attempt to use null combinable domains");
        }
        if (sort_field == null) {
            throw new IllegalArgumentException("attempt to use null sorting");
        }
        if (species_data == null) {
            throw new IllegalArgumentException("attempt to use null species data");
        }
        if (species_data.size() < 1) {
            throw new IllegalArgumentException("attempt to use empty species data");
        }
        if (n < 0) {
            throw new IllegalArgumentException("attempt to use N less than 0");
        }
        if (species_data.size() > 1 && n < 1) {
            throw new IllegalArgumentException("attempt to use N less than 1");
        }
        if (sd < 0.0) {
            throw new IllegalArgumentException("attempt to use negative SD");
        }
        if (max < min) {
            throw new IllegalArgumentException("attempt to use max smaller than min");
        }
        this.init();
        this._combinable_domains = combinable_domains;
        this._min = min;
        this._max = max;
        this._mean = mean;
        this._sd = sd;
        this._n = n;
        this._max_difference_in_counts = max_difference_in_counts;
        this._max_difference = max_difference;
        this._species_data = species_data;
        this._sort_field = sort_field;
        this._sort_by_species_count_first = sort_by_species_count_first;
        this._treat_as_binary_comparison = treat_as_binary_comparison;
        int s = species_data.size();
        if (s * s - s != this.getN() * 2) {
            throw new IllegalArgumentException("illegal species count and n: species count:" + s + ", n:" + this._n + " for domain " + combinable_domains.getKeyDomain());
        }
        if (s > 2) {
            if (this.getMaximalDifferenceInCounts() < 0) {
                throw new IllegalArgumentException("attempt to use negative max difference in counts with more than two species");
            }
            if (this.getMaximalDifference() < 0) {
                throw new IllegalArgumentException("attempt to use negative max difference with more than two species");
            }
        }
    }

    private void addGoInformation(StringBuffer sb, boolean for_table, boolean html) {
        if (!for_table) {
            sb.append("<");
        }
        switch (this.getGoAnnotationOutput()) {
            case ALL: {
                int go_ids = this.getCombinableDomains().getKeyDomain().getNumberOfGoIds();
                boolean first = true;
                int i = 0;
                while (i < go_ids) {
                    GoId go_id = this.getCombinableDomains().getKeyDomain().getGoId(i);
                    if (this.getGoIdToTermMap() != null) {
                        if (this.getGoIdToTermMap().containsKey(go_id)) {
                            first = this.appendGoTerm(sb, this.getGoIdToTermMap().get(go_id), first, html);
                        } else {
                            sb.append("go id \"" + go_id + "\" not found [" + this.getCombinableDomains().getKeyDomain().getId() + "]");
                        }
                    } else {
                        if (!first) {
                            sb.append(", ");
                        }
                        if (html) {
                            sb.append("<a href=\"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&query=" + go_id + "\" target=\"amigo_window\">" + go_id + "</a>");
                        } else {
                            sb.append(go_id);
                        }
                        first = false;
                    }
                    ++i;
                }
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("unknown " + (Object)((Object)this.getGoAnnotationOutput()));
            }
        }
        if (!for_table) {
            sb.append(">: ");
        }
    }

    private void addSpeciesSpecificDomainData(StringBuffer sb, Species species, boolean html) {
        if (this.getDetaildness() != DomainSimilarityCalculator.Detailedness.BASIC) {
            sb.append("[");
        }
        if (html) {
            sb.append("<b>");
            if ("http://beta.uniprot.org/taxonomy/?query=" != null && species.getSpeciesId().length() > 2 && species.getSpeciesId().length() < 6) {
                sb.append("<a href=\"http://beta.uniprot.org/taxonomy/?query=" + species.getSpeciesId() + "\" target=\"taxonomy_window\">" + species.getSpeciesId() + "</a>");
            } else {
                sb.append(species.getSpeciesId());
            }
            sb.append("</b>");
        } else {
            sb.append(species.getSpeciesId());
        }
        if (this.getDetaildness() != DomainSimilarityCalculator.Detailedness.BASIC) {
            sb.append(":");
            sb.append(((SpeciesSpecificDomainSimilariyData)this.getSpeciesData().get(species)).toStringBuffer(this.getDetaildness(), html));
            sb.append("]");
        }
        if (html) {
            sb.append("<br>");
        }
        sb.append(SPECIES_SEPARATOR);
    }

    private boolean appendGoTerm(StringBuffer sb, GoTerm go_term, boolean first, boolean html) {
        if (this.getGoNamespaceLimit() == null || this.getGoNamespaceLimit().equals(go_term.getGoNameSpace())) {
            if (!first) {
                sb.append(", ");
            }
            GoId go_id = go_term.getGoId();
            if (html) {
                sb.append("<a href=\"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&query=" + go_id + "\" target=\"amigo_window\">" + go_id + "</a>");
            } else {
                sb.append(go_id);
            }
            sb.append(":");
            sb.append(go_term.getName());
            if (!html) {
                if (this.getGoNamespaceLimit() == null) {
                    sb.append(":");
                    sb.append(go_term.getGoNameSpace().toString());
                }
                for (GoXRef xref : go_term.getGoXRefs()) {
                    sb.append(":");
                    sb.append(xref.toString());
                }
            }
            return false;
        }
        return true;
    }

    private void boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField sort_field, StringBuffer sb) {
        if (this.getSortField() == sort_field) {
            sb.append("</b>");
        }
    }

    private void boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField sort_field, StringBuffer sb) {
        if (this.getSortField() == sort_field) {
            sb.append("<b>");
        }
    }

    private int compareByDomainId(DomainSimilarity other) {
        return this.getDomainId().compareTo(other.getDomainId());
    }

    private int compareBySpeciesCount(DomainSimilarity domain_similarity) {
        int s_other;
        int s_this = this.getSpeciesData().size();
        if (s_this < (s_other = domain_similarity.getSpeciesData().size())) {
            return -1;
        }
        if (s_this > s_other) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(DomainSimilarity domain_similarity) {
        if (this == domain_similarity) {
            return 0;
        }
        if (domain_similarity == null) {
            throw new IllegalArgumentException("attempt to compare " + this.getClass() + " to null");
        }
        if (domain_similarity.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to compare " + this.getClass() + " to " + domain_similarity.getClass());
        }
        switch (this.getSortField()) {
            case MIN: {
                int i;
                if (this.isSortBySpeciesCountFirst() && (i = this.compareBySpeciesCount(domain_similarity)) != 0) {
                    return i;
                }
                if (this.getMinimalSimilarityScore() < domain_similarity.getMinimalSimilarityScore()) {
                    return -1;
                }
                if (this.getMinimalSimilarityScore() > domain_similarity.getMinimalSimilarityScore()) {
                    return 1;
                }
                return this.compareByDomainId(domain_similarity);
            }
            case MAX: {
                int i;
                if (this.isSortBySpeciesCountFirst() && (i = this.compareBySpeciesCount(domain_similarity)) != 0) {
                    return i;
                }
                if (this.getMaximalSimilarityScore() < domain_similarity.getMaximalSimilarityScore()) {
                    return -1;
                }
                if (this.getMaximalSimilarityScore() > domain_similarity.getMaximalSimilarityScore()) {
                    return 1;
                }
                return this.compareByDomainId(domain_similarity);
            }
            case MEAN: {
                int i;
                if (this.isSortBySpeciesCountFirst() && (i = this.compareBySpeciesCount(domain_similarity)) != 0) {
                    return i;
                }
                if (this.getMeanSimilarityScore() < domain_similarity.getMeanSimilarityScore()) {
                    return -1;
                }
                if (this.getMeanSimilarityScore() > domain_similarity.getMeanSimilarityScore()) {
                    return 1;
                }
                return this.compareByDomainId(domain_similarity);
            }
            case SD: {
                int i;
                if (this.isSortBySpeciesCountFirst() && (i = this.compareBySpeciesCount(domain_similarity)) != 0) {
                    return i;
                }
                if (this.getStandardDeviationOfSimilarityScore() < domain_similarity.getStandardDeviationOfSimilarityScore()) {
                    return -1;
                }
                if (this.getStandardDeviationOfSimilarityScore() > domain_similarity.getStandardDeviationOfSimilarityScore()) {
                    return 1;
                }
                return this.compareByDomainId(domain_similarity);
            }
            case MAX_DIFFERENCE: {
                int i;
                if (this.isSortBySpeciesCountFirst() && (i = this.compareBySpeciesCount(domain_similarity)) != 0) {
                    return i;
                }
                if (this.getMaximalDifference() > domain_similarity.getMaximalDifference()) {
                    return -1;
                }
                if (this.getMaximalDifference() < domain_similarity.getMaximalDifference()) {
                    return 1;
                }
                return this.compareByDomainId(domain_similarity);
            }
            case ABS_MAX_COUNTS_DIFFERENCE: {
                int i;
                if (this.isSortBySpeciesCountFirst() && (i = this.compareBySpeciesCount(domain_similarity)) != 0) {
                    return i;
                }
                if (Math.abs(this.getMaximalDifferenceInCounts()) > Math.abs(domain_similarity.getMaximalDifferenceInCounts())) {
                    return -1;
                }
                if (Math.abs(this.getMaximalDifferenceInCounts()) < Math.abs(domain_similarity.getMaximalDifferenceInCounts())) {
                    return 1;
                }
                return this.compareByDomainId(domain_similarity);
            }
            case MAX_COUNTS_DIFFERENCE: {
                int i;
                if (this.getSpeciesData().size() != 2) {
                    throw new IllegalStateException("attempt to sort by maximal difference with species not equal to two");
                }
                if (this.isSortBySpeciesCountFirst() && (i = this.compareBySpeciesCount(domain_similarity)) != 0) {
                    return i;
                }
                if (this.getMaximalDifferenceInCounts() > domain_similarity.getMaximalDifferenceInCounts()) {
                    return -1;
                }
                if (this.getMaximalDifferenceInCounts() < domain_similarity.getMaximalDifferenceInCounts()) {
                    return 1;
                }
                return this.compareByDomainId(domain_similarity);
            }
            case SPECIES_COUNT: {
                int i = this.compareBySpeciesCount(domain_similarity);
                if (i != 0) {
                    return i;
                }
                return this.compareByDomainId(domain_similarity);
            }
            case DOMAIN_ID: {
                return this.compareByDomainId(domain_similarity);
            }
        }
        throw new AssertionError((Object)("Unknown sort method: " + (Object)((Object)this.getSortField())));
    }

    @Override
    public SortedSet<DomainId> getCombinableDomainIds(Species species_of_combinable_domain) {
        TreeSet<DomainId> sorted_ids = new TreeSet<DomainId>();
        if (this.getSpeciesData().containsKey(species_of_combinable_domain)) {
            for (DomainId id : ((SpeciesSpecificDomainSimilariyData)this.getSpeciesData().get(species_of_combinable_domain)).getCombinableDomainIdToCountsMap().keySet()) {
                sorted_ids.add(id);
            }
        }
        return sorted_ids;
    }

    private CombinableDomains getCombinableDomains() {
        return this._combinable_domains;
    }

    private DomainSimilarityCalculator.Detailedness getDetaildness() {
        return this._detailedness;
    }

    @Override
    public DomainId getDomainId() {
        return this.getCombinableDomains().getKeyDomain();
    }

    private DomainSimilarityCalculator.GoAnnotationOutput getGoAnnotationOutput() {
        return this._go_annotation_output;
    }

    private Map<GoId, GoTerm> getGoIdToTermMap() {
        return this._go_id_to_term_map;
    }

    public GoNameSpace getGoNamespaceLimit() {
        return this._go_namespace_limit;
    }

    @Override
    public int getMaximalDifference() {
        return this._max_difference;
    }

    @Override
    public int getMaximalDifferenceInCounts() {
        return this._max_difference_in_counts;
    }

    @Override
    public double getMaximalSimilarityScore() {
        return this._max;
    }

    @Override
    public double getMeanSimilarityScore() {
        return this._mean;
    }

    @Override
    public double getMinimalSimilarityScore() {
        return this._min;
    }

    @Override
    public int getN() {
        return this._n;
    }

    private DomainSimilarity.DomainSimilaritySortField getSortField() {
        return this._sort_field;
    }

    @Override
    public SortedSet<Species> getSpecies() {
        TreeSet<Species> species = new TreeSet<Species>();
        for (Species s : this.getSpeciesData().keySet()) {
            species.add(s);
        }
        return species;
    }

    public List<Species> getSpeciesCustomOrder() {
        return this._species_order;
    }

    @Override
    public SortedMap<Species, SpeciesSpecificDomainSimilariyData> getSpeciesData() {
        return this._species_data;
    }

    private StringBuffer getSpeciesDataInAlphabeticalOrder(boolean html) {
        StringBuffer sb = new StringBuffer();
        for (Species species : this.getSpeciesData().keySet()) {
            this.addSpeciesSpecificDomainData(sb, species, html);
        }
        return sb;
    }

    private StringBuffer getSpeciesDataInCustomOrder(boolean html) {
        StringBuffer sb = new StringBuffer();
        for (Species order_species : this.getSpeciesCustomOrder()) {
            if (this.getSpeciesData().keySet().contains(order_species)) {
                this.addSpeciesSpecificDomainData(sb, order_species, html);
                continue;
            }
            sb.append(NO_SPECIES);
            sb.append(SPECIES_SEPARATOR);
        }
        return sb;
    }

    @Override
    public double getStandardDeviationOfSimilarityScore() {
        return this._sd;
    }

    private void init() {
        this._detailedness = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
        this._go_annotation_output = null;
        this._go_id_to_term_map = null;
    }

    private boolean isSortBySpeciesCountFirst() {
        return this._sort_by_species_count_first;
    }

    private boolean isTreatAsBinaryComparison() {
        return this._treat_as_binary_comparison;
    }

    public void setDetailedness(DomainSimilarityCalculator.Detailedness detailedness) {
        this._detailedness = detailedness;
    }

    public void setGoAnnotationOutput(DomainSimilarityCalculator.GoAnnotationOutput go_annotation_output) {
        this._go_annotation_output = go_annotation_output;
    }

    public void setGoIdToTermMap(Map<GoId, GoTerm> go_id_to_term_map) {
        this._go_id_to_term_map = go_id_to_term_map;
    }

    public void setGoNamespaceLimit(GoNameSpace go_namespace_limit) {
        this._go_namespace_limit = go_namespace_limit;
    }

    public void setSpeciesOrder(List<Species> species_order) {
        if (!species_order.containsAll(this.getSpeciesData().keySet())) {
            throw new IllegalArgumentException("list to order species must contain all species of multiple combinable domains similarity");
        }
        this._species_order = species_order;
    }

    public String toString() {
        return this.toStringBuffer(null).toString();
    }

    @Override
    public StringBuffer toStringBuffer(PRINT_OPTION print_option) {
        switch (print_option) {
            case SIMPLE_TAB_DELIMITED: {
                return this.toStringBufferSimpleTabDelimited();
            }
            case HTML: {
                return this.toStringBufferDetailedHTML();
            }
        }
        throw new AssertionError((Object)("Unknown print option: " + (Object)((Object)print_option)));
    }

    private StringBuffer toStringBufferDetailedHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr>");
        sb.append("<td>");
        this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, sb);
        sb.append("<a href=\"http://pfam.sanger.ac.uk/family?id=" + this.getDomainId() + "\">" + this.getDomainId() + "</a>");
        this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID, sb);
        sb.append("</td>");
        sb.append("<td>");
        this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MEAN, sb);
        sb.append(ForesterUtil.round(this.getMeanSimilarityScore(), 3));
        this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MEAN, sb);
        sb.append("</td>");
        if (!this.isTreatAsBinaryComparison()) {
            sb.append("<td>");
            sb.append("(");
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.SD, sb);
            sb.append(ForesterUtil.round(this.getStandardDeviationOfSimilarityScore(), 3));
            this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.SD, sb);
            sb.append(")");
            sb.append("</td>");
            sb.append("<td>");
            sb.append("[");
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MIN, sb);
            sb.append(ForesterUtil.round(this.getMinimalSimilarityScore(), 3));
            this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MIN, sb);
            sb.append(",");
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX, sb);
            sb.append(ForesterUtil.round(this.getMaximalSimilarityScore(), 3));
            this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX, sb);
            sb.append("]");
            sb.append("</td>");
        }
        sb.append("<td>");
        this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE, sb);
        sb.append(this.getMaximalDifference());
        this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE, sb);
        sb.append("</td>");
        sb.append("<td>");
        if (this.isTreatAsBinaryComparison()) {
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE, sb);
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE, sb);
            sb.append(this.getMaximalDifferenceInCounts());
            this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE, sb);
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE, sb);
        } else {
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE, sb);
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE, sb);
            sb.append(Math.abs(this.getMaximalDifferenceInCounts()));
            this.boldEndIfSortedBy(DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE, sb);
            this.boldStartIfSortedBy(DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE, sb);
        }
        sb.append("</td>");
        if (!this.isTreatAsBinaryComparison()) {
            sb.append("<td>");
            if (this.getSortField() == DomainSimilarity.DomainSimilaritySortField.SPECIES_COUNT || this.isSortBySpeciesCountFirst()) {
                sb.append("<b>");
            }
            sb.append(this.getSpeciesData().size());
            if (this.getSortField() == DomainSimilarity.DomainSimilaritySortField.SPECIES_COUNT || this.isSortBySpeciesCountFirst()) {
                sb.append("</b>");
            }
            sb.append("</td>");
        }
        if (this.getGoAnnotationOutput() != DomainSimilarityCalculator.GoAnnotationOutput.NONE) {
            sb.append("<td>");
            this.addGoInformation(sb, true, true);
            sb.append("</td>");
        }
        if (this.getSpeciesCustomOrder() == null || this.getSpeciesCustomOrder().isEmpty()) {
            sb.append("<td>");
            sb.append(this.getSpeciesDataInAlphabeticalOrder(true));
            sb.append("</td>");
        } else {
            sb.append("<td>");
            sb.append(this.getSpeciesDataInCustomOrder(true));
            sb.append("</td>");
        }
        sb.append("</tr>");
        return sb;
    }

    private StringBuffer toStringBufferSimpleTabDelimited() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDomainId());
        switch (this.getSortField()) {
            case MIN: {
                sb.append('\t');
                sb.append(ForesterUtil.round(this.getMinimalSimilarityScore(), 3));
                break;
            }
            case MAX: {
                sb.append('\t');
                sb.append(ForesterUtil.round(this.getMaximalSimilarityScore(), 3));
                break;
            }
            case MEAN: {
                sb.append('\t');
                sb.append(ForesterUtil.round(this.getMeanSimilarityScore(), 3));
                break;
            }
            case SD: {
                sb.append('\t');
                sb.append(ForesterUtil.round(this.getStandardDeviationOfSimilarityScore(), 3));
                break;
            }
            case MAX_DIFFERENCE: {
                sb.append('\t');
                sb.append(this.getMaximalDifference());
            }
            case ABS_MAX_COUNTS_DIFFERENCE: 
            case MAX_COUNTS_DIFFERENCE: {
                sb.append('\t');
                if (this.isTreatAsBinaryComparison()) {
                    sb.append(this.getMaximalDifferenceInCounts());
                    break;
                }
                sb.append(Math.abs(this.getMaximalDifferenceInCounts()));
                break;
            }
            case SPECIES_COUNT: {
                sb.append('\t');
                sb.append(this.getSpeciesData().size());
                break;
            }
            case DOMAIN_ID: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown sort method: " + (Object)((Object)this.getSortField())));
            }
        }
        if (this.getGoAnnotationOutput() != DomainSimilarityCalculator.GoAnnotationOutput.NONE) {
            sb.append('\t');
            this.addGoInformation(sb, true, false);
        }
        return sb;
    }

    public static enum PRINT_OPTION {
        SIMPLE_TAB_DELIMITED,
        HTML;

    }
}

